<?php
/**
 * The Template for displaying all single products
 *
 * This template can be overridden by copying it to kiedo/woocommerce/single-product.php.
 *
 * HOWEVER, on occasion WooCommerce will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen. When this occurs the version of the template file will be bumped and
 * the readme will list any important changes.
 *
 * @see 	    https://docs.woocommerce.com/document/template-structure/
 * @package 	WooCommerce/Templates
 * @version     7.4.0
 */
global $kiedo_opt;

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly
}

global $kiedo_opt;

get_header( 'shop' );

remove_action( 'woocommerce_before_main_content', 'woocommerce_breadcrumb', 20 );

// Page Title
if( isset($kiedo_opt['shop_title']) ):
    $tag            = $kiedo_opt['page_title_tag'];
else:
    $tag        = 'h2';
endif;
?>
<div class="page-title-area">
    <div class="container">
        <div class="page-title-content">
            <<?php echo esc_attr( $tag ); ?>><?php the_title(); ?></<?php echo esc_attr( $tag ); ?>>
            <?php
            if ( function_exists('yoast_breadcrumb') ) {
                yoast_breadcrumb( '<p class="kiedo-seo-breadcrumbs" id="breadcrumbs">','</p>' );
            } else { ?>
                <ul>
                    <li><a href="<?php echo esc_url( home_url( '/' ) ); ?>"><?php esc_html_e( 'Home', 'kiedo' ); ?></a></li>
                    <li><?php the_title(); ?></li>
                </ul>
            <?php } ?>
        </div>
    </div>

    <?php kiedo_page_shape_images(); ?>
</div>

<div class="products-area products_details ptb-100">
        <div class="container">
            <div class="row">
                <?php if ( is_active_sidebar( 'shop' ) ): ?>
                    <?php if ( isset( $_GET['shop-sidebar'] ) ): ?>
                        <?php  $kiedo_shop_cat_sidebar = $_GET['shop-sidebar']; ?>
                        <?php if ( $kiedo_shop_cat_sidebar == 'none' ): ?>
                            <div class="col-lg-12 col-md-12">
                        <?php elseif ( $kiedo_shop_cat_sidebar == 'left' ): ?>
                            <?php do_action( 'woocommerce_sidebar' ); ?>
                            <div class="col-lg-8 col-md-12">
                        <?php elseif ( $kiedo_shop_cat_sidebar == 'right' ): ?>
                            <div class="col-lg-8 col-md-12">
                        <?php endif; ?>
                    <?php else: ?>
                        <?php if( $kiedo_opt['kiedo_product_sidebar'] == 'kiedo_product_left_sidebar' ): ?>
                            <?php do_action( 'woocommerce_sidebar' ); ?>
                            <div class="col-lg-8 col-md-12">
                        <?php elseif ( $kiedo_opt['kiedo_product_sidebar'] == 'kiedo_product_right_sidebar' ): ?>
                            <div class="col-lg-8 col-md-12">
                        <?php else: ?>
                            <div class="col-lg-12 col-md-12">
                        <?php endif; ?>
                    <?php endif; ?>
                <?php else: ?>
                    <div class="col-lg-12 col-md-12">
                <?php endif; ?>

                    <?php
                    /**
                     * woocommerce_before_main_content hook.
                     *
                     * @hooked woocommerce_output_content_wrapper - 10 (outputs opening divs for the content)
                     * @hooked woocommerce_breadcrumb - 20
                     */

                    do_action( 'woocommerce_before_main_content' );
                    ?>

                        <?php while ( have_posts() ) : the_post(); ?>

                            <?php wc_get_template_part( 'content', 'single-product' ); ?>

                        <?php endwhile; // end of the loop. ?>

                    <?php
                        /**
                         * woocommerce_after_main_content hook.
                         *
                         * @hooked woocommerce_output_content_wrapper_end - 10 (outputs closing divs for the content)
                         */
                        do_action( 'woocommerce_after_main_content' );
                    ?>
                </div>
                <?php
                if ( isset( $_GET['shop-sidebar'] ) ):
                    if ( $kiedo_shop_cat_sidebar == 'right' ) :
                        do_action( 'woocommerce_sidebar' );
                    endif;
                else:
                    if ( $kiedo_opt['kiedo_product_sidebar'] == 'kiedo_product_right_sidebar' ):
                        do_action( 'woocommerce_sidebar' );
                    endif;
                endif;
                ?>
            </div>
        </div>
</div>
<?php get_footer( 'shop' );

/* Omit closing PHP tag at the end of PHP files to avoid "headers already sent" issues. */
?>

