<?php
/**
 * Style One
 * @package WordPress
 * @subpackage Kiedo
*/
	if ( ! function_exists( 'kiedo_nav_area' ) ) {
		function kiedo_nav_area() {
			global $kiedo_opt;

			// Main site logo
			if(isset($kiedo_opt['main_logo']['url'])):
				$logo 	= $kiedo_opt['main_logo']['url'];
			else:
				$logo	= '';
			endif;

			// Logo for mobile device
			if(isset($kiedo_opt['mobile_logo']['url'])):
				$mobile_logo 	= $kiedo_opt['mobile_logo']['url'];
			else:
				$mobile_logo	= '';
			endif;

			// Header Info
			if( isset( $kiedo_opt['header_btn'] ) ):
				$header_btn 		= $kiedo_opt['header_btn'];
				$header_btn_link 	= $kiedo_opt['header_btn_link'];
			else:
				$header_btn 		= '';
			endif;

			if( isset( $kiedo_opt['enable_cart_icon'] ) ):
				$cart_icon 			= $kiedo_opt['enable_cart_icon'];
			else:
				$cart_icon 			= false;
			endif;

			$hide_adminbar = 'hide-adminbar';

			if( function_exists('acf_add_options_page') ) {
				$header_style_two	= get_field( 'header_style_two' );
			}else {
				$header_style_two	= false;
			}
			$header_layout 		= function_exists( 'get_field' ) ? get_field( 'header_layout' ) : 'container';
   			$header_layout 		= isset($header_layout) ? $header_layout : 'container';

			?>
			<div  class="navbar-area <?php if ( is_user_logged_in() ) { echo esc_attr( $hide_adminbar ); } ?> <?php if($header_style_two == true): echo esc_attr__('navbar-style-two', 'kiedo'); endif; ?> <?php if($header_layout == 'container-fluid'): echo esc_attr__('navbar-style-four', 'kiedo'); endif; ?> navbar-style-two">
				<div class="kiedo-responsive-nav">
					<div class="container">
						<div class="kiedo-responsive-menu">
							<div class="logo">
								<a href="<?php echo esc_url( home_url( '/' ) );?>">
									<?php if( $mobile_logo != '' ): ?>
										<img src="<?php echo esc_url( $mobile_logo ); ?>" alt="<?php bloginfo( 'name' ); ?>">
									<?php elseif( $logo != '' ): ?>
										<img src="<?php echo esc_url( $logo ); ?>" alt="<?php bloginfo( 'name' ); ?>">
									<?php else: ?>
										<h2><?php bloginfo( 'name' ); ?></h2>
									<?php endif; ?>
								</a>
							</div>
						</div>
					</div>
				</div>

				<div class="kiedo-nav">
					<div class="<?php echo esc_attr( $header_layout ); ?>">
						<nav class="navbar navbar-expand-lg navbar-light bg-light">
							<a class="navbar-brand <?php if(!has_nav_menu('primary')){echo esc_attr__('logo-without-menu', 'kiedo');} ?>" href="<?php echo esc_url( home_url( '/' ) ); ?>">
								<?php if( $logo != '' ): ?>
									<img src="<?php echo esc_url( $logo ); ?>" alt="<?php bloginfo( 'name' ); ?>">
								<?php else: ?>
									<h2><?php bloginfo( 'name' ); ?></h2>
								<?php endif; ?>
							</a>

							<div class="collapse navbar-collapse mean-menu" id="navbarSupportedContent">
								<?php
								$primary_nav_arg = [
									'menu'            => 'primary',
									'theme_location'  => 'primary',
									'container'       => null,
									'menu_class'      => 'navbar-nav',
									'depth'           => 3,
									'walker'          => new Kiedo_Bootstrap_Navwalker(),
									'fallback_cb'     => 'Kiedo_Bootstrap_Navwalker::fallback',
								];

								if(has_nav_menu('primary')){
									wp_nav_menu($primary_nav_arg);
								}
								?>
								<div class="others-option">
									<?php if ( class_exists( 'WooCommerce' ) ):?>
										<?php if( $cart_icon == true ): ?>
											<a href="<?php echo esc_url(wc_get_cart_url()) ?>" class="cart-link">
												<i class="ri-shopping-cart-2-line"></i>
												<?php kiedo_custom_mini_cart_count(); ?>
											</a>
										<?php endif; ?>
									<?php endif; ?>

									<?php if($header_btn): ?>
										<div class="option-item">
											<a href="<?php echo esc_url( $header_btn_link ); ?>" class="default-btn"><?php echo esc_html($header_btn); ?></a>
										</div>
									<?php endif; ?>
								</div>
							</div>
						</nav>
					</div>
				</div>
			</div>
			<?php
		}
	}