<?php
/**
 * Kiedo post content
 */

global $kiedo_opt;

// Post thumb size
if(isset($kiedo_opt['kiedo_blog_sidebar'])) {
   if( $kiedo_opt['kiedo_blog_sidebar'] == 'kiedo_without_sidebar' ):
        $thumb_size = 'full';
   else:
        $thumb_size = 'kiedo_post_thumb';
   endif;
}else {
    $thumb_size = 'kiedo_post_thumb';
}

if( isset( $kiedo_opt['read_more'] ) ):
    $read_more      = $kiedo_opt['read_more'];
    $blog_style     = $kiedo_opt['kiedo_blog_style'];
else:
    $read_more      = 'Read More';
    $blog_style     = '1';
endif;

// Author info
$get_author_id = get_the_author_meta('ID');

// Blog Column
$kiedo_blog_grid = !empty($kiedo_opt['kiedo_blog_grid']) ? $kiedo_opt['kiedo_blog_grid'] : 'col-lg-12 col-md-12';
if ( !empty($_GET['kiedo_blog_grid']) ) {
    $kiedo_blog_grid = $_GET['kiedo_blog_grid'];
}

?>

<?php if($blog_style == '2'): ?>
    <div <?php post_class( $kiedo_blog_grid ); ?>>
        <div class="single-blog">
            <?php if(has_post_thumbnail()) { ?>
                <div class="image">
                    <a href="<?php the_permalink() ?>" class="d-block">
                        <img src="<?php the_post_thumbnail_url($thumb_size) ?>" alt="<?php the_title_attribute(); ?>">
                    </a>
                    <?php
                        $post_tags  = get_the_tags();
                        $count      = 0;
                        $sep        = '';
                        if ( $post_tags ) {
                            foreach( $post_tags as $tag ) {
                                $count++;
                                if($tag->name):
                                    ?>
                                    <a href="<?php the_permalink() ?>" class="tag"><?php echo esc_html( $tag->name ); ?></a>
                                    <?php
                                endif;
                                if( $count > 0 ) break;
                            }
                        }
                        ?>
                </div>
            <?php } ?>

            <div class="blog-content">

                <?php if( isset( $kiedo_opt['is_post_meta'] ) && $kiedo_opt['is_post_meta'] == true ) { ?>
                    <ul class="meta">
                        <li>
                            <i class="ri-time-line"></i>
                            <?php echo esc_html(get_the_date()); ?>
                        </li>
                        <li>
                            <i class="ri-user-line"></i>
                            <?php echo esc_html(get_the_author()); ?>
                        </li>
                    </ul>
                <?php } ?>

                <?php if( get_the_title() != '' ): ?>
                    <h3><a href="<?php the_permalink() ?>"><?php the_title() ?></a></h3>
                <?php endif; ?>

                <?php if( $read_more != '' ): ?>
                    <a href="<?php the_permalink() ?>" class="default-btn"><?php echo esc_html( $read_more ); ?> </a>
                <?php endif; ?>
            </div>
        </div>
    </div>
<?php else: ?>
    <div <?php post_class( $kiedo_blog_grid ); ?>>
        <div class="single-blog-post">
            <?php if(has_post_thumbnail()) { ?>
                <div class="post-image">
                    <a href="<?php the_permalink() ?>">
                        <img src="<?php the_post_thumbnail_url($thumb_size) ?>" alt="<?php the_title_attribute(); ?>">
                    </a>
                </div>
            <?php } ?>

            <div class="post-content">
                <?php if( isset( $kiedo_opt['is_post_meta'] ) && $kiedo_opt['is_post_meta'] == true ) { ?>
                    <div class="post-meta">
                        <ul class="entry-meta">
                            <li><?php esc_html_e( 'By:', 'kiedo' ); ?> <a href="<?php echo esc_url( get_author_posts_url( get_the_author_meta( 'ID' ), get_the_author_meta( 'user_nicename' ) ) ); ?>"><?php echo esc_html(get_the_author()); ?></a></li>
                            <li><?php echo esc_html(get_the_date()); ?></li>
                        </ul>
                    </div> <?php
                } ?>

                <?php if( get_the_title() != '' ): ?>
                    <h3><a href="<?php the_permalink() ?>"><?php the_title() ?></a></h3>
                <?php endif; ?>
                <?php the_excerpt() ?>

                <?php if( $read_more != '' ): ?>
                    <a href="<?php the_permalink() ?>" class="default-btn"><?php echo esc_html( $read_more ); ?> </a>
                <?php endif; ?>
            </div>
        </div>
    </div>
<?php endif; ?>