<?php
/**
 * The single template file
 * @package Kiedo
 */
get_header();

$title = get_the_title();

// Blog sidebar
if(isset($kiedo_opt['kiedo_single_blog_sidebar'])) {
    if( $kiedo_opt['kiedo_single_blog_sidebar'] == 'kiedo_without_sidebar_center' ):
        $kiedo_sidebar_class = 'col-lg-8 col-md-12 offset-lg-2';
    elseif( $kiedo_opt['kiedo_single_blog_sidebar'] == 'kiedo_without_sidebar' ):
        $kiedo_sidebar_class = 'col-lg-12 col-md-12';
    else:
        if( is_active_sidebar( 'sidebar-1' ) ):
            $kiedo_sidebar_class = 'col-lg-8 col-md-12';
        else:
            $kiedo_sidebar_class = 'col-lg-8 col-md-12 offset-lg-2';
        endif;
    endif;
    $sidebar_hide = $kiedo_opt['kiedo_single_blog_sidebar'];
} else {
    if( is_active_sidebar( 'sidebar-1' ) ):
        $kiedo_sidebar_class = 'col-lg-8 col-md-12';
        $sidebar_hide = 'kiedo_with_sidebar';
    else:
        $kiedo_sidebar_class = 'col-lg-8 col-md-12 offset-lg-2';
        $sidebar_hide = 'kiedo_without_sidebar';
    endif;
}

// Blog breadcrumb
if( isset($kiedo_opt['blog_title']) ) {
    $hide_breadcrumb    	= $kiedo_opt['hide_breadcrumb'];
    $blog_title             = $kiedo_opt['blog_title'];
    $hide_blog_banner       = $kiedo_opt['hide_blog_banner'];
} else {
    $hide_breadcrumb    	= 	false;
    $blog_title             = esc_html__('Blog', 'kiedo');
    $hide_blog_banner       = false;
}

if( function_exists('acf_add_options_page') ) {
	$bg_img = get_field( 'post_banner_background_image' );
}else {
	$bg_img = '';
}

// Blog page link
if ( get_option( 'page_for_posts' ) ) {
	$blog_link = get_permalink( get_option( 'page_for_posts' ));
}else{
	$blog_link = home_url( '/' );
}

$kiedo_blog_single_layout = !empty($kiedo_opt['kiedo_blog_single_layout']) ? $kiedo_opt['kiedo_blog_single_layout'] : 'container';
if ( !empty($_GET['kiedo_blog_single_layout']) ) {
    $kiedo_blog_single_layout = $_GET['kiedo_blog_single_layout'];
}

if( isset($kiedo_opt['page_title_tag']) ):
    $tag = $kiedo_opt['page_title_tag'];
else:
    $tag = 'h2';
endif;
?>
    <?php if( $hide_blog_banner == false ): ?>
		<div class="page-title-area">
            <div class="container">
                <div class="page-title-content max-width">
                    <<?php echo esc_attr( $tag ); ?>>
						<?php
							if( !empty(get_the_title()) ):
								the_title();
							else:
								esc_html_e( 'No Title', 'kiedo' );
							endif;
						?>
					</<?php echo esc_attr( $tag ); ?>>

                    <?php if( $hide_breadcrumb == false ): ?>
                        <?php
                            if ( function_exists('yoast_breadcrumb') ) {
                                yoast_breadcrumb( '<p class="kiedo-seo-breadcrumbs" id="breadcrumbs">','</p>' );
                            } else { ?>
                                <ul>
                                    <li><a href="<?php echo esc_url( home_url( '/' ) ); ?>"><?php esc_html_e( 'Home', 'kiedo' ); ?></a></li>
                                    <li>
										<?php
											if( !empty(get_the_title()) ):
												the_title();
											else:
												esc_html_e( 'No Title', 'kiedo' );
											endif;
										?>
									</li>
                                </ul>
                                <?php
                            }
                    endif; ?>
                </div>
            </div>
        	<?php kiedo_page_shape_images(); ?>
        </div>
	<?php endif; ?>

	<!-- Start Blog Area -->
	<div class="blog-details-area ptb-100">
		<div class="<?php echo esc_attr( $kiedo_blog_single_layout ); ?>">
			<div class="row">
				<?php
				while ( have_posts() ) :
				the_post(); ?>
					<div class="<?php echo esc_attr( $kiedo_sidebar_class ); ?>">
						<div class="blog-details">
							<?php if(has_post_thumbnail()) { ?>
								<div class="post-image">
									<img src="<?php the_post_thumbnail_url('full') ?>" alt="<?php the_title_attribute(); ?>">
								</div>
							<?php } ?>

							<div class="blog-details-content">
								<?php if( isset( $kiedo_opt['is_post_meta'] ) && $kiedo_opt['is_post_meta'] == true ) { ?>
									<div class="blog-meta">
										<ul class="entry-meta">
											<li>
												<i class="ri-user-line"></i>
												<a href="<?php echo esc_url( get_author_posts_url( get_the_author_meta( 'ID' ), get_the_author_meta( 'user_nicename' ) ) ); ?>"><?php echo esc_html(get_the_author()); ?></a>
											</li>
											<li>
												<i class="ri-time-line"></i>
												<?php echo wp_kses_post(get_the_date('F d, Y')) ?>
											</li>
											<li>
												<i class="ri-message-2-line"></i>
												<?php comments_number(); ?>
											</li>
										</ul>
									</div> <?php
								} ?>

								<?php the_content();

								wp_link_pages( array(
									'before' => '<div class="page-links">' . esc_html__( 'Pages:', 'kiedo' ),
									'after'  => '</div>',
								) );
								?>

								<?php if ( get_the_tags() ) {  ?>
								<div class="post-tag-media">
									<ul class="tag">
										<li><span><?php echo esc_html_e('Tags:', 'kiedo') ?></span></li>
										<?php $tags = get_the_tags();
										foreach ($tags as $tag ) {  ?>
												<li><a href="<?php echo esc_url(get_tag_link($tag->term_id)); ?>">
													<?php echo esc_html($tag->name) ?></a>
												</li>
											<?php
										} ?>
									</ul>
								</div>
								<?php } ?>
							</div>
						</div>

						<?php
							// If comments are open or we have at least one comment, load up the comment template.
							if ( comments_open() || get_comments_number() ) :
								comments_template();
							endif;
						?>
					</div>
				<?php endwhile; // End of the loop. ?>

				<?php if( $sidebar_hide == 'kiedo_with_sidebar' ): ?>
					<?php get_sidebar(); ?>
				<?php endif; ?>

			</div>
		</div>
	</div>
	<!-- End Blog Area -->

<?php
get_footer();