<?php
/**
 * Single Features
 */
    get_header();

    global $kiedo_opt;

    $hide_career_banner        =   $kiedo_opt['hide_career_banner'];
    $hide_career_breadcrumb    =   $kiedo_opt['hide_career_breadcrumb'];

    if( $hide_career_banner == false ):
        $pt_165   = '';
    else:
        $pt_165   = 'pt-165';
    endif;

    // Page Title
    if( isset($kiedo_opt['page_title_tag']) ):
        $tag = $kiedo_opt['page_title_tag'];
    else:
        $tag = 'h2';
    endif;

    if ( class_exists('ACF') ) {
        $job_location    = get_field('job_location_label');
        $career_job_type = get_field('career_job_type');
    } else {
        $job_location    = '';
        $career_job_type = '';
    }

?>
    <!-- Start Page Title Area -->
    <?php if( $hide_career_banner == false ): ?>
        <div class="page-title-area">
            <div class="container">
                <div class="page-title-content">
					<<?php echo esc_attr( $tag ); ?>><?php the_title(); ?></<?php echo esc_attr( $tag ); ?>>

                    <?php if( $hide_career_breadcrumb == false ): ?>
						<?php if ( function_exists('yoast_breadcrumb') ) {
                            yoast_breadcrumb( '<p class="kiedo-seo-breadcrumbs" id="breadcrumbs">','</p>' );
                        } else { ?>
                            <ul>
                                <li><a href="<?php echo esc_url( home_url( '/' ) ); ?>"><?php esc_html_e( 'Home', 'kiedo' ); ?></a></li>
                                <li><?php echo esc_html( $job_location  ); ?></li>
                                <li><?php echo esc_html( $career_job_type  ); ?></li>
                            </ul>
                            <?php
                        }
					endif; ?>
                </div>
            </div>

           <?php kiedo_page_shape_images(); ?>
        </div>
    <?php endif; ?>
    <!-- End Page Title Area -->

    <?php if( !kiedo_is_elementor()): ?><section class="features-details-area ptb-100 <?php echo esc_attr( $pt_165 ); ?>"><?php endif; ?>
        <?php if( !kiedo_is_elementor()): ?><div class="container"><?php endif; ?>
            <?php while ( have_posts() ) : the_post(); ?>
                <?php the_content(); ?>
            <?php endwhile; ?>
    <?php if( !kiedo_is_elementor()): ?><div></section><?php endif; ?>

<?php get_footer();