<?php
/**
 * The main template file
 * @package kiedo
 */
get_header();

    // Blog Sidebar
    if(isset($kiedo_opt['kiedo_blog_sidebar'])) {
        if( $kiedo_opt['kiedo_blog_sidebar'] == 'kiedo_without_sidebar_center' ):
            $kiedo_sidebar_class = 'col-lg-8 col-md-12 offset-lg-2';
        elseif( $kiedo_opt['kiedo_blog_sidebar'] == 'kiedo_without_sidebar' ):
            $kiedo_sidebar_class = 'col-lg-12 col-md-12';
        else:
            if( is_active_sidebar( 'sidebar-1' ) ):
                $kiedo_sidebar_class = 'col-lg-8 col-md-12';
            else:
                $kiedo_sidebar_class = 'col-lg-8 col-md-12 offset-lg-2';
            endif;
        endif;
        $sidebar_hide = $kiedo_opt['kiedo_blog_sidebar'];
    } else {
        if( is_active_sidebar( 'sidebar-1' ) ):
            $kiedo_sidebar_class = 'col-lg-8 col-md-12';
            $sidebar_hide = 'kiedo_with_sidebar';
        else:
            $kiedo_sidebar_class = 'col-lg-8 col-md-12 offset-lg-2';
            $sidebar_hide = 'kiedo_without_sidebar';
        endif;
    }

    // Blog title and breadcrumb
    if( isset($kiedo_opt['blog_title']) ) {
        $title                  = $kiedo_opt['blog_title'];
        $hide_breadcrumb        = $kiedo_opt['hide_breadcrumb'];
        $hide_blog_banner       = $kiedo_opt['hide_blog_banner'];
    } else {
        $title                  = esc_html__('Blog', 'kiedo');
        $hide_breadcrumb        = false;
        $hide_blog_banner       = false;
    }

    $kiedo_blog_layout = !empty($kiedo_opt['kiedo_blog_layout']) ? $kiedo_opt['kiedo_blog_layout'] : 'container';

    if ( !empty($_GET['kiedo_blog_layout']) ) {
        $kiedo_blog_layout = $_GET['kiedo_blog_layout'];
    }

    if( isset($kiedo_opt['page_title_tag']) ):
        $tag = $kiedo_opt['page_title_tag'];
    else:
        $tag = 'h2';
    endif;
    ?>

    <!-- Start Page Title Area -->
    <?php if( $hide_blog_banner == false ): ?>
        <div class="page-title-area">
            <div class="container">
                <div class="page-title-content">
					<<?php echo esc_attr( $tag ); ?>><?php echo esc_html( $title ); ?></<?php echo esc_attr( $tag ); ?>>

                    <?php if( $hide_breadcrumb == false ): ?>
						<?php
							if ( function_exists('yoast_breadcrumb') ) {
								yoast_breadcrumb( '<p class="kiedo-seo-breadcrumbs" id="breadcrumbs">','</p>' );
							} else { ?>
								<ul>
									<li><a href="<?php echo esc_url( home_url( '/' ) ); ?>"><?php esc_html_e( 'Home', 'kiedo' ); ?></a></li>
									<li><?php echo esc_html( $title ); ?></li>
								</ul>
								<?php
							}
					endif; ?>
                </div>
            </div>

           <?php kiedo_page_shape_images(); ?>
        </div>
    <?php endif; ?>
    <!-- End Page Title Area -->

    <!-- Start Blog Area -->
    <div class="blog-area pt-100 pb-75">
        <div class="<?php echo esc_attr( $kiedo_blog_layout ); ?>">
            <div class="row">
                <!-- Start Blog Content -->
                <div class="<?php echo esc_attr( $kiedo_sidebar_class ); ?>">
                    <div class="row">
                        <?php
                        if ( have_posts() ) :
                            while ( have_posts() ) :
                                the_post();
                                get_template_part( 'template-parts/content', get_post_format());
                            endwhile;
                        else :
                            get_template_part( 'template-parts/content', 'none' );
                        endif;
                        ?>

                        <?php if(paginate_links()): ?>
                            <!-- Stat Pagination -->
                            <div class="col-lg-12 col-md-12">
                                <div class="pagination-area">
                                    <?php echo paginate_links( array(
                                        'format' => '?paged=%#%',
                                        'prev_text' => '<i class="ri-arrow-left-line"></i>',
                                        'next_text' => '<i class="ri-arrow-right-line"></i>',
                                            )
                                        ) ?>
                                </div>
                            </div>
                        <?php endif; ?>
                    </div>
                </div>
                <!-- End Blog Content -->

                <?php if( $sidebar_hide == 'kiedo_with_sidebar' ): ?>
                    <?php get_sidebar(); ?>
                <?php endif; ?>
            </div>
        </div>
    </div>
    <!-- End Blog Area -->
<?php
get_footer();