<?php

if ( ! function_exists( 'kiedo_wc_refresh_mini_cart_count' ) ) :
	function kiedo_wc_refresh_mini_cart_count($fragments){

		$cart_number = WC()->cart->get_cart_contents_count();
		ob_start();
		?>
		<span class="mini-cart-count">
			<?php echo esc_html(WC()->cart->get_cart_contents_count()); ?>
		</span>
		<?php
			$fragments['.mini-cart-count'] = ob_get_clean();
		return $fragments;
	}
endif;
add_filter( 'woocommerce_add_to_cart_fragments', 'kiedo_wc_refresh_mini_cart_count');


// Enqueue JavaScript for AJAX
function kiedo_enqueue_custom_scripts() {
    wp_enqueue_script( 'custom-ajax-script', get_template_directory_uri() . '/assets/js/custom-ajax-script.js', array( 'jquery' ), '1.0', true );
    wp_localize_script( 'custom-ajax-script', 'customAjax', array(
        'ajaxUrl' => admin_url( 'admin-ajax.php' ),
        'nonce'   => wp_create_nonce( 'custom-ajax-nonce' ),
    ) );
}
add_action( 'wp_enqueue_scripts', 'kiedo_enqueue_custom_scripts' );

// Update mini-cart count using AJAX
function kiedo_update_mini_cart_count() {
    check_ajax_referer( 'custom-ajax-nonce', 'security' );

    $count = WC()->cart->get_cart_contents_count();

    wp_send_json( $count );
}
add_action( 'wp_ajax_kiedo_update_mini_cart_count', 'kiedo_update_mini_cart_count' );
add_action( 'wp_ajax_nopriv_kiedo_update_mini_cart_count', 'kiedo_update_mini_cart_count' );

// Update mini-cart count in the header
function kiedo_custom_mini_cart_count() {
    $count = WC()->cart->get_cart_contents_count();
    ?>
    <span class="mini-cart-count"><?php echo esc_html( $count ); ?></span>
    <?php
}

// Update mini-cart count via AJAX after cart update
function kiedo_update_mini_cart_count_after_update() {
    ob_start();
    kiedo_custom_mini_cart_count();
    $mini_cart_count = ob_get_clean();
    wp_send_json_success( $mini_cart_count );
}
add_action( 'wp_ajax_kiedo_update_mini_cart_count_after_update', 'kiedo_update_mini_cart_count_after_update' );
add_action( 'wp_ajax_nopriv_kiedo_update_mini_cart_count_after_update', 'kiedo_update_mini_cart_count_after_update' );