<?php
/**
 * Kiedo functions and definitions
 * @package Kiedo
 */


/**
 * Shorthand contents for theme assets url
 */

define('KIEDO_VERSION', time());
define('KIEDO_THEME_URI', get_template_directory_uri());
define('KIEDO_THEME_DIR', get_template_directory());
define('KIEDO_IMG',KIEDO_THEME_URI . '/assets/img');
define('KIEDO_CSS',KIEDO_THEME_URI . '/assets/css');
define('KIEDO_JS',KIEDO_THEME_URI . '/assets/js');
if( !defined('KIEDO_FRAMEWORK_VAR') ) define('KIEDO_FRAMEWORK_VAR', 'kiedo_opt');

/**
 * Sets up theme defaults and registers support for various WordPress features.
 */
if ( ! function_exists( 'kiedo_setup' ) ) :

	function kiedo_setup() {

		// Make theme available for translation.
		load_theme_textdomain( 'kiedo', KIEDO_THEME_DIR. '/languages' );

		// Add default posts and comments RSS feed links to head.
		add_theme_support( 'automatic-feed-links' );

		// Let WordPress manage the document title.
		add_theme_support( 'title-tag' );

		// Enable support for Post Thumbnails on posts and pages.
		add_theme_support( 'post-thumbnails' );

		add_theme_support( 'yoast-seo-breadcrumbs' );

		// Kiedo blog post image size for EL
		// add_image_size( 'kiedo_post_thumb', 730, 400, true );

		// WooCommerce support
		add_theme_support( 'woocommerce' );
		add_theme_support( 'wc-product-gallery-lightbox' );
		add_theme_support( 'wc-product-gallery-slider' );

		// Switch default core markup for search form, comment form, and comments
		add_theme_support( 'html5', array(
			'search-form',
			'comment-form',
			'comment-list',
			'gallery',
			'caption',
		) );

		// Add theme support for selective refresh for widgets.
		add_theme_support( 'customize-selective-refresh-widgets' );
	}
endif;
add_action( 'after_setup_theme', 'kiedo_setup' );

/**
 * Set the content width in pixels, based on the theme's design and stylesheet.
 */
function kiedo_content_width() {
	// This variable is intended to be overruled from themes.
	$GLOBALS['content_width'] = apply_filters( 'kiedo_content_width', 640 );
}
add_action( 'after_setup_theme', 'kiedo_content_width', 0 );

/**
 * Enqueue scripts and styles.
 */
if ( ! function_exists( 'kiedo_scripts' ) ) :

	function kiedo_scripts() {
		global $kiedo_opt;

		wp_enqueue_style( 'kiedo-style', get_stylesheet_uri() );
		wp_style_add_data( 'kiedo-style', 'rtl', 'replace' );

		wp_enqueue_style( 'bootstrap', 			KIEDO_CSS . '/bootstrap.min.css', null, KIEDO_VERSION );
		wp_enqueue_style( 'aos', 				KIEDO_CSS . '/aos.css', null, KIEDO_VERSION );
		wp_enqueue_style( 'meanmenu', 			KIEDO_CSS . '/meanmenu.min.css', null, KIEDO_VERSION );
		wp_enqueue_style( 'fontawesome', 		KIEDO_CSS . '/fontawesome.min.css', null, KIEDO_VERSION );
		wp_enqueue_style( 'remixicon', 			KIEDO_CSS . '/remixicon.css', null, KIEDO_VERSION );
		wp_enqueue_style( 'odometer', 			KIEDO_CSS . '/odometer.min.css', null, KIEDO_VERSION );
		wp_enqueue_style( 'magnific-popup', 	KIEDO_CSS . '/magnific-popup.min.css', null, KIEDO_VERSION );
		wp_enqueue_style( 'swiper-bundle', 			KIEDO_CSS . '/swiper-bundle.min.css', null, KIEDO_VERSION );
		wp_enqueue_style( 'owl-carousel', 		KIEDO_CSS . '/owl.carousel.min.css', null, KIEDO_VERSION );
		wp_enqueue_style( 'owl-theme-default', 	KIEDO_CSS . '/owl.theme.default.min.css', null, KIEDO_VERSION );
		if( kiedo_rtl() == true ):
			// WooCommerce CSS
			if ( class_exists( 'WooCommerce' ) ):
				wp_enqueue_style( 'kied-woocommerce',  	KIEDO_CSS . '/rtl/woocommerce-rtl.css');
			endif;
			// BuddyPress CSS
			if ( class_exists( 'BuddyPress' ) ):
				wp_enqueue_style( 'kiedo-buddypress',  	KIEDO_CSS . '/rtl/buddypress-rtl.css');
			endif;
			wp_enqueue_style( 'kiedo-main-style', 	KIEDO_CSS . '/rtl/style-rtl.css', null, KIEDO_VERSION );
			wp_enqueue_style( 'kiedo-responsive', 	KIEDO_CSS . '/rtl/responsive-rtl.css', null, KIEDO_VERSION );
			wp_enqueue_style( 'kiedo-blog', 	    KIEDO_CSS . '/rtl/blog-rtl.css', null, KIEDO_VERSION );
		else:
			// WooCommerce CSS
			if ( class_exists( 'WooCommerce' ) ):
				wp_enqueue_style( 'kied-woocommerce', get_template_directory_uri() . '/assets/css/woocommerce.css');
			endif;
			// BuddyPress CSS
			if ( class_exists( 'BuddyPress' ) ):
				wp_enqueue_style( 'kiedo-buddypress', get_template_directory_uri() . '/assets/css/buddypress.css');
			endif;
			wp_enqueue_style( 'kiedo-main-style', 	KIEDO_CSS . '/style.css', null, KIEDO_VERSION );
			wp_enqueue_style( 'kiedo-responsive', 	KIEDO_CSS . '/responsive.css', null, KIEDO_VERSION );
			wp_enqueue_style( 'kiedo-blog', 	    KIEDO_CSS . '/blog.css', null, KIEDO_VERSION );
		endif;

		// RTL CSS
		if( kiedo_rtl() == true ):
			wp_enqueue_style( 'kiedo-rtl', get_template_directory_uri() . '/style-rtl.css' );
		endif;

		wp_enqueue_script( 'bootstrap', 			KIEDO_JS . '/bootstrap.min.js', array('jquery'), KIEDO_VERSION );
		wp_enqueue_script( 'jquery-meanmenu', 		KIEDO_JS . '/jquery.meanmenu.js', array('jquery'), KIEDO_VERSION );
		wp_enqueue_script( 'owl-carousel', 			KIEDO_JS . '/owl.carousel.min.js', array('jquery'), KIEDO_VERSION );
		wp_enqueue_script( 'swiper-bundle', 		KIEDO_JS . '/swiper-bundle.min.js', array('jquery'), KIEDO_VERSION );
		wp_enqueue_script( 'jquery-appear', 		KIEDO_JS . '/jquery.appear.js', array('jquery'), KIEDO_VERSION );
		wp_enqueue_script( 'odometer', 				KIEDO_JS . '/odometer.min.js', array('jquery'), KIEDO_VERSION );
		wp_enqueue_script( 'jquery-magnific-popup', KIEDO_JS . '/jquery.magnific-popup.min.js', array('jquery'), KIEDO_VERSION );
		wp_enqueue_script( 'jquery-ajaxchimp', 		KIEDO_JS . '/jquery.ajaxchimp.min.js', array('jquery'), KIEDO_VERSION );
		wp_enqueue_script( 'aos', 					KIEDO_JS . '/aos.js', array('jquery'), KIEDO_VERSION );
		wp_enqueue_script( 'kiedo-main', 			KIEDO_JS . '/main.js', array('jquery'), KIEDO_VERSION );

		wp_deregister_style( 'bp-nouveau' );

		if ( is_singular() && comments_open() && get_option( 'thread_comments' ) ) {
			wp_enqueue_script( 'comment-reply' );
		}
	}

endif;
add_action( 'wp_enqueue_scripts', 'kiedo_scripts' );

if ( ! function_exists( 'kiedo_fonts' ) ) {
	function kiedo_fonts() {
		wp_enqueue_style( 'kiedo-fonts', "//fonts.googleapis.com/css2?family=Inter:wght@100;200;300;400;500;600;700;800;900&display=swap", '', '1.0.0', 'screen' );
	}
}
add_action( 'wp_enqueue_scripts', 'kiedo_fonts' );

/**
 * Custom template tags for this theme.
 */
require KIEDO_THEME_DIR. '/inc/template-tags.php';

/**
 * Functions which enhance the theme by hooking into WordPress.
 */
require KIEDO_THEME_DIR. '/inc/template-functions.php';

/**
 * Customizer additions.
 */
require KIEDO_THEME_DIR. '/inc/customizer.php';

/**
 * Load Jetpack compatibility file.
 */
if ( defined( 'JETPACK__VERSION' ) ) {
	require KIEDO_THEME_DIR. '/inc/jetpack.php';
}

/**
 * Load bootstrap navwalker
 */
require KIEDO_THEME_DIR. '/inc/bootstrap-navwalker.php';

/**
 * Load theme widgets
 */
require KIEDO_THEME_DIR. '/inc/widget.php';

/**
 * Custom style
 */
require KIEDO_THEME_DIR. '/inc/custom-style.php';

/**
 * Social link
*/
require KIEDO_THEME_DIR. '/inc/social-link.php';

/**
 * Header Style
*/
require KIEDO_THEME_DIR. '/template-parts/header/style-1.php';

/**
 * Recommended plugin
*/
require KIEDO_THEME_DIR. '/lib/recommended-plugin.php';

/**
 * ACF meta filed
*/
require KIEDO_THEME_DIR. '/inc/acf.php';

// Load WooCommerce compatibility file.
if ( class_exists( 'WooCommerce' ) ):
	require KIEDO_THEME_DIR . '/inc/woocommerce.php';
endif;

// Load BuddyPress compatibility file.
if ( class_exists( 'BuddyPress' ) ) {
	require get_template_directory() . '/inc/buddypress-functions.php';
}

/**
 * Filter the categories archive widget to add a span around post count
 */
if ( ! function_exists( 'kiedo_cat_count_span' ) ) {
	function kiedo_cat_count_span( $links ) {
		$links = str_replace( '</a> (', '</a><span class="post-count">(', $links );
		$links = str_replace( ')', ')</span>', $links );
		return $links;
	}
}
add_filter( 'wp_list_categories', 'kiedo_cat_count_span' );

/**
 * Filter the archives widget to add a span around post count
 */
if ( ! function_exists( 'kiedo_archive_count_span' ) ) {
	function kiedo_archive_count_span( $links ) {
		$links = str_replace( '</a>&nbsp;(', '</a><span class="post-count">(', $links );
		$links = str_replace( ')', ')</span>', $links );
		return $links;
	}
}
add_filter( 'get_archives_link', 'kiedo_archive_count_span' );

/**
 * Excerpt more text
 */
if ( ! function_exists( 'kiedo_excerpt_more' ) ) :
	function kiedo_excerpt_more( $more ) {
		return ' ';
	}
endif;
add_filter('excerpt_more', 'kiedo_excerpt_more');

/**
 * Remove pages from search result
 */
if ( ! function_exists( 'kiedo_remove_pages_from_search' ) ) :
    function kiedo_remove_pages_from_search() {
		global $kiedo_opt;
		global $wp_post_types;

		if( isset( $kiedo_opt['kiedo_search_page'] ) ):
			if( $kiedo_opt['kiedo_search_page'] != true ):
				$wp_post_types['page']->exclude_from_search = true;
			else:
				$wp_post_types['page']->exclude_from_search = false;
			endif;
		else:
			$wp_post_types['page']->exclude_from_search = false;
		endif;
	}
endif;
add_action('init', 'kiedo_remove_pages_from_search');

/**
 * If page edited by elementor
 */
if ( ! function_exists( 'kiedo_is_elementor' ) ) :
	function kiedo_is_elementor(){
		if ( function_exists( 'elementor_fail_php_version' ) ):
			global $post;
			if( $post != '' ):
				return \Elementor\Plugin::$instance->documents->get($post->ID)->is_built_with_elementor();
			endif;
		endif;
	}
endif;

/**
 * If page edited by elementor
 */
if ( ! function_exists( 'kiedo_register_primary_menus' ) ) :
	function kiedo_register_primary_menus(){
		register_nav_menus(
			array(
				'primary' 		=> esc_html__('Primary Menu', 'kiedo'),
			)
		);
	}
endif;
add_action('init', 'kiedo_register_primary_menus');

/**
 * Admin dashboard style and scripts
 */
add_action( 'admin_enqueue_scripts', function() {
    global $pagenow;
    wp_enqueue_script( 'kiedo-admin', KIEDO_JS .'/kiedo-admin.js', array('jquery'), '1.0.0', true );
    if ( $pagenow == 'admin.php' ) {
		wp_enqueue_style( 'kiedo-admin-dashboard', KIEDO_CSS .'/admin-dashboard.min.css' );
    }
});

/**
 * Notice dismiss handle
 */
add_action( 'admin_init', function() {
    if ( isset($_GET['dismissed']) && $_GET['dismissed'] == 1 ) {
        update_option('notice_dismissed', '1');
    }
    if ( isset($_GET['plugin_dismissed']) && $_GET['plugin_dismissed'] == 1 ) {
        update_option('plugin_notice_dismissed', '1');
    }
});

// Disables the block editor from managing widgets in the Gutenberg plugin.
add_filter( 'gutenberg_use_widgets_block_editor', '__return_false', 100 );
// Disables the block editor from managing widgets. renamed from wp_use_widgets_block_editor
add_filter( 'use_widgets_block_editor', '__return_false' );
