<?php
/**
 * The template for displaying 404 pages (not found)
 *
 * @package Kiedo
 */

global $kiedo_opt;

get_header();

if ( isset( $kiedo_opt['title_not_found'] ) ):
	$banner_title	= $kiedo_opt['banner_title_not_found'];
	$title 			= $kiedo_opt['title_not_found'];
	$content 		= $kiedo_opt['content_not_found'];
	$button 		= $kiedo_opt['button_not_found'];
	$image 			= $kiedo_opt['not_found_image']['url'];
else:
	$banner_title	= esc_html__('404 Error', 'kiedo');
	$title 			=  esc_html__('Page Not Found', 'kiedo');
	$content 		=  esc_html__('The page you are looking for might have been removed had its name changed or is temporarily unavailable.', 'kiedo');
	$button 		=  esc_html__('Go to Home', 'kiedo');
	$image 			= '';
endif;

// Page Title
if( isset($kiedo_opt['page_title_tag']) ):
    $tag = $kiedo_opt['page_title_tag'];
else:
    $tag = 'h2';
endif;
?>

<?php if($banner_title): ?>
	<div class="page-title-area">
		<div class="container">
			<div class="page-title-content">
				<<?php echo esc_attr( $tag ); ?>><?php echo esc_html( $banner_title ); ?></<?php echo esc_attr( $tag ); ?>>

					<?php
						if ( function_exists('yoast_breadcrumb') ) {
							yoast_breadcrumb( '<p class="kiedo-seo-breadcrumbs" id="breadcrumbs">','</p>' );
						} else { ?>
							<ul>
								<li><a href="<?php echo esc_url( home_url( '/' ) ); ?>"><?php esc_html_e( 'Home', 'kiedo' ); ?></a></li>
								<li><?php echo esc_html( $banner_title ); ?></li>
							</ul>
							<?php
						}
					?>
			</div>
		</div>

		<?php kiedo_page_shape_images(); ?>
	</div>
<?php endif;?>

<div class="error-area ptb-100">
	<div class="d-table">
		<div class="d-table-cell">
			<div class="container">
				<div class="error-content">
					<?php if( $image != '' ): ?>
						<img src="<?php echo esc_url( $image ); ?> " alt="<?php echo esc_attr( $title ); ?>">
					<?php endif; ?>

					<h3><?php echo esc_html( $title ); ?></h3>
					<p><?php echo esc_html( $content ); ?></p>

					<?php if(  $button != '' ): ?>
						<a href="<?php echo esc_url( home_url( '/' ) ); ?>" class="default-btn"><?php echo esc_html( $button ); ?></a>
					<?php endif; ?>
				</div>
			</div>
		</div>
	</div>
</div>

<?php get_footer();