<?php

class TlpPortfolioElementorWidget extends \Elementor\Widget_Base
{

    public function get_name() {
        return 'tlp-portfolio-pro';
    }

    public function get_title() {
        return esc_html__('Portfolio Pro', 'tlp-portfolio-pro');
    }

    public function get_icon() {
        return 'eicon-gallery-grid';
    }

    public function get_categories() {
        return ['general'];
    }

    public function get_script_depends() {
        return ['pfp-owl-carousel', 'pfp-image-load', 'pfp-isotope', 'pfp'];
    }
    
    public function get_style_depends() {
		return [ 'pfp-owl-carousel', 'pfp-owl-carousel-theme' ];
	}

    protected function register_controls() {
        $this->start_controls_section(
            'setting_section',
            [
                'label' => esc_html__('TLP Portfolio Shortcode', 'tlp-portfolio-pro'),
                'tab'   => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );

        $this->add_control(
            'tlp_portfolio_id',
            array(
                'type'    => \Elementor\Controls_Manager::SELECT2,
                'id'      => 'tlp_portfolio_id',
                'label'   => esc_html__('Portfolio grid', 'tlp-portfolio-pro'),
                'options' => TLPpPro()->get_shortCode_list()
            )
        );
        $this->end_controls_section();
    }

    protected function render() {

        $settings = $this->get_settings_for_display();
        if (isset($settings['tlp_portfolio_id']) && !empty($settings['tlp_portfolio_id']) && $id = absint($settings['tlp_portfolio_id'])) {
            echo do_shortcode('[tlpportfolio id="' . $id . '"]');
        } else {
            echo esc_html__("Please select a portfolio shordcode", "tlp-portfolio-pro");
        }

        $this->edit_mode_script();
    }
    
    /**
     * Elementor Edit mode need some extra js for isotop reinitialize 
     *
     * @return mixed
     */
    public function edit_mode_script(){
        if ( \Elementor\Plugin::$instance->editor->is_edit_mode() ) {
        ?>
            <script>
                var container = jQuery('.pfp-wrapper');
                if (container.find('.pfp-isotope').length) {
                    container.find('.pfp-isotope').isotope();
                }
                if (container.find('.pfp-row.pfp-masonry').length) {
                    var masonryTarget = container.find('.pfp-row.pfp-masonry');
                        masonryTarget.isotope({
                            itemSelector: '.masonry-grid-item',
                            masonry: {columnWidth: '.masonry-grid-item'}
                        });
                }
            </script>
            <?php
        }

    }


}
