<?php
	/**
	 * Dynamic Css generator 
	 */
	$layoutID   = "pfp-container-" . $scID;
	$meta        = get_post_meta( $scID );
	$css = null ;

	$primaryColor = ( ! empty( $meta['pfp_primary_color'][0] ) ? sanitize_text_field( $meta['pfp_primary_color'][0] ) : null );
	if ( $primaryColor ) {
		
		$css .= ".{$layoutID}.tlp-popup-wrap .tlp-popup-navigation-wrap,nav.tlp-pagination ul.page-numbers li .page-numbers {";
		$css .= "background:" . $primaryColor . ";";
		$css .= "}";
		$css .= "#{$layoutID} .tlp-portfolio-item .tlp-content,#{$layoutID} .pfp-layout7 .short-desc p, #{$layoutID} .pfp-isotope6 .tlp-portfolio-item p,#{$layoutID} .pfp-carousel6 .tlp-portfolio-item p,#{$layoutID} .tlp-portfolio .isotop-btn button, #{$layoutID} .tlp-overlay .tlp-title, #{$layoutID} .tlp-overlay .line, #{$layoutID} .pfp-layout19 figcaption, #{$layoutID} .pfp-isotope18 figcaption, #{$layoutID} .pfp-carousel18 figcaption {";
		$css .= "background:" . $primaryColor . ";";
		$css .= "}";
		$css .= "#{$layoutID} .tlp-portfolio-item .tlp-overlay h3,#{$layoutID} .tlp-portfolio-item .tlp-overlay16 h3, #{$layoutID} .tlp-portfolio-item .tlp-overlay17 h3 {";
		$css .= "border-color:" . $primaryColor . ";";
		$css .= "}";
		$css .= "#{$layoutID} .pfp-layout19 figure:hover figcaption,#{$layoutID} .pfp-isotope18 figure:hover figcaption, #{$layoutID} .pfp-carousel18 figure:hover figcaption {";
		$css .= "box-shadow: 0 0 0 10px" . $primaryColor . ";";
		$css .= "}";
		$css .= "#{$layoutID} .flex-direction-nav a:before {";
		$css .= "color:" . $primaryColor . ";";
		$css .= "}";
		$css .= "#{$layoutID} .tlp-portfolio-item .tlp-content-holder{padding:15px}";
		$css .= "#{$layoutID} .tlp-portfolio-item .tlp-content2{padding: 0;}";
	}

// .pfp-wrapper .pfp-layout3 .tlp-content2 .tlp-content-holder, .pfp-wrapper .pfp-isotope2 .tlp-content2 .tlp-content-holder, .pfp-wrapper .pfp-carousel2 .tlp-content2 .tlp-content-holder

	/* Button background color */
	$buttonBgColor  = ( ! empty( $meta['pfp_button_bg_color'][0] ) ? sanitize_text_field( $meta['pfp_button_bg_color'][0] ) : null );
	$buttonTxtColor = ( ! empty( $meta['pfp_button_text_color'][0] ) ? sanitize_text_field( $meta['pfp_button_text_color'][0] ) : null );

	if ( $buttonBgColor ) {
		$css .= "#{$layoutID} .pfp-load-more button, #{$layoutID} .pfp-isotope-buttons button, #{$layoutID} .pfp-isotope-buttons button, #{$layoutID} .owl-theme .owl-nav [class*=owl-], #{$layoutID} .owl-theme .owl-dots .owl-dot span,#{$layoutID} .pfp-pagination ul.pagination-list li span,.{$layoutID} #pfp-gallery-wrapper .flex-direction-nav a:before, #{$layoutID} .pfp-pagination ul.pagination-list li a {";
		$css .= "background: {$buttonBgColor};";
		$css .= "}";
	}

	if ( $buttonTxtColor ) {
		$css .= "#{$layoutID} .pfp-load-more button, #{$layoutID} .pfp-isotope-buttons button, #{$layoutID} .pfp-isotope-buttons button, #{$layoutID} .owl-theme .owl-nav [class*=owl-], #{$layoutID} .owl-theme .owl-dots .owl-dot span,#{$layoutID} .pfp-pagination ul.pagination-list li span, #{$layoutID} .pfp-pagination ul.pagination-list li a {";
		$css .= "color: {$buttonTxtColor}";
		$css .= "}";

		$css .= ".{$layoutID} #pfp-gallery-wrapper .flex-direction-nav a:before, .{$layoutID} .tlp-popup-navigation i{";
		$css .= "color: {$buttonTxtColor}";
		$css .= "}";
	}

	/* Button hover background color */
	$buttonHoverBgColor = ( ! empty( $meta['pfp_button_hover_bg_color'][0] ) ? sanitize_text_field( $meta['pfp_button_hover_bg_color'][0] ) : null );
	if ( $buttonHoverBgColor ) {
		$css .= "#{$layoutID} .pfp-load-more button:hover,#{$layoutID} .pfp-isotope-buttons button:hover, #{$layoutID} .owl-theme .owl-nav [class*=owl-]:hover, #{$layoutID} .pfp-pagination ul.pagination-list li span:hover, #{$layoutID} .pfp-pagination ul.pagination-list li a:hover {";
		$css .= "background: {$buttonHoverBgColor};";
		$css .= "}";
	}

	/* Button Active background color */
	$buttonActiveBgColor = ( ! empty( $meta['pfp_button_active_bg_color'][0] ) ? sanitize_text_field( $meta['pfp_button_active_bg_color'][0] ) : null );
	if ( $buttonActiveBgColor ) {
		$css .= "#{$layoutID} .pfp-isotope-buttons button.selected, #{$layoutID} .owl-theme .owl-dots .owl-dot.active span, #{$layoutID} .pfp-pagination ul.pagination-list li.active span {";
		$css .= "background: {$buttonActiveBgColor};";
		$css .= "}";
	}

	// Isotope counter tooltip color
	$tooltipBg   = ( ! empty( $meta['pfp_iso_counter_tooltip_bg_color'][0] ) ? sanitize_text_field( $meta['pfp_iso_counter_tooltip_bg_color'][0] ) : null );
	$tooltipText = ( ! empty( $meta['pfp_iso_counter_tooltip_text_color'][0] ) ? sanitize_text_field( $meta['pfp_iso_counter_tooltip_text_color'][0] ) : null );
	if ( $tooltipBg || $tooltipText ) {
		$css .= "#pfp-tooltip-{$layoutID}, #pfp-tooltip-{$layoutID} .pfp-tooltip-bottom:after {";
		$css .= ($tooltipBg ? "background: {$tooltipBg}; " : null);
		$css .= ($tooltipText ? "color: {$tooltipText};" : null);
		$css .= "}";
	}

	/* gutter */
	if ( ! empty( $meta['pfp_gutter'][0] ) && $gutter = absint( $meta['pfp_gutter'][0] ) ) {
		$css .= "#{$layoutID} [class*='pfp-col-'] {";
		$css .= "padding-left : {$gutter}px;";
		$css .= "padding-right : {$gutter}px;";
		$css .= "margin-top : {$gutter}px;";
		$css .= "margin-bottom : {$gutter}px;";
		$css .= "}";
		$css .= "#{$layoutID} .pfp-row{";
		$css .= "margin-left : -{$gutter}px;";
		$css .= "margin-right : -{$gutter}px;";
		$css .= "}";
	}

	// Name
	$name = ( ! empty( $meta['pfp_name_style'][0] ) ? TLPpPro()->array_text_sanitization( $meta['pfp_name_style'][0] ) : array() );
	if ( ! empty( $name ) && is_array( $name ) ) {
		$nameCommon = ( ! empty( $name['align'] ) ? "text-align:" . $name['align'] . " !important;" : null );
		$nameCommon .= ( ! empty( $name['weight'] ) ? "font-weight:" . $name['weight'] . ";" : null );
		$nameCommon .= ( ! empty( $name['size'] ) ? "font-size:" . $name['size'] . "px;" : null );
		if( $nameCommon ){
			$css .= "#{$layoutID} .tlp-portfolio-item h3.title a, #{$layoutID} .tlp-portfolio-item h3.title {";
			$css .= $nameCommon;
			$css .= "}";
		}
		if( ! empty( $name['color'] )  ){
			$css .= "#{$layoutID} .tlp-portfolio-item h3.title:not(.color-white) a, #{$layoutID} .tlp-portfolio-item h3.title:not(.color-white) {" ;
			$css .= "color:" . $name['color'] . ";" ;
			$css .= "}";
		}

	}

	$name_hover = !empty( $meta['pfp_name_hover_style'][0] ) ? TLPpPro()->array_text_sanitization( $meta['pfp_name_hover_style'][0] ) : array();
	// Name Hover
	if ( ! empty( $name_hover ) && is_array( $name_hover ) ) {
		$name_hover_common = ( ! empty( $name_hover['align'] ) ? "text-align:" . $name_hover['align'] . " !important;" : null );
		$name_hover_common .= ( ! empty( $name_hover['weight'] ) ? "font-weight:" . $name_hover['weight'] . ";" : null );
		$name_hover_common .= ( ! empty( $name_hover['size'] ) ? "font-size:" . $name_hover['size'] . "px;" : null );
		if( $name_hover_common ){
			$css .= "#{$layoutID} .tlp-portfolio-item h3.title a:hover, #{$layoutID} .tlp-portfolio-item h3.title:hover {";
			$css .= $name_hover_common ;
			$css .= "}";
		}
		if( ! empty( $name_hover['color'] ) ){
			$css .= "#{$layoutID} .tlp-portfolio-item h3.title:not(.color-white) a:hover, #{$layoutID} .tlp-portfolio-item h3.title:not(.color-white):hover {";
			$css .= "color:" . $name_hover['color'] . ";";
			$css .= "}";
		}
		
	}

	// Short Description
	$short_desc = ( ! empty( $meta['pfp_short_description_style'][0] ) ? TLPpPro()->array_text_sanitization( $meta['pfp_short_description_style'][0] ) : array() );
	if ( ! empty( $short_desc ) && is_array( $short_desc ) ) {
		$s_d_common = ( ! empty( $short_desc['color'] ) ? "color:" . $short_desc['color'] . ";" : null );
		$s_d_common .= ( ! empty( $short_desc['size'] ) ? "font-size:" . $short_desc['size'] . "px;" : null );
		$s_d_common .= ( ! empty( $short_desc['weight'] ) ? "font-weight:" . $short_desc['weight'] . ";" : null );
		$s_d_common .= ( ! empty( $short_desc['align'] ) ? "text-align:" . $short_desc['align'] . ";" : null );
		$css .= "#{$layoutID} .tlp-portfolio-item .short-desc, #{$layoutID} .pfp-layout19 figcaption .pfp-categories {";
		$css .= $s_d_common ; 
		$css .= "}";
	}

	// pfp_meta_style
	$pfp_meta_style = ( ! empty( $meta['pfp_meta_style'][0] ) ? TLPpPro()->array_text_sanitization( $meta['pfp_meta_style'][0] ) : array() );
	if ( ! empty( $pfp_meta_style ) && is_array( $pfp_meta_style ) ) {

		$pfp_meta_common = ( ! empty( $pfp_meta_style['color'] ) ? "color:" . $pfp_meta_style['color'] . ";" : null );
		$pfp_meta_common .= ( ! empty( $pfp_meta_style['size'] ) ? "font-size:" . $pfp_meta_style['size'] . "px;" : null );
		$pfp_meta_common .= ( ! empty( $pfp_meta_style['align'] ) ? "text-align:" . $pfp_meta_style['align'] . ";" : null );
		$pfp_meta_common .= ( ! empty( $pfp_meta_style['weight'] ) ? "font-weight:" . $pfp_meta_style['weight'] . ";" : null );
		if( $pfp_meta_common ){
			$css .= "#{$layoutID} .tlp-portfolio-item .extra-features li{";
			$css .= $pfp_meta_common ;
			$css .= "}";
		}
	}

	// client_name_style
	$client_name_style = ( ! empty( $meta['pfp_client_name_style'][0] ) ? TLPpPro()->array_text_sanitization( $meta['pfp_client_name_style'][0] ) : array() );
	if ( ! empty( $client_name_style ) && is_array( $client_name_style ) ) {

		$client_name_common = ( ! empty( $client_name_style['color'] ) ? "color:" . $client_name_style['color'] . ";" : null );
		$client_name_common .= ( ! empty( $client_name_style['size'] ) ? "font-size:" . $client_name_style['size'] . "px;" : null );
		$client_name_common .= ( ! empty( $client_name_style['align'] ) ? "text-align:" . $client_name_style['align'] . ";" : null );
		$client_name_common .= ( ! empty( $client_name_style['weight'] ) ? "font-weight:" . $client_name_style['weight'] . ";" : null );
		if( $client_name_common ){
			$css .= "#{$layoutID} .tlp-portfolio-item .extra-features li.client-name{";
			$css .= $client_name_common ;
			$css .= "}";
		}
	}

	// tools
	$tools = ( ! empty( $meta['pfp_tools_style'][0] ) ? TLPpPro()->array_text_sanitization( $meta['pfp_tools_style'][0] ) : array() );
	if ( ! empty( $tools ) && is_array( $tools ) ) {

		$tools_common = ( ! empty( $tools['color'] ) ? "color:" . $tools['color'] . ";" : null );
		$tools_common .= ( ! empty( $tools['size'] ) ? "font-size:" . $tools['size'] . "px;" : null );
		$tools_common .= ( ! empty( $tools['align'] ) ? "text-align:" . $tools['align'] . ";" : null );
		$tools_common .= ( ! empty( $tools['weight'] ) ? "font-weight:" . $tools['weight'] . ";" : null );
		if( $tools_common ){
			$css .= "#{$layoutID} .tlp-portfolio-item .tools, #{$layoutID} .tlp-portfolio-item .pfp-categories {";
			$css .= $tools_common ;
			$css .= "}";
		}

	}

	// Social icon color
	$iconStyle = ( ! empty( $meta['pfp_icon_style'][0] ) ? TLPpPro()->array_text_sanitization( $meta['pfp_icon_style'][0] ) : array() );
	if ( ! empty( $iconStyle ) && is_array( $iconStyle ) ) {
		$iconStyleCommon = ( ! empty( $iconStyle['color'] ) ? "border: 1px solid  " . $iconStyle['color'] . ";" : null );
		$iconStyleCommon .= ( ! empty( $iconStyle['color'] ) ? "color:" . $iconStyle['color'] . ";" : null );
		$iconStyleCommon .= ( ! empty( $iconStyle['size'] ) ? "font-size:" . $iconStyle['size'] . "px;" : null );
		if( $iconStyleCommon ){
			$css .= "#{$layoutID} .tlp-portfolio-item .link-icon a {";
			$css .= $iconStyleCommon;
			$css .= "}";
		}
	}

	// link-icon Style 
	if ( ! empty( $iconStyle ) && is_array( $iconStyle ) ) {
		$css .= "#{$layoutID} .tlp-portfolio-item .link-icon{";
		$css .= ( ! empty( $iconStyle['align'] ) ? "text-align:" . $iconStyle['align'] . ";" : null );
		$css .= "}";
	}
	

	// Overlay
	$overlayColor   = ( ! empty( $meta['pfp_overlay_color'][0] ) ? sanitize_text_field( $meta['pfp_overlay_color'][0] ) : null );
	$overlayOpacity = ( ! empty( $meta['pfp_overlay_opacity'][0] ) ? absint( $meta['pfp_overlay_opacity'][0] ) : null );
	if ( $overlayColor ) {
		$css .= "#{$layoutID} .pfp-layout1 .tlp-portfolio-item:hover .tlp-overlay, #{$layoutID} .pfp-layout2 .tlp-overlay,#{$layoutID} .pfp-isotope20 .tlp-overlay, #{$layoutID} .pfp-layout3 .tlp-overlay, #{$layoutID} .pfp-layout4 .tlp-overlay, #{$layoutID} .tlp-portfolio-item:hover .tlp-overlay,#{$layoutID} .tlp-portfolio-item:hover .tlp-overlay, #{$layoutID}  .tlp-portfolio-thumb:hover .tlp-overlay, #{$layoutID} .tlp-portfolio-item .overlay,#{$layoutID} .pfp-carousel1 .tlp-portfolio-item:hover .tlp-overlay, #{$layoutID} .tlp-portfolio-item .post-info, #{$layoutID} .pfp-layout9 .tlp-portfolio-item figcaption:hover,#{$layoutID} .pfp-isotope8 .tlp-portfolio-item figcaption:hover,#{$layoutID} .pfp-carousel8 .tlp-portfolio-item figcaption:hover {";
		$css .= "background:" . TLPpPro()->TLPhex2rgba( $overlayColor,
				( $overlayOpacity ? $overlayOpacity / 100 : .8 ) ) . ";";
		$css .= "}";
	}
	// Overlay Padding
	$overlaypadding = ( ! empty( $meta['pfp_overlay_padding'][0] ) ? absint( $meta['pfp_overlay_padding'][0] ) : null );
	if ( $overlaypadding ) {
		$css .= "#{$layoutID} .pfp-layout1 .tlp-portfolio-item:hover .tlp-overlay, #{$layoutID} .pfp-layout2 .tlp-overlay,#{$layoutID} .pfp-isotope20 .tlp-overlay, #{$layoutID} .pfp-layout3 .tlp-overlay, #{$layoutID} .pfp-layout4 .tlp-overlay, #{$layoutID} .tlp-portfolio-item:hover .tlp-overlay,#{$layoutID} .tlp-portfolio-item:hover .tlp-overlay, #{$layoutID}  .tlp-portfolio-thumb:hover .tlp-overlay, #{$layoutID} .tlp-portfolio-item .overlay,#{$layoutID} .pfp-carousel1 .tlp-portfolio-item:hover .tlp-overlay, #{$layoutID} .tlp-portfolio-item .post-info, #{$layoutID} .pfp-layout9 .tlp-portfolio-item figcaption:hover,#{$layoutID} .pfp-isotope8 .tlp-portfolio-item figcaption:hover,#{$layoutID} .pfp-carousel8 .tlp-portfolio-item figcaption:hover {";
		$css .= "padding-top:" . $overlaypadding . "%;";
		$css .= "}";
	}



	
	if(  $css ){
		echo  sanitize_text_field( $css ) ;
	}