<?php
$linkTarget = ($link_target ? " target='{$link_target}'" : null);
$class = $grid . " " . $class;

$exFeature = null;
if (in_array('client_name', $items) && $client_name) {
    $exFeature .= '<li class="client-name"><label>' . __("Client Name :", 'tlp-portfolio-pro') . '</label>' . esc_html($client_name) . '</li>';
}
if (in_array('completed_date', $items) && $completed_date) {
    $exFeature .= '<li class="completed-date"><label>' . __("Completed Date :", 'tlp-portfolio-pro') . '</label>' . esc_html($completed_date) . '</li>';
}
if (in_array('project_url', $items) && $project_url) {
    $exFeature .= '<li class="project-url"><label>' . __("Project URL :", 'tlp-portfolio-pro') . '</label><a href="' . esc_url($project_url) . '" target="_blank">' . esc_url($project_url) . '</a></li>';
}
if (in_array('tools', $items) && $tools) {
    $exFeature .= '<li class="tools"><label>' . __("Tools :", 'tlp-portfolio-pro') . '</label>' . $tools . '</li>';
}
if (in_array('categories', $items) && $categories) {
    $exFeature .= '<li class="categories"><label>' . __("Categories :", 'tlp-portfolio-pro') . '</label>' . $categories . '</li>';
}
if (in_array('tags', $items) && $tags) {
    $exFeature .= '<li class="tags"><label>' . __("Tags :", 'tlp-portfolio-pro') . '</label>' . $tags . '</li>';
}
?>
<div class="<?php echo esc_attr($class); ?>" data-id="<?php echo esc_attr($iID); ?>">
    <div class="tlp-portfolio-item">
        <div class="tlp-portfolio-thumb tlp-item <?php echo esc_attr($image_area); ?>">
            <?php if ($img): ?>
                <figure><?php echo wp_kses_post($img); ?></figure>
            <?php endif; ?>
            <div class="tlp-overlay">
                <p class="link-icon">
                    <?php if ($link && !$external_url): ?>
                        <a class="tlp-item-details <?php echo esc_attr($anchorClass); ?>" <?php echo esc_attr($linkTarget); ?>
                           data-id="<?php echo esc_attr($iID) ?>" title="<?php echo esc_html($title) ?>"
                           href="<?php echo esc_url($pLink) ?>">
                            <i class="icon-info"></i>
                        </a>
                    <?php endif; ?>
                    <?php if (in_array('project_url', $items) && $project_url): ?>
                        <a target="_blank" href="<?php echo esc_url($project_url) ?>">
                            <i class="icon-link-ext"></i>
                        </a>
                    <?php endif; ?>
                    <?php if (in_array('zoom', $items)): ?>
                        <a class="pfp-zoom" data-lightbox="<?php echo esc_attr($zoomId) ?>"
                           title="<?php echo esc_html($title) ?>" href="<?php echo esc_url($img_full_url) ?>">
                            <i class="icon-move" aria-hidden="true"></i>
                        </a>
                    <?php endif; ?>
                </p>
            </div>
        </div>
        <div class="tlp-content2 tlp-content <?php echo esc_attr($content_area); ?>">
            <div class="tlp-content-holder">
                <?php if (in_array('name', $items)): ?>
                    <?php if ($link): ?>
                        <h3 class="title">
                            <a class="tlp-item-details <?php echo esc_attr($anchorClass); ?>"
                               data-id="<?php echo esc_attr($iID) ?>" <?php echo esc_attr($linkTarget) ?>
                               title="<?php echo esc_html($title) ?>" href="<?php echo esc_url($pLink) ?>">
                                <?php echo esc_html($title) ?>
                            </a>
                        </h3>
                    <?php else: ?>
                        <h3 class="title"><?php echo esc_html($title) ?></h3>
                    <?php endif; ?>
                <?php endif; ?>

                <?php if (in_array('short_description', $items) && $short_desc): ?>
                    <div class="short-desc"><?php echo wp_kses_post($short_desc) ?></div>
                <?php endif; ?>
                <?php
                if ($exFeature): ?>
                    <div class="extra-features">
                        <ul><?php echo wp_kses_post($exFeature); ?></ul>
                    </div>
                <?php endif; ?>
            </div>
        </div>
    </div>
</div>