<?php
if (!class_exists('TLPpPro')) {
    class TLPpPro {

        public $post_type;
        public $shortCodePT;
        public $taxonomies;
        public $preSettings;

		public $options;

		public $post_type_slug;
		public $incPath;
		public $functionsPath;
		public $classesPath;
		public $widgetsPath;
		public $viewsPath;
		public $templatePath;
		public $modelsPath;

		public $assetsUrl;

		public $objects;

        protected static $_instance;

        function __construct()
        {
            $this->options = array(
                'settings'    => 'tlp_portfolio_settings',
                'version'     => TLP_PORTFOLIO_PRO_VERSION,
                'title'       => EDD_TLP_PORTFOLIO_PRO_ITEM_NAME,
                'plugin_slug' => 'tlp-portfolio-pro',
                'flash'       => 'pfp-flash'
            );
            $this->shortCodePT = "portfolio-sc";
            $settings = get_option($this->options['settings']);
            $this->post_type = 'portfolio';
            $this->post_type_slug = isset($settings['slug']) ? ($settings['slug'] ? sanitize_title_with_dashes($settings['slug']) : 'portfolio') : 'portfolio';
            $this->taxonomies = array(
                'category' => $this->post_type . "-category",
                'tag'      => $this->post_type . "-tag",
                'tool'     => $this->post_type . "-tool",
            );
            $this->incPath = dirname(__FILE__);
            $this->functionsPath = $this->incPath . '/functions/';
            $this->classesPath = $this->incPath . '/classes/';
            $this->widgetsPath = $this->incPath . '/widgets/';
            $this->viewsPath = $this->incPath . '/views/';
            $this->templatePath = $this->incPath . '/templates/';
            $this->modelsPath = $this->incPath . '/models/';

            $this->assetsUrl = TLP_PORTFOLIO_PRO_PLUGIN_URL . '/assets/';
            $this->pfpLoadModel();
            $this->pfpLoadClass();
            $this->preSettings = array(
                'slug'  => 'portfolio',
                'field' => array(
                    'name',
                    'short_description',
                    'client_name',
                    'project_url',
                    'completed_date',
                    'tools',
                    'categories',
                    'tags',
                    'zoom',
                    'description',
                    'social_share',
                    'slider',
                    'thumbnail_slider',
                    'related_project',
                )
            );
        }

        public static function instance()
        {
            if (is_null(self::$_instance)) {
                self::$_instance = new self();
            }

            return self::$_instance;
        }

        /**
         * Load Model class
         *
         */
        function pfpLoadModel()
        {
            $dir = $this->modelsPath;
            if (!file_exists($dir)) {
                return;
            }
            foreach (scandir($dir) as $item) {
                if (preg_match("/.php$/i", $item)) {
                    require_once($dir . $item);
                }
            }
        }

        /**
         *
         */
        function pfpLoadClass()
        {
            $dir = $this->classesPath;
            if (!file_exists($dir)) {
                return;
            }

            $classes = array();

            foreach (scandir($dir) as $item) {
                if (preg_match("/.php$/i", $item)) {
                    require_once($dir . $item);
                    $className = str_replace(".php", "", $item);
                    $classes[] = new $className;
                }
            }

            if ($classes) {
                foreach ($classes as $class) {
                    $this->objects[] = $class;
                }
            }
        }

        function loadWidget()
        {
            $dir = $this->widgetsPath;
            if (!file_exists($dir)) {
                return;
            }
            foreach (scandir($dir) as $item) {
                if (preg_match("/.php$/i", $item)) {
                    require_once($dir . $item);
                    $class = str_replace(".php", "", $item);

                    if (method_exists($class, 'register_widget')) {
                        $caller = new $class;
                        $caller->register_widget();
                    } else {
                        register_widget($class);
                    }
                }
            }
        }

        /**
         * @param $viewName
         * @param array $args
         * @param bool $return
         * @return string|void
         */
        function render_view($viewName, $args = array(), $return = false)
        {
            $viewName = str_replace(".", "/", $viewName);
            $viewPath = $this->viewsPath . $viewName . '.php';
            if (!file_exists($viewPath)) {
                return;
            }
            if ($args) {
                extract($args);
            }
            if ($return) {
                ob_start();
                include $viewPath;

                return ob_get_clean();
            }
            include $viewPath;
        }

        /**
         * @param $templateName
         * @param array $args
         * @param bool $return
         * @return string|void
         */
        function render($templateName, $args = array(), $return = true)
        {

            $templateName = str_replace(".", "/", $templateName);
            if ($args) {
                extract($args);
            }
            $template = array(
                "the-portfolio-pro/{$templateName}.php"
            );

            if (!$template_file = locate_template($template)) {
                $template_file = $this->templatePath . $templateName . '.php';
            }
            if (!file_exists($template_file)) {
                return;
            }
            if ($return) {

                ob_start();
                include $template_file;

                return ob_get_clean();
            } else {

                include $template_file;
            }
        }


        /**
         * Dynamically call any  method from models class
         * by pluginFramework instance
         */
        function __call($name, $args)
        {
            if (!is_array($this->objects)) {
                return;
            }
            foreach ($this->objects as $object) {
                if (method_exists($object, $name)) {
                    $count = count($args);
                    if ($count == 0) {
                        return $object->$name();
                    } elseif ($count == 1) {
                        return $object->$name($args[0]);
                    } elseif ($count == 2) {
                        return $object->$name($args[0], $args[1]);
                    } elseif ($count == 3) {
                        return $object->$name($args[0], $args[1], $args[2]);
                    } elseif ($count == 4) {
                        return $object->$name($args[0], $args[1], $args[2], $args[3]);
                    } elseif ($count == 5) {
                        return $object->$name($args[0], $args[1], $args[2], $args[3], $args[4]);
                    } elseif ($count == 6) {
                        return $object->$name($args[0], $args[1], $args[2], $args[3], $args[4], $args[5]);
                    }
                }
            }
        }
    }

    function TLPpPro()
    {
        return TLPpPro::instance();
    }

    TLPpPro();
}
