<?php
if (!defined('WPINC')) {
    die;
}
// Free version error handling for activation time debug.log error 
if ( !class_exists('TLPPortfolioGutenBurg') ):

    class TLPPortfolioGutenBurg
    {
        function __construct() {

            $activated_plugins = apply_filters('active_plugins', get_option('active_plugins')) ;
            // check for plugin using plugin name
            // The condition for activation time error handaling. That conflict With Free version 
            if( in_array('tlp-portfolio-pro/tlp-portfolio-pro.php', $activated_plugins )){ 
                add_action('enqueue_block_assets', array($this, 'block_assets'));
                add_action('enqueue_block_editor_assets', array($this, 'block_editor_assets'));
                if(function_exists('register_block_type')) {
                    register_block_type('rt-portfolio/tlp-portfolio-pro', array(
                        'render_callback' => array($this,'render_shortcode'),
                    ));
                }
            }
            

        }

        static function render_shortcode( $atts ){
            if(!empty($atts['gridId']) && $id = absint($atts['gridId'])){
                return do_shortcode( '[tlpportfolio id="' . $id . '"]' );
            }
        }


        function block_assets() {
            wp_enqueue_style('wp-blocks');
        }

        function block_editor_assets() {
            $asset_file = include( TLP_PORTFOLIO_PRO_PLUGIN_PATH . '/assets/blocks/blocks.asset.php');
            // Scripts.
            wp_enqueue_script(
                'rt-portfolio-cgb-block-js',
                TLPpPro()->assetsUrl. "/blocks/blocks.js",
                $asset_file['dependencies'],
                (defined('WP_DEBUG') && WP_DEBUG) ? time() : TLP_PORTFOLIO_PRO_VERSION,
                true
            );
            wp_localize_script('rt-portfolio-cgb-block-js', 'rtPortfolio', array(
                'short_codes' => TLPpPro()->get_shortCode_list(),
                'icon' => TLPpPro()->assetsUrl . 'images/tlp-vc.png',
            ));
            wp_enqueue_style('wp-edit-blocks');
        }
    }

endif;