<?php

if (!class_exists('PFProTemplate')):

    /**
     *
     */
    class PFProTemplate {

        function __construct()
        {
            add_filter('template_include', array($this, 'template_loader'));
            add_action('wp_enqueue_scripts', array($this, 'load_template_script'));
        }

        public static function template_loader($template)
        {
            $find = array();
            $file = null;
            if (is_single() && get_post_type() == TLPpPro()->post_type) {
                $file = 'single-portfolio.php';
                $find[] = $file;
                $find[] = "tlp-portfolio-pro/" . $file;
            }

            if ($file) {
                $template = locate_template($find);
                if (!$template) {
                    $template = TLPpPro()->templatePath . $file;
                }
            }

            return $template;
        }

        public function load_template_script()
        {
            if (get_post_type() == TLPpPro()->post_type || is_post_type_archive(TLPpPro()->post_type)) {
                wp_enqueue_style(array(
                    'pfp-flex-slider',
                    'pfp'
                ));
                wp_enqueue_script(array(
                    'pfp-flex-slider',
                    'pfp-single'
                ));
            }
        }


    }

endif;
