<?php
if ( ! class_exists( 'PFProSC' ) ):
	/**
	 *
	 */
	class PFProSC {
		private $scA = array();

		function __construct() {
			add_shortcode( 'tlpportfolio', array( $this, 'portfolio_shortcode' ) );
		}

		function register_scripts() {
			$caro   = false;
			$iso    = false;
			$script = array();
			$style  = array();
			array_push( $script, 'jquery' );
			foreach ( $this->scA as $sc ) {
				if ( isset( $sc ) && is_array( $sc ) ) {
					if ( $sc['isCarousel'] ) {
						$caro = true;
					}
					if ( $sc['isIsotope'] ) {
						$iso = true;
					}
				}
			}

			if ( count( $this->scA ) ) {
				array_push( $script, 'pfp-image-load' );
				if ( $caro ) {
					array_push( $style, 'pfp-owl-carousel' );
					array_push( $style, 'pfp-owl-carousel-theme' );
					array_push( $script, 'pfp-owl-carousel' );
				}

				if ( $iso ) {
					array_push( $script, 'pfp-isotope' );
				}
				array_push( $style, 'pfp-lightbox' );
				array_push( $style, 'pfp-flex-slider' );
				array_push( $script, 'pfp-lightbox' );
				array_push( $script, 'pfp-flex-slider' );
				array_push( $script, 'pfp' );

				wp_enqueue_style( $style );
				wp_enqueue_script( $script );

				$nonce = wp_create_nonce( TLPpPro()->nonceText() );
				$ajaxurl = '';
				if( in_array('sitepress-multilingual-cms/sitepress.php', get_option('active_plugins')) ){
					$ajaxurl .= admin_url( 'admin-ajax.php?lang=' . ICL_LANGUAGE_CODE );
				} else{
					$ajaxurl .= admin_url( 'admin-ajax.php');
				}
				wp_localize_script( 'pfp', 'pfp',
					array(
						'ajaxurl' => $ajaxurl,
						'nonce'   => $nonce,
						'nonceId' => TLPpPro()->nonceId(),
					) );
			}

		}
		//TODO: Need Recover Equal Height Option.
		function portfolio_shortcode( $atts, $content = "" ) {
			$atts = shortcode_atts( array(
				'id' => null
			), $atts, 'tlpportfolio' );
			$scID = $atts['id'];
			$rand     = mt_rand();
			$layoutID = "pfp-container-" . $scID;
			$html = null;
			$arg  = array();
			//TODO: Filter Load more option only for selected category.
			if ( $scID && ! is_null( get_post( $scID ) ) ) {
				$scMeta = get_post_meta( $scID );
				$layout = ( ! empty( $scMeta['pfp_layout'][0] ) ? sanitize_text_field( $scMeta['pfp_layout'][0] ) : 'layout1' );
				if ( ! in_array( $layout, array_keys( TLPpPro()->scLayout() ) ) ) {
					$layout = 'layout1';
				}
				$dCol = ( isset( $scMeta['pfp_desktop_column'][0] ) ? absint( $scMeta['pfp_desktop_column'][0] ) : 3 );
				$tCol = ( isset( $scMeta['pfp_tab_column'][0] ) ? absint( $scMeta['pfp_tab_column'][0] ) : 2 );
				$mCol = ( isset( $scMeta['pfp_mobile_column'][0] ) ? absint( $scMeta['pfp_mobile_column'][0] ) : 1 );
				if ( ! in_array( $dCol, array_keys( TLPpPro()->scColumns() ) ) ) {
					$dCol = 3;
				}
				if ( ! in_array( $tCol, array_keys( TLPpPro()->scColumns() ) ) ) {
					$tCol = 2;
				}
				if ( ! in_array( $mCol, array_keys( TLPpPro()->scColumns() ) ) ) {
					$mCol = 1;
				}

				$dColItems          = $dCol;
				$tColItems          = $tCol;
				$mColItems          = $mCol;

				$customImgSize = get_post_meta( $scID, 'pfp_custom_image_size', true );
				$imgSize       = ( ! empty( $scMeta['pfp_image_size'][0] ) ? sanitize_text_field( $scMeta['pfp_image_size'][0] ) : "medium" );
				$excerpt_limit = ( ! empty( $scMeta['pfp_excerpt_limit'][0] ) ? absint( $scMeta['pfp_excerpt_limit'][0] ) : 0 );

				$isIsotope  = preg_match( '/isotope/', $layout );
				$isCarousel = preg_match( '/carousel/', $layout );

				/* Argument create */
				$containerDataAttr = false;
				$args              = array();
				$args['post_type'] = array( TLPpPro()->post_type );
				// Common filter
				/* post__in */
				$post__in = ( isset( $scMeta['pfp_post__in'][0] ) ? sanitize_text_field( $scMeta['pfp_post__in'][0] ) : null );
				if ( $post__in ) {
					$post__in         = explode( ',', $post__in );
					$args['post__in'] = $post__in;
				}
				/* post__not_in */
				$post__not_in = ( isset( $scMeta['pfp_post__not_in'][0] ) ? sanitize_text_field( $scMeta['pfp_post__not_in'][0] ) : null );
				if ( $post__not_in ) {
					$post__not_in         = explode( ',', $post__not_in );
					$args['post__not_in'] = $post__not_in;
				}
				/* LIMIT */
				$limit                  = ( ( empty( $scMeta['pfp_limit'][0] ) || $scMeta['pfp_limit'][0] === '-1' ) ? 10000000 : absint( $scMeta['pfp_limit'][0] ) );
				$args['posts_per_page'] = $limit;
				$pagination             = ( ! empty( $scMeta['pfp_pagination'][0] ) ? true : false );
				$posts_loading_type     = ( ! empty( $scMeta['pfp_pagination_type'][0] ) ? sanitize_text_field( $scMeta['pfp_pagination_type'][0] ) : "pagination" );
				if ( $pagination ) {
					$posts_per_page = ( isset( $scMeta['pfp_posts_per_page'][0] ) ? intval( $scMeta['pfp_posts_per_page'][0] ) : $limit );
					if ( $posts_per_page > $limit ) {
						$posts_per_page = $limit;
					}
					// Set 'posts_per_page' parameter
					$args['posts_per_page'] = $posts_per_page;

					if ( is_front_page() ) {
						$paged = ( get_query_var( 'page' ) ) ? get_query_var( 'page' ) : 1;
					} else {
						$paged = ( get_query_var( 'paged' ) ) ? get_query_var( 'paged' ) : 1;
					}

					$offset        = $posts_per_page * ( (int) $paged - 1 );
					$args['paged'] = $paged;

					// Update posts_per_page
					$remaining_post = $limit - $offset ;
					if( 0 < $remaining_post ){
						if ( intval( $args['posts_per_page'] ) > $remaining_post ) {
							$args['posts_per_page'] = $remaining_post;
							$args['offset'] = $offset;
						}
					}else{
						$args['posts_per_page'] = 0;
					}

				}
				if ( $isCarousel ) {
					$args['posts_per_page'] = $limit;
				}

				// Taxonomy
				$cats  = ( isset( $scMeta['pfp_categories'] ) ? TLPpPro()->array_int_sanitization( $scMeta['pfp_categories'] ) : array() );
				$tags  = ( isset( $scMeta['pfp_tags'] ) ? TLPpPro()->array_int_sanitization( $scMeta['pfp_tags'] ) : array() );
				$tools = ( isset( $scMeta['pfp_tools'] ) ? TLPpPro()->array_int_sanitization( $scMeta['pfp_tools'] ) : array() );

				$taxQ  = array();
				if ( is_array( $cats ) && ! empty( $cats ) ) {
					$taxQ[] = array(
						'taxonomy' => TLPpPro()->taxonomies['category'],
						'field'    => 'term_id',
						'terms'    => $cats,
					);
				}
				if ( is_array( $tags ) && ! empty( $tags ) ) {
					$taxQ[] = array(
						'taxonomy' => TLPpPro()->taxonomies['tag'],
						'field'    => 'term_id',
						'terms'    => $tags,
					);
				}
				if ( is_array( $tools ) && ! empty( $tools ) ) {
					$taxQ[] = array(
						'taxonomy' => TLPpPro()->taxonomies['tool'],
						'field'    => 'term_id',
						'terms'    => $tools,
					);
				}
				if ( ! empty( $taxQ ) ) {
					if ( count( $taxQ ) > 1 ) {
						$taxQ['relation'] = ! empty( $scMeta['pfp_taxonomy_relation'][0] ) ? sanitize_text_field( $scMeta['pfp_taxonomy_relation'][0] ) : "AND";
					}
                    $args['tax_query'] = $taxQ;

                }


				// Order
				$order_by = ( isset( $scMeta['pfp_order_by'][0] ) ? sanitize_text_field( $scMeta['pfp_order_by'][0] ) : null );
				$order    = ( isset( $scMeta['pfp_order'][0] ) ? sanitize_text_field( $scMeta['pfp_order'][0] ) : null );
				if ( $order ) {
					$args['order'] = $order;
				}
				if ( $order_by ) {
					$args['orderby'] = $order_by;
				}


				// Validation
				$containerDataAttr .= " data-layout='{$layout}' data-desktop-col='{$dCol}'  data-tab-col='{$tCol}'  data-mobile-col='{$mCol}'";
				$dCol = round( 12 / $dCol );
				$tCol = round( 12 / $tCol );
				$mCol = round( 12 / $mCol );
				if ( $isCarousel ) {
					$dCol = $tCol = $mCol = 12;
				}
				$gridExtra    = null;
				$arg          = array();
				$arg['grid']  = "pfp-col-md-{$dCol} pfp-col-sm-{$tCol} pfp-col-xs-{$mCol}";
				$gridType     = ! empty( $scMeta['pfp_grid_style'][0] ) ? sanitize_text_field( $scMeta['pfp_grid_style'][0] ) : 'even';
				$arg['class'] = $gridType . "-grid-item";
				$arg['class'] .= " pfp-grid-item";
				$preLoader = null;
				if ( $isIsotope ) {
					$arg['class'] .= ' isotope-item';
					$preLoader = 'pfp-pre-loader';
				}
				if ( $isCarousel ) {
					$arg['class'] .= ' pfp-carousel-item';
					$preLoader = 'pfp-pre-loader';
				}
				$masonryG = null;
				if ( $gridType == "even" ) {
					$masonryG = " pfp-even";
					$arg['class'] .= ' even-grid-item';
				// } else if ( $gridType == "masonry" && ! $isIsotope && ! $isCarousel ) {
				} else if ( $gridType == "masonry" && ! $isCarousel ) {
					$masonryG = " pfp-masonry";
					$arg['class'] .= ' masonry-grid-item';
				}
				$image_shape = ! empty( $scMeta['pfp_image_shape'][0] ) ? sanitize_text_field( $scMeta['pfp_image_shape'][0] ) : null;
				if ( $image_shape == 'circle' ) {
					$arg['class'] .= ' pfp-img-circle';
				}

				$margin = ! empty( $scMeta['pfp_margin'][0] ) ? sanitize_text_field( $scMeta['pfp_margin'][0] ) : 'default';
				if ( $margin == 'no' ) {
					$arg['class'] .= ' no-margin';
				} else {
					$arg['class'] .= ' default-margin';
				}
				if ( $layout == 'layout2' || $layout == 'isotope20' ) {
					$arg['image_area']   = "pfp-col-md-5 pfp-col-sm-12";
					$arg['content_area'] = "pfp-col-md-7 pfp-col-sm-12";
				}else{
					$arg['image_area']   = "";
					$arg['content_area'] = "";
				}

				$arg['items']       = ! empty( $scMeta['pfp_item_fields'] ) ? TLPpPro()->array_text_sanitization( $scMeta['pfp_item_fields'] ) : array();
				$arg['anchorClass'] = null;
				$link               = ! empty( $scMeta['pfp_detail_page_link'][0] ) ? true : false;
				$arg['link']        = $arg['link_type'] = $arg['link_target'] = false;
				if ( $link ) {
					$link_type = $arg['link_type'] = ! empty( $scMeta['pfp_detail_page_link_type'][0] ) ? sanitize_text_field( $scMeta['pfp_detail_page_link_type'][0] ) : 'popup';
					if ( $link_type == "popup" ) {
						$arg['anchorClass'] .= ' pfp-popup tlp-single-item-popup';
					} else if ( $link_type == "external_link" ) {
						$arg['link_target'] = ! empty( $scMeta['pfp_link_target'][0] ) ? sanitize_text_field( $scMeta['pfp_link_target'][0] ) : '_blank';
					}
					$arg['link']      = true;
				} else {
					$arg['anchorClass'] .= ' pfp-disable';
				}

				$parentClass = ( ! empty( $scMeta['pfp_parent_class'][0] ) ? sanitize_text_field( trim( $scMeta['pfp_parent_class'][0] ) ) : null );

				$args['post_status']      = 'publish';
				$arg['zoomId'] = $layout;
				if ( is_user_logged_in() && is_super_admin() ) {
					$args['post_status'] = array( 'publish', 'private' );
				}

				// Start layout
				// $html .= $this->layoutStyle( $layoutID, $scMeta );
				$html .= "<div class='pfp-container-fluid pfp-wrapper {$parentClass}' id='{$layoutID}' {$containerDataAttr}>";
				$html .= "<div data-title='" . esc_html__( "Loading ...",
						"tlp-portfolio-pro" ) . "' class='pfp-row pfp-{$layout}{$masonryG} {$preLoader}'>";

				$portQuery = new WP_Query( $args );
				if ( $portQuery->have_posts() ) {
					if ( $isCarousel ) {
						// $scMeta['pfp_carousel_items_per_slider'][0] the metafield only for old (v-2.9.0) version support.
						$items              = ! empty( $scMeta['pfp_carousel_items_per_slider'][0] ) ? absint( $scMeta['pfp_carousel_items_per_slider'][0] ) : $dColItems;
						$smartSpeed         = ! empty( $scMeta['pfp_carousel_speed'][0] ) ? absint( $scMeta['pfp_carousel_speed'][0] ) : 250;
						$autoplayTimeout    = ! empty( $scMeta['pfp_carousel_autoplay_timeout'][0] ) ? absint( $scMeta['pfp_carousel_autoplay_timeout'][0] ) : 5000;
						$cOpt               = ! empty( $scMeta['pfp_carousel_options'] ) ?  TLPpPro()->array_text_sanitization( $scMeta['pfp_carousel_options'] )  : array();

						$autoPlay           = ( in_array( 'autoplay', $cOpt ) ? 'true' : 'false' );
						$autoPlayHoverPause = ( in_array( 'autoplayHoverPause', $cOpt ) ? 'true' : 'false' );
						$nav                = ( in_array( 'nav', $cOpt ) ? 'true' : 'false' );
						$dots               = ( in_array( 'dots', $cOpt ) ? 'true' : 'false' );
						$loop               = ( in_array( 'loop', $cOpt ) ? 'true' : 'false' );
						$lazyLoad           = ( in_array( 'lazy_load', $cOpt ) ? 'true' : 'false' );
						$autoHeight         = ( in_array( 'auto_height', $cOpt ) ? 'true' : 'false' );
						$rtl                = ( in_array( 'rtl', $cOpt ) ? 'true' : 'false' );

						$html .= "<div class='pfp-carousel owl-carousel owl-theme'
										data-loop='{$loop}'
										data-items='{$items}'
										data-tabcolumn='{$tColItems}'
										data-mobilecolumn='{$mColItems}'
										data-autoplay='{$autoPlay}'
										data-autoplay-timeout='{$autoplayTimeout}'
										data-autoplay-hover-pause='{$autoPlayHoverPause}'
										data-dots='{$dots}'
										data-nav='{$nav}'
										data-lazyload='{$lazyLoad}'
										data-autoheight='{$autoHeight}'
										data-rtl='{$rtl}'
										data-smapfpspeed='{$smartSpeed}'
										>";
					}

					$current_page_term = array();
					$loops_content = '' ;
					while ( $portQuery->have_posts() ) : $portQuery->the_post();
						$iID                   = get_the_ID();
						$arg['iID']            = $iID;
						$arg['title']          = get_the_title();
						$arg['client_name']    = get_post_meta( $iID, 'client_name', true );
						$arg['completed_date'] = get_post_meta( $iID, 'completed_date', true );
						$arg['short_desc']     = get_post_meta( $iID, 'short_description', true );
						$arg['short_desc']     = TLPpPro()->strip_tags_content( $arg['short_desc'], $excerpt_limit );
						$arg['project_url']    = get_post_meta( $iID, 'project_url', true );
						$arg['external_url']    = get_post_meta( $iID, 'external_url', true );
						$arg['tools']          = strip_tags( get_the_term_list( $iID, TLPpPro()->taxonomies['tool'], null, ' | ' ) );
						$arg['categories']     = strip_tags( get_the_term_list( $iID, TLPpPro()->taxonomies['category'], null, ', ' ) );
						$arg['tags']           = strip_tags( get_the_term_list( $iID, TLPpPro()->taxonomies['tag'], null, ', ' ) );
						$arg['pLink']          = get_permalink();
						if($arg['link_type'] == "external_link" && $arg['external_url']){
							$arg['pLink'] = $arg['external_url'];
						}
						$imgUrl                = wp_get_attachment_image_src( get_post_thumbnail_id( $iID ), 'full' );;
						$arg['img_full_url'] = ( ! empty( $imgUrl ) ? $imgUrl[0] : null );
						$excerpt             = get_the_excerpt();
						$arg['excerpt']      = TLPpPro()->strip_tags_content( $excerpt, $excerpt_limit );
						if ( $isIsotope ) {
							$termAs    = wp_get_post_terms( $iID, TLPpPro()->taxonomies['category'],
								array( "fields" => "all" ) );
							$isoFilter = null;
							if ( ! empty( $termAs ) ) {
								foreach ( $termAs as $term ) {
									$isoFilter .= " " . "iso_" . $term->term_id;
									$isoFilter .= " " . $term->slug;
									$current_page_term[] = $term->term_id;
								}
							}
							$arg['isoFilter'] = $isoFilter;
						}
						$arg['img'] = TLPpPro()->getFeatureImage( $iID, $imgSize, $customImgSize );
						$loops_content .= TLPpPro()->render( 'layouts/' . $layout, $arg );

					endwhile;
					$filter_button = '' ;
					if ( $isIsotope ) {
						if ( function_exists( 'get_term_meta' ) ) {
							$terms = get_terms( array(
								'taxonomy'   => TLPpPro()->taxonomies['category'],
								'hide_empty' => false,
								'orderby'    => 'meta_value_num',
								'order'      => 'ASC',
								'meta_key'   => '_order'
							) );
						} else {
							$terms = get_terms( TLPpPro()->taxonomies['category'], array( 'hide_empty' => false ) );
						}
						$filter_button .= '<div class="pfp-iso-filter"><div id="iso-button-' . $rand . '" class="pfp-isotope-buttons button-group filter-button-group option-set">';
						$htmlButton     = null;
						$fSelectTrigger = false;
						if ( ! empty( $terms ) && ! is_wp_error( $terms ) ) {
							$tItem   = ! empty( $scMeta['pfp_isotope_selected_filter'][0] ) ? absint( $scMeta['pfp_isotope_selected_filter'][0] ) : null;
							foreach ( $terms as $term ) {
								$fSelect = null;
								if ( $tItem == $term->term_id ) {
									$fSelect        = 'selected';
									$fSelectTrigger = true;
								}
								if ( is_array( $cats ) && ! empty( $cats ) ) {
									if ( in_array( $term->term_id, $cats ) && in_array( $term->term_id, $current_page_term ) ) {
										$htmlButton .= "<button data-filter-counter='' class='iso-button-{$term->term_id} {$fSelect}' data-filter='.iso_{$term->term_id}'>" . $term->name . "</button>";
									}
								}else{
									if( in_array( $term->term_id, $current_page_term ) ){
										$htmlButton .= "<button data-filter-counter='' class='iso-button-{$term->term_id} {$fSelect}' data-filter='.iso_{$term->term_id}'>" . $term->name . "</button>";
									}
								}
							}
						}
						if ( empty( $scMeta['pfp_isotope_filter_show_all'][0] ) ) {
							$fSelect = ( $fSelectTrigger ? null : 'class="selected"' );
							$filter_button .= "<button data-filter-counter='' data-filter='*' {$fSelect}>" . esc_html__( 'Show all',
									'tlp-portfolio-pro' ) . "</button>";
						}
						$filter_button .= $htmlButton;
						$filter_button .= '</div>';
						if ( ! empty( $scMeta['pfp_isotope_search_filtering'][0] ) ) {
							$filter_button .= "<div class='iso-search'><input type='text' class='iso-search-input' placeholder='" . esc_html__( 'Search',
									'tlp-portfolio-pro' ) . "' /></div>";
						}
						$filter_button .= '</div>';

						$filter_button .= '<div class="pfp-isotope" id="pfp-isotope-' . $rand . '">';
					}

					$html .= $filter_button . $loops_content ;

					if ( $isIsotope || $isCarousel ) {
						$html .= '</div>'; // End isotope / Carousel item holder
					}
				} else {
					$html .= "<p>" . esc_html__( "No portfolio found", 'tlp-portfolio-pro' ) . "</p>";
				}
				$html .= "</div>"; // End row

				if ( $pagination && ! $isCarousel ) {
					$htmlUtility = null;
					$postPp         = $portQuery->query_vars['posts_per_page'];
					$page           = $portQuery->query_vars['paged'];
					$foundPosts     = $portQuery->found_posts;
					$morePosts      = $foundPosts - ( $postPp * $page );
					$totalPage      = $portQuery->max_num_pages;
					$foundPost = $portQuery->found_posts;

					if( ! empty( $scMeta['pfp_limit'][0] ) ) {
						$range = $scMeta['pfp_posts_per_page'][0];
						$foundPost = $portQuery->found_posts;

						if($range && $foundPost > $range ){
							$foundPost = $scMeta['pfp_limit'][0];
							$totalPage  = ceil( (int) $foundPost / (int) $range );
						}
					}
					$morePosts     = (int) $foundPost - ( (int) $postPp * (int) $page );

					$foundPosts = $foundPost;
					$totalPage = absint( $totalPage ) ;
					$morePosts = absint( $morePosts ) ;
					if ( $posts_loading_type == "pagination" ) {
						$htmlUtility .= TLPpPro()->pagination( $totalPage, $postPp );

					} elseif ( $posts_loading_type == "pagination_ajax" && ! $isIsotope ) {
						$htmlUtility .= TLPpPro()->pagination( $totalPage, $args['posts_per_page'], true,
							$scID );
					} elseif ( $posts_loading_type == "load_more" ) {


						$noMorePostText = esc_html__( "No More Post to load", 'tlp-portfolio-pro' );
						$loadMoreText   = ! empty( $scMeta['pfp_load_more_button_text'][0] ) ? sanitize_text_field( $scMeta['pfp_load_more_button_text'][0] ) : esc_html__( "Load More", 'tlp-portfolio-pro' );
						$loadingText    = esc_html__( 'Loading ...', 'tlp-portfolio-pro' );

						if( $morePosts ){
							$htmlUtility .= "<div class='pfp-load-more'>
                                        <button data-limit='{$limit}' data-sc-id='{$scID}' data-total-pages='{$totalPage}' data-posts-per-page='{$postPp}' data-found-posts='{$foundPosts}' data-paged='1'
                                        data-no-more-post-text='{$noMorePostText}' data-loading-text='{$loadingText}'>{$loadMoreText} <span>({$morePosts})</span></button>
                                    </div>";
						}

					}

					elseif ( $posts_loading_type == "load_on_scroll" ) {

						$htmlUtility .= "<div class='pfp-scroll-load-more' data-limit='{$limit}'  data-trigger='1' data-total-pages='{$totalPage}' data-posts-per-page='{$postPp}' data-sc-id='{$scID}' data-found-posts='{$foundPosts}' data-paged='1'></div>";
					}

					if ( $htmlUtility ) {
						$html .= "<div class='pfp-utility'>" . $htmlUtility . "</div>";
					}

				}
				$html .= "</div>"; // pfp-container pfp
				wp_reset_postdata();
				$scriptGenerator               = array();
				$scriptGenerator['layout']     = $layoutID;
				$scriptGenerator['rand']       = $rand;
				$scriptGenerator['scMeta']     = $scMeta;
				$scriptGenerator['isIsotope']  = ( $isIsotope || $gridType == "masonry" ? true : false );
				$scriptGenerator['isCarousel'] = $isCarousel;
				$this->scA[]                   = $scriptGenerator;
				add_action( 'wp_footer', array( $this, 'register_scripts' ) );
			} else {
				$html .= "<p>" . esc_html__( "No shortCode found", 'tlp-portfolio-pro' ) . "</p>";
			}

			return $html;
		}

		// TODO: This function will remove in future.
		private function layoutStyle( $layoutID, $meta ) {
			$css = null;
			$css .= "<style type='text/css' media='all'>";
			// Variable

			$primaryColor = ( ! empty( $meta['pfp_primary_color'][0] ) ? sanitize_text_field( $meta['pfp_primary_color'][0] ) : null );
			if ( $primaryColor ) {

				$css .= ".{$layoutID}.tlp-popup-wrap .tlp-popup-navigation-wrap,nav.tlp-pagination ul.page-numbers li .page-numbers {";
				$css .= "background:" . $primaryColor . ";";
				$css .= "}";
				$css .= "#{$layoutID} .tlp-portfolio-item .tlp-content,
					#{$layoutID} .pfp-layout7 .short-desc p,
					#{$layoutID} .pfp-isotope6 .tlp-portfolio-item p,
					#{$layoutID} .pfp-carousel6 .tlp-portfolio-item p,
					#{$layoutID} .tlp-portfolio .isotop-btn button,
					#{$layoutID} .tlp-overlay .tlp-title,
					#{$layoutID} .tlp-overlay .line,
					#{$layoutID} .pfp-layout19 figcaption,
					#{$layoutID} .pfp-isotope18 figcaption,
					#{$layoutID} .pfp-carousel18 figcaption {";
				$css .= "background:" . $primaryColor . ";";
				$css .= "}";
				$css .= "#{$layoutID} .tlp-portfolio-item .tlp-overlay h3,#{$layoutID} .tlp-portfolio-item .tlp-overlay16 h3, #{$layoutID} .tlp-portfolio-item .tlp-overlay17 h3 {";
				$css .= "border-color:" . $primaryColor . ";";
				$css .= "}";
				$css .= "#{$layoutID} .pfp-layout19 figure:hover figcaption,#{$layoutID} .pfp-isotope18 figure:hover figcaption, #{$layoutID} .pfp-carousel18 figure:hover figcaption {";
				$css .= "box-shadow: 0 0 0 10px" . $primaryColor . ";";
				$css .= "}";
				$css .= ".{$layoutID} .flex-direction-nav a:before {";
				$css .= "color:" . $primaryColor . ";";
				$css .= "}";
			}

			/* Button background color */
			$buttonBgColor  = ( ! empty( $meta['pfp_button_bg_color'][0] ) ? sanitize_text_field( $meta['pfp_button_bg_color'][0] ) : null );
			$buttonTxtColor = ( ! empty( $meta['pfp_button_text_color'][0] ) ? sanitize_text_field( $meta['pfp_button_text_color'][0] ) : null );

			if ( $buttonBgColor ) {
				$css .= "#{$layoutID} .pfp-load-more button, #{$layoutID} .pfp-isotope-buttons button, #{$layoutID} .pfp-isotope-buttons button, #{$layoutID} .owl-theme .owl-nav [class*=owl-],
			    #{$layoutID} .owl-theme .owl-dots .owl-dot span,#{$layoutID} .pfp-pagination ul.pagination-list li span, #{$layoutID} .pfp-pagination ul.pagination-list li a {";
				$css .= "background: {$buttonBgColor};";
				$css .= ( $buttonTxtColor ? "color: {$buttonTxtColor}" : null );
				$css .= "}";
			}

			/* Button hover background color */
			$buttonHoverBgColor = ( ! empty( $meta['pfp_button_hover_bg_color'][0] ) ? sanitize_text_field( $meta['pfp_button_hover_bg_color'][0] ) : null );
			if ( $buttonHoverBgColor ) {
				$css .= "#{$layoutID} .pfp-load-more button:hover,#{$layoutID} .pfp-isotope-buttons button:hover, #{$layoutID} .owl-theme .owl-nav [class*=owl-]:hover, #{$layoutID} .pfp-pagination ul.pagination-list li span:hover, #{$layoutID} .pfp-pagination ul.pagination-list li a:hover {";
				$css .= "background: {$buttonHoverBgColor};";
				$css .= "}";
			}

			/* Button Active background color */
			$buttonActiveBgColor = ( ! empty( $meta['pfp_button_active_bg_color'][0] ) ? sanitize_text_field( $meta['pfp_button_active_bg_color'][0] ) : null );
			if ( $buttonActiveBgColor ) {
				$css .= "#{$layoutID} .pfp-isotope-buttons button.selected, #{$layoutID} .owl-theme .owl-dots .owl-dot.active span, #{$layoutID} .pfp-pagination ul.pagination-list li.active span {";
				$css .= "background: {$buttonActiveBgColor};";
				$css .= "}";
			}

			// Isotope counter tooltip color
			$tooltipBg   = ( ! empty( $meta['pfp_iso_counter_tooltip_bg_color'][0] ) ? sanitize_text_field( $meta['pfp_iso_counter_tooltip_bg_color'][0] ) : null );
			$tooltipText = ( ! empty( $meta['pfp_iso_counter_tooltip_text_color'][0] ) ? sanitize_text_field( $meta['pfp_iso_counter_tooltip_text_color'][0] ) : null );
			if ( $tooltipBg || $tooltipText ) {
				$css .= "#pfp-tooltip-{$layoutID}, #pfp-tooltip-{$layoutID} .pfp-tooltip-bottom:after {";
				$css .= ($tooltipBg ? "background: {$tooltipBg}; " : null);
				$css .= ($tooltipText ? "color: {$tooltipText};" : null);
				$css .= "}";
			}

			/* gutter */
			if ( ! empty( $meta['pfp_gutter'][0] ) && $gutter = absint( $meta['pfp_gutter'][0] ) ) {
				$css .= "#{$layoutID} [class*='pfp-col-'] {";
				$css .= "padding-left : {$gutter}px;";
				$css .= "padding-right : {$gutter}px;";
				$css .= "margin-top : {$gutter}px;";
				$css .= "margin-bottom : {$gutter}px;";
				$css .= "}";
				$css .= "#{$layoutID} .pfp-row{";
				$css .= "margin-left : -{$gutter}px;";
				$css .= "margin-right : -{$gutter}px;";
				$css .= "}";
			}

			// Name
			$name = ( ! empty( $meta['pfp_name_style'][0] ) ? TLPpPro()->array_text_sanitization( $meta['pfp_name_style'][0] ) : array() );
			if ( ! empty( $name ) && is_array( $name ) ) {

				$css .= "#{$layoutID} .tlp-portfolio-item h3.title a, #{$layoutID} .tlp-portfolio-item h3.title {";
				$css .= ( ! empty( $name['align'] ) ? "text-align:" . $name['align'] . " !important;" : null );
				$css .= ( ! empty( $name['weight'] ) ? "font-weight:" . $name['weight'] . ";" : null );
				$css .= ( ! empty( $name['size'] ) ? "font-size:" . $name['size'] . "px;" : null );
				$css .= "}";
				$css .= "#{$layoutID} .tlp-portfolio-item h3.title:not(.color-white) a, #{$layoutID} .tlp-portfolio-item h3.title:not(.color-white) {";
				$css .= ( ! empty( $name['color'] ) ? "color:" . $name['color'] . ";" : null );
				$css .= "}";

			}

			$name_hover = !empty( $meta['pfp_name_hover_style'][0] ) ? TLPpPro()->array_text_sanitization( $meta['pfp_name_hover_style'][0] ) : array();
			// Name
			if ( ! empty( $name_hover ) && is_array( $name_hover ) ) {
				$css .= "#{$layoutID} .tlp-portfolio-item h3.title a:hover, #{$layoutID} .tlp-portfolio-item h3.title:hover {";
				// $css .= ( ! empty( $name_hover['color'] ) ? "color:" . $name_hover['color'] . ";" : null );
				$css .= ( ! empty( $name_hover['align'] ) ? "text-align:" . $name_hover['align'] . " !important;" : null );
				$css .= ( ! empty( $name_hover['weight'] ) ? "font-weight:" . $name_hover['weight'] . ";" : null );
				$css .= ( ! empty( $name_hover['size'] ) ? "font-size:" . $name_hover['size'] . "px;" : null );
				$css .= "}";

				$css .= "#{$layoutID} .tlp-portfolio-item h3.title:not(.color-white) a:hover, #{$layoutID} .tlp-portfolio-item h3.title:not(.color-white):hover {";
				$css .= ( ! empty( $name_hover['color'] ) ? "color:" . $name_hover['color'] . ";" : null );
				$css .= "}";
			}

			// Short Description
			$short_desc = ( ! empty( $meta['pfp_short_description_style'][0] ) ? TLPpPro()->array_text_sanitization( $meta['pfp_short_description_style'][0] ) : array() );
			if ( ! empty( $short_desc ) && is_array( $short_desc ) ) {
				$css .= "#{$layoutID} .tlp-portfolio-item .short-desc, #{$layoutID} .pfp-layout19 figcaption .pfp-categories {";
				$css .= ( ! empty( $short_desc['color'] ) ? "color:" . $short_desc['color'] . ";" : null );
				$css .= ( ! empty( $short_desc['size'] ) ? "font-size:" . $short_desc['size'] . "px;" : null );
				$css .= ( ! empty( $short_desc['weight'] ) ? "font-weight:" . $short_desc['weight'] . ";" : null );
				$css .= ( ! empty( $short_desc['align'] ) ? "text-align:" . $short_desc['align'] . ";" : null );
				$css .= "}";
			}
			// project_url
			$project_url = ( ! empty( $meta['pfp_client_name_style'][0] ) ? TLPpPro()->array_text_sanitization( $meta['pfp_client_name_style'][0] ) : array() );
			if ( ! empty( $project_url ) && is_array( $project_url ) ) {
				$css .= "#{$layoutID} .tlp-portfolio-item .extra-features li.client-name{";
				$css .= ( ! empty( $project_url['color'] ) ? "color:" . $project_url['color'] . ";" : null );
				$css .= ( ! empty( $project_url['size'] ) ? "font-size:" . $project_url['size'] . "px;" : null );
				$css .= ( ! empty( $project_url['align'] ) ? "text-align:" . $project_url['align'] . ";" : null );
				$css .= ( ! empty( $project_url['weight'] ) ? "font-weight:" . $project_url['weight'] . ";" : null );
				$css .= "}";
			}
			// tools
			$tools = ( ! empty( $meta['pfp_tools_style'][0] ) ? TLPpPro()->array_text_sanitization( $meta['pfp_tools_style'][0] ) : array() );
			if ( ! empty( $tools ) && is_array( $tools ) ) {
				$css .= "#{$layoutID} .tlp-portfolio-item .tools, #{$layoutID} .tlp-portfolio-item .pfp-categories {";
				$css .= ( ! empty( $tools['color'] ) ? "color:" . $tools['color'] . ";" : null );
				$css .= ( ! empty( $tools['size'] ) ? "font-size:" . $tools['size'] . "px;" : null );
				$css .= ( ! empty( $tools['align'] ) ? "text-align:" . $tools['align'] . ";" : null );
				$css .= ( ! empty( $tools['weight'] ) ? "font-weight:" . $tools['weight'] . ";" : null );
				$css .= "}";
			}

			// Social icon color
			$iconStyle = ( ! empty( $meta['pfp_icon_style'][0] ) ? TLPpPro()->array_text_sanitization( $meta['pfp_icon_style'][0] ) : array() );
			if ( ! empty( $iconStyle ) && is_array( $iconStyle ) ) {
				$css .= "#{$layoutID} .tlp-portfolio-item .link-icon a {";
				$css .= ( ! empty( $iconStyle['color'] ) ? "border: 1px solid  " . $iconStyle['color'] . ";" : null );
				$css .= ( ! empty( $iconStyle['color'] ) ? "color:" . $iconStyle['color'] . ";" : null );
				$css .= ( ! empty( $iconStyle['size'] ) ? "font-size:" . $iconStyle['size'] . "px;" : null );
				$css .= "}";
			}

			// link-icon Style
			if ( ! empty( $iconStyle ) && is_array( $iconStyle ) ) {
				$css .= "#{$layoutID} .tlp-portfolio-item .link-icon{";
				$css .= ( ! empty( $iconStyle['align'] ) ? "text-align:" . $iconStyle['align'] . ";" : null );
				$css .= "}";
			}


			// Overlay
			$overlayColor   = ( ! empty( $meta['pfp_overlay_color'][0] ) ? sanitize_text_field( $meta['pfp_overlay_color'][0] ) : null );
			$overlayOpacity = ( ! empty( $meta['pfp_overlay_opacity'][0] ) ? absint( $meta['pfp_overlay_opacity'][0] ) : null );
			if ( $overlayColor ) {
				$css .= "#{$layoutID} .pfp-layout1 .tlp-portfolio-item:hover .tlp-overlay,
				#{$layoutID} .pfp-layout2 .tlp-overlay,#{$layoutID} .pfp-isotope20 .tlp-overlay, #{$layoutID} .pfp-layout3 .tlp-overlay, #{$layoutID} .pfp-layout4 .tlp-overlay, #{$layoutID} .tlp-portfolio-item:hover .tlp-overlay,
				#{$layoutID} .tlp-portfolio-item:hover .tlp-overlay, #{$layoutID}  .tlp-portfolio-thumb:hover .tlp-overlay, #{$layoutID} .tlp-portfolio-item .overlay,
				#{$layoutID} .pfp-carousel1 .tlp-portfolio-item:hover .tlp-overlay, #{$layoutID} .tlp-portfolio-item .post-info, #{$layoutID} .pfp-layout9 .tlp-portfolio-item figcaption:hover,#{$layoutID} .pfp-isotope8 .tlp-portfolio-item figcaption:hover,#{$layoutID} .pfp-carousel8 .tlp-portfolio-item figcaption:hover {";
				$css .= "background:" . TLPpPro()->TLPhex2rgba( $overlayColor,
						( $overlayOpacity ? $overlayOpacity / 100 : .8 ) ) . ";";
				$css .= "}";
			}
			// Overlay Padding
			$overlaypadding = ( ! empty( $meta['pfp_overlay_padding'][0] ) ? absint( $meta['pfp_overlay_padding'][0] ) : null );
			if ( $overlaypadding ) {
				$css .= "#{$layoutID} .pfp-layout1 .tlp-portfolio-item:hover .tlp-overlay,
				#{$layoutID} .pfp-layout2 .tlp-overlay,#{$layoutID} .pfp-isotope20 .tlp-overlay, #{$layoutID} .pfp-layout3 .tlp-overlay, #{$layoutID} .pfp-layout4 .tlp-overlay, #{$layoutID} .tlp-portfolio-item:hover .tlp-overlay,
				#{$layoutID} .tlp-portfolio-item:hover .tlp-overlay, #{$layoutID}  .tlp-portfolio-thumb:hover .tlp-overlay, #{$layoutID} .tlp-portfolio-item .overlay,
				#{$layoutID} .pfp-carousel1 .tlp-portfolio-item:hover .tlp-overlay, #{$layoutID} .tlp-portfolio-item .post-info, #{$layoutID} .pfp-layout9 .tlp-portfolio-item figcaption:hover,#{$layoutID} .pfp-isotope8 .tlp-portfolio-item figcaption:hover,#{$layoutID} .pfp-carousel8 .tlp-portfolio-item figcaption:hover {";
				$css .= "padding-top:" . $overlaypadding . "%;";
				$css .= "}";
			}
			$css .= "</style>";

			return $css;
		}

	}
endif;
