<?php
if ( ! class_exists( 'PFProPostMeta' ) ) :

	/**
	 *
	 */
	class PFProPostMeta {


		function __construct() {
			add_action( 'add_meta_boxes', array( $this, 'add_portfolio_meta_box' ) );
			add_action( 'save_post', array( $this, 'save_portfolio_meta_data' ), 10, 2 );
		}

		function add_portfolio_meta_box() {
			add_meta_box( 'pfp_details_meta', esc_html__( 'Portfolio Details', 'tlp-portfolio-pro' ), array( $this, 'pfp_details_meta' ), 'portfolio', 'normal', 'high' );
			add_meta_box( 'pfp_gallery_meta', esc_html__( 'Portfolio Gallery', 'tlp-portfolio-pro' ), array( $this, 'pfp_gallery_meta' ), 'portfolio', 'normal', 'high' );
		}

		function pfp_details_meta( $post ) {
			wp_nonce_field( TLPpPro()->nonceText(), TLPpPro()->nonceId() );
			echo '<div class="pfp-meta-wrapper">';
				echo TLPpPro()->rtFieldGenerator( TLPpPro()->singlePortfolioFields() );
			echo '</div>';
		}

		function pfp_gallery_meta( $post ) {
			$image_ids     = get_post_meta( $post->ID, 'tlp_portfolio_gallery' );
			$html          = null;
			$html         .= "<div id='tlp-portfolio-gallery-holder'>";
					$html .= '<div class="add-new-holder"><button  class="button-primary button" id="add-new-port-img" />' . __( 'Add New Image', 'tlp-portfolio-pro' ) . '</button></div>';
			$html         .= "<ul id='tlp-gallery'>";
			if ( $image_ids ) {
				foreach ( $image_ids as $id ) {
					$html .= '<li><span class="dashicons dashicons-dismiss"></span>';
					$html .= wp_get_attachment_image( $id, array( 150, 150 ) );
					$html .= '<input type="hidden" name="tlp_portfolio_gallery[]" value="' . $id . '">';
					$html .= '</li>';
				}
			} else {
				$html .= "<li class='no-img'>" . esc_html__( 'No image found', 'tlp-portfolio-pro' ) . '</li>';
			}
			$html .= '</ul>';
			$html .= '</div>';

			echo $html;
		}



		function save_portfolio_meta_data( $post_id, $post ) {

			if ( defined( 'DOING_AUTOSAVE' ) && DOING_AUTOSAVE ) {
				return;
			}
			if ( ! TLPpPro()->verifyNonce() ) {
				return $post_id;
			}

			if ( TLPpPro()->post_type != $post->post_type ) {
				return $post_id;
			}

			$mates = TLPpPro()->singlePortfolioFields();
			foreach ( $mates as $metaKey => $field ) {
				$rValue = isset( $_REQUEST[ $metaKey ] ) ? $_REQUEST[ $metaKey ] : null;
				$value  = TLPpPro()->sanitize( $field, $rValue );
				if ( empty( $field['multiple'] ) ) {
					update_post_meta( $post_id, $metaKey, $value );
				} else {
					delete_post_meta( $post_id, $metaKey );
					if ( is_array( $value ) && ! empty( $value ) ) {
						foreach ( $value as $item ) {
							add_post_meta( $post_id, $metaKey, $item );
						}
					}
				}
			}

			delete_post_meta( $post->ID, 'tlp_portfolio_gallery' );
			if ( isset( $_POST['tlp_portfolio_gallery'] ) && ! empty( $_POST['tlp_portfolio_gallery'] ) ) {
				$image_ids = array_unique( $_POST['tlp_portfolio_gallery'] );
				foreach ( $image_ids as $id ) {
					add_post_meta( $post->ID, 'tlp_portfolio_gallery', esc_attr( absint( $id ) ) );
				}
			}

		}

	}
endif;
