<?php
if (!class_exists('PFProOptions')) :
    class PFProOptions
    {

        function generalSettings() {
            $settings = get_option(TLPpPro()->options['settings']);

            return array(
                'slug' => array(
                    'label'       => esc_html__('Slug', 'tlp-portfolio-pro'),
                    'type'        => 'text',
                    'description' => esc_html__('Slug configuration', 'tlp-portfolio-pro'),
                    'attr'        => "size='10'",
                    'value'       => (isset($settings['slug']) ? ($settings['slug'] ? sanitize_title_with_dashes($settings['slug']) : 'portfolio') : 'portfolio')
                )
            );
        }

        function detailFieldControl() {
            $settings = get_option(TLPpPro()->options['settings']);

            return array(
                'field'              => array(
                    'label'       => esc_html__('Select the field', 'tlp-portfolio-pro'),
                    'type'        => 'checkbox',
                    'options'     => TLPpPro()->single_page_field(),
                    'multiple'    => true,
                    'alignment'   => 'vertical',
                    'description' => esc_html__('Select the option which you like to display', 'tlp-portfolio-pro'),
                    'value'       => (isset($settings['field']) ? $settings['field'] : array())
                ),
                'project_url_text'   => array(
                    "type"      => "text",
                    "label"     => esc_html__("Project URL Text", 'tlp-portfolio-pro'),
                    "alignment" => 'vertical',
                    'value'     => (isset($settings['project_url_text']) ? $settings['project_url_text'] : esc_html__("Click to View", 'tlp-portfolio-pro'))
                ),
                'project_url_target' => array(
                    "type"      => "radio",
                    "label"     => esc_html__("Project URL link type", 'tlp-portfolio-pro'),
                    "alignment" => 'vertical',
                    'value'     => isset($settings['project_url_target']) && !empty($settings['project_url_target']) ? '_blank' : '',
                    "options"   => array(
                        ''       => esc_html__("Same Page", 'tlp-portfolio-pro'),
                        '_blank' => esc_html__("New Page", 'tlp-portfolio-pro')
                    )
                )
            );
        }

        function othersSettings() {
            $settings = get_option(TLPpPro()->options['settings']);

            return array(
                'custom_css' => array(
                    'label'       => esc_html__('Custom CSS', 'tlp-portfolio-pro'),
                    'type'        => 'custom_css',
                    'description' => esc_html__('Add your custom css here!!!', 'tlp-portfolio-pro'),
                    'value'       => (!empty($settings['custom_css']) ? wp_specialchars_decode($settings['custom_css']) : null)
                )
            );
        }

        function rtPfpLicenceField() {
            $settings = get_option(TLPpPro()->options['settings']);
            $status = !empty($settings['license_status']) && $settings['license_status'] === 'valid' ? true : false;
            $license_status = !empty($settings['license_key']) ? sprintf("<span class='license-status'>%s</span>",
                $status ? "<input type='submit' class='button-secondary rt-licensing-btn danger' name='license_deactivate' value='Deactivate License'/>"
                    : "<input type='submit' class='button-secondary rt-licensing-btn button-primary' name='license_activate' value='Activate License'/>"
            ) : ' ';
            return array(
                "license_key" => array(
                    'type'        => 'text',
                    'attr'        => 'style="min-width:300px;"',
                    'label'       => 'Enter your license key',
                    'description' => $license_status,
                    'id'          => 'rt_pfp_license_key',
                    'value'       => isset($settings['license_key']) ? $settings['license_key'] : ''
                )
            );
        }

        function scItemMetaFields() {
            return array(
                "pfp_item_fields" => array(
                    "type"        => "checkbox",
                    "label"       => esc_html__("Field selection", 'tlp-portfolio-pro'),
                    "multiple"    => true,
                    "alignment"   => "vertical",
                    "default"     => array_keys($this->sc_field()),
                    "options"     => $this->sc_field(),
                    "description" => esc_html__('Check the field which you want to display', 'tlp-portfolio-pro')
                )
            );
        }

        function scLayoutMetaFields() {
            return array(

                "pfp_layout_type" => array(
                    "type"    => "radio-image",
                    "label"   => esc_html__("Layout type", 'tlp-portfolio-pro'),
                    "id"      => "pfp-layout-type",
                    "options" => array(
							'grid' => array(
								'title' => esc_html__('Grid Layout', 'tlp-portfolio-pro'),
								'img' => TLPpPro()->assetsUrl . 'images/layout_type_grid.png',
							),
							'isotope' => array(
								'title' => esc_html__('Isotop Layout', 'tlp-portfolio-pro'),
								'img' => TLPpPro()->assetsUrl . 'images/layout_type_isotope.png',
							),
							'carousel' => array(
								'title' => esc_html__('Slider Layout', 'tlp-portfolio-pro'),
								'img' => TLPpPro()->assetsUrl . 'images/layout_type_slider.png',
							),
						)

                ),
				'pfp_layout'    => array(
					'label'   => esc_html__( 'Layout', 'tlp-portfolio-pro' ),
					'type'    => 'radio-image',
					'class'   => 'rt-select2',
					'options' => TLPpPro()->scLayout(),
				),

                'pfp_isotope_selected_filter'   => array(
                    "type"        => "select",
                    "label"       => esc_html__("Isotope filter (Selected item)", 'tlp-portfolio-pro'),
                    'holderClass' => "pfp-isotope-item pfp-hidden",
                    "class"       => "rt-select2",
                    "blank"       => esc_html__('Show All', 'tlp-portfolio-pro'),
                    "options"     => TLPpPro()->getAllPortFolioCategoryList()
                ),
                'pfp_isotope_filter_show_all'   => array(
                    "type"        => "checkbox",
                    "label"       => "Isotope filter (Show All item)",
                    'holderClass' => "pfp-isotope-item pfp-hidden",
                    "id"          => "rt-tpg-sc-isotope-filter-show-all",
                    "optionLabel" => esc_html__('Disable', 'tlp-portfolio-pro'),
                    "option"      => 1
                ),
                'pfp_isotope_search_filtering'  => array(
                    "type"        => "checkbox",
                    "label"       => "Isotope search filter",
                    'holderClass' => "pfp-isotope-item pfp-hidden",
                    "optionLabel" => 'Enable',
                    "option"      => 1
                ),
                'pfp_carousel_speed'            => array(
                    "label"       => esc_html__("Speed", 'tlp-portfolio-pro'),
                    "holderClass" => "pfp-hidden pfp-carousel-item",
                    "type"        => "number",
                    'default'     => 2000,
                    "description" => esc_html__('Auto play Speed in milliseconds', 'tlp-portfolio-pro'),
                ),
                'pfp_carousel_options'          => array(
                    "label"       => esc_html__("Carousel Options", 'tlp-portfolio-pro'),
                    "holderClass" => "pfp-hidden pfp-carousel-item",
                    "type"        => "checkbox",
                    "multiple"    => true,
                    "alignment"   => "vertical",
                    "options"     => $this->owlProperty(),
                    "default"     => array('autoplay', 'arrows', 'dots', 'responsive', 'infinite'),
                ),
                'pfp_carousel_autoplay_timeout' => array(
                    "label"       => esc_html__("Autoplay timeout", 'tlp-portfolio-pro'),
                    "holderClass" => "pfp-hidden pfp-carousel-auto-play-timeout",
                    "type"        => "number",
                    'default'     => 5000,
                    "description" => esc_html__('Autoplay interval timeout', 'tlp-portfolio-pro'),
                ),
                'pfp_desktop_column'            => array(
                    'type'    => 'select',
                    'label'   => esc_html__('Desktop column', 'tlp-portfolio-pro'),
                    'class'   => 'rt-select2',
                    'default' => 3,
                    'options' => $this->scColumns()
                ),
                'pfp_tab_column'                => array(
                    'type'    => 'select',
                    'label'   => esc_html__('Tab column', 'tlp-portfolio-pro'),
                    'class'   => 'rt-select2',
                    'default' => 2,
                    'options' => $this->scColumns()
                ),
                'pfp_mobile_column'             => array(
                    'type'    => 'select',
                    'label'   => esc_html__('Mobile column', 'tlp-portfolio-pro'),
                    'class'   => 'rt-select2',
                    'default' => 1,
                    'options' => $this->scColumns()
                ),
                'pfp_pagination'                => array(
                    "type"        => "checkbox",
                    "label"       => esc_html__("Pagination", 'tlp-portfolio-pro'),
                    'holderClass' => "pagination",
                    "optionLabel" => esc_html__('Enable', 'tlp-portfolio-pro'),
                    "option"      => 1
                ),
                'pfp_posts_per_page'            => array(
                    "type"        => "number",
                    "label"       => esc_html__("Display per page", 'tlp-portfolio-pro'),
                    'holderClass' => "pfp-pagination-item pfp-hidden",
                    "default"     => 5,
                    "description" => esc_html__("If value of Limit setting is not blank (empty), this value should be smaller than Limit value.",
                        'tlp-portfolio-pro')
                ),
                'pfp_pagination_type'           => array(
                    "type"        => "radio",
                    "label"       => esc_html__("Pagination type", 'tlp-portfolio-pro'),
                    'holderClass' => "pfp-pagination-item pfp-hidden",
                    "alignment"   => "vertical",
                    "default"     => 'pagination',
                    "options"     => $this->paginationType(),
                ),
                'pfp_load_more_button_text'     => array(
                    "type"        => "text",
                    "label"       => esc_html__("Load more button text", 'tlp-portfolio-pro'),
                    'holderClass' => "pfp-load-more-item pfp-hidden",
                    "default"     => esc_html__("Load more", 'tlp-portfolio-pro')
                ),
                'pfp_image_size'                => array(
                    "type"    => "select",
                    "label"   => esc_html__("Image size", 'tlp-portfolio-pro'),
                    "class"   => "rt-select2",
                    "options" => TLPpPro()->get_image_sizes()
                ),
                'pfp_custom_image_size'         => array(
                    "type"        => "image_size",
                    "label"       => esc_html__("Custom Image Size", 'tlp-portfolio-pro'),
                    'holderClass' => "pfp-hidden",
                    'description' => __( 'We prefer to upload image larger than your custom size.<span style="margin-top: 5px; display: block; color: #9A2A2A; font-weight: 400;">Please note that, if you enter image size larger than the actual image iteself, the image sizes will fallback to the full size image.</span>', 'tlp-portfolio' ),
                ),
                'pfp_excerpt_limit'             => array(
                    "type"        => "number",
                    "label"       => esc_html__("Short description limit", 'tlp-portfolio-pro'),
                    "description" => esc_html__("Short description limit only integer number is allowed, Leave it blank for full text.",
                        'tlp-portfolio-pro')
                ),
                'pfp_margin'                    => array(
                    "type"        => "radio",
                    "label"       => esc_html__("Margin", 'tlp-portfolio-pro'),
                    "alignment"   => "vertical",
                    "description" => esc_html__("Select the margin for layout", 'tlp-portfolio-pro'),
                    "default"     => "default",
                    "options"     => $this->scMarginOpt()
                ),
                'pfp_grid_style'                => array(
                    "type"        => "radio",
                    "label"       => esc_html__("Grid style", 'tlp-portfolio-pro'),
                    "alignment"   => "vertical",
                    "description" => esc_html__("Select grid style for layout", 'tlp-portfolio-pro'),
                    "default"     => "even",
                    "options"     => $this->scGridStyle()
                ),
                'pfp_detail_page_link'          => array(
                    "type"        => "checkbox",
                    "label"       => esc_html__("Detail page link", 'tlp-portfolio-pro'),
                    "optionLabel" => esc_html__("Enable", 'tlp-portfolio-pro'),
                    "default"     => 1,
                    "option"      => 1
                ),
                'pfp_detail_page_link_type'     => array(
                    "type"        => "radio",
                    "label"       => esc_html__("Detail page link type", 'tlp-portfolio-pro'),
                    "default"     => 'popup',
                    'holderClass' => "pfp_detail_page_link_type pfp-hidden",
                    "alignment"   => 'vertical',
                    "options"     => array(
                        'popup'         => 'PopUp',
                        'new_page'      => 'New Page',
                        'external_link' => "External Link"
                    )
                ),
                'pfp_link_target'               => array(
                    "type"        => "radio",
                    "label"       => esc_html__("Link Target", 'tlp-portfolio-pro'),
                    "default"     => '_blank',
                    'holderClass' => "pfp_link_target pfp-hidden",
                    "alignment"   => 'vertical',
                    "options"     => array(
                        '_self'  => 'Same Window',
                        '_blank' => 'New Window'
                    )
                )
            );
        }

        function scFilterMetaFields() {
            return array(
                'pfp_post__in'          => array(
                    "label"       => esc_html__("Include only", 'tlp-portfolio-pro'),
                    "type"        => "text",
                    "description" => esc_html__('List of post IDs to show (comma-separated values, for example: 1,2,3)',
                        'tlp-portfolio-pro')
                ),
                'pfp_post__not_in'      => array(
                    "label"       => esc_html__("Exclude", 'tlp-portfolio-pro'),
                    "type"        => "text",
                    "description" => esc_html__('List of post IDs to show (comma-separated values, for example: 1,2,3)',
                        'tlp-portfolio-pro')
                ),
                'pfp_limit'             => array(
                    "label"       => esc_html__("Limit", 'tlp-portfolio-pro'),
                    "type"        => "number",
                    "description" => esc_html__('The number of posts to show. Set empty to show all found posts.',
                        'tlp-portfolio-pro')
                ),
                'pfp_categories'        => array(
                    "label"       => esc_html__("Categories", 'tlp-portfolio-pro'),
                    "type"        => "select",
                    "class"       => "rt-select2",
                    "multiple"    => true,
                    "description" => esc_html__('Select the category you want to filter, Leave it blank for All category',
                        'tlp-portfolio-pro'),
                    "options"     => TLPpPro()->getAllPortFolioCategoryList()
                ),
                'pfp_tags'              => array(
                    "label"       => esc_html__("Tags", 'tlp-portfolio-pro'),
                    "type"        => "select",
                    "class"       => "rt-select2",
                    "multiple"    => true,
                    "description" => esc_html__('Select the category you want to filter, Leave it blank for All category',
                        'tlp-portfolio-pro'),
                    "options"     => TLPpPro()->getAllPortFolioTagList()
                ),
                'pfp_tools'             => array(
                    "label"       => esc_html__("Tools", 'tlp-portfolio-pro'),
                    "type"        => "select",
                    "class"       => "rt-select2",
                    "multiple"    => true,
                    "description" => esc_html__('Select the category you want to filter, Leave it blank for All category',
                        'tlp-portfolio-pro'),
                    "options"     => TLPpPro()->getAllPortFolioToolList()
                ),
                'pfp_taxonomy_relation' => array(
                    "label"       => esc_html__("Taxonomy relation", 'tlp-portfolio-pro'),
                    "type"        => "select",
                    "class"       => "rt-select2",
                    "description" => esc_html__('Select this option if you select more than one taxonomy like category and tag, or category , tag and tools',
                        'tlp-portfolio-pro'),
                    "options"     => TLPpPro()->scTaxonomyRelation()
                ),
                'pfp_order_by'          => array(
                    "label"   => esc_html__("Order By", 'tlp-portfolio-pro'),
                    "type"    => "select",
                    "class"   => "rt-select2",
                    "default" => "date",
                    "options" => $this->scOrderBy()
                ),
                'pfp_order'             => array(
                    "label"     => esc_html__("Order", 'tlp-portfolio-pro'),
                    "type"      => "radio",
                    "options"   => $this->scOrder(),
                    "default"   => "DESC",
                    "alignment" => "vertical",
                ),
            );
        }

        function singlePortfolioFields() {
            return array(
                'short_description' => array(
                    'label'       => esc_html__('Short Description', "tlp-portfolio-pro"),
                    'type'        => 'textarea',
                    'description' => esc_html__('Add some short description for hint view', 'tlp-portfolio-pro')
                ),
                'client_name'       => array(
                    'label' => esc_html__('Client Name', 'tlp-portfolio-pro'),
                    'type'  => 'text',
                ),
                'completed_date'    => array(
                    'label' => esc_html__('Completed Date', 'tlp-portfolio-pro'),
                    'type'  => 'text',
                    'class' => 'tlp-date',
                ),
                'project_url'       => array(
                    'label' => esc_html__('Project Url', 'tlp-portfolio-pro'),
                    'type'  => 'url',
                ),
                'external_url'      => array(
                    'label' => esc_html__('External URL (Custom detail link)', 'tlp-portfolio-pro'),
                    'type'  => 'url',
                ),
                'related_project'   => array(
                    'label'    => esc_html__('Related Project', 'tlp-portfolio-pro'),
                    'type'     => 'select',
                    'class'    => 'rt-select2',
                    'multiple' => true,
                    'options'  => TLPpPro()->getPortfolioListExceptId()
                )
            );
        }

        function scStyleFields() {
            return array(
                'pfp_parent_class'                   => array(
                    "type"        => "text",
                    "label"       => esc_html__("Parent class", 'tlp-portfolio-pro'),
                    "class"       => "medium-text",
                    "description" => esc_html__("Parent class for adding custom css", 'tlp-portfolio-pro')
                ),
                'pfp_primary_color'                  => array(
                    "type"    => "colorpicker",
                    "label"   => esc_html__("Primary Color", 'tlp-portfolio-pro'),
                    "default" => "#0367bf"
                ),
                'pfp_button_bg_color'                => array(
                    "type"  => "colorpicker",
                    "label" => esc_html__("Button background color", 'tlp-portfolio-pro'),
                ),
                'pfp_button_hover_bg_color'          => array(
                    "type"  => "colorpicker",
                    "label" => esc_html__("Button hover background color", 'tlp-portfolio-pro'),
                ),
                'pfp_button_active_bg_color'         => array(
                    "type"  => "colorpicker",
                    "label" => esc_html__("Button active background color", 'tlp-portfolio-pro'),
                ),
                'pfp_button_text_color'              => array(
                    "type"  => "colorpicker",
                    "label" => esc_html__("Button text color", 'tlp-portfolio-pro'),
                ),
                'pfp_iso_counter_tooltip_bg_color'   => array(
                    "type"        => "colorpicker",
                    'holderClass' => "pfp-isotope-item pfp-hidden",
                    "label"       => esc_html__("Isotope counter tooltip background color", 'tlp-portfolio-pro'),
                ),
                'pfp_iso_counter_tooltip_text_color' => array(
                    "type"        => "colorpicker",
                    'holderClass' => "pfp-isotope-item pfp-hidden",
                    "label"       => esc_html__("Isotope counter tooltip text color", 'tlp-portfolio-pro'),
                ),
                'pfp_gutter'                         => array(
                    'type'        => 'number',
                    'label'       => esc_html__('Gutter / Padding', 'tlp-portfolio-pro'),
                    'description' => "Unit will be pixel, No need to give any unit. Only integer value will be valid.<br> Leave it blank for default"
                ),
                'pfp_overlay_color'                  => array(
                    "type"  => "colorpicker",
                    "label" => esc_html__("Overlay color", 'tlp-portfolio-pro'),
                ),
                'pfp_overlay_opacity'                => array(
                    "type"        => "select",
                    "label"       => esc_html__("Overlay opacity", 'tlp-portfolio-pro'),
                    "class"       => "rt-select2",
                    "default"     => .8,
                    "options"     => $this->overflowOpacity(),
                    "description" => esc_html__("Overlay opacity use only positive integer value", 'tlp-portfolio-pro')
                ),
                'pfp_overlay_padding'                => array(
                    "type"        => "number",
                    "label"       => esc_html__("Overlay top padding", 'tlp-portfolio-pro'),
                    "class"       => "small-text",
                    "description" => esc_html__("Overlay top padding use only positive integer value, e.g : 20 ( without postfix like px, em, % etc). it will displayed by %",
                        'tlp-portfolio-pro')
                ),
                'pfp_name_style'                     => array(
                    'type'  => 'style',
                    'label' => esc_html__('Name', 'tlp-portfolio-pro'),
                ),
                'pfp_name_hover_style'                     => array(
                    'type'  => 'style',
                    'label' => esc_html__('Name Hover', 'tlp-portfolio-pro'),
                ),
                'pfp_short_description_style'        => array(
                    'type'  => 'style',
                    'label' => esc_html__('Short description', 'tlp-portfolio-pro'),
                ),
                'pfp_client_name_style'              => array(
                    'type'  => 'style',
                    'label' => esc_html__('Client Name', 'tlp-portfolio-pro'),
                ),
                'pfp_tools_style'                    => array(
                    'type'  => 'style',
                    'label' => esc_html__('Tools', 'tlp-portfolio-pro'),
                ),
                'pfp_icon_style'                     => array(
                    'type'  => 'style',
                    'label' => esc_html__('Icon style', 'tlp-portfolio-pro'),
                ),
                'pfp_short_description_style'        => array(
                    'type'  => 'style',
                    'label' => esc_html__('Short description', 'tlp-portfolio-pro'),
                ),
                'pfp_meta_style'              => array(
					'type'  => 'style',
					'label' => __( 'Meta style', 'tlp-portfolio' ),
				)
            );
        }

        function scTaxonomyRelation() {
            return array(
                'OR'  => "OR Relation",
                'AND' => "AND Relation"
            );
        }

        function overflowOpacity() {
            return array(
                10 => '10%',
                20 => '20%',
                30 => '30%',
                40 => '40%',
                50 => '50%',
                60 => '60%',
                70 => '70%',
                80 => '80%',
                90 => '90%',
            );
        }

        function paginationType() {
            return array(
                'pagination'      =>esc_html__("Pagination", 'tlp-portfolio-pro'),
                'pagination_ajax' =>esc_html__("Ajax Number Pagination ( Only for Grid )", 'tlp-portfolio-pro'),
                'load_more'       =>esc_html__("Load more button (by ajax loading)", 'tlp-portfolio-pro'),
                'load_on_scroll'  =>esc_html__("Load more on scroll (by ajax loading)", 'tlp-portfolio-pro')
            );
        }

        function scColumns() {
            return array(
                1 => "1 Column",
                2 => "2 Column",
                3 => "3 Column",
                4 => "4 Column",
                6 => "6 Column",
            );
        }

        function scOrderBy() {
            return array(
                'menu_order' => "Menu Order",
                'title'      => "Name",
                'ID'         => "ID",
                'date'       => "Date",
                'rand'       => "Random",
            );
        }

        function scOrder() {
            return array(
                'ASC'  => esc_html__("Ascending", 'tlp-portfolio-pro'),
                'DESC' => esc_html__("Descending", 'tlp-portfolio-pro'),
            );
        }

        // Layouts
        // TLPpPro()->assetsUrl
        function scLayout(){
            return array(
                'layout1'    =>  array(
							'title' => 'Layout 1',
							'layout' => 'grid',
                            "demoUrl"  => 'https://www.radiustheme.com/demo/plugins/portfolio/',
							'img' => TLPpPro()->assetsUrl . 'images/layout/grid/layout1.png',
						),
                'layout2'    => array(
							'title' => "Layout 2",
							'layout' => 'grid',
                            "demoUrl"  => 'https://www.radiustheme.com/demo/plugins/portfolio/grid-layout/layout-2/',
							'img' => TLPpPro()->assetsUrl . 'images/layout/grid/layout2.png',
						),
                'layout3'    => array(
							'title' => "Layout 3",
							'layout' => 'grid',
                            "demoUrl"  => 'https://www.radiustheme.com/demo/plugins/portfolio/grid-layout/layout-3/',
							'img' => TLPpPro()->assetsUrl . 'images/layout/grid/layout3.png',
						),
                'layout4'    => array(
							'title' => "Layout 4",
							'layout' => 'grid',
                            "demoUrl"  => 'https://www.radiustheme.com/demo/plugins/portfolio/grid-layout/layout-4/',
							'img' => TLPpPro()->assetsUrl . 'images/layout/grid/layout4.png',
						),
                'layout5'    =>  array(
							'title' => "Layout 5",
							'layout' => 'grid',
                            "demoUrl"  => 'https://www.radiustheme.com/demo/plugins/portfolio/grid-layout/layout-5/',
							'img' => TLPpPro()->assetsUrl . 'images/layout/grid/layout5.png',
						),
                'layout6'    => array(
							'title' => "Layout 6",
							'layout' => 'grid',
                            "demoUrl"  => 'https://www.radiustheme.com/demo/plugins/portfolio/grid-layout/layout-6/',
							'img' => TLPpPro()->assetsUrl . 'images/layout/grid/layout6.png',
						),
                'layout7'    => array(
							'title' => "Layout 7",
							'layout' => 'grid',
                            "demoUrl"  => 'https://www.radiustheme.com/demo/plugins/portfolio/grid-layout/layout-7/',
							'img' => TLPpPro()->assetsUrl . 'images/layout/grid/layout7.png',
						),
                'layout8'    => array(
							'title' => "Layout 8",
							'layout' => 'grid',
                            "demoUrl"  => 'https://www.radiustheme.com/demo/plugins/portfolio/grid-layout/layout-8/',
							'img' => TLPpPro()->assetsUrl . 'images/layout/grid/layout8.png',
						),
                'layout9'    => array(
							'title' => "Layout 9",
							'layout' => 'grid',
                            "demoUrl"  => 'https://www.radiustheme.com/demo/plugins/portfolio/grid-layout/layout-9/',
							'img' => TLPpPro()->assetsUrl . 'images/layout/grid/layout9.png',
						),
                'layout10'   => array(
							'title' => "Layout 10",
							'layout' => 'grid',
                            "demoUrl"  => 'https://www.radiustheme.com/demo/plugins/portfolio/grid-layout/layout-10/',
							'img' => TLPpPro()->assetsUrl . 'images/layout/grid/layout10.png',
						),
                'layout11'   => array(
							'title' => "Layout 11",
							'layout' => 'grid',
                            "demoUrl"  => 'https://www.radiustheme.com/demo/plugins/portfolio/grid-layout/layout-11/',
							'img' => TLPpPro()->assetsUrl . 'images/layout/grid/layout11.png',
						),
                'layout12'   => array(
							'title' => "Layout 12",
							'layout' => 'grid',
                            "demoUrl"  => 'https://www.radiustheme.com/demo/plugins/portfolio/grid-layout/layout-12/',
							'img' => TLPpPro()->assetsUrl . 'images/layout/grid/layout12.png',
						),
                'layout13'   => array(
							'title' => "Layout 13",
							'layout' => 'grid',
                            "demoUrl"  => 'https://www.radiustheme.com/demo/plugins/portfolio/grid-layout/layout-13/',
							'img' => TLPpPro()->assetsUrl . 'images/layout/grid/layout13.png',
						),
                'layout14'   => array(
							'title' => "Layout 14",
							'layout' => 'grid',
                            "demoUrl"  => 'https://www.radiustheme.com/demo/plugins/portfolio/grid-layout/layout-14/',
							'img' => TLPpPro()->assetsUrl . 'images/layout/grid/layout14.png',
						),
                'layout15'   => array(
							'title' => "Layout 15",
							'layout' => 'grid',
                            "demoUrl"  => 'https://www.radiustheme.com/demo/plugins/portfolio/grid-layout/layout-15/',
							'img' => TLPpPro()->assetsUrl . 'images/layout/grid/layout15.png',
						),
                'layout16'   => array(
							'title' => "Layout 16",
							'layout' => 'grid',
                            "demoUrl"  => 'https://www.radiustheme.com/demo/plugins/portfolio/grid-layout/layout-16/',
							'img' => TLPpPro()->assetsUrl . 'images/layout/grid/layout16.png',
						),
                'layout17'   => array(
							'title' => "Layout 17",
							'layout' => 'grid',
                            "demoUrl"  => 'https://www.radiustheme.com/demo/plugins/portfolio/grid-layout/layout-17/',
							'img' => TLPpPro()->assetsUrl . 'images/layout/grid/layout17.png',
						),
                'layout18'   => array(
							'title' => "Layout 18",
							'layout' => 'grid',
                            "demoUrl"  => 'https://www.radiustheme.com/demo/plugins/portfolio/grid-layout/layout-18/',
							'img' => TLPpPro()->assetsUrl . 'images/layout/grid/layout18.png',
						),
                'layout19'   => array(
							'title' => "Layout 19",
							'layout' => 'grid',
                            "demoUrl"  => 'https://www.radiustheme.com/demo/plugins/portfolio/grid-layout/layout-19/',
							'img' => TLPpPro()->assetsUrl . 'images/layout/grid/layout19.png',
						),
                'layout20'   => array(
							'title' => "Layout 20",
							'layout' => 'grid',
                            "demoUrl"  => 'https://www.radiustheme.com/demo/plugins/portfolio/grid-layout/layout-20/',
							'img' => TLPpPro()->assetsUrl . 'images/layout/grid/layout20.png',
						),
                'isotope1'   => array(
							'title' => 'Isotope 1',
							'layout' => 'isotope',
                            "demoUrl"  => 'https://www.radiustheme.com/demo/plugins/portfolio/isotope/layout-1-isotop/',
							'img' => TLPpPro()->assetsUrl . 'images/layout/isotope/isotope1.png',
						),
                'isotope2'   => array(
							'title' => 'Isotope 2',
							'layout' => 'isotope',
                            "demoUrl"  => 'https://www.radiustheme.com/demo/plugins/portfolio/isotope/layout-2-isotope-even/',
							'img' => TLPpPro()->assetsUrl . 'images/layout/isotope/isotope2.png',
						),
                'isotope3'   => array(
							'title' => 'Isotope 3',
							'layout' => 'isotope',
                            "demoUrl"  => 'https://www.radiustheme.com/demo/plugins/portfolio/isotope/layout-3-isotope-even/',
							'img' => TLPpPro()->assetsUrl . 'images/layout/isotope/isotope3.png',
						),
                'isotope4'   => array(
							'title' => 'Isotope 4',
							'layout' => 'isotope',
                            "demoUrl"  => 'https://www.radiustheme.com/demo/plugins/portfolio/isotope/layout-4-isotope-even/',
							'img' => TLPpPro()->assetsUrl . 'images/layout/isotope/isotope4.png',
						),
                'isotope5'   => array(
							'title' => 'Isotope 5',
							'layout' => 'isotope',
                            "demoUrl"  => 'https://www.radiustheme.com/demo/plugins/portfolio/isotope/layout-5-isotope-even/',
							'img' => TLPpPro()->assetsUrl . 'images/layout/isotope/isotope5.png',
						),
                'isotope6'   => array(
							'title' => 'Isotope 6',
							'layout' => 'isotope',
                            "demoUrl"  => 'https://www.radiustheme.com/demo/plugins/portfolio/isotope/layout-6-isotope-even/',
							'img' => TLPpPro()->assetsUrl . 'images/layout/isotope/isotope6.png',
						),
                'isotope7'   => array(
							'title' => 'Isotope 7',
							'layout' => 'isotope',
                            "demoUrl"  => 'https://www.radiustheme.com/demo/plugins/portfolio/isotope/layout-7-isotope-even/',
							'img' => TLPpPro()->assetsUrl . 'images/layout/isotope/isotope7.png',
						),
                'isotope8'   => array(
							'title' => 'Isotope 8',
							'layout' => 'isotope',
                            "demoUrl"  => 'https://www.radiustheme.com/demo/plugins/portfolio/isotope/layout-8-isotope-even/',
							'img' => TLPpPro()->assetsUrl . 'images/layout/isotope/isotope8.png',
						),
                'isotope9'   => array(
							'title' => 'Isotope 9',
							'layout' => 'isotope',
                            "demoUrl"  => 'https://www.radiustheme.com/demo/plugins/portfolio/isotope/layout-9-isotope-even/',
							'img' => TLPpPro()->assetsUrl . 'images/layout/isotope/isotope9.png',
						),
                'isotope10'  => array(
							'title' => 'Isotope 10',
							'layout' => 'isotope',
                            "demoUrl"  => 'https://www.radiustheme.com/demo/plugins/portfolio/isotope/layout-10-isotope-even/',
							'img' => TLPpPro()->assetsUrl . 'images/layout/isotope/isotope10.png',
						),
                'isotope11'  => array(
							'title' => 'Isotope 11',
							'layout' => 'isotope',
                            "demoUrl"  => 'https://www.radiustheme.com/demo/plugins/portfolio/isotope/layout-11-isotope-masonry/',
							'img' => TLPpPro()->assetsUrl . 'images/layout/isotope/isotope11.png',
						),
                'isotope12'  => array(
							'title' => 'Isotope 12',
							'layout' => 'isotope',
                            "demoUrl"  => 'https://www.radiustheme.com/demo/plugins/portfolio/isotope/layout-12-isotope-masonry/',
							'img' => TLPpPro()->assetsUrl . 'images/layout/isotope/isotope12.png',
						),
                'isotope13'  => array(
							'title' => 'Isotope 13',
							'layout' => 'isotope',
                            "demoUrl"  => 'https://www.radiustheme.com/demo/plugins/portfolio/isotope/layout-13-isotope-masonry/',
							'img' => TLPpPro()->assetsUrl . 'images/layout/isotope/isotope13.png',
						),
                'isotope14'  => array(
							'title' => 'Isotope 14',
							'layout' => 'isotope',
                            "demoUrl"  => 'https://www.radiustheme.com/demo/plugins/portfolio/isotope/layout-14-isotope-masonry/',
							'img' => TLPpPro()->assetsUrl . 'images/layout/isotope/isotope14.png',
						),
                'isotope15'  => array(
							'title' => 'Isotope 15',
							'layout' => 'isotope',
                            "demoUrl"  => 'https://www.radiustheme.com/demo/plugins/portfolio/isotope/layout-15-isotope-masonry/',
							'img' => TLPpPro()->assetsUrl . 'images/layout/isotope/isotope15.png',
						),
                'isotope16'  => array(
							'title' => 'Isotope 16',
							'layout' => 'isotope',
                            "demoUrl"  => 'https://www.radiustheme.com/demo/plugins/portfolio/isotope/layout-16-isotope-masonry/',
							'img' => TLPpPro()->assetsUrl . 'images/layout/isotope/isotope16.png',
						),
                'isotope17'  => array(
							'title' => 'Isotope 17',
							'layout' => 'isotope',
                            "demoUrl"  => 'https://www.radiustheme.com/demo/plugins/portfolio/isotope/layout-17-isotope-masonry/',
							'img' => TLPpPro()->assetsUrl . 'images/layout/isotope/isotope17.png',
						),
                'isotope18'  => array(
							'title' => 'Isotope 18',
							'layout' => 'isotope',
                            "demoUrl"  => 'https://www.radiustheme.com/demo/plugins/portfolio/isotope/layout-18-isotope-masonry/',
							'img' => TLPpPro()->assetsUrl . 'images/layout/isotope/isotope18.png',
						),
                'isotope19'  => array(
							'title' => 'Isotope 19',
							'layout' => 'isotope',
                            "demoUrl"  => 'https://www.radiustheme.com/demo/plugins/portfolio/isotope/layout-19-isotope-masonry/',
							'img' => TLPpPro()->assetsUrl . 'images/layout/isotope/isotope19.png',
						),
                'isotope20'  => array(
							'title' => 'Isotope 20',
							'layout' => 'isotope',
                            "demoUrl"  => 'https://www.radiustheme.com/demo/plugins/portfolio/isotope/layout-20-isotope-masonry/',
							'img' => TLPpPro()->assetsUrl . 'images/layout/isotope/isotope20.png',
						),
                'carousel1'  => array(
							'title' => 'Carousel Slider 1',
							'layout' => 'carousel',
                            "demoUrl"  => 'https://www.radiustheme.com/demo/plugins/portfolio/carousel/layout-carousel-slider-01/',
							'img' => TLPpPro()->assetsUrl . 'images/layout/carousel/carousel1.png',
						),
                'carousel2'  => array(
							'title' => 'Carousel Slider 2',
							'layout' => 'carousel',
                            "demoUrl"  => 'https://www.radiustheme.com/demo/plugins/portfolio/carousel/layout-carousel-slider-02/',
							'img' => TLPpPro()->assetsUrl . 'images/layout/carousel/carousel2.png',
						),
                'carousel3'  =>  array(
							'title' => 'Carousel Slider 3',
							'layout' => 'carousel',
                            "demoUrl"  => 'https://www.radiustheme.com/demo/plugins/portfolio/carousel/layout-carousel-slider-03/',
							'img' => TLPpPro()->assetsUrl . 'images/layout/carousel/carousel3.png',
						),
                'carousel4'  =>  array(
							'title' => 'Carousel Slider 4',
							'layout' => 'carousel',
                            "demoUrl"  => 'https://www.radiustheme.com/demo/plugins/portfolio/carousel/layout-carousel-slider-04/',
							'img' => TLPpPro()->assetsUrl . 'images/layout/carousel/carousel4.png',
						),
                'carousel5'  =>  array(
							'title' => 'Carousel Slider 5',
							'layout' => 'carousel',
                            "demoUrl"  => 'https://www.radiustheme.com/demo/plugins/portfolio/carousel/layout-carousel-slider-05/',
							'img' => TLPpPro()->assetsUrl . 'images/layout/carousel/carousel5.png',
						),
                'carousel6'  =>  array(
							'title' => 'Carousel Slider 6',
							'layout' => 'carousel',
                            "demoUrl"  => 'https://www.radiustheme.com/demo/plugins/portfolio/carousel/layout-carousel-slider-06/',
							'img' => TLPpPro()->assetsUrl . 'images/layout/carousel/carousel6.png',
						),
                'carousel7'  =>  array(
							'title' => 'Carousel Slider 7',
							'layout' => 'carousel',
                            "demoUrl"  => 'https://www.radiustheme.com/demo/plugins/portfolio/carousel/layout-carousel-slider-07/',
							'img' => TLPpPro()->assetsUrl . 'images/layout/carousel/carousel7.png',
						),
                'carousel8'  =>  array(
							'title' => 'Carousel Slider 8',
							'layout' => 'carousel',
                            "demoUrl"  => 'https://www.radiustheme.com/demo/plugins/portfolio/carousel/layout-carousel-slider-08/',
							'img' => TLPpPro()->assetsUrl . 'images/layout/carousel/carousel8.png',
						),
                'carousel9'  =>  array(
							'title' => 'Carousel Slider 9',
							'layout' => 'carousel',
                            "demoUrl"  => 'https://www.radiustheme.com/demo/plugins/portfolio/carousel/layout-carousel-slider-09/',
							'img' => TLPpPro()->assetsUrl . 'images/layout/carousel/carousel9.png',
						),
                'carousel10' =>  array(
							'title' => 'Carousel Slider 10',
							'layout' => 'carousel',
                            "demoUrl"  => 'https://www.radiustheme.com/demo/plugins/portfolio/carousel/layout-carousel-slider-10/',
							'img' => TLPpPro()->assetsUrl . 'images/layout/carousel/carousel10.png',
						),
                'carousel11' =>  array(
							'title' => 'Carousel Slider 11',
							'layout' => 'carousel',
                            "demoUrl"  => 'https://www.radiustheme.com/demo/plugins/portfolio/carousel/layout-carousel-slider-11/',
							'img' => TLPpPro()->assetsUrl . 'images/layout/carousel/carousel11.png',
						),
                'carousel12' =>  array(
							'title' => 'Carousel Slider 12',
							'layout' => 'carousel',
                            "demoUrl"  => 'https://www.radiustheme.com/demo/plugins/portfolio/carousel/layout-carousel-slider-12/',
							'img' => TLPpPro()->assetsUrl . 'images/layout/carousel/carousel12.png',
						),
                'carousel13' =>  array(
							'title' => 'Carousel Slider 13',
							'layout' => 'carousel',
                            "demoUrl"  => 'https://www.radiustheme.com/demo/plugins/portfolio/carousel/layout-carousel-slider-13/',
							'img' => TLPpPro()->assetsUrl . 'images/layout/carousel/carousel13.png',
						),
                'carousel14' => array(
							'title' => 'Carousel Slider 14',
							'layout' => 'carousel',
                            "demoUrl"  => 'https://www.radiustheme.com/demo/plugins/portfolio/carousel/layout-carousel-slider-14/',
							'img' => TLPpPro()->assetsUrl . 'images/layout/carousel/carousel14.png',
						),
                'carousel15' => array(
							'title' => 'Carousel Slider 15',
							'layout' => 'carousel',
                            "demoUrl"  => 'https://www.radiustheme.com/demo/plugins/portfolio/carousel/layout-carousel-slider-15/',
							'img' => TLPpPro()->assetsUrl . 'images/layout/carousel/carousel15.png',
						),
                'carousel16' => array(
							'title' => 'Carousel Slider 16',
							'layout' => 'carousel',
                            "demoUrl"  => 'https://www.radiustheme.com/demo/plugins/portfolio/carousel/layout-carousel-slider-16/',
							'img' => TLPpPro()->assetsUrl . 'images/layout/carousel/carousel16.png',
						),
                'carousel17' => array(
							'title' => 'Carousel Slider 17',
							'layout' => 'carousel',
                            "demoUrl"  => 'https://www.radiustheme.com/demo/plugins/portfolio/carousel/layout-carousel-slider-17/',
							'img' => TLPpPro()->assetsUrl . 'images/layout/carousel/carousel17.png',
						),
                'carousel18' => array(
							'title' => 'Carousel Slider 18',
							'layout' => 'carousel',
                            "demoUrl"  => 'https://www.radiustheme.com/demo/plugins/portfolio/carousel/layout-carousel-slider-18/',
							'img' => TLPpPro()->assetsUrl . 'images/layout/carousel/carousel18.png',
						)
            );
        }

        function scGridStyle() {
            return array(
                'even'    => "Even",
                'masonry' => "Masonry"
            );
        }

        function imageCropType() {
            return array(
                'soft' => esc_html__("Soft Crop", 'tlp-portfolio-pro'),
                'hard' => esc_html__("Hard Crop", 'tlp-portfolio-pro')
            );
        }

        function scFontSize() {
            $num = array();
            for ($i = 10; $i <= 30; $i++) {
                $num[$i] = $i . "px";
            }

            return $num;
        }

        function scMarginOpt() {
            return array(
                'default' => "Bootstrap default",
                'no'      => "No Margin"
            );
        }

        function socialLink() {
            return array(
                'facebook' => 'Facebook',
                'twitter'  => 'Twitter',
                'linkedin' => 'LinkedIn'
            );
        }

        function alignment() {
            return array(
                'left'    => "Left",
                'right'   => "Right",
                'center'  => "Center",
                'justify' => "Justify"
            );
        }

        function tlpOverlayBg() {
            return array(
                '0.1' => "10 %",
                '0.2' => "20 %",
                '0.3' => "30 %",
                '0.4' => "40 %",
                '0.5' => "50 %",
                '0.6' => "60 %",
                '0.7' => "70 %",
                '0.8' => "80 %",
                '0.9' => "90 %"
            );
        }

        function owlProperty() {
            return array(
                'loop'               => esc_html__('Loop', 'tlp-portfolio-pro'),
                'autoplay'           => esc_html__('Auto Play', 'tlp-portfolio-pro'),
                'autoplayHoverPause' => esc_html__('Pause on mouse hover', 'tlp-portfolio-pro'),
                'nav'                => esc_html__('Nav Button', 'tlp-portfolio-pro'),
                'dots'               => esc_html__('Pagination', 'tlp-portfolio-pro'),
                'auto_height'        => esc_html__('Auto Height', 'tlp-portfolio-pro'),
                'lazy_load'          => esc_html__('Lazy Load', 'tlp-portfolio-pro'),
                'rtl'                => esc_html__('Right to left (RTL)', 'tlp-portfolio-pro')
            );
        }

        function field() {
            return array(
                'name'              => 'Name',
                'short_description' => 'Short description',
                'client_name'       => 'Client Name',
                'project_url'       => 'Project Url',
                'completed_date'    => 'Completed Date',
                'tools'             => 'Tools',
            );
        }

        function sc_field() {
            $old = $this->field();
            $new = array(
                'categories' => 'Categories',
                'tags'       => 'Tags',
                'zoom'       => 'Image zoom',
            );
            $newField = array_merge($old, $new);

            return $newField;
        }

        function single_page_field() {
            $fields = $this->sc_field();
            unset($fields['zoom']);
            unset($fields['short_description']);
            $newFields = array(
                'description'           => 'Description',
                'social_share'          => 'Social Share',
                'slider'                => 'Slider',
                'exclude_feature_image' => 'Exclude feature image from slider',
                'thumbnail_slider'      => 'Thumbnail Slider',
                'related_project'       => 'Related Project',
            );
            $fields = array_merge($fields, $newFields);

            return $fields;
        }
    }
endif;
