<?php

if (!class_exists('PFProLicence')):

    class PFProLicence {

        function __construct()
        {
            add_action('wp_ajax_rtPfpManageLicencing', array($this, 'rtPfpManageLicencing'));
            add_action('wp_ajax_rtPfp_active_Licence', array($this, 'rtPfp_active_Licence'));
            add_action('admin_init', array($this, 'pfp_licence'));
        }

        function pfp_licence()
        {
            $settings = get_option(TLPpPro()->options['settings']);
            $license = !empty($settings['license_key']) ? sanitize_text_field( trim($settings['license_key']) ) : null;
            new EDD_TLP_PFP_Plugin_Updater(EDD_TLP_PORTFOLIO_PRO_STORE_URL, TLP_PORTFOLIO_PRO_PLUGIN_ACTIVE_FILE_NAME, array(
                'version' => TLP_PORTFOLIO_PRO_VERSION,
                'license' => $license,
                'item_id' => EDD_TLP_PORTFOLIO_PRO_ITEM_ID,
                'author'  => TLP_PORTFOLIO_PRO_AUTHOR,
                'url'     => home_url(),
                'beta'    => false
            ));
        }

        function rtPfp_active_Licence()
        {
            $error = true;
            $html = $message = null;
            if (TLPpPro()->verifyNonce()) {
                $settings = get_option(TLPpPro()->options['settings']);
                $license = !empty($settings['license_key']) ? sanitize_text_field( trim($settings['license_key']) ) : null;
                $api_params = array(
                    'edd_action' => 'activate_license',
                    'license'    => $license,
                    'item_id'    => EDD_TLP_PORTFOLIO_PRO_ITEM_ID,
                    'url'        => home_url()
                );
                $response = wp_remote_post(EDD_TLP_PORTFOLIO_PRO_STORE_URL,
                    array('timeout' => 15, 'sslverify' => false, 'body' => $api_params));
                if (is_wp_error($response) || 200 !== wp_remote_retrieve_response_code($response)) {
                    $err = $response->get_error_message();
                    $message = (is_wp_error($response) && !empty($err)) ? $err : esc_html__('An error occurred, please try again.', "tlp-portfolio-pro");
                } else {
                    $license_data = json_decode(wp_remote_retrieve_body($response));
                    if (false === $license_data->success) {
                        switch ($license_data->error) {
                            case 'expired' :
                                $message = sprintf(
                                    esc_html__('Your license key expired on %s.', "tlp-portfolio-pro"),
                                    date_i18n(get_option('date_format'),
                                        strtotime($license_data->expires, current_time('timestamp')))
                                );
                                break;
                            case 'revoked' :
                                $message = esc_html__('Your license key has been disabled.', "tlp-portfolio-pro");
                                break;
                            case 'missing' :
                                $message = esc_html__('Invalid license.', "tlp-portfolio-pro");
                                break;
                            case 'invalid' :
                            case 'site_inactive' :
                                $message = esc_html__('Your license is not active for this URL.', "tlp-portfolio-pro");
                                break;
                            case 'item_name_mismatch' :
                                $message = sprintf(esc_html__('This appears to be an invalid license key for %s.', "tlp-portfolio-pro"),
                                    EDD_TLP_PORTFOLIO_PRO_ITEM_NAME);
                                break;
                            case 'no_activations_left':
                                $message = esc_html__('Your license key has reached its activation limit.', "tlp-portfolio-pro");
                                break;
                            default :
                                $message = esc_html__('An error occurred, please try again.', "tlp-portfolio-pro");
                                break;
                        }
                    }
                    // Check if anything passed on a message constituting a failure
                    if (empty($message)) {
                        $settings['license_status'] = $license_data->license;
                        update_option(TLPpPro()->options['settings'], $settings);
                        $error = false;
                        $message = esc_html__('Successfully activated', 'the-post-grid-pro');
                    }
                    $html = ($license_data->license === 'valid') ? "<input type='submit' class='button-secondary rt-licensing-btn danger' name='license_deactivate' value='".esc_html__("Deactivate License", "tlp-portfolio-pro")."'/>"
                        : "<input type='submit' class='button-secondary rt-licensing-btn button-primary' name='license_activate' value='".esc_html__("Activate License", "tlp-portfolio-pro")."'/>";
                }
            } else {
                $message = esc_html__('Session Error !!', 'the-post-grid-pro');
            }
            $response = array(
                'error' => $error,
                'msg'   => $message,
                'html'  => $html,
            );
            wp_send_json($response);
            die();
        }

        function rtPfpManageLicencing()
        {
            $error = true;
            $name = $value = $data = $class = $message = null;
            if (TLPpPro()->verifyNonce()) {
                $settings = get_option(TLPpPro()->options['settings']);
                $license = !empty($settings['license_key']) ? trim($settings['license_key']) : null;
                $request_type = sanitize_text_field( $_REQUEST['type'] );
                if (!empty( $request_type ) && $request_type == "license_activate") {

                    $api_params = array(
                        'edd_action' => 'activate_license',
                        'license'    => $license,
                        'item_id'    => EDD_TLP_PORTFOLIO_PRO_ITEM_ID,
                        'url'        => home_url()
                    );
                    $response = wp_remote_post(EDD_TLP_PORTFOLIO_PRO_STORE_URL,
                        array('timeout' => 15, 'sslverify' => false, 'body' => $api_params));
                    if (is_wp_error($response) || 200 !== wp_remote_retrieve_response_code($response)) {
                        $err = $response->get_error_message();
                        $message = (is_wp_error($response) && !empty($err)) ? $err : esc_html__('An error occurred, please try again.', "tlp-portfolio-pro");
                    } else {
                        $license_data = json_decode(wp_remote_retrieve_body($response));
                        if (false === $license_data->success) {
                            switch ($license_data->error) {
                                case 'expired' :
                                    $message = sprintf(
                                        esc_html__('Your license key expired on %s.', "tlp-portfolio-pro"),
                                        date_i18n(get_option('date_format'),
                                            strtotime($license_data->expires, current_time('timestamp')))
                                    );
                                    break;
                                case 'revoked' :
                                    $message = esc_html__('Your license key has been disabled.', "tlp-portfolio-pro");
                                    break;
                                case 'missing' :
                                    $message = esc_html__('Invalid license.', "tlp-portfolio-pro");
                                    break;
                                case 'invalid' :
                                case 'site_inactive' :
                                    $message = esc_html__('Your license is not active for this URL.', "tlp-portfolio-pro");
                                    break;
                                case 'item_name_mismatch' :
                                    $message = sprintf(esc_html__('This appears to be an invalid license key for %s.', "tlp-portfolio-pro"),
                                        EDD_TLP_PORTFOLIO_PRO_ITEM_NAME);
                                    break;
                                case 'no_activations_left':
                                    $message = esc_html__('Your license key has reached its activation limit.', "tlp-portfolio-pro");
                                    break;
                                default :
                                    $message = esc_html__('An error occurred, please try again.', "tlp-portfolio-pro");
                                    break;
                            }
                        }
                        // Check if anything passed on a message constituting a failure
                        if (empty($message)) {
                            $settings['license_status'] = $license_data->license;
                            update_option(TLPpPro()->options['settings'], $settings);
                            $error = false;
                            $name = 'license_deactivate';
                            $value = 'Deactivate License';
                            $class = 'button-primary';
                        }
                    }
                }
                if (!empty( $request_type ) && $request_type == "license_deactivate") {
                    $api_params = array(
                        'edd_action' => 'deactivate_license',
                        'license'    => $license,
                        'item_id'    => EDD_TLP_PORTFOLIO_PRO_ITEM_ID,
                        'url'        => home_url()
                    );
                    $response = wp_remote_post(EDD_TLP_PORTFOLIO_PRO_STORE_URL,
                        array('timeout' => 15, 'sslverify' => false, 'body' => $api_params));

                    // Make sure there are no errors
                    if (is_wp_error($response) || 200 !== wp_remote_retrieve_response_code($response)) {
                        $err = $response->get_error_message();
                        $message = (is_wp_error($response) && !empty($err)) ? $err : esc_html__('An error occurred, please try again.', "tlp-portfolio-pro");
                    } else {
                        unset($settings['license_status']);
                        update_option(TLPpPro()->options['settings'], $settings);
                        $error = false;
                        $name = 'license_activate';
                        $value = 'Activate License';
                        $class = 'button-primary';
                    }
                }
            } else {
                $message = esc_html__('Something went wrong !!', 'tlp-team-pro');
            }
            $data = $_REQUEST;
            $response = array(
                'error' => $error,
                'msg'   => $message,
                'name'  => $name,
                'value' => $value,
                'class' => $class,
                'data'  => $data
            );
            wp_send_json($response);
            die();
        }
    }

endif;