<?php
if ( ! class_exists( 'PFProFrontEnd' ) ) :

	class PFProFrontEnd {

		function __construct() {
			add_action( 'wp_enqueue_scripts', array( $this, 'tlp_front_end' ) );
			add_action( 'wp_ajax_tlpPFPSingleItem', array( $this, 'tlpPFPSingleItem' ) );
			add_action( 'wp_ajax_nopriv_tlpPFPSingleItem', array( $this, 'tlpPFPSingleItem' ) );
		}

		public function tlpPFPSingleItem() {
			$html    = null;
			$success = false;
			$error   = true;
			if ( TLPpPro()->verifyNonce() ) {
				$req_id = absint( $_REQUEST['id'] ) ; 
				if ( $req_id ) {
					$settings = get_option( TLPpPro()->options['settings'] );
					$field    = ( ! empty( $settings['field'] ) ? TLPpPro()->array_text_sanitization( $settings['field'] ) : array() );
					
					global $post;
					$post    = get_post( $req_id );
					setup_postdata($post);
					$content = apply_filters( 'the_content', get_the_content() );
					$title = get_the_title();
					$html .= "<div class='pfp-container pfp-portfolio-detail'>";
						$html .= "<div class='pfp-row'>";
							$html .= "<div class='pfp-col-lg-12 pfp-col-md-12 pfp-col-sm-12 pfp-col-xs-12'>";
								if ( in_array( 'name', $field ) ) {
									$html .= "<h2 class='portfolio-title'>{$title}</h2>";
								}
								$html .= TLPpPro()->pfpGallery( $post->ID );
							$html .= '</div>';
							$html .= '<div class="portfolio-detail-desc pfp-col-lg-12 pfp-col-md-12 pfp-col-sm-12 pfp-col-xs-12 padding0">';
								$html .= "<div class='pfp-col-lg-8 pfp-col-md-8 pfp-col-sm-6 pfp-col-xs-12'>";
									if ( in_array( 'description', $field ) ) {
										$html .="<div class='portfolio-details'>{$content}</div>";
									}
									if ( in_array( 'social_share', $field ) ) {
										$html .= TLPpPro()->socialShare( get_permalink( $post->ID ) );
									}
								$html .= "</div>";
								$html .= '<div class="pfp-col-lg-4 pfp-col-md-4 pfp-col-sm-6 pfp-col-xs-12">';
									$html .= TLPpPro()->singleMeta( $post->ID );
								$html .= '</div>';
							$html .= '</div>';
						if ( in_array( 'related_project', $field ) ) {
							$html .= TLPpPro()->relatedProject( $post->ID );
						}
						$html .= "</div>"; // row
					$html .= "</div>"; // container
					$html .= "<script>(function($){ pfpGalleryRender();})(jQuery)</script>";
					$success = true;
				} else {
					$html .= "<p>" . __( "No item id found", 'tlp-portfolio-pro' ) . "</p>";
					$error = true;
				}
			} else {
				$error = true;
				$html .= "<p>" . __( 'Something went wrong !!', 'tlp-portfolio-pro' ) . "</p>";
			}

			wp_send_json(
				array(
					'data'    => $html,
					'error'   => $error,
					'success' => $success
				)
			);
			die();
		}

		function tlp_front_end() {
			wp_enqueue_style( 'pfp' );
			wp_enqueue_style( 'pfp-lightbox' );
			wp_enqueue_script( 'pfp-lightbox' );
			$upload_dir = wp_upload_dir(); 
            $cssFile = $upload_dir['basedir'] . '/tlp-portfolio/portfolio-sc.css'; 
			if( file_exists( $cssFile ) ){
				$version = filemtime( $cssFile ) ;
				wp_enqueue_style( 'portfolio-sc', set_url_scheme( $upload_dir['baseurl'] ) . '/tlp-portfolio/portfolio-sc.css' , '' , $version );
			}
			$settings = get_option( TLPpPro()->options['settings'] );
			if ( !empty($settings['custom_css']) ) {
				wp_add_inline_style('pfp', wp_specialchars_decode($settings['custom_css']));
			}
		}

	}
endif;
