<?php

if ( ! class_exists( 'PFPPreview' ) ):

	class PFPPreview {

		function __construct() {
			add_action( 'wp_ajax_pfpPreviewAjaxCall', array( $this, 'pfpPreviewAjaxCall' ) );
			add_action( 'wp_ajax_pfpLoadMorePreview', array( $this, 'pfpLoadMorePreview' ) );
		}

		function pfpPreviewAjaxCall() {
			$msg   = $html = $scID = null;
			$error = true;
			if ( TLPpPro()->verifyNonce() ) {
				$error    = false;
				$scMeta   = $_REQUEST;
				$rand     = mt_rand();
				$layoutID = "pfp-container-" . $rand;
				$layout = ( ! empty( $scMeta['pfp_layout'] ) ? sanitize_text_field($scMeta['pfp_layout']) : 'layout1' );
				if ( ! in_array( $layout, array_keys( TLPpPro()->scLayout() ) ) ) {
					$layout = 'layout1';
				}
				$dCol = ( isset( $scMeta['pfp_desktop_column'] ) ? absint( $scMeta['pfp_desktop_column'] ) : 3 );
				$tCol = ( isset( $scMeta['pfp_tab_column'] ) ? absint( $scMeta['pfp_tab_column'] ) : 2 );
				$mCol = ( isset( $scMeta['pfp_mobile_column'] ) ? absint( $scMeta['pfp_mobile_column'] ) : 1 );
				if ( ! in_array( $dCol, array_keys( TLPpPro()->scColumns() ) ) ) {
					$dCol = 3;
				}
				if ( ! in_array( $tCol, array_keys( TLPpPro()->scColumns() ) ) ) {
					$tCol = 2;
				}
				if ( ! in_array( $dCol, array_keys( TLPpPro()->scColumns() ) ) ) {
					$mCol = 1;
				}

				$dColItems          = absint( $dCol );
				$tColItems          = absint( $tCol );
				$mColItems          = absint( $mCol );

				$customImgSize = isset( $scMeta['pfp_custom_image_size'] ) ? TLPpPro()->array_text_sanitization( $scMeta['pfp_custom_image_size'] ) : array() ;
				$imgSize       = ( ! empty( $scMeta['pfp_image_size'] ) ? sanitize_text_field($scMeta['pfp_image_size']) : "medium" );

				$excerpt_limit = ( ! empty( $scMeta['pfp_excerpt_limit'] ) ? absint( $scMeta['pfp_excerpt_limit'] ) : 0 );

				if ( $layout == 'layout2' || $layout == 'isotope20' ) {
					$image_area   = "pfp-col-md-5 pfp-col-sm-12";
					$content_area = "pfp-col-md-7 pfp-col-sm-12";
				}else{
					$image_area   = "";
					$content_area = "";
				}

				$isIsotope  = preg_match( '/isotope/', $layout );
				$isCarousel = preg_match( '/carousel/', $layout );

				/* Argument create */
				$containerDataAttr = false;
				$args              = array();
				$args['post_type'] = TLPpPro()->post_type;
				// Common filter
				/* post__in */
				$post__in = ( isset( $scMeta['pfp_post__in'] ) ? sanitize_text_field( $scMeta['pfp_post__in'] ) : null );
				
				if ( $post__in ) {
					$post__in         = explode( ',', $post__in );
					$args['post__in'] = $post__in;
				}
				/* post__not_in */
				$post__not_in = ( isset( $scMeta['pfp_post__not_in'] ) ? sanitize_text_field( $scMeta['pfp_post__not_in'] ) : null );
				
				if ( $post__not_in ) {
					$post__not_in         = explode( ',', $post__not_in );
					$args['post__not_in'] = $post__not_in;
				}
				/* LIMIT */
				$limit                  = ( ( empty( $scMeta['pfp_limit'] ) || $scMeta['pfp_limit'] === '-1' ) ? 10000000 : absint($scMeta['pfp_limit'] ) );

				$args['posts_per_page'] = $limit;
				$pagination             = ( ! empty( $scMeta['pfp_pagination'] ) ? true : false );
				$posts_loading_type     = ( ! empty( $scMeta['pfp_pagination_type'] ) ? sanitize_text_field( $scMeta['pfp_pagination_type'] ) : "pagination" );
				
				if ( $pagination ) {
					$posts_per_page = ( isset( $scMeta['pfp_posts_per_page'] ) ? intval( $scMeta['pfp_posts_per_page'] ) : $limit );
					if ( $posts_per_page > $limit ) {
						$posts_per_page = $limit;
					}
					// Set 'posts_per_page' parameter
					$args['posts_per_page'] = $posts_per_page;

					$paged = ( get_query_var( 'paged' ) ) ? get_query_var( 'paged' ) : 1;

					$offset        = $posts_per_page * ( (int) $paged - 1 );
					$args['paged'] = $paged;

					// Update posts_per_page
					if ( intval( $args['posts_per_page'] ) > $limit - $offset ) {
						$args['posts_per_page'] = $limit - $offset;
					}

				}
				if ( $isCarousel ) {
					$args['posts_per_page'] = $limit;
				}
				$itemIdsArgs = array();
				// Taxonomy
				$cats  = ( isset( $scMeta['pfp_categories'] ) ? TLPpPro()->array_int_sanitization( $scMeta['pfp_categories'] ) : array() );
				$tags  = ( isset( $scMeta['pfp_tags'] ) ? TLPpPro()->array_int_sanitization( $scMeta['pfp_tags'] ) : array() );
				$tools = ( isset( $scMeta['pfp_tools'] ) ? TLPpPro()->array_int_sanitization( $scMeta['pfp_tools'] ) : array() );

				
				$taxQ  = array();
				if ( is_array( $cats ) && ! empty( $cats ) ) {
					$taxQ[] = array(
						'taxonomy' => TLPpPro()->taxonomies['category'],
						'field'    => 'term_id',
						'terms'    => $cats,
					);
				}
				if ( is_array( $tags ) && ! empty( $tags ) ) {
					$taxQ[] = array(
						'taxonomy' => TLPpPro()->taxonomies['tag'],
						'field'    => 'term_id',
						'terms'    => $tags,
					);
				}
				if ( is_array( $tools ) && ! empty( $tools ) ) {
					$taxQ[] = array(
						'taxonomy' => TLPpPro()->taxonomies['tool'],
						'field'    => 'term_id',
						'terms'    => $tools,
					);
				}
				if ( ! empty( $taxQ ) ) {
					$args['tax_query'] = $itemIdsArgs['tax_query'] = $taxQ;
					if ( count( $taxQ ) > 1 ) {
						$taxQ['relation'] = $itemIdsArgs['relation'] = ! empty( $scMeta['pfp_taxonomy_relation'] ) ? sanitize_text_field( $scMeta['pfp_taxonomy_relation'] ) : "AND";
					}
				}
				
				// Order
				$order_by = ( isset( $scMeta['pfp_order_by'] ) ? sanitize_text_field( $scMeta['pfp_order_by'] ) : null );
				$order    = ( isset( $scMeta['pfp_order'] ) ? sanitize_text_field( $scMeta['pfp_order'] ) : null );
				if ( $order ) {
					$args['order'] = $itemIdsArgs['order'] = $order;
				}
				if ( $order_by ) {
					$args['orderby'] = $itemIdsArgs['orderby'] = $order_by;
				}


				// Validation
				$containerDataAttr .= " data-layout='{$layout}' data-desktop-col='{$dCol}'  data-tab-col='{$tCol}'  data-mobile-col='{$mCol}'";
				$dCol = round( 12 / $dCol );
				$tCol = round( 12 / $tCol );
				$mCol = round( 12 / $mCol );
				if ( $isCarousel ) {
					$dCol = $tCol = $mCol = 12;
				}
				$gridExtra        = null;
				$arg              = array();
				$arg['grid']      = "pfp-col-md-{$dCol} pfp-col-sm-{$tCol} pfp-col-xs-{$mCol}";
				$gridType         = ! empty( $scMeta['pfp_grid_style'] ) ? sanitize_text_field( $scMeta['pfp_grid_style'] ) : 'even';
				$arg['class']     = $gridType . "-grid-item";
				$arg['class'] .= " pfp-grid-item";
				$preLoader = null;
				if ( $isIsotope ) {
					$arg['class'] .= ' isotope-item';
					$preLoader = 'pfp-pre-loader';
				}
				if ( $isCarousel ) {
					$arg['class'] .= ' pfp-carousel-item';
					$preLoader = 'pfp-pre-loader';
				}
				$masonryG = null;
				if ( $gridType == "even" ) {
					$masonryG = " pfp-even";
					$arg['class'] .= ' even-grid-item';
				} else if ( $gridType == "masonry" && ! $isIsotope && ! $isCarousel ) {
					$masonryG = " pfp-masonry";
					$arg['class'] .= ' masonry-grid-item';
				}
				$image_shape = ! empty( $scMeta['pfp_image_shape'] ) ? sanitize_text_field( $scMeta['pfp_image_shape'] ) : null;
				if ( $image_shape == 'circle' ) {
					$arg['class'] .= ' pfp-img-circle';
				}

				$margin = ! empty( $scMeta['pfp_margin'] ) ? sanitize_text_field($scMeta['pfp_margin']) : 'default';
				if ( $margin == 'no' ) {
					$arg['class'] .= ' no-margin';
				} else {
					$arg['class'] .= ' default-margin';
				}

				$image_shape = ! empty( $scMeta['pfp_image_shape'] ) ? sanitize_text_field( $scMeta['pfp_image_shape'] ) : null;
				if ( $image_shape == 'circle' ) {
					$arg['class'] .= ' pfp-img-circle';
				}

				$arg['items']       = ! empty( $scMeta['pfp_item_fields'] ) ? TLPpPro()->array_text_sanitization($scMeta['pfp_item_fields']) : array();

				$arg['anchorClass'] = null;
				$link               = ! empty( $scMeta['pfp_detail_page_link'] ) ? true : false;
				$arg['link']        = $arg['link_type'] = $arg['link_target'] = false;
				if ( $link ) {

					$link_type = $arg['link_type'] = ! empty( $scMeta['pfp_detail_page_link_type'] ) ? sanitize_text_field( $scMeta['pfp_detail_page_link_type'] ) : 'popup';

					if ( $link_type == "popup" ) {
						$arg['anchorClass'] .= ' pfp-popup tlp-single-item-popup';
					} else if ( $link_type == "external_link" ) {
						$arg['link_target'] = ! empty( $scMeta['pfp_link_target'] ) ? sanitize_text_field( $scMeta['pfp_link_target'] ) : '_blank';
					}
					$arg['link']      = true;
					
				} else {
					$arg['anchorClass'] .= ' pfp-disable';
				}

				$parentClass  = ( ! empty( $scMeta['pfp_parent_class'] ) ? sanitize_text_field(trim( $scMeta['pfp_parent_class'] ) ) : null );

				$itemIdsArgs['post_type'] = $args['post_type'];
				$args['post_status']      = $itemIdsArgs['post_status'] = 'publish';
				$arg['zoomId'] = $layout;
				$itemIdsQ = new WP_Query( $itemIdsArgs );
				$itemIds  = array();
				if ( $itemIdsQ->have_posts() ) {
					while ( $itemIdsQ->have_posts() ) {
						$itemIdsQ->the_post();
						$itemIds[] = get_the_ID();
					}
				}
				wp_reset_postdata();
				$args['preview'] = true;
				// Start layout
				$html .= $this->layoutStyle( $layoutID, $scMeta );
				$html .= "<div class='pfp-container-fluid pfp-wrapper {$parentClass}' id='{$layoutID}' {$containerDataAttr}>";
				$html .= "<div class='pfp-row pfp-{$layout}{$masonryG} {$preLoader}'>";
				$portQuery = new WP_Query( $args );

				if ( $portQuery->have_posts() ) {
					if ( $isIsotope ) {
						if(function_exists('get_term_meta')){
							$terms = get_terms( array(
								'taxonomy'   => TLPpPro()->taxonomies['category'],
								'hide_empty' => false,
								'orderby'    => 'meta_value_num',
								'order'      => 'ASC',
								'meta_key'   => '_order'
							) );
						}else{
							$terms = get_terms( TLPpPro()->taxonomies['category'], array('hide_empty' => false) );
						}

						$html .= '<div class="pfp-iso-filter"><div id="iso-button-' . $rand . '" class="pfp-isotope-buttons button-group filter-button-group option-set">';
						$htmlButton     = null;
						$fSelectTrigger = false;

                        if ( ! empty( $terms ) && ! is_wp_error( $terms ) ) {
                            $tItem   = ! empty( $scMeta['pfp_isotope_selected_filter'] ) ? absint($scMeta['pfp_isotope_selected_filter'] ) : null;

                            foreach ( $terms as $term ) {
                                $fSelect = null;
                                if ( $tItem == $term->term_id ) {
                                    $fSelect        = 'selected';
                                    $fSelectTrigger = true;
                                }
                                if ( is_array( $cats ) && ! empty( $cats ) ) {
                                    if ( in_array( $term->term_id, $cats ) ) {
                                        $htmlButton .= "<button data-filter-counter='' class='iso-button-{$term->term_id} {$fSelect}' data-filter='.iso_{$term->term_id}'>" . $term->name . "</button>";
                                    }
                                }else{
                                    $htmlButton .= "<button data-filter-counter='' class='iso-button-{$term->term_id} {$fSelect}' data-filter='.iso_{$term->term_id}'>" . $term->name . "</button>";
                                }
                            }
                        }
						if ( empty( $scMeta['pfp_isotope_filter_show_all'] ) ) {
							$fSelect = ( $fSelectTrigger ? null : 'class="selected"' );
							$html .= "<button data-filter='*' {$fSelect}>" . __( 'Show all',
									'tlp-portfolio-pro' ) . "</button>";
						}
						$html .= $htmlButton;
						$html .= '</div>';
						if ( ! empty( $scMeta['pfp_isotope_search_filtering'] ) ) {
							$html .= "<div class='iso-search'><input type='text' class='iso-search-input' placeholder='" . __( 'Search',
									'tlp-portfolio-pro' ) . "' /></div>";
						}
						$html .= '</div>';

						$html .= '<div class="pfp-isotope" id="pfp-isotope-' . $rand . '">';
					} elseif ( $isCarousel ) {
						// $scMeta['pfp_carousel_items_per_slider'] the metafield only for old (v-2.9.0) version support. 
						$items              = ! empty( $scMeta['pfp_carousel_items_per_slider'] ) ? absint( $scMeta['pfp_carousel_items_per_slider'] ) : $dColItems  ;
						$smartSpeed         = ! empty( $scMeta['pfp_carousel_speed'] ) ? absint( $scMeta['pfp_carousel_speed'] ) : 250;
						$autoplayTimeout    = ! empty( $scMeta['pfp_carousel_autoplay_timeout'] ) ? absint( $scMeta['pfp_carousel_autoplay_timeout'] ) : 5000;
						$cOpt               = ! empty( $scMeta['pfp_carousel_options'] ) ? TLPpPro()->array_text_sanitization( $scMeta['pfp_carousel_options'] ) : array();
						$autoPlay           = ( in_array( 'autoplay', $cOpt ) ? 'true' : 'false' );
						$autoPlayHoverPause = ( in_array( 'autoplayHoverPause', $cOpt ) ? 'true' : 'false' );
						$nav                = ( in_array( 'nav', $cOpt ) ? 'true' : 'false' );
						$dots               = ( in_array( 'dots', $cOpt ) ? 'true' : 'false' );
						$loop               = ( in_array( 'loop', $cOpt ) ? 'true' : 'false' );
						$lazyLoad           = ( in_array( 'lazy_load', $cOpt ) ? 'true' : 'false' );
						$autoHeight         = ( in_array( 'auto_height', $cOpt ) ? 'true' : 'false' );
						$rtl                = ( in_array( 'rtl', $cOpt ) ? 'true' : 'false' );

						$html .= "<div class='pfp-carousel owl-carousel owl-theme' 
									data-loop='{$loop}'
									data-items='{$items}'
									data-tabcolumn='{$tColItems}'
									data-mobilecolumn='{$mColItems}'
									data-autoplay='{$autoPlay}'
									data-autoplay-timeout='{$autoplayTimeout}'
									data-autoplay-hover-pause='{$autoPlayHoverPause}'
									data-dots='{$dots}'
									data-nav='{$nav}'
									data-lazyload='{$lazyLoad}'
									data-autoheight='{$autoHeight}'
									data-rtl='{$rtl}'
									data-smapfpspeed='{$smartSpeed}'
									>";
					}

					while ( $portQuery->have_posts() ) : $portQuery->the_post();
						$iID                   = get_the_ID();
						$arg['iID']            = $iID;
						$arg['image_area'] 		= $image_area;
						$arg['content_area'] 	= $content_area;
						$arg['title']          = get_the_title();
						$arg['client_name']    = get_post_meta( $iID, 'client_name', true );
						$arg['completed_date'] = get_post_meta( $iID, 'completed_date', true );
						$arg['short_desc']     = get_post_meta( $iID, 'short_description', true );
						$arg['short_desc']     = TLPpPro()->strip_tags_content($arg['short_desc'], $excerpt_limit);
						$arg['project_url']    = get_post_meta( $iID, 'project_url', true );
						$arg['external_url']    = get_post_meta( $iID, 'external_url', true );
						$arg['tools']          = strip_tags( get_the_term_list( $iID, TLPpPro()->taxonomies['tool'],
							null, ' | ' ) );
						$arg['categories']     = strip_tags( get_the_term_list( $iID,
							TLPpPro()->taxonomies['category'], null, ', ' ) );
						$arg['tags']           = strip_tags( get_the_term_list( $iID, TLPpPro()->taxonomies['tag'],
							null, ', ' ) );
						$arg['pLink']          = get_permalink();
						if($arg['link_type'] == "external_link" && $arg['external_url']){
							$arg['pLink'] = $arg['external_url'];
						}
						$imgUrl                = wp_get_attachment_image_src( get_post_thumbnail_id( $iID ), 'full' );;
						$arg['img_full_url'] = ( ! empty( $imgUrl ) ? $imgUrl[0] : null );
						$excerpt             = get_the_excerpt();
						$arg['excerpt']      = TLPpPro()->strip_tags_content( $excerpt, $excerpt_limit );
						if ( $isIsotope ) {
							$termAs    = wp_get_post_terms( $iID, TLPpPro()->taxonomies['category'],
								array( "fields" => "all" ) );
							$isoFilter = null;
							if ( ! empty( $termAs ) ) {
								foreach ( $termAs as $term ) {
									$isoFilter .= " " . "iso_" . $term->term_id;
									$isoFilter .= " " . $term->slug;
								}
							}
							$arg['isoFilter'] = $isoFilter;
						}
						$arg['img'] = TLPpPro()->getFeatureImage( $iID, $imgSize, $customImgSize );
						$html .= TLPpPro()->render( 'layouts/' . $layout, $arg );

					endwhile;

					if ( $isIsotope || $isCarousel ) {
						$html .= '</div>'; // End isotope / Carousel item holder
					}
				} else {
					$html .= "<p>" . esc_html__( "No portfolio found", 'tlp-portfolio-pro' ) . "</p>";
				}

				$html .= "</div>"; // End row

				if ( $pagination && ! $isCarousel ) {
					$htmlUtility = null;
					$postPp     = $portQuery->query_vars['posts_per_page'];
					$page       = $portQuery->query_vars['paged'];
					$foundPosts = $portQuery->found_posts;
					$totalPage  = $portQuery->max_num_pages;
					$morePosts  = absint( $foundPosts - ( $postPp * $page ) );
					if ( $posts_loading_type == "pagination" ) {
						$htmlUtility .= TLPpPro()->pagination( $portQuery->max_num_pages, $args['posts_per_page'] );
					} elseif ( $posts_loading_type == "pagination_ajax" && ! $isIsotope ) {
						$htmlUtility .= TLPpPro()->pagination( $portQuery->max_num_pages, $args['posts_per_page'], true,
							$scID );
					} elseif ( $posts_loading_type == "load_more" ) {
						
						$noMorePostText = esc_html__("No More Post to load", 'tlp-portfolio-pro');
						$loadMoreText   = ! empty( $scMeta['pfp_load_more_button_text'] ) ? esc_html( $scMeta['pfp_load_more_button_text']) : esc_html__( "Load More", 'tlp-portfolio-pro' );
						$loadingText = esc_html__( 'Loading ...', 'tlp-portfolio-pro' );
						$htmlUtility .= "<div class='pfp-load-more'> 
                                        <button data-sc-id='{$scID}' data-total-pages='{$totalPage}' data-posts-per-page='{$postPp}' data-found-posts='{$foundPosts}' data-paged='1'
                                        data-no-more-post-text='{$noMorePostText}' data-loading-text='{$loadingText}'>{$loadMoreText} <span>({$morePosts})</span></button>
                                    </div>";
					} elseif ( $posts_loading_type == "load_on_scroll" ) {
						$htmlUtility .= "<div class='pfp-scroll-load-more' data-limit='{$limit}' data-found-posts='{$foundPosts}'  data-trigger='1'  data-total-pages='{$totalPage}'  data-sc-id='{$scID}'  data-posts-per-page='{$postPp}' data-paged='1'></div>";
					}

					if ( $htmlUtility ) {
						$html .= "<div class='pfp-utility'>" . $htmlUtility . "</div>";
					}

				}

				$html .= "</div>"; // pfp-container pfpfmp
				wp_reset_postdata();

			} else {
				$msg = __( 'Something went wrong !!', 'tlp-portfolio-pro' );
			}

			wp_send_json( array(
				'error' => $error,
				'msg'   => $msg,
				'data'  => $html
			) );

		}

		function pfpLoadMorePreview() {
			$error = true;
			$msg   = $data = null;
			if ( TLPpPro()->verifyNonce() ) {
				$scMeta = $_REQUEST;
				$foundPosts = isset( $_REQUEST['foundPosts'] ) ? absint( $_REQUEST['foundPosts'] ) : null ;
				$layout        = ( ! empty( $scMeta['pfp_layout'] ) ? sanitize_text_field( $scMeta['pfp_layout'] ) : 'layout1' );
				if ( ! in_array( $layout, array_keys( TLPpPro()->scLayout() ) ) ) {
					$layout = 'layout1';
				}
				$dCol = ( isset( $scMeta['pfp_desktop_column'] ) ? absint( $scMeta['pfp_desktop_column'] ) : 3 );
				$tCol = ( isset( $scMeta['pfp_tab_column'] ) ? absint( $scMeta['pfp_tab_column'] ) : 2 );
				$mCol = ( isset( $scMeta['pfp_mobile_column'] ) ? absint( $scMeta['pfp_mobile_column'] ) : 1 );
				if ( ! in_array( $dCol, array_keys( TLPpPro()->scColumns() ) ) ) {
					$dCol = 3;
				}if ( ! in_array( $tCol, array_keys( TLPpPro()->scColumns() ) ) ) {
					$tCol = 2;
				}if ( ! in_array( $dCol, array_keys( TLPpPro()->scColumns() ) ) ) {
					$mCol = 1;
				}

				$dColItems          = absint( $dCol );
				$tColItems          = absint( $tCol );
				$mColItems          = absint( $mCol );

				$customImgSize = ( ! empty( $scMeta['pfp_custom_image_size'] ) ? TLPpPro()->array_text_sanitization( $scMeta['pfp_custom_image_size'] ) : array() );
				
				$imgSize       = ( ! empty( $scMeta['pfp_image_size'] ) ? sanitize_text_field( $scMeta['pfp_image_size'] ) : "medium" );
				$excerpt_limit = ( ! empty( $scMeta['pfp_excerpt_limit'] ) ? absint( $scMeta['pfp_excerpt_limit'] ) : 0 );

				if ( $layout == 'layout2' || $layout == 'isotope20' ) {
					$arg['image_area']   = "pfp-col-md-5 pfp-col-sm-12";
					$arg['content_area'] = "pfp-col-md-7 pfp-col-sm-12";
				}else{
					$arg['image_area']   = "";
					$arg['content_area'] = "";
				}

				$isIsotope  = preg_match( '/isotope/', $layout );
				$isCarousel = preg_match( '/carousel/', $layout );

				/* Argument create */
				$containerDataAttr           = false;
				$args              = array();
				$args['preview'] = true;
				$args['post_type'] = TLPpPro()->post_type;
				// Common filter
				/* post__in */
				$post__in = ( isset( $scMeta['pfp_post__in'] ) ? sanitize_text_field( $scMeta['pfp_post__in'] )  : null );
				if ( $post__in ) {
					$post__in         = explode( ',', $post__in );
					$args['post__in'] = $post__in;
				}
				
				/* post__not_in */
				$post__not_in = ( isset( $scMeta['pfp_post__not_in'] ) ? sanitize_text_field( $scMeta['pfp_post__not_in'] ) : null );
				if ( $post__not_in ) {
					$post__not_in         = explode( ',', $post__not_in );
					$args['post__not_in'] = $post__not_in;
				}

				$loaded_post_ids = sanitize_text_field( $_REQUEST['loaded_post_ids'] ) ; 

				$loaded_posts = !empty( $loaded_post_ids ) ? explode(',', $loaded_post_ids ) : array();
				if (!empty($loaded_posts)) {
					$args['post__not_in'] = is_array($post__not_in) && !empty($post__not_in) ? array_merge($post__not_in, $loaded_posts) : $loaded_posts;
				}
				/* LIMIT */
				$limit                  = ( ( empty( $scMeta['pfp_limit'] ) || $scMeta['pfp_limit'] === '-1' ) ? 10000000 : absint( $scMeta['pfp_limit'] ) );
				$args['posts_per_page'] = $limit;
				// $args['paged'] = 1;
				$pagination             = ( ! empty( $scMeta['pfp_pagination'] ) ? true : false );

				if ( $pagination ) {
					$posts_per_page = ( isset( $scMeta['pfp_posts_per_page'] ) ? absint( $scMeta['pfp_posts_per_page'] ) : $limit );
					if ( $posts_per_page > $limit ) {
						$posts_per_page = $limit;
					}
					// Set 'posts_per_page' parameter
					$args['posts_per_page'] = $posts_per_page;
					$paged = ( ! empty( $_REQUEST['paged'] ) ) ? absint( $_REQUEST['paged'] ) : 1;
					$offset        = $posts_per_page * ( (int) $paged - 1 );
					$args['paged'] = $paged;
					// Update posts_per_page
					// if ( intval( $args['posts_per_page'] ) > $limit - $offset ) {
					// 	$args['posts_per_page'] = $limit - $offset;
					// }

					// Update posts_per_page
					if( isset( $args['post__not_in'] ) && !empty( $args['post__not_in'] ) ){
						$remaining_post = $limit - count( $args['post__not_in'] ) ;
						$foundPostsRemaining = $foundPosts - count( $args['post__not_in'] ) ;
						if( 0 < $remaining_post ){
							if ( intval( $args['posts_per_page'] ) > $remaining_post ) {
								$args['posts_per_page'] = $remaining_post;
							}
							elseif ( intval( $args['posts_per_page'] ) > $foundPostsRemaining ){
								$args['posts_per_page'] = $foundPostsRemaining;
							}
						}
					}

				}

				$cats  = ( isset( $scMeta['pfp_categories'] ) ? TLPpPro()->array_int_sanitization( $scMeta['pfp_categories'] ) : array() );
				$tags  = ( isset( $scMeta['pfp_tags'] ) ? TLPpPro()->array_int_sanitization( $scMeta['pfp_tags'] ) : array() );
				$tools = ( isset( $scMeta['pfp_tools'] ) ? TLPpPro()->array_int_sanitization( $scMeta['pfp_tools'] ) : array() );
				$taxQ  = array();
				if ( is_array( $cats ) && ! empty( $cats ) ) {
					$taxQ[] = array(
						'taxonomy' => TLPpPro()->taxonomies['category'],
						'field'    => 'term_id',
						'terms'    => $cats,
					);
				}
				if ( is_array( $tags ) && ! empty( $tags ) ) {
					$taxQ[] = array(
						'taxonomy' => TLPpPro()->taxonomies['tag'],
						'field'    => 'term_id',
						'terms'    => $tags,
					);
				}
				if ( is_array( $tools ) && ! empty( $tools ) ) {
					$taxQ[] = array(
						'taxonomy' => TLPpPro()->taxonomies['tool'],
						'field'    => 'term_id',
						'terms'    => $tools,
					);
				}
				if ( ! empty( $taxQ ) ) {
					$args['tax_query'] = $itemIdsArgs['tax_query'] = $taxQ;
					if ( count( $taxQ ) > 1 ) {
						$taxQ['relation'] = $itemIdsArgs['relation'] = ! empty( $scMeta['pfp_taxonomy_relation'] ) ? sanitize_text_field( $scMeta['pfp_taxonomy_relation'] ) : "AND";
					}
				}

				// Order
				$order_by = ( !empty( $scMeta['pfp_order_by'] ) ? sanitize_text_field( $scMeta['pfp_order_by'] ) : null );
				$order    = ( !empty( $scMeta['pfp_order'] ) ? sanitize_text_field( $scMeta['pfp_order'] ) : null );
				if ( $order ) {
					$args['order'] = $order;
				}
				if ( $order_by ) {
					$args['orderby'] = $order_by;
				}

				// Validation
				$dCol = round( 12 / $dCol );
				$tCol = round( 12 / $tCol );
				$mCol = round( 12 / $mCol );
				if ( $isCarousel ) {
					$dCol = $tCol = $mCol = 12;
				}


				$arg['grid']      = "pfp-col-lg-{$dCol} pfp-col-md-{$dCol} pfp-col-sm-{$tCol} pfp-col-xs-{$mCol}";
				$gridType     = ! empty( $scMeta['pfp_grid_style'] ) ? sanitize_text_field( $scMeta['pfp_grid_style'] ) : 'even';
				$arg['class']     = $gridType . "-grid-item";
				$arg['class'] .= " pfp-grid-item";
				if ( $isIsotope ) {
					$arg['class'] .= ' isotope-item';
				}
				if ( $isCarousel ) {
					$arg['class'] .= ' pfp-carousel-item';
				}
				if ( $gridType == "even" ) {
					$arg['class'] .= ' even-grid-item';
				} else if ( $gridType == "masonry" && ! $isIsotope && ! $isCarousel ) {
					$arg['class'] .= ' masonry-grid-item';
				}
				$margin = ! empty( $scMeta['pfp_margin'] ) ? sanitize_text_field( $scMeta['pfp_margin'] ) : 'default';
				if ( $margin == 'no' ) {
					$arg['class'] .= ' no-margin';
				}

				$image_shape = ! empty( $scMeta['pfp_image_shape'] ) ? sanitize_text_field( $scMeta['pfp_image_shape'] ) : null;
				if($image_shape == 'circle'){
					$arg['class'] .= ' pfp-img-circle';
				}
				// $margin = ! empty( $scMeta['pfp_margin'] ) ? $scMeta['pfp_margin'] : 'default';
				if ( $margin == 'no' ) {
					$arg['class'] .= ' no-margin';
				}else{
					$arg['class'] .= ' default-margin';
				}

				$arg['items'] = ! empty( $scMeta['pfp_item_fields'] ) ? TLPpPro()->array_text_sanitization( $scMeta['pfp_item_fields'] ) : array();
				
				$arg['anchorClass'] = null;
				$link              = ! empty( $scMeta['pfp_detail_page_link'] ) ? true : false;
				$arg['link']        = $arg['link_type'] = $arg['link_target'] = false;
				if ( $link ) {
					$link_type = $arg['link_type'] = ! empty( $scMeta['pfp_detail_page_link_type'] ) ? sanitize_text_field( $scMeta['pfp_detail_page_link_type'] ) : 'popup';

					if ( $link_type == "popup" ) {
						$arg['anchorClass'] .= ' pfp-popup tlp-single-item-popup';
					} else if ( $link_type == "external_link" ) {
						$arg['link_target'] = ! empty( $scMeta['pfp_link_target'] ) ? sanitize_text_field( $scMeta['pfp_link_target'] ) : '_blank';
					}
					$arg['link']      = true;
				} else {
					$arg['anchorClass'] .= ' pfp-disable';
				}
				$arg['zoomId'] = $layout;
				$portQuery = new WP_Query( $args );
				// Start layout
				if ( $portQuery->have_posts() ) {

					while ( $portQuery->have_posts() ) {
						$portQuery->the_post();

						$iID                   = get_the_ID();
						$arg['iID']            = $iID;
						$arg['title']          = get_the_title();
						$arg['client_name']    = get_post_meta( $iID, 'client_name', true );
						$arg['completed_date'] = get_post_meta( $iID, 'completed_date', true );
						$arg['short_desc']     = get_post_meta( $iID, 'short_description', true );
						$arg['short_desc']     = TLPpPro()->strip_tags_content($arg['short_desc'], $excerpt_limit);
						$arg['project_url']    = get_post_meta( $iID, 'project_url', true );
						$arg['external_url']    = get_post_meta( $iID, 'external_url', true );
						$arg['tools']          = strip_tags( get_the_term_list( $iID, TLPpPro()->taxonomies['tool'],
							null, ' | ' ) );
						$arg['categories']     = strip_tags( get_the_term_list( $iID,
							TLPpPro()->taxonomies['category'], null, ', ' ) );
						$arg['tags']           = strip_tags( get_the_term_list( $iID, TLPpPro()->taxonomies['tag'],
							null, ', ' ) );
						$arg['pLink']          = get_permalink();
						if($arg['link_type'] == "external_link" && $arg['external_url']){
							$arg['pLink'] = $arg['external_url'];
						}
						$imgUrl                = wp_get_attachment_image_src( get_post_thumbnail_id( $iID ), 'full' );;
						$arg['img_full_url'] = ( ! empty( $imgUrl ) ? $imgUrl[0] : null );
						$excerpt             = get_the_excerpt();
						$arg['excerpt']      = TLPpPro()->strip_tags_content( $excerpt, $excerpt_limit );
						if ( $isIsotope ) {
							$termAs    = wp_get_post_terms( $iID, TLPpPro()->taxonomies['category'],
								array( "fields" => "all" ) );
							$isoFilter = null;
							if ( ! empty( $termAs ) ) {
								foreach ( $termAs as $term ) {
									$isoFilter .= " " . "iso_" . $term->term_id;
									$isoFilter .= " " . $term->slug;
								}
							}
							$arg['isoFilter'] = $isoFilter;
						}
						$arg['img'] = TLPpPro()->getFeatureImage( $iID, $imgSize, $customImgSize );
						
						$data .= TLPpPro()->render( 'layouts/' . $layout, $arg );

					}
					if ( ! empty( $data ) ) {
						$error = false;
					}

				} else {
					$msg = esc_html__( 'No More Post to load', 'tlp-portfolio-pro' );
				}
				wp_reset_postdata();

			} else {
				$msg = esc_html__( 'Something went wrong !!', 'tlp-portfolio-pro' );
			}
			wp_send_json( array(
				'error'    => $error,
				'msg'      => $msg,
				'data'     => $data
			) );
			die();

		}

		function layoutStyle($layoutID,$meta ){
			$css = null;
			$css .= "<style type='text/css' media='all'>";
			// Variable
			$primaryColor = ( !empty( $meta['pfp_primary_color'] ) ? sanitize_text_field( $meta['pfp_primary_color'] ) : null );

			if ( $primaryColor ) {
				$css .= ".{$layoutID}.tlp-popup-wrap .tlp-popup-navigation-wrap,nav.tlp-pagination ul.page-numbers li .page-numbers {";
				$css .= "background:" . $primaryColor . ";";
				$css .= "}";
				$css .= "#{$layoutID} .tlp-portfolio-item .tlp-content,
				#{$layoutID} .pfp-layout7 .short-desc p,
				#{$layoutID} .pfp-isotope6 .tlp-portfolio-item p,
				#{$layoutID} .pfp-carousel6 .tlp-portfolio-item p,
				.tlp-portfolio .isotop-btn button, 
				#{$layoutID} .tlp-overlay .tlp-title, 
				#{$layoutID}  .tlp-overlay .line, 
				#{$layoutID} .pfp-layout19 figcaption, 
				#{$layoutID} .pfp-isotope18 figcaption, #{$layoutID} .pfp-carousel18 figcaption {";
				$css .= "background:" . $primaryColor . ";";
				$css .= "}";
				$css .= "#{$layoutID} .tlp-portfolio-item .tlp-overlay h3,#{$layoutID} .tlp-portfolio-item .tlp-overlay16 h3, #{$layoutID} .tlp-portfolio-item .tlp-overlay17 h3 {";
				$css .= "border-color:" . $primaryColor . ";";
				$css .= "}";
				$css .= "#{$layoutID} .pfp-layout19 figure:hover figcaption,#{$layoutID} .pfp-isotope18 figure:hover figcaption, #{$layoutID} .pfp-carousel18 figure:hover figcaption {";
				$css .= "box-shadow: 0 0 0 10px" . $primaryColor . ";";
				$css .= "}";
				$css .= "#{$layoutID} .tlp-portfolio-item .tlp-content .tlp-content-holder{padding:15px}";
				// $css .= "#{$layoutID} .tlp-portfolio-item .tlp-content .tlp-content-holder h3{margin-bottom: 0;}";
			}

			/* Button background color */
			$buttonBgColor = ( !empty( $meta['pfp_button_bg_color'] ) ? sanitize_text_field( $meta['pfp_button_bg_color'] ) : null );
			$buttonTxtColor = ( !empty( $meta['pfp_button_text_color'] ) ? sanitize_text_field( $meta['pfp_button_text_color'] ) : null );
			if($buttonBgColor){
				$css .= "#{$layoutID} .pfp-load-more button, #{$layoutID} .pfp-isotope-buttons button, #{$layoutID} .pfp-isotope-buttons button, #{$layoutID} .owl-theme .owl-nav [class*=owl-], 
			    #{$layoutID} .owl-theme .owl-dots .owl-dot span,#{$layoutID} .pfp-pagination ul.pagination-list li span, #{$layoutID} .pfp-pagination ul.pagination-list li a {";
				$css .= "background: {$buttonBgColor};";
				$css .= ( $buttonTxtColor ? "color: {$buttonTxtColor}" : null );
				$css .= "}";
			}

			/* Button hover background color */
			$buttonHoverBgColor = ( !empty( $meta['pfp_button_hover_bg_color'] ) ? sanitize_text_field( $meta['pfp_button_hover_bg_color'] ) : null );
			if($buttonHoverBgColor){
				$css .= "#{$layoutID} .pfp-load-more button:hover,#{$layoutID} .pfp-isotope-buttons button:hover, #{$layoutID} .owl-theme .owl-nav [class*=owl-]:hover, #{$layoutID} .pfp-pagination ul.pagination-list li span:hover, #{$layoutID} .pfp-pagination ul.pagination-list li a:hover {";
				$css .= "background: {$buttonHoverBgColor};";
				$css .= "}";
			}

			/* Button Active background color */
			$buttonActiveBgColor = ( !empty( $meta['pfp_button_active_bg_color'] ) ? sanitize_text_field( $meta['pfp_button_active_bg_color'] ) : null );
			if($buttonActiveBgColor){
				$css .= "#{$layoutID} .pfp-isotope-buttons button.selected, #{$layoutID} .owl-theme .owl-dots .owl-dot.active span, #{$layoutID} .pfp-pagination ul.pagination-list li.active span {";
				$css .= "background: {$buttonActiveBgColor};";
				$css .= "}";
			}

			// Isotope counter tooltip color
			$tooltipBg = ( !empty( $meta['pfp_iso_counter_tooltip_bg_color'] ) ? sanitize_text_field( $meta['pfp_iso_counter_tooltip_bg_color'] ) : null );
			$tooltipText = ( !empty( $meta['pfp_iso_counter_tooltip_text_color'] ) ? sanitize_text_field( $meta['pfp_iso_counter_tooltip_text_color'] ): null );
			if($tooltipBg || $tooltipText){
				$css .= "#pfp-tooltip-{$layoutID}, #pfp-tooltip-{$layoutID} .pfp-tooltip-bottom:after {";
				$css .= ($tooltipBg ? "background: {$tooltipBg}; " : null);
				$css .= ($tooltipText ? "color: {$tooltipText};" : null);
				$css .= "}";
			}

			/* gutter */
			if(!empty($meta['pfp_gutter']) && $gutter = absint($meta['pfp_gutter'])){
				$css .= "#{$layoutID} [class*='pfp-col-'] {";
				$css .= "padding-left : {$gutter}px;";
				$css .= "padding-right : {$gutter}px;";
				$css .= "margin-top : {$gutter}px;";
				$css .= "margin-bottom : {$gutter}px;";
				$css .= "}";
				$css .= "#{$layoutID} .pfp-row{";
				$css .= "margin-left : -{$gutter}px;";
				$css .= "margin-right : -{$gutter}px;";
				$css .= "}";
			}

			// Name
			$name = !empty( $meta['pfp_name_style'] ) ?  TLPpPro()->array_text_sanitization( $meta['pfp_name_style'] )  : array();
			
			if ( ! empty( $name ) && is_array( $name ) ) {
				$css .= "#{$layoutID} .tlp-portfolio-item h3 a, #{$layoutID} .tlp-portfolio-item h3{";
				
				$css .= ( !empty( $name['align'] ) ? "text-align:" . $name['align'] . ";" : null );
				$css .= ( !empty( $name['weight'] ) ? "font-weight:" . $name['weight'] . ";" : null );
				$css .= ( !empty( $name['size'] ) ? "font-size:" . $name['size'] . "px;" : null );
				$css .= "}";
				$css .= "#{$layoutID} .tlp-portfolio-item h3:not(.color-white) a, #{$layoutID} .tlp-portfolio-item h3:not(.color-white){";
					$css .= ( !empty( $name['color'] ) ? "color:" . $name['color'] . ";" : null );
				$css .= "}";

			}

			$name_hover = !empty( $meta['pfp_name_hover_style'] ) ? TLPpPro()->array_text_sanitization( $meta['pfp_name_hover_style'] ) : array();
		
			if ( ! empty( $name_hover ) && is_array( $name_hover ) ) {
				$css .= "#{$layoutID} .tlp-portfolio-item h3 a:hover, #{$layoutID} .tlp-portfolio-item h3:hover{";
				
				$css .= ( !empty( $name_hover['align'] ) ? "text-align:" . $name_hover['align'] . ";" : null );
				$css .= ( !empty( $name_hover['weight'] ) ? "font-weight:" . $name_hover['weight'] . ";" : null );
				$css .= ( !empty( $name_hover['size'] ) ? "font-size:" . $name_hover['size'] . "px;" : null );
				$css .= "}";
				$css .= "#{$layoutID} .tlp-portfolio-item h3:not(.color-white) a:hover, #{$layoutID} .tlp-portfolio-item h3:not(.color-white):hover{";
					$css .= ( !empty( $name_hover['color'] ) ? "color:" . $name_hover['color'] . ";" : null );
				$css .= "}";

			}

			// Short Description
			$short_desc = ( !empty( $meta['pfp_short_description_style'] ) ? TLPpPro()->array_text_sanitization( $meta['pfp_short_description_style'] ) : array() );
			if ( ! empty( $short_desc ) && is_array( $short_desc ) ) {
				$css .= "#{$layoutID} .tlp-portfolio-item .short-desc, #{$layoutID} .pfp-layout19 figcaption .pfp-categories{";
				$css .= ( !empty( $short_desc['color'] ) ? "color:" . $short_desc['color'] . ";" : null );
				$css .= ( !empty( $short_desc['size'] ) ? "font-size:" . $short_desc['size'] . "px;" : null );
				$css .= ( !empty( $short_desc['weight'] ) ? "font-weight:" . $short_desc['weight'] . ";" : null );
				$css .= ( !empty( $short_desc['align'] ) ? "text-align:" . $short_desc['align'] . ";" : null );
				$css .= "}";
			}

			// Meta Style
			$pfp_meta_style = ( !empty( $meta['pfp_meta_style'] ) ? TLPpPro()->array_text_sanitization( $meta['pfp_meta_style'] ) : array() );
			if ( ! empty( $pfp_meta_style ) && is_array( $pfp_meta_style ) ) {
				$css .= "#{$layoutID} .tlp-portfolio-item .extra-features li{";
				$css .= ( !empty( $pfp_meta_style['color'] ) ? "color:" . $pfp_meta_style['color'] . ";" : null );
				$css .= ( !empty( $pfp_meta_style['size'] ) ? "font-size:" . $pfp_meta_style['size'] . "px;" : null );
				$css .= ( !empty( $pfp_meta_style['align'] ) ? "text-align:" . $pfp_meta_style['align'] . ";" : null );
				$css .= ( !empty( $pfp_meta_style['weight'] ) ? "font-weight:" . $pfp_meta_style['weight'] . ";" : null );
				$css .= "}";
			}
			
			// client_name
			$client_name = ( !empty( $meta['pfp_client_name_style'] ) ? TLPpPro()->array_text_sanitization( $meta['pfp_client_name_style'] ) : array() );
			if ( ! empty( $client_name ) && is_array( $client_name ) ) {
				$css .= "#{$layoutID} .tlp-portfolio-item .extra-features li.client-name{";
				$css .= ( !empty( $client_name['color'] ) ? "color:" . $client_name['color'] . ";" : null );
				$css .= ( !empty( $client_name['size'] ) ? "font-size:" . $client_name['size'] . "px;" : null );
				$css .= ( !empty( $client_name['align'] ) ? "text-align:" . $client_name['align'] . ";" : null );
				$css .= ( !empty( $client_name['weight'] ) ? "font-weight:" . $client_name['weight'] . ";" : null );
				$css .= "}";
			}

			

			// .tlp-portfolio-item .extra-features li
			// tools
			$tools = ( !empty( $meta['pfp_tools_style'] ) ? TLPpPro()->array_text_sanitization( $meta['pfp_tools_style'] ) : array() );
			if ( ! empty( $tools ) && is_array( $tools ) ) {
				$css .= "#{$layoutID} .tlp-portfolio-item .tools{";
				$css .= ( !empty( $tools['color'] ) ? "color:" . $tools['color'] . ";" : null );
				$css .= ( !empty( $tools['size'] ) ? "font-size:" . $tools['size'] . "px;" : null );
				$css .= ( !empty( $tools['align'] ) ? "text-align:" . $tools['align'] . ";" : null );
				$css .= ( !empty( $tools['weight'] ) ? "font-weight:" . $tools['weight'] . ";" : null );
				$css .= "}";
			}

			// Social icon color
			$iconStyle = ( !empty( $meta['pfp_icon_style'] ) ? TLPpPro()->array_text_sanitization( $meta['pfp_icon_style'] ) : array() );
			if ( ! empty( $iconStyle ) && is_array( $iconStyle ) ) {
				
				$css .= "#{$layoutID} .tlp-portfolio-item .link-icon a{";
				$css .= isset( $iconStyle['color'] ) ? "border-color: " . $iconStyle['color'] . ";" : null;
				$css .= isset( $iconStyle['color'] ) ? "color:" . $iconStyle['color'] . ";" : null;
				$css .= "}";
			}

			// Overlay
			$overlayColor   = ( ! empty( $meta['pfp_overlay_color'] ) ? sanitize_text_field( $meta['pfp_overlay_color'] ) : null );
			$overlayOpacity = ( ! empty( $meta['pfp_overlay_opacity'] ) ? absint( $meta['pfp_overlay_opacity'] ) : null );
			if ( $overlayColor ) {
				$css .= "#{$layoutID} .pfp-layout1 .tlp-portfolio-item:hover .tlp-overlay,
				#{$layoutID} .pfp-layout2 .tlp-overlay, #{$layoutID} .pfp-layout3 .tlp-overlay, #{$layoutID} .pfp-layout4 .tlp-overlay, #{$layoutID} .tlp-portfolio-item:hover .tlp-overlay,
				#{$layoutID} .tlp-portfolio-item:hover .tlp-overlay, #{$layoutID}  .tlp-portfolio-thumb:hover .tlp-overlay, #{$layoutID} .tlp-portfolio-item .overlay,
				#{$layoutID} .pfp-carousel1 .tlp-portfolio-item:hover .tlp-overlay, #{$layoutID} .tlp-portfolio-item .post-info, #{$layoutID} .pfp-layout9 .tlp-portfolio-item figcaption:hover,#{$layoutID} .pfp-isotope8 .tlp-portfolio-item figcaption:hover,#{$layoutID} .pfp-carousel8 .tlp-portfolio-item figcaption:hover {";
				$css .= "background:" . TLPpPro()->TLPhex2rgba( $overlayColor,
						( $overlayOpacity ? $overlayOpacity / 100 : .8 ) ) . ";";
				$css .= "}";
			}

			// Overlay Padding
			$overlayPadding = ( ! empty( $meta['pfp_overlay_padding'] ) ? absint( $meta['pfp_overlay_padding'] ) : null );

			if ( $overlayPadding ) {
				$css .= "#{$layoutID} .pfp-layout1 .tlp-portfolio-item:hover .tlp-overlay,
				#{$layoutID} .pfp-layout2 .tlp-overlay, #{$layoutID} .pfp-layout3 .tlp-overlay, #{$layoutID} .pfp-layout4 .tlp-overlay, #{$layoutID} .tlp-portfolio-item:hover .tlp-overlay,
				#{$layoutID} .tlp-portfolio-item:hover .tlp-overlay, #{$layoutID}  .tlp-portfolio-thumb:hover .tlp-overlay, #{$layoutID} .tlp-portfolio-item .overlay,
				#{$layoutID} .pfp-carousel1 .tlp-portfolio-item:hover .tlp-overlay, #{$layoutID} .tlp-portfolio-item .post-info, #{$layoutID} .pfp-layout9 .tlp-portfolio-item figcaption:hover,#{$layoutID} .pfp-isotope8 .tlp-portfolio-item figcaption:hover,#{$layoutID} .pfp-carousel8 .tlp-portfolio-item figcaption:hover {";
				$css .= "padding-top:" . $overlayPadding . "%;";
				$css .= "}";
			}

			$css .= "</style>";

			return $css;
		}
	}

endif;