(function ($) {
    'use strict';
    $('*').on('touchstart', function () {
        $(this).trigger('hover');
    }).on('touchend', function () {
        $(this).trigger('hover');
    });

    $(function () {
        preFunction();
        $(document).on('mouseover', '.pfp-isotope-buttons button',
            function () {
                var self = $(this),
                    count = self.attr('data-filter-counter'),
                    id = self.parents('.pfp-wrapper').attr('id');
                $tooltip = '<div class="pfp-tooltip" id="pfp-tooltip-' + id + '">' +
                    '<div class="pfp-tooltip-content">' + count + '</div>' +
                    '<div class="pfp-tooltip-bottom"></div>' +
                    '</div>';
                $('body').append($tooltip);
                var $tooltip = $('body > .pfp-tooltip');
                var tHeight = $tooltip.outerHeight();
                var tBottomHeight = $tooltip.find('.pfp-tooltip-bottom').outerHeight();
                var tWidth = $tooltip.outerWidth();
                var tHolderWidth = self.outerWidth();
                var top = self.offset().top - (tHeight + tBottomHeight);
                var left = self.offset().left;
                $tooltip.css({
                    'top': top + 'px',
                    'left': left + 'px',
                    'opacity': 1
                }).show();
                if (tWidth <= tHolderWidth) {
                    var itemLeft = (tHolderWidth - tWidth) / 2;
                    left = left + itemLeft;
                    $tooltip.css('left', left + 'px');
                } else {
                    var itemLeft = (tWidth - tHolderWidth) / 2;
                    left = left - itemLeft;
                    if (left < 0) {
                        left = 0;
                    }
                    $tooltip.css('left', left + 'px');
                }
            })
            .on('mouseout', '.pfp-isotope-buttons button', function () {
                $('body > .pfp-tooltip').remove();
            });
    });
    $(document).on('click', '.pfp-wrapper .tlp-single-item-popup', function () {
        var self = $(this),
            id = self.attr("data-id"),
            current = id,
            wrapper = self.parents('.pfp-wrapper'),
            wrapperId = wrapper.attr('id'),
            itemArray = [];
        wrapper.find('.pfp-grid-item').each(function () {
            var _id = $(this).data('id');
            if (itemArray.indexOf(_id) === -1) {
                itemArray.push(parseInt(_id, 10));
            }
        });
        var data = pfp.nonceId + "=" + pfp.nonce + "&action=tlpPFPSingleItem&id=" + id;
        $.ajax({
            type: "post",
            url: pfp.ajaxurl,
            data: data,
            beforeSend: function () {
                initPopup(wrapperId);
                setLevel(current, itemArray);
            },
            success: function (data) {
                $("#tlp-popup-wrap .tlp-popup-content").html(data.data);
            },
            complete: function() {	
                
			},
            error: function () {
                $("#tlp-popup-wrap .tlp-popup-content").html("<p>Loading error!!!</p>");
            }
        });

        $('.tlp-popup-next').on('click', function () {
            rightClick();
        });
        $('.tlp-popup-prev').on('click', function () {
            leftClick();
        });
        $('.tlp-popup-close').on('click', function () {
            animation();
        });

        $(window).bind('keydown', function (event) {
            if (event.keyCode === 27) { // Esc
                animation();
            } else if (event.keyCode === 37) { // left arrow
                leftClick();
            } else if (event.keyCode === 39) { // right arrow
                rightClick();
            }
        });

        function rightClick() {
            var nextId = nextItem(current, itemArray);
            current = nextId;
            var data = pfp.nonceId + "=" + pfp.nonce + "&action=tlpPFPSingleItem&id=" + current;
            $.ajax({
                type: "post",
                url: pfp.ajaxurl,
                data: data,
                beforeSend: function () {
                    setLevel(current, itemArray);
                    $('#tlp-popup-wrap .tlp-popup-content').html('<div class="tlp-popup-loading"></div>');
                },
                success: function (data) {
                    $('#tlp-popup-wrap .tlp-popup-content').html(data.data);
                },
                error: function (jqXHR, textStatus, errorThrown) {
                    $('#tlp-popup-wrap .tlp-popup-content').html('');
                    alert(textStatus + ' (' + errorThrown + ')');
                }
            });
        }

        function leftClick() {
            var prevId = prevItem(current, itemArray);
            current = prevId;
            var data = pfp.nonceId + "=" + pfp.nonce + "&action=tlpPFPSingleItem&id=" + current;
            $.ajax({
                type: "post",
                url: pfp.ajaxurl,
                data: data,
                beforeSend: function () {
                    setLevel(current, itemArray);
                    $('#tlp-popup-wrap .tlp-popup-content').html('<div class="tlp-popup-loading"></div>');
                },
                success: function (data) {
                    $('#tlp-popup-wrap .tlp-popup-content').html(data.data);
                },
                error: function (jqXHR, textStatus, errorThrown) {
                    $('#tlp-popup-wrap .tlp-popup-content').html('');
                    alert(textStatus + ' (' + errorThrown + ')');
                }
            });
        }

        return false;
    });

    $('.tlp-close, .tlp-popup-escap').click(function () {
        $('#tlp-popup').hide();
        $('.tlp-popup-container').attr('style', '');
        $('#tlp-popup .tlp-popup-container .tlp-popup-content').html('');
    });

    $(window).bind('keydown', function (event) {
        if (event.keyCode === 27) {
            $('#tlp-popup').hide();
            $('.tlp-popup-container').attr('style', '');
            $('#tlp-popup .tlp-popup-container .tlp-popup-content').html('');
        }
    });
    $(window).on('load resize', function () {
        preFunction();
        navResize();
    });

    function preFunction() {
        // HeightResize();
        // overlayIconResize();
    }

    $(window).on('load', function () {
        initRtppCaroselPortfolio();
    });

    function initRtppCaroselPortfolio() {
        $('.pfp-wrapper').each(function () {
            var container = $(this),
                loaded_post_ids = [],
                id = $.trim(container.attr('id')),
                str = $(this).attr("data-layout"),
                storeLoadedIds = function () {
                    container.find('.pfp-grid-item').each(function () {
                        var id = $(this).data('id');
                        if (loaded_post_ids.indexOf(id) === -1) {
                            loaded_post_ids.push(parseInt(id, 10));
                        }
                    });
                };
            if (str) {
                var qsRegex,
                    buttonFilter,
                    Iso = container.find(".pfp-isotope"),
                    caro = container.find('.pfp-carousel');

                if (caro.length) {
                    caro.parents('.pfp-row').removeClass('pfp-pre-loader');
                    var items = caro.data('items'),
                        tabcolumn = caro.data('tabcolumn'),
                        mobilecolumn = caro.data('mobilecolumn'),
                        loop = caro.data('loop'),
                        nav = caro.data('nav'),
                        dots = caro.data('dots'),
                        autoplay = caro.data('autoplay'),
                        autoPlayHoverPause = caro.data('autoplay-hover-pause'),
                        autoPlayTimeOut = caro.data('autoplay-timeout'),
                        autoHeight = caro.data('autoheight'),
                        lazyLoad = caro.data('lazyload'),
                        rtl = caro.data('rtl'),
                        smartSpeed = caro.data('smart-speed');
                        
                    caro.owlCarousel({
                        items: items ? items : 3,
                        loop: loop ? true : false,
                        nav: nav ? true : false,
                        dots: dots ? true : false,
                        navText: ["<i class=\'icon-left-open\'></i>", "<i class=\'icon-right-open\'></i>"],
                        autoplay: autoplay ? true : false,
                        autoplayHoverPause: autoPlayHoverPause ? true : false,
                        autoplayTimeout: autoPlayTimeOut ? autoPlayTimeOut : 5000,
                        smartSpeed: smartSpeed ? smartSpeed : 250,
                        autoHeight: autoHeight ? true : false,
                        lazyLoad: lazyLoad ? true : false,
                        rtl: rtl ? true : false,
                        responsiveClass: true,
                        responsive: {
                            0: {
                                items: mobilecolumn ? mobilecolumn : 1
                            },
                            600: {
                                items: tabcolumn ? tabcolumn : 2
                            },
                            1000: {
                                items: items ? items : 3
                            }
                        }
                    });
                    caro.find('.owl-prev').attr('aria-label', 'Previous');
                    caro.find('.owl-next').attr('aria-label', 'Next');
                    caro.find('.owl-dot').each(function(index) {
                        $(this).attr('aria-label', index + 1);
                    });
                    preFunction();
                }

                if (Iso.length) {
                    var IsoButton = container.find(".pfp-isotope-buttons");
                    var layOutMode = container.find(".pfp-masonry").length ? 'masonry' : 'fitRows';
                    if (!buttonFilter) {
                        buttonFilter = IsoButton.find('button.selected').data('filter');
                    }
                    var isotope = Iso.imagesLoaded(function () {
                        preFunction();
                        Iso.parents('.pfp-row').removeClass('pfp-pre-loader');
                        isotope.isotope({
                            layoutMode: layOutMode,
                            itemSelector: '.isotope-item',
                            masonry: {columnWidth: '.isotope-item'},
                            filter: function () {
                                var $this = $(this);
                                var searchResult = qsRegex ? $this.text().match(qsRegex) : true;
                                var buttonResult = buttonFilter ? $this.is(buttonFilter) : true;
                                return searchResult && buttonResult;
                            }
                        });
                        isoFilterCounter(container, isotope);
                    });
                    // use value of search field to filter
                    var $quicksearch = container.find('.iso-search-input').keyup(debounce(function () {
                        qsRegex = new RegExp($quicksearch.val(), 'gi');
                        isotope.isotope();
                    }));

                    IsoButton.on('click touchstart', 'button', function (e) {
                        e.preventDefault();
                        buttonFilter = $(this).attr('data-filter');
                        isotope.isotope();
                        $(this).parent().find('.selected').removeClass('selected');
                        $(this).addClass('selected');
                    });

                    $(document).on('click', '.ult_tab_section', function (e) {
                        e.preventDefault();
                        preFunction();
                        if (isotope !== undefined) {
                            setTimeout(function () {
                                preFunction();
                                isotope.isotope();
                            }, 1000);
                        }
                    });

                    if (container.find('.pfp-utility .pfp-load-more').length) {
                        container.find(".pfp-load-more").on('click', 'button', function (e) {
                            e.preventDefault(e);
                            storeLoadedIds();
                            loadMoreButton($(this), isotope, container, 'isotope', IsoButton, loaded_post_ids);
                        });
                    }

                    if (container.find('.pfp-utility .pfp-scroll-load-more').length) {
                        $(window).on('scroll', function () {
                            var $this = container.find('.pfp-utility .pfp-scroll-load-more');
                            storeLoadedIds();
                            scrollLoadMore($this, isotope, container, 'isotope', IsoButton, loaded_post_ids);
                        });
                    }
                } else if (container.find('.pfp-row.pfp-masonry').length) {
                    var masonryTarget = container.find('.pfp-row.pfp-masonry');
                    preFunction();
                    var isotopeM = masonryTarget.imagesLoaded(function () {
                        isotopeM.isotope({
                            itemSelector: '.masonry-grid-item',
                            masonry: {columnWidth: '.masonry-grid-item'}
                        });
                    });
                    if (container.find('.pfp-utility .pfp-load-more').length) {
                        container.find(".pfp-load-more").on('click', 'button', function (e) {
                            e.preventDefault(e);
                            storeLoadedIds()
                            loadMoreButton($(this), isotopeM, container, 'mLayout', '', loaded_post_ids);
                        });
                    }
                    if (container.find('.pfp-utility .pfp-scroll-load-more').length) {
                        $(window).on('scroll', function () {
                            var $this = container.find('.pfp-utility .pfp-scroll-load-more');
                            if ($this.attr('data-trigger') > 0) {
                                storeLoadedIds();
                                scrollLoadMore($this, isotopeM, container, 'mLayout', '', loaded_post_ids);
                            }
                        });
                    }

                    if (container.find('.pfp-utility .pfp-pagination.pfp-ajax').length) {
                        ajaxPagination(container, isotopeM);
                    }
                } else {
                    if (container.find(".pfp-utility  .pfp-load-more").length) {

                        container.find(".pfp-load-more").on('click', 'button', function (e) {
                            e.preventDefault(e);
                            storeLoadedIds();
                            loadMoreButton($(this), isotopeM, container, 'eLayout', '', loaded_post_ids);
                        });
                    }
                    if (container.find('.pfp-utility .pfp-scroll-load-more').length) {
                        $(window).on('scroll', function () {
                            var $this = container.find('.pfp-utility .pfp-scroll-load-more');
                            if ($this.attr('data-trigger') > 0) {
                                storeLoadedIds();
                                scrollLoadMore($this, isotopeM, container, 'eLayout', '', loaded_post_ids);
                            }
                        });
                    }
                    if (container.find('.pfp-utility .pfp-pagination.pfp-ajax').length) {
                        ajaxPagination(container);
                    }
                }
            }
        });
    }

    function isoFilterCounter(container, isotope) {
        var total_count = isotope.find('.pfp-grid-item').length;
        container.find('.pfp-isotope-buttons').find('button[data-filter="*"]').attr('data-filter-counter', total_count);
        container.find('.pfp-isotope-buttons button').each(function () {
            var self = $(this),
                filter = self.data("filter"),
                itemTotal = isotope.find(filter).length;
            if (filter !== "*") {
                self.attr("data-filter-counter", itemTotal);
            }
        });
    }


    function loadMoreButton($this, $isotope, container, layout, IsoButton, loaded_post_ids) {
        var $thisText = $this.clone().children().remove().end().text(),
            noMorePostText = $this.data("no-more-post-text"),
            loadingText = $this.data("loading-text"),
            scID = $this.attr("data-sc-id"),
            // limit = $this.attr("data-limit"),
            paged = parseInt($this.attr("data-paged"), 10),
            totalPages = parseInt($this.data("total-pages"), 10),
            foundPosts = parseInt($this.data("found-posts"), 10),
            postsPerPage = parseInt($this.data("posts-per-page"), 10),
            loaded_post_ids = loaded_post_ids || '',
            data = "scID=" + scID + "&foundPosts=" + foundPosts + "&paged=1&loaded_post_ids=" + loaded_post_ids;
        data = data + "&action=pfpLoadMore&" + pfp.nonceId + "=" + pfp.nonce;
        if (container.data("archive")) {
            data = data + "&archive=" + container.data("archive");
            if (container.data("archive-value")) {
                data = data + "&archive-value=" + container.data("archive-value");
            }
        }

        $.ajax({
            type: "post",
            url: pfp.ajaxurl,
            data: data,
            beforeSend: function () {
                $this.html('<span class="more-loading">' + loadingText + '</span>');
            },
            success: function (data) {
                if (!data.error) {
                    
                    var next_page = paged + 1 ;
                    var morePosts = foundPosts - (postsPerPage * next_page);
                    if (morePosts > 0) {
                        $thisText = $thisText + " <span>(" + morePosts + ")</span>";
                    } else {
                        $thisText = noMorePostText;
                    }
                    $this.attr("data-paged", next_page);
                    if (layout == "isotope") {
                        renderIsotope(container, $isotope, data.data, IsoButton);
                    } else if (layout == "mLayout") {
                        $isotope.append(data.data).isotope('appended', data.data).isotope('updateSortData').isotope('reloadItems');
                        $isotope.imagesLoaded(function () {
                            $isotope.isotope();
                        });
                    } else {
                        container.children(".pfp-row").append(data.data);
                        container.children(".pfp-row").imagesLoaded(function () {
                            preFunction();
                        });
                    }
                    $this.html($thisText);
                    if ( morePosts <= 0 || totalPages <= next_page ) {
                        $this.attr('disabled', 'disabled');
                        $this.parent().hide();
                    }
                } else {
                    $this.text(data.msg);
                    $this.attr('disabled', 'disabled');
                    $this.parent().hide();
                }
            },
            error: function (jqXHR, textStatus, errorThrown) {
                container.find(".more-loading").remove();
                alert(textStatus + ' (' + errorThrown + ')');
            }
        });
        return false;
    }

    function renderIsotope(container, $isotope, data, IsoButton) {

        var qsRegexG, buttonFilter;
        if (!buttonFilter) {
            buttonFilter = IsoButton.find('button.selected').data('filter');
        }

        $isotope.append(data)
            .isotope('appended', data)
            .isotope('reloadItems')
            .isotope('updateSortData');
        $isotope.imagesLoaded(function () {
            preFunction();
            $isotope.isotope();
        });

        $(IsoButton).on('click touchstart', 'button', function (e) {
            e.preventDefault();
            buttonFilter = $(this).attr('data-filter');
            $isotope.isotope();
            $(this).parent().find('.selected').removeClass('selected');
            $(this).addClass('selected');
        });
        var $quicksearch = container.find('.iso-search-input').keyup(debounce(function () {
            qsRegexG = new RegExp($quicksearch.val(), 'gi');
            $isotope.isotope();
        }));
        isoFilterCounter(container, $isotope);
    }

    function scrollLoadMore($this, $isotope, container, layout, IsoButton, loaded_post_ids) {
        var viewportHeight = $(window).height(),
            scrollTop = $(window).scrollTop(),
            targetHeight = $this.offset().top + $this.outerHeight() - 50,
            targetScroll = scrollTop + viewportHeight,
            loaded_post_ids = loaded_post_ids || '';

        if (targetScroll >= targetHeight) {
            var trigger = $this.attr("data-trigger");
            if (trigger == 1) {
                // $this.data('trigger', false);
                $this.attr("data-trigger", 0);
                var data,
                    scID = $this.attr("data-sc-id"),
                    foundPosts = parseInt($this.data("found-posts"), 10),
                    postsPerPage = parseInt($this.data("posts-per-page"), 10),
                    totalPages = parseInt($this.data("total-pages"), 10),
                    paged = parseInt($this.attr("data-paged"), 10);
                data = "scID=" + scID + "&paged=1&foundPosts=" + foundPosts + "&loaded_post_ids=" + loaded_post_ids;
                data = data + "&action=pfpLoadMore&" + pfp.nonceId + "=" + pfp.nonce;

                if (container.data("archive")) {
                    data = data + "&archive=" + container.data("archive");
                    if (container.data("archive-value")) {
                        data = data + "&archive-value=" + container.data("archive-value");
                    }
                }
                $.ajax({
                    type: "post",
                    url: pfp.ajaxurl,
                    data: data,
                    beforeSend: function () {
                        $this.html('<span class="more-loading">Loading ...</span>');
                    },
                    success: function (data) {
                        if (!data.error) {
                            var next_page = paged + 1 ;
                            var morePosts = foundPosts - (postsPerPage * next_page);
                            $this.attr("data-paged", next_page );
                            if (layout == "isotope") {
                                renderIsotope(container, $isotope, data.data, IsoButton);
                            } else if (layout == "mLayout") {
                                $isotope.append(data.data).isotope('appended', data.data).isotope('updateSortData').isotope('reloadItems');
                                $isotope.imagesLoaded(function () {
                                    $isotope.isotope();
                                });
                            } else {
                                container.children(".pfp-row").append(data.data);
                                container.children(".pfp-row").imagesLoaded(function () {
                                    preFunction();
                                });
                            }
                            $this.html('');
                            if ( morePosts > 0 ){
                                $this.attr("data-trigger", 1);
                            }
                            
                        } else {
                            $this.html('');
                            $this.attr("data-trigger", 0);
                        }
                    },
                    error: function (jqXHR, textStatus, errorThrown) {
                        container.find(".more-loading").remove();
                        alert(textStatus + ' (' + errorThrown + ')');
                    }
                });
            } // if trigger == 1

        }
    }

    function ajaxPagination(container, isotopeM) {
        $(".pfp-pagination.pfp-ajax ul li").on('click', 'a', function (e) {
            e.preventDefault();
            var data,
                $this = $(this),
                target = $this.parents("li"),
                parent = target.parents(".pfp-pagination.pfp-ajax"),
                activeLi = parent.find("li.active"),
                activeNumber = parseInt(activeLi.text(), 10),
                replaced = "<a data-paged='" + activeNumber + "' href='#'>" + activeNumber + "</a>",
                scID = parent.data("sc-id"),
                paged = $this.data("paged");
            activeLi.html(replaced);
            parent.find("li").removeClass("active");
            target.addClass("active");
            target.html("<span>" + paged + "</span>");
            data = "scID=" + scID + "&paged=" + paged;
            data = data + "&action=pfpLoadMore&" + pfp.nonceId + "=" + pfp.nonce;
            if (container.data("archive")) {
                data = data + "&archive=" + container.data("archive");
                if (container.data("archive-value")) {
                    data = data + "&archive-value=" + container.data("archive-value");
                }
            }
            $.ajax({
                type: "post",
                url: pfp.ajaxurl,
                data: data,
                beforeSend: function () {
                    parent.append('<div class="pfp-loading-holder"><span class="more-loading">Loading ...</span></div>');
                },
                success: function (data) {
                    if (!data.error) {
                        if (typeof isotopeM === "undefined") {
                            container.children(".pfp-row").animate({opacity: 0});
                            container.children(".pfp-row").html(data.data);
                            container.children(".pfp-row").imagesLoaded(function () {
                                preFunction();
                                container.children(".pfp-row").animate({opacity: 1}, 1000);
                            });
                        } else {
                            container.children(".pfp-row").find(".masonry-grid-item").remove();
                            isotopeM.append(data.data).isotope('appended', data.data).isotope('updateSortData').isotope('reloadItems');
                            isotopeM.imagesLoaded(function () {
                                preFunction();
                                isotopeM.isotope();
                            });
                        }
                    } else {
                        alert(data.msg);
                    }
                    container.find(".pfp-loading-holder").remove();
                },
                error: function (jqXHR, textStatus, errorThrown) {
                    container.find(".pfp-loading-holder").remove();
                    alert(textStatus + ' (' + errorThrown + ')');
                }
            });
        });
    }

    // debounce so filtering doesn't happen every millisecond
    function debounce(fn, threshold) {
        var timeout;
        return function debounced() {
            if (timeout) {
                clearTimeout(timeout);
            }

            function delayed() {
                fn();
                timeout = null;
            }

            setTimeout(delayed, threshold || 100);
        };
    }

    // Elementor Frontend Load
    $( window ).on( 'elementor/frontend/init', function() {
        if (elementorFrontend.isEditMode()) {
            elementorFrontend.hooks.addAction( 'frontend/element_ready/widget', function(){
                initRtppCaroselPortfolio();
            } );
        }
    } );

})(jQuery);



function initPopup(wrapperId) {
    var html = '<div id="tlp-popup-wrap" class="tlp-portfolio-popup-wrap tlp-popup-wrap pfp-wrapper tlp-popup-singlePage-sticky tlp-popup-singlePage ' + wrapperId + '">' +
        '<div class="tlp-popup-content">' +
        '<div class="tlp-popup-loading"></div>' +
        '</div>' +
        '<div class="tlp-popup-navigation-wrap">' +
        '<div class="tlp-popup-navigation">' +
        '<div class="tlp-popup-prev" title="Previous (Left arrow key)" data-action="prev"> <i class="icon-left-open"></i> </div>' +
        '<div class="tlp-popup-close" title="Close (Esc arrow key)" data-action="close"> <i class="icon-cancel"></i> </div>' +
        '<div class="tlp-popup-next" title="Next (Right arrow key)" data-action="next"><i class="icon-right-open"></i></div>' +
        '<div class="tlp-popup-singlePage-counter"><span class="ccurrent"></span> of <span class="ctotal"></span></div>' +
        '</div>' +
        '</div>' +
        '</div>';
    jQuery("body").append(html);
    var $pHolder = jQuery('#tlp-popup-wrap');
    $pHolder.css('display', 'block');
    var navHeight = $pHolder.find('.tlp-popup-navigation-wrap').height(),
        navHeightA = $pHolder.find('.tlp-popup-navigation-wrap').height() - 32;
    $pHolder.find('.tlp-popup-content').css('padding-top', navHeight + "px");
    jQuery('.admin-bar #tlp-popup-wrap .tlp-popup-content').css('padding-top', navHeightA + "px");
    animation();
}

function animation() {
    var $pHolder = jQuery('#tlp-popup-wrap');
    $pHolder.animate({
        marginLeft: parseInt($pHolder.css('marginLeft'), 10) == 0 ?
            $pHolder.outerWidth() : 0
    }).promise().done(function () {
        if (parseInt($pHolder.css('marginLeft')) > 0) {
            jQuery('#tlp-popup-wrap').remove();
            jQuery('body').removeClass('tlp-body-overflow');
        } else {
            jQuery('body').addClass('tlp-body-overflow');
        }
    });
}

function nextItem(current, list) {
    var index = list.indexOf(parseInt(current, 10));
    index++;
    if (index >= list.length)
        index = 0;
    return list[index];
}

function prevItem(current, list) {
    var index = list.indexOf(parseInt(current, 10));
    index--;
    if (index < 0)
        index = list.length - 1;
    return list[index];
}

function setLevel(current, list) {
    var index = list.indexOf(parseInt(current, 10)) + 1,
        count = list.length;
    jQuery(".ccurrent").text(index);
    jQuery(".ctotal").text(count);
}

function navResize() {
    var $pHolder = jQuery('#tlp-popup-wrap');
    $pHolder.css('display', 'block');
}

function pfpGalleryRender() {
    var sliderPFP = jQuery("#pfp-gallery-wrapper");
    sliderPFP.imagesLoaded(function () {
        sliderPFP.removeClass('pfp-pre-loader');
        jQuery('#pfp-gallery-wrapper #carousel').flexslider({
            animation: "slide",
            controlNav: false,
            animationLoop: false,
            slideshow: false,
            itemWidth: 100,
            itemMargin: 5,
            asNavFor: '#pfp-gallery-wrapper #slider'
        });

        jQuery('#pfp-gallery-wrapper #slider').flexslider({
            animation: "slide",
            controlNav: false,
            animationLoop: false,
            smoothHeight: true,
            slideshow: false,
            sync: "#pfp-gallery-wrapper #carousel",
            start: function( slider ){
                var items_height = slider.find('.flex-active-slide img').height();

                if(items_height === 0) {
                    setTimeout(function() {
                        slider.find('.flex-viewport').animate({ height: items_height }, 'fast');
                    }, 1000);
                } else {
                    slider.find('.flex-viewport').animate({ height: items_height }, 'fast');
                }
            },
            after: function( slider ){
                var items_height = slider.find('.flex-active-slide img').height();

                if(items_height === 0) {
                    setTimeout(function() {
                        slider.find('.flex-viewport').animate({ height: items_height }, 'fast');
                    }, 1000);
                } else {
                    slider.find('.flex-viewport').animate({ height: items_height }, 'fast');
                }
            }
        });
    });
}
