(function() {
    tinymce.PluginManager.add('tlp_pot_scg', function( editor, url ) {
        var tlpsc_tag = 'tlpportfolio';

        //add popup
        editor.addCommand('tlp_pot_scg_popup', function(ui, v) {
            //setup defaults

            editor.windowManager.open( {
                title: 'Portfolio Pro ShortCode',
                width: jQuery( window ).width() * 0.3,
                height: (jQuery( window ).height() - 36 - 50) * 0.1,
                id: 'tlpportfolio-insert-dialog',
                body: [
                    {
                        type   : 'container',
                        html   : '<span class="tlp_loading">Loading...</span>'
                    },
                ],
                onsubmit: function( e ) {

                    var shortcode_str;
                    var id = jQuery("#scid").val();
                    var title = jQuery( "#scid option:selected" ).text();
                    if(id && id != 'undefined'){
                        shortcode_str = '[' + tlpsc_tag;
                        shortcode_str += ' id="'+id+'" title="'+ title +'"';
                        shortcode_str += ']';
                    }
                    if(shortcode_str) {
                        editor.insertContent(shortcode_str);
                    }else{
                        alert('No short code selected');
                    }
                }
            });

            putScList();
        });

        //add button
        editor.addButton('tlp_pot_scg', {
            icon: 'tlp_pot_scg',
            tooltip: 'TLP Portfolio Shortcode',
            cmd: 'tlp_pot_scg_popup'
        });

        function putScList(){
            var dialogBody = jQuery( '#tlpportfolio-insert-dialog-body' )
            jQuery.post( ajaxurl, {
                action: 'shortCodeList'
            }, function( response ) {
                dialogBody.html(response);
            });

        }

    });
})();