(function ($) {
    'use strict';

    $(function(){
        renderPfpPreview();
        $("#pfp_sc_settings_meta").on('change input', 'select,input', function () {
            renderPfpPreview();
        });
        $("#pfp_sc_settings_meta").on("input propertychange", function () {
            renderPfpPreview();
        });
        $('.rt-color').wpColorPicker({
            change: function(event, ui){
                setTimeout(function(){  renderPfpPreview(); }, 500);
            },
            clear: function () {
                setTimeout(function(){  renderPfpPreview(); }, 500);
            },
            hide: true,
            palettes: true 
            
        });
        
    });

    $(document).on("click", "span.rtAddImage", function (e) {
        var file_frame, image_data;
        var $this = $(this).parents('.rt-image-holder');
        if (undefined !== file_frame) {
            file_frame.open();
            return;
        }
        file_frame = wp.media.frames.file_frame = wp.media({
            title: 'Select or Upload Media For your profile gallery',
            button: {
                text: 'Use this media'
            },
            multiple: false
        });
        file_frame.on('select', function () {
            var attachment = file_frame.state().get('selection').first().toJSON();
            var imgId = attachment.id;
            var imgUrl = (typeof attachment.sizes.thumbnail === "undefined") ? attachment.url : attachment.sizes.thumbnail.url;
            $this.find('.hidden-image-id').val(imgId);
            $this.find('.rtRemoveImage').show();
            $this.find('img').remove();
            $this.find('.rt-image-preview').append("<img src='" + imgUrl + "' />");
            renderPfpPreview();
        });
        // Now display the actual file_frame
        file_frame.open();
    });

    $(document).on("click", "span.rtRemoveImage", function (e) {
        e.preventDefault();
        if (confirm("Are you sure?")) {
            var $this = $(this).parents('.rt-image-holder');
            $this.find('.hidden-image-id').val('');
            $this.find('.rtRemoveImage').hide();
            $this.find('img').remove();
            renderPfpPreview();
        }
    });


    function renderPfpPreview() {
        if ( $("#pfp_sc_settings_meta").length ) {
            var data = $("#pfp_sc_settings_meta").find('input[name],select[name],textarea[name]').serialize();
            pfpPreviewAjaxCall(null, 'pfpPreviewAjaxCall', data, function (data) {
                if (!data.error) {
                    $("#pfp-preview-container").html(data.data);
                    renderLayout();
                    // overlayIconResize();
                }
            });
        }
    }

    function renderLayout() {
        var container = $('.pfp-wrapper');
        if(container.length) {
            var str = container.attr("data-layout");
            var loaded_post_ids = [];
            // id = $.trim(container.attr('id'));
            var container_id = $('#pfp-preview-container'),
            storeLoadedIds = function () {
                container_id.find('.pfp-grid-item').each(function () {
                    var id = $(this).data('id');
                    if (loaded_post_ids.indexOf(id) === -1) {
                        loaded_post_ids.push(parseInt(id, 10));
                    }
                });
            };

            
            if (str) {
                var qsRegex,
                    buttonFilter;
                var Iso = container.find(".pfp-isotope");
                var caro = container.find('.pfp-carousel');
                if (caro.length) {
                    caro.parents('.pfp-row').removeClass('pfp-pre-loader');
                    var items = caro.attr('data-items'),
                        tabcolumn = caro.data('tabcolumn'),
                        mobilecolumn = caro.data('mobilecolumn'),
                        loop = caro.data('loop'),
                        nav = caro.data('nav'),
                        dots = caro.data('dots'),
                        autoplay = caro.data('autoplay'),
                        autoPlayHoverPause = caro.data('autoplay-hover-pause'),
                        autoPlayTimeOut = caro.data('autoplay-timeout'),
                        autoHeight = caro.data('autoheight'),
                        lazyLoad = caro.data('lazyload'),
                        rtl = caro.data('rtl'),
                        smartSpeed = caro.data('smart-speed');
                    caro.owlCarousel({
                        items: items ? items : 3,
                        loop: loop ? true : false,
                        nav: nav ? true : false,
                        dots: dots ? true : false,
                        navText: ["<i class=\'icon-left-open\'></i>", "<i class=\'icon-right-open\'></i>"],
                        autoplay: autoplay ? true : false,
                        autoplayHoverPause: autoPlayHoverPause ? true : false,
                        autoplayTimeout: autoPlayTimeOut ? autoPlayTimeOut : 5000,
                        smartSpeed: smartSpeed ? smartSpeed : 250,
                        autoHeight: autoHeight ? true : false,
                        lazyLoad: lazyLoad ? true : false,
                        rtl: rtl ? true : false,
                        responsiveClass: true,
                        responsive: {
                            0: {
                                items: mobilecolumn ? mobilecolumn : 1
                            },
                            600: {
                                items: tabcolumn ? tabcolumn : 2
                            },
                            1000: {
                                items: items ? items : 3
                            }
                        }
                    });
                    preFunction();
                }

                if (Iso.length) {
                    var IsoButton = container.find(".pfp-isotope-buttons");
                    var layOutMode = container.find(".pfp-masonry").length ? 'masonry' : 'fitRows';
                    if (!buttonFilter) {
                        buttonFilter = IsoButton.find('button.selected').data('filter');
                    }
                    var isotope = Iso.imagesLoaded(function () {
                        preFunction();
                        Iso.parents('.pfp-row').removeClass('pfp-pre-loader');
                        isotope.isotope({
                            layoutMode: layOutMode,
                            itemSelector: '.isotope-item',
                            masonry: {columnWidth: '.isotope-item'},
                            filter: function () {
                                var $this = $(this);
                                var searchResult = qsRegex ? $this.text().match(qsRegex) : true;
                                var buttonResult = buttonFilter ? $this.is(buttonFilter) : true;
                                return searchResult && buttonResult;
                            }
                        });
                    });
                    // use value of search field to filter
                    var $quicksearch = container.find('.iso-search-input').keyup(debounce(function () {
                        qsRegex = new RegExp($quicksearch.val(), 'gi');
                        isotope.isotope();
                    }));

                    IsoButton.on('click', 'button', function (e) {
                        e.preventDefault();
                        buttonFilter = $(this).attr('data-filter');
                        isotope.isotope();
                        $(this).parent().find('.selected').removeClass('selected');
                        $(this).addClass('selected');
                        return false;
                    });

                    if (container.find('.pfp-utility .pfp-load-more').length) {
                        container.find(".pfp-load-more").on('click', 'button', function (e) {
                            e.preventDefault(e);
                            storeLoadedIds();
                            loadMoreButton($(this), isotope, container, 'isotope', IsoButton, loaded_post_ids);
                            return false;
                        });
                    }

                    if (container.find('.pfp-utility .pfp-scroll-load-more').length) {
                        $(window).on('scroll', function () {
                            var $this = container.find('.pfp-utility .pfp-scroll-load-more');
                            storeLoadedIds();
                            scrollLoadMore($this, isotope, container, 'isotope', IsoButton, loaded_post_ids);
                        });
                    }
                } else if (container.find('.pfp-row.pfp-masonry').length) {
                    var masonryTarget = container.find('.pfp-row.pfp-masonry');
                    preFunction();
                    var isotopeM = masonryTarget.imagesLoaded(function () {
                        isotopeM.isotope({
                            itemSelector: '.masonry-grid-item',
                            masonry: {columnWidth: '.masonry-grid-item'}
                        });
                    });
                    if (container.find('.pfp-utility .pfp-load-more').length) {
                        container.find(".pfp-load-more").on('click', 'button', function (e) {
                            e.preventDefault(e);
                            storeLoadedIds();
                            loadMoreButton($(this), isotopeM, container, 'mLayout', false, loaded_post_ids);
                            return false;
                        });
                    }
                    if (container.find('.pfp-utility .pfp-scroll-load-more').length) {
                        $(window).on('scroll', function () {
                            var $this = container.find('.pfp-utility .pfp-scroll-load-more');
                            if ($this.attr('data-trigger') > 0) {
                                storeLoadedIds();
                                scrollLoadMore($this, isotopeM, container, 'mLayout', false, loaded_post_ids);
                            }
                        });
                    }

                    if (container.find('.pfp-utility .pfp-pagination.pfp-ajax').length) {
                        ajaxPagination(container, isotopeM);
                    }
                } else {
                    if (container.find(".pfp-utility  .pfp-load-more").length) {
                        container.find(".pfp-load-more").on('click', 'button', function (e) {
                            e.preventDefault(e);
                            storeLoadedIds();
                            loadMoreButton($(this), isotopeM, container, 'eLayout', true, loaded_post_ids);
                            return false;
                        });
                    }
                    if (container.find('.pfp-utility .pfp-scroll-load-more').length) {
                        $(window).on('scroll', function () {
                            var $this = container.find('.pfp-utility .pfp-scroll-load-more');
                            if ($this.attr('data-trigger') > 0) {
                                storeLoadedIds();
                                scrollLoadMore($this, isotopeM, container, 'eLayout', false, loaded_post_ids);
                            }
                        });
                    }
                    if (container.find('.pfp-utility .pfp-pagination.pfp-ajax').length) {
                        ajaxPagination(container);
                    }
                }
            }
        }
    }


    function loadMoreButton($this, $isotope, container, layout, IsoButton, loaded_post_ids) {
        var $thisText = $this.clone().children().remove().end().text();
        var data = $("#pfp_sc_settings_meta").find('input[name],select[name],textarea[name]').serialize(),
            paged = parseInt($this.attr("data-paged"), 10),
            noMorePostText = $this.data("no-more-post-text"),
            totalPages = parseInt($this.data("total-pages"), 10),
            foundPosts = parseInt($this.data("found-posts"), 10),
            postsPerPage = parseInt($this.data("posts-per-page"), 10),
            data = data + "&foundPosts=" + foundPosts + "&paged=1&action=pfpLoadMorePreview&" + pfp.nonceId + "=" + pfp.nonce 
            + "&loaded_post_ids=" + loaded_post_ids;
        if (container.data("archive")) {
            data = data + "&archive=" + container.data("archive");
            if (container.data("archive-value")) {
                data = data + "&archive-value=" + container.data("archive-value");
            }
        }
        $.ajax({
            type: "post",
            url: pfp.ajaxurl,
            data: data,
            beforeSend: function () {
                $this.html('<span class="more-loading">Loading ...</span>');
            },
            success: function (data) {
                if (!data.error) {
                    var next_page = paged + 1 ;
                    var morePosts = foundPosts - (postsPerPage * next_page);
                    if (morePosts > 0) {
                        $thisText = $thisText + " <span>(" + morePosts + ")</span>";
                    } else {
                        $thisText = noMorePostText;
                    }
                    $this.attr("data-paged", next_page );
                    if (layout == "isotope") {
                        renderIsotope(container, $isotope, data.data, IsoButton);
                    } else if (layout == "mLayout") {
                        $isotope.append(data.data).isotope('appended', data.data).isotope('updateSortData').isotope('reloadItems');
                        $isotope.imagesLoaded(function () {
                            $isotope.isotope();
                        });
                    } else {
                        container.children(".pfp-row").append(data.data);
                        container.children(".pfp-row").imagesLoaded(function () {
                            preFunction();
                        });
                    }
                    $this.html($thisText);
                    if (totalPages <= next_page) {
                        $this.attr('disabled', 'disabled');
                        $this.parent().hide();
                    }
                } else {
                    $this.text(data.msg);
                    $this.attr('disabled', 'disabled');
                    $this.parent().hide();
                }
            }
        });
        return false;
    }

    function renderIsotope(container, $isotope, data, IsoButton) {

        var qsRegexG, buttonFilter;
        if (!buttonFilter) {
            buttonFilter = IsoButton.find('button.selected').data('filter');
        }

        $isotope.append(data)
            .isotope('appended', data)
            .isotope('reloadItems')
            .isotope('updateSortData');
        $isotope.imagesLoaded(function () {
            preFunction();
            $isotope.isotope();
        });

        $(IsoButton).on('click', 'button', function (e) {
            e.preventDefault();
            buttonFilter = $(this).attr('data-filter');
            $isotope.isotope();
            $(this).parent().find('.selected').removeClass('selected');
            $(this).addClass('selected');
            return false;
        });
        var $quicksearch = container.find('.iso-search-input').keyup(debounce(function () {
            qsRegexG = new RegExp($quicksearch.val(), 'gi');
            $isotope.isotope();
        }));
    }

    function scrollLoadMore($this, $isotope, container, layout, IsoButton, loaded_post_ids) {
        var viewportHeight = $(window).height();
        var scrollTop = $(window).scrollTop();
        var targetHeight = $this.offset().top + $this.outerHeight() - 50;
        var targetScroll = scrollTop + viewportHeight;
        
        if (targetScroll >= targetHeight) {
            var trigger = $this.attr("data-trigger");
            if (trigger == 1) {
                $this.attr("data-trigger", 0);
                var data = $("#pfp_sc_settings_meta").find('input[name],select[name],textarea[name]').serialize(),
                    foundPosts = parseInt($this.data("found-posts"), 10),
                    paged = parseInt($this.attr("data-paged"), 10),
                    data = data + "&foundPosts=" + foundPosts +"&paged=" + paged + "&action=pfpLoadMorePreview&" + pfp.nonceId + "=" + pfp.nonce;
                if (container.data("archive")) {
                    data = data + "&archive=" + container.data("archive");
                    if (container.data("archive-value")) {
                        data = data + "&archive-value=" + container.data("archive-value");
                    }
                }
                data = data + "&loaded_post_ids=" + loaded_post_ids;

                $.ajax({
                    type: "post",
                    url: pfp.ajaxurl,
                    data: data,
                    beforeSend: function () {
                        $this.html('<span class="more-loading">Loading ...</span>');
                    },
                    success: function (data) {
                        if (!data.error) {
                            if (layout == "isotope") {
                                renderIsotope(container, $isotope, data.data, IsoButton);
                            } else if (layout == "mLayout") {
                                $isotope.append(data.data).isotope('appended', data.data).isotope('updateSortData').isotope('reloadItems');
                                $isotope.imagesLoaded(function () {
                                    $isotope.isotope();
                                });
                            } else {
                                container.children(".pfp-row").append(data.data);
                                container.children(".pfp-row").imagesLoaded(function () {
                                    preFunction();
                                });
                            }
                            $this.html('');
                            $this.attr("data-trigger", 1);
                        } else {
                            $this.html('');
                            $this.attr("data-trigger", 0);
                        }
                    },
                    error: function (jqXHR, textStatus, errorThrown) {
                        container.find(".more-loading").remove();
                        alert(textStatus + ' (' + errorThrown + ')');
                    }
                });
            } // if trigger == 1

        }
    }

    function ajaxPagination(container, isotopeM) {
        
        $(".pfp-pagination.pfp-ajax ul li").on('click', 'a', function (e) {
            e.preventDefault();
            var data = $("#pfp_sc_settings_meta").find('input[name],select[name],textarea[name]').serialize(),
                $this = $(this),
                target = $this.parents("li"),
                parent = target.parents(".pfp-pagination.pfp-ajax"),
                activeLi = parent.find("li.active"),
                activeNumber = parseInt(activeLi.text(), 10),
                replaced = "<a data-paged='" + activeNumber + "' href='#'>" + activeNumber + "</a>",
                paged = $this.data("paged"),
                data = data + "&paged=" + paged + "&action=pfpLoadMorePreview&" + pfp.nonceId + "=" + pfp.nonce;
            activeLi.html(replaced);
            parent.find("li").removeClass("active");
            target.addClass("active");
            target.html("<span>" + paged + "</span>");

            if (container.data("archive")) {
                data = data + "&archive=" + container.data("archive");
                if (container.data("archive-value")) {
                    data = data + "&archive-value=" + container.data("archive-value");
                }
            }
            $.ajax({
                type: "post",
                url: pfp.ajaxurl,
                data: data,
                beforeSend: function () {
                    parent.append('<div class="pfp-loading-holder"><span class="more-loading">Loading ...</span></div>');
                },
                success: function (data) {

                    if (!data.error) {
                        if (typeof isotopeM === "undefined") {
                            container.children(".pfp-row").animate({opacity: 0});
                            container.children(".pfp-row").html(data.data);
                            container.children(".pfp-row").imagesLoaded(function () {
                                preFunction();
                                container.children(".pfp-row").animate({opacity: 1}, 1000);
                            });
                        } else {
                            container.children(".pfp-row").find(".masonry-grid-item").remove();
                            isotopeM.append(data.data).isotope('appended', data.data).isotope('updateSortData').isotope('reloadItems');
                            isotopeM.imagesLoaded(function () {
                                preFunction();
                                isotopeM.isotope();
                            });
                        }
                    } else {
                        alert(data.msg);
                    }
                    container.find(".pfp-loading-holder").remove();
                },
                error: function (jqXHR, textStatus, errorThrown) {
                    container.find(".pfp-loading-holder").remove();
                    alert(textStatus + ' (' + errorThrown + ')');
                }
            });
        });
    }

    function preFunction() {
        // HeightResize();
        // overlayIconResize();
    }
    // Unuse function . It will remove before production

    // debounce so filtering doesn't happen every millisecond
    function debounce(fn, threshold) {
        var timeout;
        return function debounced() {
            if (timeout) {
                clearTimeout(timeout);
            }
            function delayed() {
                fn();
                timeout = null;
            }

            setTimeout(delayed, threshold || 100);
        };
    }

    function pfpPreviewAjaxCall(element, action, arg, handle) {
        var data;
        if (action) data = "action=" + action;
        if (arg)    data = arg + "&action=" + action;
        if (arg && !action) data = arg;

        var n = data.search(pfp.nonceId);
        if (n < 0) {
            data = data + "&" + pfp.nonceId + "=" + pfp.nonce;
        }
        $.ajax({
            type: "post",
            url: pfp.ajaxurl,
            data: data,
            beforeSend: function () {
                $('#pfp_sc_preview_meta').addClass('loading');
                $('.pfp-response .spinner').addClass('is-active');
            },
            success: function (data) {
                $('#pfp_sc_preview_meta').removeClass('loading');
                $('.pfp-response .spinner').removeClass('is-active');
                handle(data);
            }
        });
    }

})(jQuery);