<?php
/**
 * Video Area Widget
 */

namespace Elementor;
class Kiedo_Video extends Widget_Base {

	public function get_name() {
        return 'Kiedo_Video';
    }

	public function get_title() {
        return __( 'Video Area', 'kiedo-toolkit' );
    }

	public function get_icon() {
        return 'eicon-video-camera';
    }

	public function get_categories() {
        return [ 'kiedo-elements' ];
    }

	protected function register_controls() {

        $this->start_controls_section(
			'Kiedo_Video_Area',
			[
				'label' => __( 'Video Area Controls', 'kiedo-toolkit' ),
				'tab' => Controls_Manager::TAB_CONTENT,
			]
		);

            $this->add_control(
                'style',
                [
                    'label' => esc_html__( 'Section Style', 'kiedo-toolkit' ),
                    'type' => Controls_Manager::SELECT,
                    'options' => [
                        '1'         => esc_html__( 'Style 1', 'kiedo-toolkit' ),
                        '2'         => esc_html__( 'Style 2', 'kiedo-toolkit' ),
                        '3'         => esc_html__( 'Style 3', 'kiedo-toolkit' ),
                    ],
                    'default' => '1',
                ]
            );

            $this->add_control(
                'top_title',
                [
                    'label' => esc_html__( 'Top Title', 'kiedo-toolkit' ),
                    'type' => Controls_Manager::TEXT,
                    'default' => esc_html__('APP PROGRESS', 'kiedo-toolkit'),
                    'condition' => [
                        'style' => ['2','3'],
                    ]
                ]
            );

            $this->add_control(
                'title',
                [
                    'label' => esc_html__( 'Title', 'kiedo-toolkit' ),
                    'type' => Controls_Manager::TEXTAREA,
                    'default' => esc_html__('Set Up The Challenges and Track Your Progress', 'kiedo-toolkit'),
                    'condition' => [
                        'style' => ['2','3'],
                    ]
                ]
            );

            $this->add_control(
                'title_tag',
                [
                    'label' => esc_html__( 'Title Tag', 'kiedo-toolkit' ),
                    'type' => Controls_Manager::SELECT,
                    'options' => [
                        'h1'         => esc_html__( 'h1', 'kiedo-toolkit' ),
                        'h2'         => esc_html__( 'h2', 'kiedo-toolkit' ),
                        'h3'         => esc_html__( 'h3', 'kiedo-toolkit' ),
                        'h4'         => esc_html__( 'h4', 'kiedo-toolkit' ),
                        'h5'         => esc_html__( 'h5', 'kiedo-toolkit' ),
                        'h6'         => esc_html__( 'h6', 'kiedo-toolkit' ),
                    ],
                    'default' => 'h2',
                    'condition' => [
                        'style' => ['2','3'],
                    ]
                ]
            );

            $this->add_control(
                'content',
                [
                    'label' => esc_html__( 'Content', 'kiedo-toolkit' ),
                    'type' => Controls_Manager::TEXTAREA,
                    'default' => esc_html__('Cloud based storage for your data backup just log in with your mail account from play store and using whatever you want for your business purpose orem ipsum dummy text. never missyour chance its just began. backup just log in with your mail account from.', 'kiedo-toolkit'),
                    'condition' => [
                        'style' => ['2','3'],
                    ]
                ]
            );

            $this->add_control(
				'button_text',
				[
					'label' 	=> esc_html__( 'Button Text', 'kiedo-toolkit' ),
					'type' 		=> Controls_Manager::TEXT,
					'default' 	=> esc_html__('Start Free Trial', 'kiedo-toolkit'),
                    'condition' => [
                        'style' => ['2','3'],
                    ]
				]
            );

            $this->add_control(
                'ex_link',
                [
                    'label'		=> esc_html__('Button Link', 'kiedo-toolkit'),
                    'type'		=> Controls_Manager:: TEXT,
                    'condition' => [
                        'style' => ['2','3'],
                    ]
                ]
            );

            $this->add_control(
                'image',
                [
                    'label' => __( 'Section Image', 'kiedo-toolkit' ),
                    'type' => Controls_Manager::MEDIA,
                ]
            );

            $this->add_control(
                'video_link',
                [
                    'label'		=> esc_html__('YouTube Video Link', 'kiedo-toolkit'),
                    'type'		=> Controls_Manager:: TEXT,
                    'default' => __('https://www.youtube.com/watch?v=PWvPbGWVRrU', 'kiedo-toolkit'),
                ]
            );

			$this->add_control(
				'shape1',
				[
					'label' => __( 'Shape Image 1', 'kiedo-toolkit' ),
					'type' => Controls_Manager::MEDIA,
				]
			);
			$this->add_control(
				'shape2',
				[
					'label' => __( 'Shape Image 2', 'kiedo-toolkit' ),
					'type' => Controls_Manager::MEDIA,
                    'condition' => [
                        'style!' => '3',
                    ]
				]
			);
        $this->end_controls_section();

        $this->start_controls_section(
			'section_style',
			[
				'label' => esc_html__( 'Style', 'kiedo-toolkit' ),
				'tab' => Controls_Manager::TAB_STYLE,
                'condition' => [
                    'style' => ['2','3'],
                ]
			]
        );

            $this->add_control(
                'title_color',
                [
                    'label' => esc_html__( 'Title Color', 'kiedo-toolkit' ),
                    'type' => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .intro-video-content h2, .intro-video-content h1, .intro-video-content h3, .intro-video-content h4, .intro-video-content h5, .intro-video-content h6, .app-intro-video-content h2, .app-intro-video-content h1, .app-intro-video-content h3, .app-intro-video-content h4, .app-intro-video-content h5, .app-intro-video-content h6' => 'color: {{VALUE}}',
                    ],
                ]
            );

            $this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'name' => 'title_typography',
                    'label' => __( 'Title Typography', 'kiedo-toolkit' ),
                    'selector' => '{{WRAPPER}} .intro-video-content h2, .intro-video-content h1, .intro-video-content h3, .intro-video-content h4, .intro-video-content h5, .intro-video-content h6, .app-intro-video-content h2, .app-intro-video-content h1, .app-intro-video-content h3, .app-intro-video-content h4, .app-intro-video-content h5, .app-intro-video-content h6',
                ]
            );

            $this->add_control(
                'content_color',
                [
                    'label' => esc_html__( 'Content Color', 'kiedo-toolkit' ),
                    'type' => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .intro-video-content p, .app-intro-video-content p' => 'color: {{VALUE}}',
                    ],
                ]
            );

            $this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'name' => 'content_typography',
                    'label' => __( 'Content Typography', 'kiedo-toolkit' ),
                    'selector' => '{{WRAPPER}} .intro-video-content p, .app-intro-video-content p',
                ]
            );
            $this->add_control(
                'btn_color',
                [
                    'label' => esc_html__( 'Button Color', 'kiedo-toolkit' ),
                    'type' => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .default-btn' => 'color: {{VALUE}}',
                    ],
                ]
            );
            $this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'name' => 'btn_typography',
                    'label' => __( 'Button Typography', 'kiedo-toolkit' ),
                    'selector' => '{{WRAPPER}} .default-btn',
                ]
            );
        $this->end_controls_section();

    }

	protected function render() {

		$settings = $this->get_settings_for_display();
		?>
        <?php if($settings['style'] == '1'): ?>
            <div class="video-area">
                <div class="container">
                    <div class="video-box">
                        <?php if($settings['image']['url']): ?>
                            <img src="<?php echo esc_url( $settings['image']['url'] ); ?>" alt="<?php echo esc_attr__('video-bg1', 'kiedo-toolkit'); ?>">
                        <?php endif; ?>

                        <?php if($settings['video_link']): ?>
                            <a href="<?php echo esc_url( $settings['video_link'] ); ?>" class="video-btn popup-video"><i class="ri-play-line"></i></a>
                        <?php endif; ?>

                        <div class="shape">
                            <?php if($settings['shape1']['url'] != ''): ?>
                                <div class="shape1">
                                    <img src="<?php echo esc_url( $settings['shape1']['url'] ); ?>" alt="<?php echo esc_attr__("Shape", "kiedo-toolkit"); ?>">
                                </div>
                            <?php endif; ?>

                            <?php if($settings['shape2']['url'] != ''): ?>
                                <div class="shape2">
                                    <img src="<?php echo esc_url( $settings['shape2']['url'] ); ?>" alt="<?php echo esc_attr__("Shape", "kiedo-toolkit"); ?>">
                                </div>
                            <?php endif; ?>
                        </div>
                    </div>
                </div>
            </div>
        <?php elseif($settings['style'] == '2'): ?>
            <div class="video-area ptb-100">
                <div class="container">
                    <div class="row align-items-center">
                        <div class="col-lg-6 col-md-12">
                            <div class="intro-video-content">
                                <span class="sub-title"><?php echo esc_html( $settings['top_title'] ); ?></span>
                                <<?php echo esc_attr( $settings['title_tag'] ); ?> <?php echo $this-> get_render_attribute_string('title'); ?>><?php echo esc_html( $settings['title'] ); ?></<?php echo esc_attr( $settings['title_tag'] ); ?>>

                                <p><?php echo wp_kses_post( $settings['content'] ); ?></p>

                                <?php if($settings['button_text']): ?>
                                    <a href="<?php echo esc_url($settings['ex_link']); ?>" class="default-btn"><?php echo esc_html($settings['button_text']); ?></a>
                                <?php endif; ?>
                            </div>
                        </div>
                        <div class="col-lg-6 col-md-12">
                            <div class="intro-video-box">
                                <?php if($settings['image']['url']): ?>
                                    <img src="<?php echo esc_url( $settings['image']['url'] ); ?>" alt="<?php echo esc_attr__('video-bg1', 'kiedo-toolkit'); ?>">
                                <?php endif; ?>

                                <?php if($settings['video_link']): ?>
                                    <a href="<?php echo esc_url( $settings['video_link'] ); ?>" class="video-btn popup-video"><i class="ri-play-line"></i></a>
                                <?php endif; ?>

                                <div class="shape">
                                    <?php if($settings['shape1']['url'] != ''): ?>
                                        <img src="<?php echo esc_url( $settings['shape1']['url'] ); ?>" alt="<?php echo esc_attr__("Shape", "kiedo-toolkit"); ?>" class="shape10" data-aos="fade-left">
                                    <?php endif; ?>

                                    <?php if($settings['shape2']['url'] != ''): ?>
                                        <img src="<?php echo esc_url( $settings['shape2']['url'] ); ?>" alt="<?php echo esc_attr__("Shape", "kiedo-toolkit"); ?>" class="shape11" data-aos="fade-right">
                                    <?php endif; ?>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        <?php elseif($settings['style'] == '3'): ?>
            <div class="app-video-area pb-100">
                <div class="container">
                    <div class="row align-items-center">
                        <div class="col-lg-6 col-md-12">
                            <div class="app-intro-video-box">
                                <?php if($settings['image']['url']): ?>
                                    <img src="<?php echo esc_url( $settings['image']['url'] ); ?>" alt="<?php echo esc_attr__('video', 'kiedo-toolkit'); ?>">
                                <?php endif; ?>

                                <?php if($settings['video_link']): ?>
                                    <a href="<?php echo esc_url( $settings['video_link'] ); ?>" class="video-btn popup-video"><i class="ri-play-line"></i></a>
                                <?php endif; ?>

                                <?php if($settings['shape1']['url'] != ''): ?>
                                    <div class="intro-video-shape">
                                        <img src="<?php echo esc_url( $settings['shape1']['url'] ); ?>" alt="<?php echo esc_attr__("Shape", "kiedo-toolkit"); ?>">
                                    </div>
                                <?php endif; ?>
                            </div>
                        </div>

                        <div class="col-lg-6 col-md-12">
                            <div class="app-intro-video-content">
                                <span class="sub-title"><?php echo esc_html( $settings['top_title'] ); ?></span>
                                <<?php echo esc_attr( $settings['title_tag'] ); ?> <?php echo $this-> get_render_attribute_string('title'); ?>><?php echo esc_html( $settings['title'] ); ?></<?php echo esc_attr( $settings['title_tag'] ); ?>>

                                <p><?php echo wp_kses_post( $settings['content'] ); ?></p>

                                <?php if($settings['button_text']): ?>
                                    <a href="<?php echo esc_url($settings['ex_link']); ?>" class="default-btn"><?php echo esc_html($settings['button_text']); ?></a>
                                <?php endif; ?>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        <?php endif; 
	}
}

Plugin::instance()->widgets_manager->register( new Kiedo_Video );