<?php
/**
 * Screenshots Logo Widget
 */

namespace Elementor;

// Exit if accessed directly
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

class Kiedo_Screenshots extends Widget_Base {

	public function get_name() {
        return 'Screenshots';
    }

	public function get_title() {
        return __( 'Screenshots', 'kiedo-toolkit' );
    }

	public function get_icon() {
        return 'eicon-image-rollover';
    }

	public function get_categories() {
        return [ 'kiedo-elements' ];
    }

	protected function register_controls() {

        $this->start_controls_section(
			'partner_section',
			[
				'label' => __( 'Gallery Logo Control', 'kiedo-toolkit' ),
				'tab' => Controls_Manager::TAB_CONTENT,
			]
        );

            $this->add_control(
                'style',
                [
                    'label' => esc_html__( 'Style', 'kiedo-toolkit' ),
                    'type' => Controls_Manager::SELECT,
                    'options' => [
                        '1'         => esc_html__( 'Style 1', 'kiedo-toolkit' ),
                        '2'         => esc_html__( 'Style 2', 'kiedo-toolkit' ),
                    ],
                    'default' => '1',
                ]
            );

           $this->add_control(
				'button_text',
				[
					'label' 	=> esc_html__( 'Button Text', 'kiedo-toolkit' ),
					'type' 		=> Controls_Manager::TEXT,
                    'condition' => [
                        'style' => '2',
                    ]
				]
            );

            $this->add_control(
                'link_type',
                [
                    'label' 		=> esc_html__( 'Left Button Link Type', 'kiedo-toolkit' ),
                    'type' 			=> Controls_Manager::SELECT,
                    'label_block' 	=> true,
                    'options' => [
                        '1'  	=> esc_html__( 'Link To Page', 'kiedo-toolkit' ),
                        '2' 	=> esc_html__( 'External Link', 'kiedo-toolkit' ),
                    ],
                    'condition' => [
                        'style' => '2',
                    ]
                ]
            );

            $this->add_control(
                'link_to_page',
                [
                    'label' 		=> esc_html__( 'Button Link Page', 'kiedo-toolkit' ),
                    'type' 			=> Controls_Manager::SELECT,
                    'label_block' 	=> true,
                    'options' 		=> kiedo_toolkit_get_page_as_list(),
                    'condition' => [
                        'link_type' => '1',
                    ]
                ]
            );

            $this->add_control(
                'ex_link',
                [
                    'label'		=> esc_html__('Button External Link', 'kiedo-toolkit'),
                    'type'		=> Controls_Manager:: TEXT,
                    'condition' => [
                        'link_type' => '2',
                    ]
                ]
            );
            $this->add_control(
                'gallery',
                [
                    'label' => __( 'Add Images', 'kiedo-toolkit' ),
                    'type' =>Controls_Manager::GALLERY,
                ]
            );

        $this->end_controls_section();

    }

	protected function render() {
        $settings = $this->get_settings_for_display();
        ?>
        <?php if($settings['style'] == '1'): ?>
            <div class="container">
                <div class="screenshots-slides owl-carousel owl-theme">
                    <?php foreach ( $settings['gallery'] as $image ) { ?>
                        <div class="single-screenshot-item">
                            <a data-elementor-open-lightbox="yes" data-elementor-lightbox-slideshow="a0b6fgfgfg8f5" href="<?php echo esc_url($image['url']); ?>">
                                <img src="<?php echo esc_url($image['url']); ?>" alt="<?php echo esc_attr__('Gallery Image', 'kiedo-toolkit'); ?>">
                            </a>
                        </div>
                    <?php } ?>
                </div>
            </div>
        <?php elseif($settings['style'] == '2'):
            // Get Button Link
            if($settings['link_type'] == 1){
                $link = get_page_link( $settings['link_to_page'] );
            } else {
                $link = $settings['ex_link'];
            }
            ?>
            <div class="container">
                <div class="swiper-container swiper screenshots-swiper-slides">
                    <div class="swiper-wrapper">
                        <?php foreach ( $settings['gallery'] as $image ) { ?>
                            <div class="swiper-slide">
                                <img src="<?php echo esc_url($image['url']); ?>" alt="<?php echo esc_attr__('Gallery Image', 'kiedo-toolkit'); ?>">
                            </div>
                        <?php } ?>
                    </div>
                    <div class="swiper-button-next" data-aos="fade-right"></div>
                    <div class="swiper-button-prev" data-aos="fade-left"></div>

                    <?php if( $settings['button_text'] != '' ): ?>
                        <div class="free-trial-btn">
                            <a href="<?php echo esc_url( $link ); ?>" class="default-btn"><?php echo esc_html( $settings['button_text'] ); ?></a>
                        </div>
                    <?php endif; ?>
                </div>
            </div>
        <?php endif; ?>
        <?php
	}

}

Plugin::instance()->widgets_manager->register( new Kiedo_Screenshots );