<?php
/**
 * Pricing Table Widget
 */

namespace Elementor;
class Kiedo_Pricing_Table extends Widget_Base {

	public function get_name() {
        return 'Kiedo_Pricing_Table';
    }

	public function get_title() {
        return __( 'Pricing Table', 'kiedo-toolkit' );
    }

	public function get_icon() {
        return 'eicon-price-table';
    }

	public function get_categories() {
        return [ 'kiedo-elements' ];
    }

	protected function register_controls() {

        $this->start_controls_section(
			'Kiedo_Pricing_Table_Area',
			[
				'label' => __( 'Pricing Controls', 'kiedo-toolkit' ),
				'tab' => Controls_Manager::TAB_CONTENT,
			]
        );
            $this->add_control(
                'style',
                [
                    'label' => esc_html__( 'Section Style', 'kiedo-toolkit' ),
                    'type' => Controls_Manager::SELECT,
                    'options' => [
                        '1'         => esc_html__( 'Style 1', 'kiedo-toolkit' ),
                        '2'         => esc_html__( 'Style 2', 'kiedo-toolkit' ),
                        '3'         => esc_html__( 'Style 3', 'kiedo-toolkit' ),
                    ],
                    'default' => '1',
                ]
            );

            $this->add_control(
                'white_content',
                [
                    'label' => __( 'White Content', 'kiedo-toolkit' ),
                    'type' =>Controls_Manager::SWITCHER,
                    'label_on' => __( 'Yes', 'kiedo-toolkit' ),
                    'label_off' => __( 'No', 'kiedo-toolkit' ),
                    'return_value' => 'yes',
                    'default' => 'no',
                    'condition' => [
                        'style' => '2',
                    ]
                ]
            );

            $this->add_control(
                'with_border',
                [
                    'label' => __( 'Pricing Table With Border', 'kiedo-toolkit' ),
                    'type' =>Controls_Manager::SWITCHER,
                    'label_on' => __( 'Yes', 'kiedo-toolkit' ),
                    'label_off' => __( 'No', 'kiedo-toolkit' ),
                    'return_value' => 'yes',
                    'default' => 'no',
                    'condition' => [
                        'style' => '1',
                    ]
                ]
            );
            $this->add_control(
                'bg_title',
                [
                    'label' => __( 'Background Text', 'kiedo-toolkit' ),
                    'type' => Controls_Manager::TEXT,
                    'condition' => [
                        'style' => '3',
                    ]
                ]
            );
            $this->add_control(
                'top_title',
                [
                    'label' => __( 'Top Title', 'kiedo-toolkit' ),
                    'type' => Controls_Manager::TEXT,
                ]
            );

            $this->add_control(
                'title',
                [
                    'label' => __( 'Title', 'kiedo-toolkit' ),
                    'type' => Controls_Manager::TEXT,
                    'default' => __('Our Featured Services', 'kiedo-toolkit'),
                ]
            );

            $this->add_control(
                'title_tag',
                [
                    'label' => esc_html__( 'Title Tag', 'kiedo-toolkit' ),
                    'type' => Controls_Manager::SELECT,
                    'options' => [
                        'h1'         => esc_html__( 'h1', 'kiedo-toolkit' ),
                        'h2'         => esc_html__( 'h2', 'kiedo-toolkit' ),
                        'h3'         => esc_html__( 'h3', 'kiedo-toolkit' ),
                        'h4'         => esc_html__( 'h4', 'kiedo-toolkit' ),
                        'h5'         => esc_html__( 'h5', 'kiedo-toolkit' ),
                        'h6'         => esc_html__( 'h6', 'kiedo-toolkit' ),
                    ],
                    'default' => 'h2',
                ]
            );

            $this->add_control(
                'first_tab_title',
                [
                    'label' => __( 'First Tab Title', 'kiedo-toolkit' ),
                    'type' => Controls_Manager::TEXT,
                    'default' => __('Monthly', 'kiedo-toolkit'),
                    'condition' => [
                        'style' => '1',
                    ]
                ]
            );

            $this->add_control(
                'second_tab_title',
                [
                    'label' => __( 'Second Tab Title', 'kiedo-toolkit' ),
                    'type' => Controls_Manager::TEXT,
                    'default' => __('Yearly', 'kiedo-toolkit'),
                    'condition' => [
                        'style' => '1',
                    ]
                ]
            );

            $this->add_control(
                'hide_tab',
                [
                    'label' => __( 'Tab', 'kiedo-toolkit' ),
                    'type' =>Controls_Manager::SWITCHER,
                    'label_on' => __( 'Show', 'kiedo-toolkit' ),
                    'label_off' => __( 'Hide', 'kiedo-toolkit' ),
                    'return_value' => 'yes',
                    'default' => 'no',
                    'condition' => [
                        'style' => '1',
                    ]
                ]
            );

            $pricing_items = new Repeater();

            $pricing_items->add_control(
                'featured',
                [
                    'label' => __( 'Featured?', 'kiedo-toolkit' ),
                    'type' =>Controls_Manager::SWITCHER,
                    'label_on' => __( 'Yes', 'kiedo-toolkit' ),
                    'label_off' => __( 'No', 'kiedo-toolkit' ),
                    'return_value' => 'yes',
                    'default' => 'no',
                ]
            );

            $pricing_items->add_control(
                'featured_title',
                [
                    'label' => __( 'Featured Title', 'kiedo-toolkit' ),
                    'type' => Controls_Manager::TEXT,
                    'default' => __('Most Popular', 'kiedo-toolkit'),
                    'condition' => [
                        'featured' => 'yes',
                    ]
                ]
            );

            $pricing_items->add_control(
                'title',
                [
                    'label' => __( 'Title', 'kiedo-toolkit' ),
                    'type' => Controls_Manager::TEXT,
                    'default' => __('Small Team', 'kiedo-toolkit'),
                ]
            );

            $pricing_items->add_control(
                'short_desc',
                [
                    'label' => __( 'Short Description', 'kiedo-toolkit' ),
                    'type' => Controls_Manager::TEXT,
                    'default' => __('Powerful & Awesome Elements', 'kiedo-toolkit'),
                ]
            );

            $pricing_items->add_control(
                'price_prefix',
                [
                    'label' => __( 'Price Prefix', 'kiedo-toolkit' ),
                    'type' => Controls_Manager::TEXT,
                    'default' => __('$', 'kiedo-toolkit'),
                ]
            );

            $pricing_items->add_control(
                'price',
                [
                    'label' => __( 'Price', 'kiedo-toolkit' ),
                    'type' => Controls_Manager::TEXT,
                    'default' => __('49', 'kiedo-toolkit'),
                ]
            );

            $pricing_items->add_control(
                'price_suffix',
                [
                    'label' => __( 'Number Suffix', 'kiedo-toolkit' ),
                    'type' => Controls_Manager::TEXT,
                    'default' => __('/Month', 'kiedo-toolkit'),
                ]
            );

            $pricing_items->add_control(
                'button',
                [
                    'label' => __( 'Button Text', 'kiedo-toolkit' ),
                    'type' => Controls_Manager::TEXT,
                    'default' => __('Purchase Plan', 'kiedo-toolkit'),
                ]
            );

            $pricing_items->add_control(
                'button_link',
                [
                    'label' => __( 'Button Link', 'kiedo-toolkit' ),
                    'type' => Controls_Manager::URL,
                ]
            );

            $pricing_items->add_control(
                'features',
                [
                    'label' => __( 'Features', 'kiedo-toolkit' ),
                    'type' => Controls_Manager::TEXTAREA,
                    'default' => '<li><i class="ri-check-line"></i> Up to 10 Website</li>',
                ]
            );
            $this->add_control(
                'first_list_items',
                [
                    'label' => __( 'First Tab Items', 'kiedo-toolkit' ),
                    'type' => Controls_Manager::REPEATER,
                    'fields' => $pricing_items->get_controls(),
                    'title_field' => '{{{ title }}}',
                ]
            );

            $second_pricing_items = new Repeater();

            $second_pricing_items->add_control(
                'featured',
                [
                    'label' => __( 'Featured?', 'kiedo-toolkit' ),
                    'type' =>Controls_Manager::SWITCHER,
                    'label_on' => __( 'Yes', 'kiedo-toolkit' ),
                    'label_off' => __( 'No', 'kiedo-toolkit' ),
                    'return_value' => 'yes',
                    'default' => 'no',
                ]
            );

            $second_pricing_items->add_control(
                'featured_title',
                [
                    'label' => __( 'Featured Title', 'kiedo-toolkit' ),
                    'type' => Controls_Manager::TEXT,
                    'default' => __('Most Popular', 'kiedo-toolkit'),
                    'condition' => [
                        'featured' => 'yes',
                    ]
                ]
            );

            $second_pricing_items->add_control(
                'title',
                [
                    'label' => __( 'Title', 'kiedo-toolkit' ),
                    'type' => Controls_Manager::TEXT,
                    'default' => __('Small Team', 'kiedo-toolkit'),
                ]
            );

            $second_pricing_items->add_control(
                'short_desc',
                [
                    'label' => __( 'Short Description', 'kiedo-toolkit' ),
                    'type' => Controls_Manager::TEXT,
                    'default' => __('Powerful & Awesome Element', 'kiedo-toolkit'),
                ]
            );

            $second_pricing_items->add_control(
                'price_prefix',
                [
                    'label' => __( 'Price Prefix', 'kiedo-toolkit' ),
                    'type' => Controls_Manager::TEXT,
                    'default' => __('$', 'kiedo-toolkit'),
                ]
            );

            $second_pricing_items->add_control(
                'price',
                [
                    'label' => __( 'Price', 'kiedo-toolkit' ),
                    'type' => Controls_Manager::TEXT,
                    'default' => __('249', 'kiedo-toolkit'),
                ]
            );

            $second_pricing_items->add_control(
                'price_suffix',
                [
                    'label' => __( 'Number Suffix', 'kiedo-toolkit' ),
                    'type' => Controls_Manager::TEXT,
                    'default' => __('/Yearly', 'kiedo-toolkit'),
                ]
            );

            $second_pricing_items->add_control(
                'button',
                [
                    'label' => __( 'Button Text', 'kiedo-toolkit' ),
                    'type' => Controls_Manager::TEXT,
                    'default' => __('Purchase Now', 'kiedo-toolkit'),
                ]
            );

            $second_pricing_items->add_control(
                'button_link',
                [
                    'label' => __( 'Button Link', 'kiedo-toolkit' ),
                    'type' => Controls_Manager::URL,
                ]
            );

            $second_pricing_items->add_control(
                'features',
                [
                    'label' => __( 'Features', 'kiedo-toolkit' ),
                    'type' => Controls_Manager::TEXTAREA,
                    'default' => '<li><i class="ri-check-line"></i> Up to 10 Website</li>',
                ]
            );
            $this->add_control(
                'second_list_items',
                [
                    'label' => __( 'Second Tab Items', 'kiedo-toolkit' ),
                    'type' => Controls_Manager::REPEATER,
                    'fields' => $second_pricing_items->get_controls(),
                    'title_field' => '{{{ title }}}',
                    'condition' => [
                        'style' => '1',
                    ]
                ]
            );

            $this->add_control(
                'shape1',
                [
                    'label' => __( 'Shape 1', 'kiedo-toolkit' ),
                    'type' => Controls_Manager::MEDIA,
                    'condition' => [
                        'style!' => '3',
                    ]
                ]
            );
            $this->add_control(
                'shape2',
                [
                    'label' => __( 'Shape 2', 'kiedo-toolkit' ),
                    'type' => Controls_Manager::MEDIA,
                    'condition' => [
                        'style!' => '3',
                    ]
                ]
            );

            $this->add_control(
				'button_text',
				[
					'label' 	=> esc_html__( 'Button Text', 'kiedo-toolkit' ),
					'type' 		=> Controls_Manager::TEXT,
					'default' 	=> esc_html__('See All Pricing Plan', 'kiedo-toolkit'),
				]
            );

            $this->add_control(
                'link_type',
                [
                    'label' 		=> esc_html__( 'Button Link Type', 'kiedo-toolkit' ),
                    'type' 			=> Controls_Manager::SELECT,
                    'label_block' 	=> true,
                    'options' => [
                        '1'  	=> esc_html__( 'Link To Page', 'kiedo-toolkit' ),
                        '2' 	=> esc_html__( 'External Link', 'kiedo-toolkit' ),
                    ],
                ]
            );

            $this->add_control(
                'link_to_page',
                [
                    'label' 		=> esc_html__( 'Button Link Page', 'kiedo-toolkit' ),
                    'type' 			=> Controls_Manager::SELECT,
                    'label_block' 	=> true,
                    'options' 		=> kiedo_toolkit_get_page_as_list(),
                    'condition' => [
                        'link_type' => '1',
                    ]
                ]
            );

            $this->add_control(
                'ex_link',
                [
                    'label'		=> esc_html__('Button External Link', 'kiedo-toolkit'),
                    'type'		=> Controls_Manager:: TEXT,
                    'condition' => [
                        'link_type' => '2',
                    ]
                ]
            );
        $this->end_controls_section();

        $this->start_controls_section(
			'section_style',
			[
				'label' => __( 'Style', 'kiedo-toolkit' ),
				'tab' => Controls_Manager::TAB_STYLE,
			]
        );
            $this->add_control(
                'top_title_color',
                [
                    'label' => __( 'Top Title Color', 'kiedo-toolkit' ),
                    'type' => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .pricing-section-title .sub-title, .section-title .sub-title' => 'color: {{VALUE}}',
                    ],
                ]
            );

            $this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'name' => 'top_title_typography',
                    'label' => __( 'Top Title Typography', 'kiedo-toolkit' ),
                    'scheme' => Core\Schemes\Typography::TYPOGRAPHY_1,
                    'selector' => '{{WRAPPER}} .pricing-section-title .sub-title, .section-title .sub-title',
                ]
            );

			$this->add_control(
				'title_color',
				[
					'label' => __( 'Title Color', 'kiedo-toolkit' ),
					'type' => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .pricing-section-title h2, .section-title h2' => 'color: {{VALUE}}',
					],
				]
			);

            $this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'name' => 'title_typography',
                    'label' => __( 'Title Typography', 'kiedo-toolkit' ),
                    'scheme' => Core\Schemes\Typography::TYPOGRAPHY_1,
                    'selector' => '{{WRAPPER}} .pricing-section-title h2, .section-title h2',
                ]
            );

            $this->add_control(
				'card_title_color',
				[
					'label' => __( 'Pricing Title Color', 'kiedo-toolkit' ),
					'type' => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .single-pricing-table .title h3, .single-app-pricing-box .title h3' => 'color: {{VALUE}}',
					],
				]
			);

            $this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'name' => 'pricing_title_typography',
                    'label' => __( 'Pricing Typography', 'kiedo-toolkit' ),
                    'scheme' => Core\Schemes\Typography::TYPOGRAPHY_1,
                    'selector' => '{{WRAPPER}} .single-pricing-table .title h3, .single-app-pricing-box .title h3',
                ]
            );

            $this->add_control(
				'short_desc_color',
				[
					'label' => __( 'Short Description Color', 'kiedo-toolkit' ),
					'type' => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .single-pricing-table .title p, .single-app-pricing-box .title p' => 'color: {{VALUE}}',
					],
				]
			);

			$this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'name' => 'short_desc_typography',
                    'label' => __( 'Short Description Typography', 'kiedo-toolkit' ),
                    'scheme' => Core\Schemes\Typography::TYPOGRAPHY_1,
                    'selector' => '{{WRAPPER}} .single-pricing-table .title p, .single-app-pricing-box .title p',
                ]
            );

            $this->add_control(
				'price_color',
				[
					'label' => __( 'Price Color', 'kiedo-toolkit' ),
					'type' => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .single-pricing-table .price, .single-app-pricing-box .price' => 'color: {{VALUE}}',
					],
				]
			);

            $this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'name' => 'price_typography',
                    'label' => __( 'Price Typography', 'kiedo-toolkit' ),
                    'scheme' => Core\Schemes\Typography::TYPOGRAPHY_1,
                    'selector' => '{{WRAPPER}} .single-pricing-table .price, .single-app-pricing-box .price',
                ]
            );

            $this->add_control(
				'suf_color',
				[
					'label' => __( 'Price Suffix Color', 'kiedo-toolkit' ),
					'type' => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} ..single-pricing-table .price span, .single-app-pricing-box .price span' => 'color: {{VALUE}}',
					],
				]
			);

			$this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'name' => 'price_suf_typography',
                    'label' => __( 'Price Suffix Typography', 'kiedo-toolkit' ),
                    'scheme' => Core\Schemes\Typography::TYPOGRAPHY_1,
                    'selector' => '{{WRAPPER}} ..single-pricing-table .price span, .single-app-pricing-box .price span',
                ]
            );

            $this->add_control(
				'list_color',
				[
					'label' => __( 'List Color', 'kiedo-toolkit' ),
					'type' => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .single-pricing-table .features-list li, .single-app-pricing-box .features-list li' => 'color: {{VALUE}}',
					],
				]
			);
            $this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'name' => 'list_typography',
                    'label' => __( 'List Typography', 'kiedo-toolkit' ),
                    'scheme' => Core\Schemes\Typography::TYPOGRAPHY_1,
                    'selector' => '{{WRAPPER}} .single-pricing-table .features-list li, .single-app-pricing-box .features-list li',
                ]
            );
        $this->end_controls_section();

    }

	protected function render() {

        $settings = $this->get_settings_for_display();

        // Get Button Link
        if($settings['link_type'] == 1){
            $link = get_page_link( $settings['link_to_page'] );
        } else {
            $link = $settings['ex_link'];
        }
        ?>

        <?php if($settings['style'] == '1'): ?>
            <div class="container">
                <div class="pricing-tabs">
                    <div class="row align-items-center">
                        <div class="col-lg-4 col-md-12">
                            <div class="pricing-section-title <?php if($settings['with_border'] == 'yes'): echo "black-color"; endif; ?>">
                                <?php if( $settings['top_title'] != '' ): ?>
                                    <span class="sub-title"><?php echo wp_kses_post( $settings['top_title'] ); ?></span>
                                <?php endif; ?>
                                <h2 <?php echo $this-> get_render_attribute_string('title'); ?>><?php echo esc_html( $settings['title'] ); ?></h2>

                                <?php if( $settings['hide_tab'] == 'yes' ): ?>
                                    <nav>
                                        <div class="nav nav-tabs" id="nav-tab" role="tablist">
                                            <?php if( $settings['first_tab_title'] != '' ): ?>
                                                <button class="nav-link active" id="nav-monthly-tab" data-bs-toggle="tab" data-bs-target="#nav-monthly" type="button" role="tab" aria-controls="nav-monthly" aria-selected="true"><?php echo esc_html( $settings['first_tab_title'] ); ?></button>
                                            <?php endif; ?>

                                            <?php if( $settings['second_tab_title'] != '' ): ?>
                                                <button class="nav-link" id="nav-yearly-tab" data-bs-toggle="tab" data-bs-target="#nav-yearly" type="button" role="tab" aria-controls="nav-yearly" aria-selected="false"><?php echo esc_html( $settings['second_tab_title'] ); ?></button>
                                            <?php endif; ?>
                                        </div>
                                    </nav>
                                <?php endif; ?>
                            </div>
                        </div>
                        <div class="col-lg-8 col-md-12">
                            <div class="tab-content" id="nav-tabContent">
                                <div class="tab-pane fade show active" id="nav-monthly" role="tabpanel">
                                    <div class="row">
                                        <?php foreach( $settings['first_list_items'] as $item ): ?>
                                            <div class="col-lg-6 col-md-6 col-sm-6">
                                                <div class="single-pricing-table <?php if($settings['with_border'] == 'yes'): echo "with-border"; endif; ?>">
                                                    <div class="title">
                                                        <h3><?php echo wp_kses_post( $item['title'] ); ?></h3>
                                                        <p><?php echo $item['short_desc']; ?></p>
                                                    </div>

                                                    <?php if($item['featured'] == 'yes'): ?>
                                                        <span class="popular"><?php echo esc_html( $item['featured_title'] ); ?></span>
                                                    <?php endif; ?>

                                                    <div class="price">
                                                        <?php echo esc_html( $item['price_prefix'] ); ?><?php echo esc_html( $item['price'] ); ?> <span><?php echo esc_html( $item['price_suffix'] ); ?></span>
                                                    </div>

                                                    <?php if( $item['button'] != '' ): ?>
                                                        <a href="<?php echo esc_url( $item['button_link']['url'] ); ?>" class="default-btn"><?php echo esc_html( $item['button'] ); ?></a>
                                                    <?php endif; ?>

                                                    <ul class="features-list">
                                                        <?php echo wp_kses_post( $item['features'] ); ?>
                                                    </ul>
                                                </div>
                                            </div>
                                        <?php endforeach; ?>
                                    </div>
                                </div>

                                <?php if( $settings['second_tab_title'] != '' ): ?>
                                    <div class="tab-pane fade" id="nav-yearly" role="tabpanel">
                                        <div class="row">
                                            <?php foreach( $settings['second_list_items'] as $item ): ?>
                                                <div class="col-lg-6 col-md-6 col-sm-6">
                                                    <div class="single-pricing-table <?php if($settings['with_border'] == 'yes'): echo "with-border"; endif; ?>">
                                                        <div class="title">
                                                            <h3><?php echo wp_kses_post( $item['title'] ); ?></h3>
                                                            <p><?php echo $item['short_desc']; ?></p>
                                                        </div>

                                                        <?php if($item['featured'] == 'yes'): ?>
                                                            <span class="popular"><?php echo esc_html( $item['featured_title'] ); ?></span>
                                                        <?php endif; ?>

                                                        <div class="price">
                                                            <?php echo esc_html( $item['price_prefix'] ); ?><?php echo esc_html( $item['price'] ); ?> <span><?php echo esc_html( $item['price_suffix'] ); ?></span>
                                                        </div>

                                                        <?php if( $item['button'] != '' ): ?>
                                                            <a href="<?php echo esc_url( $item['button_link']['url'] ); ?>" class="default-btn"><?php echo esc_html( $item['button'] ); ?></a>
                                                        <?php endif; ?>

                                                        <ul class="features-list">
                                                            <?php echo wp_kses_post( $item['features'] ); ?>
                                                        </ul>
                                                    </div>
                                                </div>
                                            <?php endforeach; ?>
                                        </div>
                                    </div>
                                <?php endif; ?>
                            </div>
                        </div>

                        <?php if( $settings['button_text'] != '' ): ?>
                            <div class="col-lg-12 col-md-12">
                                <div class="see-more-pricing">
                                    <a href="<?php echo esc_url( $link ); ?>" class="link-btn"><?php echo esc_html( $settings['button_text'] ); ?></a>
                                </div>
                            </div>
                        <?php endif; ?>

                    </div>
                </div>
            </div>

            <?php if( $settings['shape1']['url'] != '' ): ?>
                <div class="shape7"><img src="<?php echo esc_url( $settings['shape1']['url'] ); ?>" alt="<?php echo esc_attr__( 'shape image', 'kiedo-toolkit' ); ?>"></div>
            <?php endif; ?>

            <?php if( $settings['shape2']['url'] != '' ): ?>
                <div class="shape8"><img src="<?php echo esc_url( $settings['shape2']['url'] ); ?>" alt="<?php echo esc_attr__( 'shape image', 'kiedo-toolkit' ); ?>"></div>
            <?php endif; ?>
        <?php elseif($settings['style'] == '2'): ?>
            <div class="container">
                <div class="section-title <?php if($settings['white_content'] == 'yes'): echo "color-white"; endif; ?>">
                    <?php if( $settings['top_title'] != '' ): ?>
                        <span class="sub-title"><?php echo wp_kses_post( $settings['top_title'] ); ?></span>
                    <?php endif; ?>
                    <h2 <?php echo $this-> get_render_attribute_string('title'); ?>><?php echo esc_html( $settings['title'] ); ?></h2>
                </div>
                <div class="row align-items-center justify-content-center">
                    <?php foreach( $settings['first_list_items'] as $item ): ?>
                        <div class="col-lg-4 col-md-6 col-sm-6">
                            <div class="single-pricing-box">
                                <div class="title">
                                    <h3><?php echo wp_kses_post( $item['title'] ); ?></h3>
                                    <p><?php echo $item['short_desc']; ?></p>
                                </div>

                                <?php if($item['featured'] == 'yes'): ?>
                                    <span class="popular"><?php echo esc_html( $item['featured_title'] ); ?></span>
                                <?php endif; ?>

                                <div class="price">
                                    <?php echo esc_html( $item['price_prefix'] ); ?><?php echo esc_html( $item['price'] ); ?> <span><?php echo esc_html( $item['price_suffix'] ); ?></span>
                                </div>

                                <?php if( $item['button'] != '' ): ?>
                                    <a href="<?php echo esc_url( $item['button_link']['url'] ); ?>" class="default-btn"><?php echo esc_html( $item['button'] ); ?></a>
                                <?php endif; ?>

                                <ul class="features-list">
                                    <?php echo wp_kses_post( $item['features'] ); ?>
                                </ul>
                            </div>
                        </div>
                    <?php endforeach; ?>

                    <?php if( $settings['button_text'] != '' ): ?>
                        <div class="col-lg-12 col-md-12">
                            <div class="see-more-pricing">
                                <a href="<?php echo esc_url( $link ); ?>" class="default-btn"><?php echo esc_html( $settings['button_text'] ); ?></a>
                            </div>
                        </div>
                    <?php endif; ?>
                </div>
            </div>

            <?php if( $settings['shape1']['url'] != '' ): ?>
                <div class="shape12"><img src="<?php echo esc_url( $settings['shape1']['url'] ); ?>" alt="<?php echo esc_attr__( 'shape image', 'kiedo-toolkit' ); ?>"></div>
            <?php endif; ?>

            <?php if( $settings['shape2']['url'] != '' ): ?>
                <div class="shape13"><img src="<?php echo esc_url( $settings['shape2']['url'] ); ?>" alt="<?php echo esc_attr__( 'shape image', 'kiedo-toolkit' ); ?>"></div>
            <?php endif; ?>

        <?php elseif($settings['style'] == '3'): ?>
            <div class="container">
                <div class="section-title title-with-bg-text">
                    <?php if( $settings['bg_title'] != '' ): ?>
                        <div class="big-title"><?php echo wp_kses_post( $settings['bg_title'] ); ?></div>
                    <?php endif; ?>
                    <?php if( $settings['top_title'] != '' ): ?>
                        <span class="sub-title"><?php echo wp_kses_post( $settings['top_title'] ); ?></span>
                    <?php endif; ?>
                    <h2 <?php echo $this-> get_render_attribute_string('title'); ?>><?php echo esc_html( $settings['title'] ); ?></h2>
                </div>

                <div class="row justify-content-center">
                    <?php foreach( $settings['first_list_items'] as $item ): ?>
                        <div class="col-lg-4 col-md-6 col-sm-6">
                            <div class="single-app-pricing-box 
                                <?php if($item['featured'] == 'yes'): ?> active <?php endif; ?>">
                                <div class="title">
                                    <h3><?php echo wp_kses_post( $item['title'] ); ?></h3>
                                    <p><?php echo $item['short_desc']; ?></p>
                                </div>

                                <?php if($item['featured'] == 'yes'): ?>
                                    <span class="popular"><?php echo esc_html( $item['featured_title'] ); ?></span>
                                <?php endif; ?>

                                <div class="price">
                                    <?php echo esc_html( $item['price_prefix'] ); ?><?php echo esc_html( $item['price'] ); ?> <span><?php echo esc_html( $item['price_suffix'] ); ?></span>
                                </div>

                                <?php if( $item['button'] != '' ): ?>
                                    <div class="pricing-btn">
                                        <a href="<?php echo esc_url( $item['button_link']['url'] ); ?>" class="default-btn"><?php echo esc_html( $item['button'] ); ?></a>
                                    </div>
                                <?php endif; ?>

                                <ul class="features-list">
                                    <?php echo wp_kses_post( $item['features'] ); ?>
                                </ul>
                            </div>
                        </div>
                    <?php endforeach; ?>
                </div>

                <?php if( $settings['button_text'] != '' ): ?>
                    <div class="app-pricing-bottom-text">
                        <a href="<?php echo esc_url( $link ); ?>"><?php echo esc_html( $settings['button_text'] ); ?></a>
                    </div>
                <?php endif; ?>
            </div>
        <?php endif; ?>
        <?php
    }
}

Plugin::instance()->widgets_manager->register( new Kiedo_Pricing_Table );