<?php
/**
 * How It Works Widget
 */

namespace Elementor;
class Kiedo_HIW extends Widget_Base {

	public function get_name() {
        return 'HowItWorks';
    }

	public function get_title() {
        return __( 'How It Works', 'kiedo-toolkit' );
    }

	public function get_icon() {
        return 'eicon-gallery-group';
    }

	public function get_categories() {
        return [ 'kiedo-elements' ];
    }

	protected function register_controls() {

        $this->start_controls_section(
			'content_section',
			[
				'label' => __( 'Content', 'kiedo-toolkit' ),
				'tab' => Controls_Manager::TAB_CONTENT,
			]
        );

        $list_items = new Repeater();

        $list_items->add_control(
            'image',
            [
                'label' => __( 'Image', 'kiedo-toolkit' ),
                'type' => Controls_Manager::MEDIA,
            ]
        );
        $list_items->add_control(
            'number',
            [
                'label' => esc_html__('Number', 'kiedo-toolkit'),
                'type' => Controls_Manager::TEXT,
                'default' => esc_html__('1', 'kiedo-toolkit'),
                'label_block' => true,
            ]
        );
        $list_items->add_control(
            'title',
            [
                'label' => esc_html__('Title', 'kiedo-toolkit'),
                'type' => Controls_Manager::TEXT,
                'default' => esc_html__('Step 1', 'kiedo-toolkit'),
                'label_block' => true,
            ]
        );
        $list_items->add_control(
            'sub_title',
            [
                'label' => esc_html__('Sub Title', 'kiedo-toolkit'),
                'type' => Controls_Manager::TEXT,
                'default' => esc_html__('Create a Kiedo Account', 'kiedo-toolkit'),
                'label_block' => true,
            ]
        );
        $list_items->add_control(
            'content',
            [
                'label' => esc_html__('Content', 'kiedo-toolkit'),
                'type' => Controls_Manager::TEXTAREA,
                'default' => esc_html__('Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco consectetur adipiscing.', 'kiedo-toolkit'),
                'label_block' => true,
            ]
        );
        $this->add_control(
            'items',
            [
                'label' => esc_html__('List Item', 'kiedo-toolkit'),
                'type' => Controls_Manager::REPEATER,
                'default' => [
                    [ 'name' => esc_html__(' Item #1', 'kiedo-toolkit') ],

                ],
                'fields' => $list_items->get_controls(),
            ]
        );
    $this->end_controls_section();
    }

	protected function render() {

        $settings = $this->get_settings_for_display();

        $items = $settings['items'];
        ?>

        <?php $count = 0;
        foreach ( $items as $key => $value ) {
            $count++;
        } ?>

        <div class="how-it-works-area ptb-100">
            <div class="container">
                <?php foreach ( $items as $key => $value ) { ?>
                    <div class="how-it-works-content">
                        <div class="number"><?php echo esc_html( $value['number'] ); ?></div>
                        <div class="row m-0">
                            <div class="col-lg-3 col-md-12 p-0">
                                <div class="box">
                                    <h3><?php echo esc_html( $value['title'] ); ?></h3>
                                    <span><?php echo esc_html( $value['sub_title'] ); ?></span>
                                </div>
                            </div>
                            <div class="col-lg-9 col-md-12 p-0">
                                <div class="content">
                                    <?php echo wp_kses_post( $value['content'] ); ?>
                                    <?php if( $value['image']['url'] != '' ): ?>
                                        <img src="<?php echo esc_url( $value['image']['url'] ); ?>" alt="<?php echo esc_attr( $value['title'] ) ?>">
                                    <?php endif; ?>
                                </div>
                            </div>
                        </div>
                    </div>
                <?php } ?>
            </div>
        </div>
        <?php
	}


}

Plugin::instance()->widgets_manager->register( new Kiedo_HIW );