<?php
/**
 * Contact Info Widget
 */

namespace Elementor;

// Exit if accessed directly
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

class Kiedo_Contact_Info extends Widget_Base {

	public function get_name() {
        return 'Contact_Info';
    }

	public function get_title() {
        return esc_html__( 'Contact Info', 'kiedo-toolkit' );
    }

	public function get_icon() {
        return 'eicon-posts-group';
    }

	public function get_categories() {
        return [ 'kiedo-elements' ];
    }

	protected function register_controls() {

        $this->start_controls_section(
			'Kiedo_Contact_Info',
			[
				'label' => esc_html__( 'Kiedo Contact Info', 'kiedo-toolkit' ),
				'tab' => Controls_Manager::TAB_CONTENT,
			]
        );

            $this->add_control(
                'title',
                [
                    'label' => esc_html__( 'Title', 'kiedo-toolkit' ),
                    'type' => Controls_Manager::TEXT,
                    'default' => esc_html__('Have any question in mind please call or mail us', 'kiedo-toolkit'),
                    'label_block' => true,
                ]
            );

            $this->add_control(
                'title_tag',
                [
                    'label' => esc_html__( 'Title Tag', 'kiedo-toolkit' ),
                    'type' => Controls_Manager::SELECT,
                    'options' => [
                        'h1'         => esc_html__( 'h1', 'kiedo-toolkit' ),
                        'h2'         => esc_html__( 'h2', 'kiedo-toolkit' ),
                        'h3'         => esc_html__( 'h3', 'kiedo-toolkit' ),
                        'h4'         => esc_html__( 'h4', 'kiedo-toolkit' ),
                        'h5'         => esc_html__( 'h5', 'kiedo-toolkit' ),
                        'h6'         => esc_html__( 'h6', 'kiedo-toolkit' ),
                    ],
                    'default' => 'h2',
                ]
            );

			$repeater = new Repeater();
            $repeater->add_control(
                'icon', [
					'type'    => Controls_Manager::ICON,
					'label'   => esc_html__( 'Icon', 'kiedo-toolkit' ),
                    'label_block' => true,
                    'options' => kiedo_icons(),
                ]
            );
            $repeater->add_control(
                'content', [
					'type'    => Controls_Manager::WYSIWYG,
					'label'   => esc_html__( 'Content', 'kiedo-toolkit' ),
                    'label_block' => true,
                ]
            );
            $this->add_control(
                'items',
                [
                    'label'   => esc_html__( 'Add Items', 'kiedo-toolkit' ),
                    'type' => Controls_Manager::REPEATER,
                    'fields' => $repeater->get_controls(),
                    'label_block' => true,
                ]
            );
        $this->end_controls_section();

    }

	protected function render() {

        $settings = $this->get_settings_for_display();

        // Inline Editing
        $this-> add_inline_editing_attributes('title','none');
        ?>

        <div class="contact-info-area ptb-100">
            <div class="container">
                <div class="contact-info-inner">
                    <<?php echo esc_attr( $settings['title_tag'] ); ?> <?php echo $this-> get_render_attribute_string('title'); ?>><?php echo esc_html( $settings['title'] ); ?></<?php echo esc_attr( $settings['title_tag'] ); ?>>
                    <div class="row justify-content-center">

                        <?php $i = 0; foreach($settings['items'] as $item): ?>
                            <div class="col-lg-4 col-md-6 col-sm-6">
                                <div class="single-contact-info-box">
                                    <div class="icon bg<?php echo $i; ?>">
                                        <i class="<?php echo esc_attr($item['icon']); ?>"></i>
                                    </div>
                                    <?php echo wp_kses_post($item['content']); ?>
                                </div>
                            </div>
                        <?php $i++; endforeach; ?>

                    </div>
                    <div class="lines">
                        <div class="line"></div>
                        <div class="line"></div>
                        <div class="line"></div>
                        <div class="line"></div>
                        <div class="line"></div>
                    </div>
                </div>
            </div>
        </div>
        <?php
	}


}

Plugin::instance()->widgets_manager->register( new Kiedo_Contact_Info );