<?php
/**
 * App Download Widget
 */

namespace Elementor;

// Exit if accessed directly
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

class Kiedo_App_Download extends Widget_Base {

	public function get_name() {
        return 'App_Download';
    }

	public function get_title() {
        return esc_html__( 'App Download', 'kiedo-toolkit' );
    }

	public function get_icon() {
        return 'eicon-download-button';
    }

	public function get_categories() {
        return [ 'kiedo-elements' ];
    }

	protected function register_controls() {

        $this->start_controls_section(
			'Kiedo_App_Download',
			[
				'label' => esc_html__( 'Kiedo App Download', 'kiedo-toolkit' ),
				'tab' => Controls_Manager::TAB_CONTENT,
			]
        );
            $this->add_control(
                'style',
                [
                    'label' => esc_html__( 'Section Style', 'kiedo-toolkit' ),
                    'type' => Controls_Manager::SELECT,
                    'options' => [
                        '1'         => esc_html__( 'Style 1', 'kiedo-toolkit' ),
                        '2'         => esc_html__( 'Style 2', 'kiedo-toolkit' ),
                        '3'         => esc_html__( 'Style 3', 'kiedo-toolkit' ),
                        '4'         => esc_html__( 'Style 4', 'kiedo-toolkit' ),
                        '5'         => esc_html__( 'Style 5', 'kiedo-toolkit' ),
                    ],
                    'default' => '1',
                ]
            );
            
            $this->add_control(
                'bg_title',
                [
                    'label'   => esc_html__( 'Background Text', 'kiedo-toolkit' ),
                    'type'    => Controls_Manager::TEXT,
                    'default' => esc_html__('About Us', 'kiedo-toolkit'),
                    'condition' => [
                        'style' => '4',
                    ]
                ]
            );
            $this->add_control(
                'top_title',
                [
                    'label' => esc_html__( 'Top Title', 'kiedo-toolkit' ),
                    'type' => Controls_Manager::TEXT,
                    'default' => esc_html__('DOWNLOAD APP', 'kiedo-toolkit'),
                ]
            );

            $this->add_control(
                'title',
                [
                    'label' => esc_html__( 'Title', 'kiedo-toolkit' ),
                    'type' => Controls_Manager::TEXT,
                    'default' => esc_html__('Lets Get Your Free Copy From Apple and Play Store', 'kiedo-toolkit'),
                ]
            );

            $this->add_control(
                'title_tag',
                [
                    'label' => esc_html__( 'Title Tag', 'kiedo-toolkit' ),
                    'type' => Controls_Manager::SELECT,
                    'options' => [
                        'h1'         => esc_html__( 'h1', 'kiedo-toolkit' ),
                        'h2'         => esc_html__( 'h2', 'kiedo-toolkit' ),
                        'h3'         => esc_html__( 'h3', 'kiedo-toolkit' ),
                        'h4'         => esc_html__( 'h4', 'kiedo-toolkit' ),
                        'h5'         => esc_html__( 'h5', 'kiedo-toolkit' ),
                        'h6'         => esc_html__( 'h6', 'kiedo-toolkit' ),
                    ],
                    'default' => 'h2',
                ]
            );

            $this->add_control(
                'content',
                [
                    'label' => esc_html__( 'Content', 'kiedo-toolkit' ),
                    'type' => Controls_Manager::TEXTAREA,
                    'default' => esc_html__('Instant free download from store Cloud based storage for your data backup just log in with your mail account from play store and using whatever you want for your business purpose orem ipsum dummy text.', 'kiedo-toolkit'),
                    'condition' => [
                        'style!' => '3',
                    ]
                ]
            );

            $this->add_control(
				'button_top_text',
				[
					'label' 	=> esc_html__( 'Left Button Top Text', 'kiedo-toolkit' ),
					'type' 		=> Controls_Manager::TEXT,
					'default' 	=> esc_html__('Start Free Trial', 'kiedo-toolkit'),
				]
            );

            $this->add_control(
				'button_text',
				[
					'label' 	=> esc_html__( 'Left Button Text', 'kiedo-toolkit' ),
					'type' 		=> Controls_Manager::TEXT,
					'default' 	=> esc_html__('Start Free Trial', 'kiedo-toolkit'),
				]
            );

            $this->add_control(
				'button_img',
				[
					'label' 	=> esc_html__( 'Left Button Image', 'kiedo-toolkit' ),
					'type' 		=> Controls_Manager::MEDIA,
				]
            );

            $this->add_control(
                'ex_link',
                [
                    'label'		=> esc_html__('Left Button Link', 'kiedo-toolkit'),
                    'type'		=> Controls_Manager:: TEXT,
                ]
            );

            $this->add_control(
				'right_button_top_text',
				[
					'label' 	=> esc_html__( 'Right Button Top Text', 'kiedo-toolkit' ),
					'type' 		=> Controls_Manager::TEXT,
					'default' 	=> esc_html__('Start Free Trial', 'kiedo-toolkit'),
				]
            );

            $this->add_control(
				'right_button_text',
				[
					'label' 	=> esc_html__( 'Right Button Text', 'kiedo-toolkit' ),
					'type' 		=> Controls_Manager::TEXT,
					'default' 	=> esc_html__('Start Free Trial', 'kiedo-toolkit'),
				]
            );

            $this->add_control(
                'right_ex_link',
                [
                    'label'		=> esc_html__('Right Button Link', 'kiedo-toolkit'),
                    'type'		=> Controls_Manager:: TEXT,
                ]
            );

            $this->add_control(
				'right_button_img',
				[
					'label' 	=> esc_html__( 'Right Button Image', 'kiedo-toolkit' ),
					'type' 		=> Controls_Manager::MEDIA,
				]
            );
          

        $this->end_controls_section();

        $this->start_controls_section(
			'section_images',
			[
				'label' => esc_html__( 'Images', 'kiedo-toolkit' ),
				'tab' => Controls_Manager::TAB_CONTENT,
			]
        );
            $this->add_control(
                'fimage',
                [
                    'label' => esc_html__( 'App Download Image', 'kiedo-toolkit' ),
                    'type'	 => Controls_Manager::MEDIA,
                ]
            );

            $this->add_control(
                'shape_image',
                [
                    'label' => esc_html__( 'App Download Shape Image', 'kiedo-toolkit' ),
                    'type'	 => Controls_Manager::MEDIA,
                ]
            );
            $this->add_control(
                'shape_2',
                [
                    'label' => esc_html__( 'Shape Two', 'kiedo-toolkit' ),
                    'type'	 => Controls_Manager::MEDIA,
                    'condition' => [
                        'style' => '5',
                    ]
                ]
            );
            $this->add_control(
                'shape_3',
                [
                    'label' => esc_html__( 'Shape Three', 'kiedo-toolkit' ),
                    'type'	 => Controls_Manager::MEDIA,
                    'condition' => [
                        'style' => '5',
                    ]
                ]
            );
        $this->end_controls_section();

        $this->start_controls_section(
			'section_style',
			[
				'label' => esc_html__( 'Style', 'kiedo-toolkit' ),
				'tab' => Controls_Manager::TAB_STYLE,
			]
        );

            $this->add_control(
                'title_color',
                [
                    'label' => esc_html__( 'Title Color', 'kiedo-toolkit' ),
                    'type' => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .app-download-content h2, .app-download-content h3, .app-download-content h4, .app-download-content h5, .app-download-content h5, .app-download-content h6, .app-download-content h1, .new-app-download-content h2, .new-app-download-content h1, .new-app-download-content h3, .new-app-download-content h4, .new-app-download-content h5, .new-app-download-content h6' => 'color: {{VALUE}}',
                    ],
                ]
            );

            $this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'name' => 'title_typography',
                    'label' => __( 'Title Typography', 'kiedo-toolkit' ),
                    'scheme' => Core\Schemes\Typography::TYPOGRAPHY_1,
                    'selector' => '{{WRAPPER}} .app-download-content h2, .app-download-content h3, .app-download-content h4, .app-download-content h5, .app-download-content h5, .app-download-content h6, .app-download-content h1, .new-app-download-content h2, .new-app-download-content h1, .new-app-download-content h3, .new-app-download-content h4, .new-app-download-content h5, .new-app-download-content h6',
                ]
            );

            $this->add_control(
                'content_color',
                [
                    'label' => esc_html__( 'Content Color', 'kiedo-toolkit' ),
                    'type' => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .app-download-content p, .new-app-download-content p' => 'color: {{VALUE}}',
                    ],
                    'condition' => [
                        'style!' => '3',
                    ]
                ]
            );

            $this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'name' => 'content_typography',
                    'label' => __( 'Content Typography', 'kiedo-toolkit' ),
                    'scheme' => Core\Schemes\Typography::TYPOGRAPHY_1,
                    'selector' => '{{WRAPPER}} .app-download-content p, .new-app-download-content p',
                    'condition' => [
                        'style!' => '3',
                    ]
                ]

            );

            $this->add_control(
				'btn_color',
				[
					'label'     => __( 'Button Top Text Color', 'kiedo-toolkit' ),
					'type'      => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .new-app-download-content .btn-box .applestore-btn, .new-app-download-content .btn-box .playstore-btn,   .app-download-content .btn-box .applestore-btn, .app-download-content .btn-box .playstore-btn' => 'color: {{VALUE}}',
					],
				]
			);
			$this->add_control(
				'btn_btcolor',
				[
					'label'     => __( 'Button Bottom Text Color', 'kiedo-toolkit' ),
					'type'      => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .new-app-download-content .btn-box .applestore-btn span, .new-app-download-content .btn-box .playstore-btn span,   .app-download-content .btn-box .applestore-btn span, .app-download-content .btn-box .playstore-btn span' => 'color: {{VALUE}}',
					],
				]
			);

			$this->add_control(
				'btn_bg_color',
				[
					'label'     => __( 'Button Background Color', 'kiedo-toolkit' ),
					'type'      => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .new-app-download-content .btn-box .applestore-btn, .new-app-download-content .btn-box .playstore-btn,   .app-download-content .btn-box .applestore-btn, .app-download-content .btn-box .playstore-btn' => 'background-color: {{VALUE}}',
					],
				]
			);
			$this->add_control(
				'btn_hbg_color',
				[
					'label'     => __( 'Button Hover Background Color', 'kiedo-toolkit' ),
					'type'      => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .new-app-download-content .btn-box .applestore-btn::before, .new-app-download-content .btn-box .playstore-btn::before,   .app-download-content .btn-box .applestore-btn::before, .app-download-content .btn-box .playstore-btn::before' => 'background: {{VALUE}}',
					],
				]
			);
			$this->add_control(
				'btn_h_color',
				[
					'label'     => __( 'Button Hover Color', 'kiedo-toolkit' ),
					'type'      => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .new-app-download-content .btn-box .applestore-btn:hover span, .new-app-download-content .btn-box .playstore-btn:hover span, .app-download-content .btn-box .applestore-btn:hover span, .app-download-content .btn-box .playstore-btn:hover span' => 'color: {{VALUE}}',
					],
				]
			);
			$this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'name'     => 'btn_typography',
                    'label'    => __( 'Button Typography', 'kiedo-toolkit' ),
                    'selector' => '{{WRAPPER}} .new-app-download-content .btn-box .applestore-btn, .new-app-download-content .btn-box .playstore-btn, .new-app-download-content .btn-box .applestore-btn span, .new-app-download-content .btn-box .playstore-btn span,  .app-download-content .btn-box .applestore-btn, .app-download-content .btn-box .playstore-btn, .app-download-content .btn-box .applestore-btn span, .app-download-content .btn-box .playstore-btn span',
                ]
            );

        $this->end_controls_section();
    }

	protected function render() {

        $settings = $this->get_settings_for_display();

        // Inline Editing
        $this-> add_inline_editing_attributes('title','none');
        $this-> add_inline_editing_attributes('content','none');

        if($settings['style'] == '2'): 
            $color_cls = "bg-gray";
        elseif($settings['style'] == '3'): 
            $color_cls = "bg-gradient-color";
        else:
            $color_cls = "";
        endif;
        ?>

        <?php if($settings['style'] == '4') : ?>
            <div class="new-app-download-area ptb-100" style="background-image:url(<?php echo esc_url($settings['shape_image']['url']); ?>)">
                <div class="container">
                    <div class="row align-items-center">
                        <div class="col-lg-6 col-md-12">
                            <div class="new-app-download-content">
                                <?php if( $settings['bg_title'] != '' ) : ?>
                                    <div class="big-text"><?php echo esc_html( $settings['bg_title'] ); ?></div>
                                <?php endif; ?>

                                <span class="sub-title"><?php echo esc_html( $settings['top_title'] ); ?></span>

                                <<?php echo esc_attr( $settings['title_tag'] ); ?> <?php echo $this-> get_render_attribute_string('title'); ?>><?php echo esc_html( $settings['title'] ); ?></<?php echo esc_attr( $settings['title_tag'] ); ?>>

                                <?php echo wp_kses_post( $settings['content'] ); ?>

                                <div class="btn-box">
                                    <?php if($settings['button_text']): ?>
                                        <a href="<?php echo esc_url($settings['ex_link']); ?>" class="playstore-btn" target="_blank">
                                            <?php if($settings['button_img']['url']): ?>
                                                <img src="<?php echo esc_url($settings['button_img']['url']); ?>" alt="<?php echo esc_attr($settings['button_text']); ?>">
                                            <?php endif; ?>
                                            <?php echo esc_html($settings['button_top_text']); ?>
                                            <span><?php echo esc_html($settings['button_text']); ?></span>
                                        </a>
                                    <?php endif; ?>

                                    <?php if($settings['right_button_text']): ?>
                                        <a href="<?php echo esc_url($settings['ex_link']); ?>" class="applestore-btn" target="_blank">
                                            <?php if($settings['right_button_img']['url']): ?>
                                                <img src="<?php echo esc_url($settings['right_button_img']['url']); ?>" alt="<?php echo esc_attr($settings['right_button_text']); ?>">
                                            <?php endif; ?>
                                            <?php echo esc_html($settings['right_button_top_text']); ?>
                                            <span><?php echo esc_html($settings['right_button_text']); ?></span>
                                        </a>
                                    <?php endif; ?>
                                </div>
                            </div>
                        </div>

                        <?php if($settings['fimage']['url']): ?>
                            <div class="col-lg-6 col-md-12">
                                <div class="new-app-download-image text-end" data-aos="fade-up">
                                    <img src="<?php echo esc_url($settings['fimage']['url']); ?>" alt="<?php echo esc_attr($settings['title']); ?>">
                                </div>
                            </div>
                        <?php endif; ?>

                    </div>
                </div>
            </div>
        <?php elseif($settings['style'] == '5') : ?>
            <div class="new-app-download-wrap-area ptb-100">
                <div class="container">
                    <div class="row align-items-center">
                        <div class="col-lg-6 col-md-12">
                            <div class="new-app-download-content">
                                <span class="sub-title"><?php echo esc_html( $settings['top_title'] ); ?></span>

                                <<?php echo esc_attr( $settings['title_tag'] ); ?> <?php echo $this-> get_render_attribute_string('title'); ?>><?php echo esc_html( $settings['title'] ); ?></<?php echo esc_attr( $settings['title_tag'] ); ?>>

                                <?php echo wp_kses_post( $settings['content'] ); ?>

                                <div class="btn-box color-wrap">
                                    <?php if($settings['button_text']): ?>
                                        <a href="<?php echo esc_url($settings['ex_link']); ?>" class="playstore-btn" target="_blank">
                                            <?php if($settings['button_img']['url']): ?>
                                                <img src="<?php echo esc_url($settings['button_img']['url']); ?>" alt="<?php echo esc_attr($settings['button_text']); ?>">
                                            <?php endif; ?>
                                            <?php echo esc_html($settings['button_top_text']); ?>
                                            <span><?php echo esc_html($settings['button_text']); ?></span>
                                        </a>
                                    <?php endif; ?>

                                    <?php if($settings['right_button_text']): ?>
                                        <a href="<?php echo esc_url($settings['ex_link']); ?>" class="applestore-btn" target="_blank">
                                            <?php if($settings['right_button_img']['url']): ?>
                                                <img src="<?php echo esc_url($settings['right_button_img']['url']); ?>" alt="<?php echo esc_attr($settings['right_button_text']); ?>">
                                            <?php endif; ?>
                                            <?php echo esc_html($settings['right_button_top_text']); ?>
                                            <span><?php echo esc_html($settings['right_button_text']); ?></span>
                                        </a>
                                    <?php endif; ?>
                                </div>
                            </div>
                        </div>

                        <div class="col-lg-6 col-md-12">
                            <div class="new-app-download-image text-end" data-aos="fade-up">
                                <?php if($settings['fimage']['url']): ?>
                                    <img src="<?php echo esc_url($settings['fimage']['url']); ?>" alt="<?php echo esc_attr($settings['title']); ?>">
                                <?php endif; ?>

                                <?php if($settings['shape_image']['url']): ?>
                                <div class="download-circle">
                                    <img src="<?php echo esc_url($settings['shape_image']['url']); ?>" alt="<?php echo esc_attr($settings['title']); ?>">
                                </div>
                                <?php endif; ?>
                            </div>
                        </div>
                    </div>
                </div>

                <?php if($settings['shape_2']['url']): ?>
                <div class="app-download-shape-1">
                    <img src="<?php echo esc_url($settings['shape_2']['url']); ?>" alt="<?php echo esc_attr($settings['title']); ?>">
                </div>
                <?php endif; ?>

                <?php if($settings['shape_3']['url']): ?>
                <div class="app-download-shape-2">
                    <img src="<?php echo esc_url($settings['shape_3']['url']); ?>" alt="<?php echo esc_attr($settings['title']); ?>">
                </div>
                <?php endif; ?>
            </div>
        <?php elseif($settings['style'] == '1' || $settings['style'] == '2' || $settings['style'] == '3') : ?>
            <div class="app-download-area">
                <div class="container">
                    <div class="app-download-inner <?php echo esc_attr($color_cls); ?>">
                        <div class="row align-items-center">
                            <div class="col-lg-6 col-md-12">
                                <div class="app-download-content">
                                    <span class="sub-title"><?php echo esc_html( $settings['top_title'] ); ?></span>
                                    <<?php echo esc_attr( $settings['title_tag'] ); ?> <?php echo $this-> get_render_attribute_string('title'); ?>><?php echo esc_html( $settings['title'] ); ?></<?php echo esc_attr( $settings['title_tag'] ); ?>>
                                    <?php echo wp_kses_post( $settings['content'] ); ?>

                                    <div class="btn-box">
                                        <?php if($settings['button_text']): ?>
                                            <a href="<?php echo esc_url($settings['ex_link']); ?>" class="playstore-btn" target="_blank">
                                                <?php if($settings['button_img']['url']): ?>
                                                    <img src="<?php echo esc_url($settings['button_img']['url']); ?>" alt="<?php echo esc_attr($settings['button_text']); ?>">
                                                <?php endif; ?>
                                                <?php echo esc_html($settings['button_top_text']); ?>
                                                <span><?php echo esc_html($settings['button_text']); ?></span>
                                            </a>
                                        <?php endif; ?>

                                        <?php if($settings['right_button_text']): ?>
                                            <a href="<?php echo esc_url($settings['ex_link']); ?>" class="applestore-btn" target="_blank">
                                                <?php if($settings['right_button_img']['url']): ?>
                                                    <img src="<?php echo esc_url($settings['right_button_img']['url']); ?>" alt="<?php echo esc_attr($settings['right_button_text']); ?>">
                                                <?php endif; ?>
                                                <?php echo esc_html($settings['right_button_top_text']); ?>
                                                <span><?php echo esc_html($settings['right_button_text']); ?></span>
                                            </a>
                                        <?php endif; ?>
                                    </div>
                                </div>
                            </div>
                            <div class="col-lg-6 col-md-12">
                                <?php if($settings['fimage']['url']): ?>
                                    <div class="app-download-image" data-aos="fade-up">
                                        <img src="<?php echo esc_url($settings['fimage']['url']); ?>" alt="<?php echo esc_attr($settings['title']); ?>">
                                    </div>
                                <?php endif; ?>
                            </div>
                        </div>

                        <?php if($settings['shape_image']['url']): ?>
                            <div class="shape5"><img src="<?php echo esc_url($settings['shape_image']['url']); ?>" alt="<?php echo esc_attr($settings['title']); ?>"></div>
                        <?php endif; ?>

                        <div class="lines">
                            <div class="line"></div>
                            <div class="line"></div>
                            <div class="line"></div>
                            <div class="line"></div>
                            <div class="line"></div>
                        </div>
                    </div>
                </div>
            </div>
        <?php endif; ?>

        <?php
	}
}

Plugin::instance()->widgets_manager->register( new Kiedo_App_Download );