<?php

class kiedo_posts_thumbs extends WP_Widget{

    function __construct(){
        $widget_ops = array('description' => esc_html__('Display Random or Recent posts with a small image.', 'kiedo-toolkit'));
        parent::__construct( false, esc_html__('Kiedo Recent Posts With Image', 'kiedo-toolkit'), $widget_ops);
    }

    function widget($args, $instance){
        global $kiedo_theme, $kiedo_opt;
        extract($args); //it receives an associative array

        $title = apply_filters('widget_title', $instance['title']);
        $args = array(
            'posts_per_page' => $instance['number'],
            'post_type' => 'post',
            'order' => 'DESC',
            'orderby' => $instance['orderby']
        );
        $query = new WP_Query($args);

        if( !$query->have_posts() ) return;
        echo $before_widget;
        if($title) echo $before_title.$title.$after_title;
        if(!$instance['number']) $instance['number'] = 4;

        if($query->have_posts()):
            $c = 0;

            while($query->have_posts()): $query->the_post(); ?>
                <?php
                $class = 'item';
                $post_id = get_the_ID();
                $thumb_size = 'kiedo_widget_thumb';
                ?>
                <?php if( !has_post_thumbnail() ) $class .= ' no-thumb'; ?>
                <article <?php post_class($class); ?>>

                    <?php if( has_post_thumbnail() ): ?>
                        <?php
                        $thumb_id   = get_post_thumbnail_id($post_id);
                        $thumb_type = get_post_mime_type($thumb_id);
                        $image_alt  = get_post_meta( $thumb_id, '_wp_attachment_image_alt', true);
                        if( !$image_alt ){
                            $image_alt = get_the_title($post_id);
                        }
                        if($thumb_type == 'image/gif'){
                            $thumb_size = '';
                        }
                        ?>
                        <a href="<?php the_permalink(); ?>" class="thumb hover-effect" aria-label="<?php the_title(); ?>">
                            <?php if( !empty($kiedo_theme) && $kiedo_theme['enable_lazyload'] == '1' ): ?>
                                <span class="fullimage cover lazy" role="img" aria-label="<?php echo esc_attr($image_alt); ?>" data-src="<?php the_post_thumbnail_url($thumb_size); ?>"></span>
                            <?php else: ?>
                                <span class="fullimage cover" role="img" aria-label="<?php echo esc_attr($image_alt); ?>" style="background: url('<?php the_post_thumbnail_url($thumb_size); ?>');"></span>
                            <?php endif; ?>
                        </a>
                    <?php endif; ?>

                    <div class="info gradient-effect">
                        <h4 class="title usmall"><a href="<?php the_permalink(); ?>"><?php the_title(); ?></a></h4>
                        <?php if( isset( $kiedo_opt['is_post_meta'] ) && $kiedo_opt['is_post_meta'] == true ) { ?>
                            <span class="date"><i class="ri-calendar-2-fill"></i> <?php the_time( get_option('date_format') ); ?></span><?php
                        } ?>
                    </div>

                    <div class="clear"></div>
                </article>
            <?php
            endwhile;
            wp_reset_postdata();
        endif;
        echo $after_widget;
    }

    function update($new_instance, $old_instance){
        $instance = $old_instance;
        $instance['title'] = strip_tags($new_instance['title']);
        $instance['number'] = (int) $new_instance['number'];
        $instance['orderby'] = $new_instance['orderby'];
        return $instance;
    }

    function form($instance){
        $defaults = array(
            'title' => 'Recent posts',
            'number' => 4,
            'orderby' => 'date'
        );
        $instance = wp_parse_args((array)$instance, $defaults);
        $number = isset( $instance['number'] ) ? absint( $instance['number'] ) : 4;
        ?>
        <p>
            <label for="<?php echo $this->get_field_id('title'); ?>">
                <?php esc_html_e('Title:', 'kiedo-toolkit'); ?>
                <input class="widefat" id="<?php echo $this->get_field_id('title'); ?>" name="<?php echo $this->get_field_name('title'); ?>" type="text" value="<?php echo $instance['title']; ?>" />
            </label>
        </p>
        <p>
            <label for="<?php echo $this->get_field_id('number'); ?>"><?php esc_html_e( 'Number of posts to show:', 'kiedo-toolkit'); ?></label>
            <input id="<?php echo $this->get_field_id('number'); ?>" name="<?php echo $this->get_field_name('number'); ?>" type="text" value="<?php echo $number; ?>" size="3" />
        </p>
        <p>
            <label for="<?php echo $this->get_field_id('orderby'); ?>"><?php esc_html_e('Mode:', 'kiedo-toolkit') ?> </label>
            <select id="<?php echo $this->get_field_id('orderby'); ?>" name="<?php echo $this->get_field_name('orderby'); ?>">
                <option <?php if ($instance['orderby'] == 'date') echo 'selected="selected"'; ?> value="date"><?php esc_html_e('Recent Posts', 'kiedo-toolkit'); ?></option>
                <option <?php if ($instance['orderby'] == 'rand') echo 'selected="selected"'; ?> value="rand"><?php esc_html_e('Random Posts', 'kiedo-toolkit'); ?></option>
                <?php if( function_exists('get_field') ): // By views ?>
                    <option <?php if ($instance['orderby'] == 'views') echo 'selected="selected"'; ?> value="views"><?php esc_html_e('Post views', 'kiedo-toolkit'); ?></option>
                <?php endif; ?>
            </select>
        </p>
        <?php
    }

}

function kiedo_register_posts_thumbs() {
    register_widget('kiedo_posts_thumbs');
}

add_action('widgets_init', 'kiedo_register_posts_thumbs');


/**
 * Contact Info Widget
 */
class kiedo_contact_info extends WP_Widget{

    function __construct(){
        $widget_ops = array('description' => esc_html__('Display Contact Info', 'kiedo-toolkit'));
        parent::__construct( false, esc_html__('Kiedo Footer Contact Info', 'kiedo-toolkit'), $widget_ops);
    }

    function widget($args, $instance){
        extract($args);
        global $kiedo_theme;

        // Main site logo
        if(isset($kiedo_opt['main_logo']['url'])):
            $logo 	= $kiedo_opt['main_logo']['url'];
        else:
            $logo	= '';
        endif;

        $title  = apply_filters('widget_title', $instance['title']);

        echo $before_widget;
        if($title) echo $before_title.$title.$after_title;
        ?>
        <?php if($logo): ?>
            <div class="widget-logo">
                <a href="<?php echo esc_url( home_url( '/' ) ); ?>">
                    <img src="<?php echo esc_url( $logo ); ?>" alt="<?php bloginfo( 'name' ); ?>">
                </a>
            </div>
        <?php endif; ?>

        <?php if( $instance['content'] != '' ): ?>
            <p><?php echo $instance['content']; ?></p>
        <?php endif; ?>

        <?php if( $instance['social'] == 'yes' ): ?>
            <ul class="social-links">
                <?php kiedo_social_link(); ?>
            </ul>
        <?php endif; ?>

        <?php
        echo $after_widget;
    }

    function update($new_instance, $old_instance){
        $instance                    = $old_instance;
        $instance['title']           = strip_tags($new_instance['title']);
        $instance['content']         = $new_instance['content'];
        $instance['social']          = $new_instance['social'];
        return $instance;
    }

    function form($instance){
        $defaults = array(
            'title'             => 'Kiedo',
            'content'           =>  'Best solution for your it startup business consecteturadipiscing elit. Scelerisque amet odio velit auctor. nam elit nulla.',
            'social'            => 'yes',
        );
        $instance = wp_parse_args((array)$instance, $defaults);
        ?>
        <p>
            <label for="<?php echo $this->get_field_id('title'); ?>">
                <?php esc_html_e('Title:', 'kiedo-toolkit'); ?>
                <input class="widefat" id="<?php echo $this->get_field_id('title'); ?>" name="<?php echo $this->get_field_name('title'); ?>" type="text" value="<?php echo $instance['title']; ?>" />
            </label>
        </p>

        <p>
            <label for="<?php echo $this->get_field_id('content'); ?>">
                <?php esc_html_e('Content:', 'kiedo-toolkit'); ?>
                <input class="widefat" id="<?php echo $this->get_field_id('content'); ?>" name="<?php echo $this->get_field_name('content'); ?>" type="text" value="<?php echo $instance['content']; ?>" />
            </label>
        </p>

        <p>
            <?php esc_html_e('Display social icons(Type yes to display):', 'kiedo-toolkit'); ?>
            <input class="widefat" id="<?php echo $this->get_field_id('social'); ?>" name="<?php echo $this->get_field_name('social'); ?>" type="text" value="<?php echo $instance['social']; ?>" />
		</p>

        <?php
    }

}

function kiedo_register_contact_info() {
    register_widget('kiedo_contact_info');
}

add_action('widgets_init', 'kiedo_register_contact_info');


/**
 * Newsletter Widget
 */
class kiedo_newsletter extends WP_Widget{

    function __construct(){
        $widget_ops = array('description' => esc_html__('Display Contact Info', 'kiedo-toolkit'));
        parent::__construct( false, esc_html__('Kiedo Footer Newsletter', 'kiedo-toolkit'), $widget_ops);
    }

    function widget($args, $instance){
        extract($args);

        $title  = apply_filters('widget_title', $instance['title']);

        echo $before_widget;
        if($title) echo $before_title.$title.$after_title;
        ?>
        <div class="widget-newsletter">
            <div class="newsletter-content">
                <?php if( $instance['content'] != '' ): ?>
                    <p><?php echo $instance['content']; ?></p>
                <?php endif; ?>
            </div>

            <?php if( $instance['email_url'] != '' ): ?>
                <form class="mailchimp newsletter-form" method="post">
                    <input type="email" class="input-newsletter memail" placeholder="<?php echo esc_attr($instance['email_placeholder']); ?>" name="EMAIL" required>

                    <button type="submit"><i class="ri-send-plane-2-line"></i></button>
                    <div class="mchimp-errmessage alert alert-danger" style="display: none;"></div>
                    <div class="mchimp-sucmessage alert alert-primary" style="display: none;"></div>
                </form>
            <?php endif; ?>
        </div>

        <script>
        ;(function($){
            "use strict";
            $(document).ready(function () {
                // MAILCHIMP
                $(".mailchimp").ajaxChimp({
                    callback: mailchimpCallback,
                    url: "<?php echo esc_js($instance['email_url']) ?>"
                });
                $(".memail").on("focus", function () {
                    $(".mchimp-errmessage").fadeOut();
                    $(".mchimp-sucmessage").fadeOut();
                });
                $(".memail").on("keydown", function () {
                    $(".mchimp-errmessage").fadeOut();
                    $(".mchimp-sucmessage").fadeOut();
                });
                $(".memail").on("click", function () {
                    $(".memail").val("");
                });

                function mailchimpCallback(resp) {
                    if (resp.result === "success") {
                        $(".mchimp-sucmessage").html(resp.msg).fadeIn(1000);
                        $(".mchimp-sucmessage").fadeOut(3000);
                    } else if (resp.result === "error") {
                        $(".mchimp-errmessage").html(resp.msg).fadeIn(1000);
                    }
                }
            });
        })(jQuery)
    </script>
        <?php
        echo $after_widget;
    }

    function update($new_instance, $old_instance){
        $instance                    = $old_instance;
        $instance['title']           = strip_tags($new_instance['title']);
        $instance['content']        = $new_instance['content'];
        $instance['email_url']        = $new_instance['email_url'];
        $instance['email_placeholder']        = $new_instance['email_placeholder'];
        return $instance;
    }

    function form($instance){
        $defaults = array(
            'title'             => 'Newsletter',
            'content'          =>  'Best solution for your it startup business consecteturadipiscing elit.',
            'email_url'          => 'https://hibootstrap.us20.list-manage.com/subscribe/post?u=60e1ffe2e8a68ce1204cd39a5&amp;id=42d6d188d9',
            'email_placeholder'            => 'Enter email',
        );
        $instance = wp_parse_args((array)$instance, $defaults);
        ?>
        <p>
            <label for="<?php echo $this->get_field_id('title'); ?>">
                <?php esc_html_e('Title:', 'kiedo-toolkit'); ?>
                <input class="widefat" id="<?php echo $this->get_field_id('title'); ?>" name="<?php echo $this->get_field_name('title'); ?>" type="text" value="<?php echo $instance['title']; ?>" />
            </label>
        </p>

        <p>
            <label for="<?php echo $this->get_field_id('content'); ?>">
                <?php esc_html_e('Content:', 'kiedo-toolkit'); ?>
                <input class="widefat" id="<?php echo $this->get_field_id('content'); ?>" name="<?php echo $this->get_field_name('content'); ?>" type="text" value="<?php echo $instance['content']; ?>" />
            </label>
        </p>

        <p>
            <label for="<?php echo $this->get_field_id('email_url'); ?>">
                <?php esc_html_e('Action URL:', 'kiedo-toolkit'); ?>
                <input class="widefat" id="<?php echo $this->get_field_id('email_url'); ?>" name="<?php echo $this->get_field_name('email_url'); ?>" type="text" value="<?php echo $instance['email_url']; ?>" />
            </label>
            <i>Enter here your MailChimp action URL. <a href="https://www.docs.hibootstrap.com/docs/kiedo-theme-documentation/tips-guides-troubleshoots/get-mailchimp-newsletter-form-action-url/" target="_blank"> How to </a></i>
        </p>

        <p>
            <label for="<?php echo $this->get_field_id('email_placeholder'); ?>">
                <?php esc_html_e('Placeholder Title:', 'kiedo-toolkit'); ?>
                <input class="widefat" id="<?php echo $this->get_field_id('email_placeholder'); ?>" name="<?php echo $this->get_field_name('email_placeholder'); ?>" type="text" value="<?php echo $instance['email_placeholder']; ?>" />
            </label>
        </p>
        <?php
    }

}

function kiedo_register_newsletter() {
    register_widget('kiedo_newsletter');
}

add_action('widgets_init', 'kiedo_register_newsletter');