<?php
/**
 * Team Widget
 */
namespace Elementor;
class Kiedo_Team extends Widget_Base{
    public function get_name(){
        return "Kiedo_Team";
    }
    public function get_title(){
        return "Team Card";
    }
    public function get_icon(){
        return "eicon-gallery-group";
    }
    public function get_categories(){
        return ['kiedo-elements'];
    }
    protected function register_controls(){

    $this->start_controls_section(
        'Kiedo_Team',
        [
            'label' => __( 'Kiedo Team', 'kiedo-toolkit' ),
            'tab' => Controls_Manager::TAB_CONTENT,
        ]
    );

        $repeater = new Repeater();

        $repeater->add_control(
            'member_img',
            [
                'label' => esc_html__( 'Image', 'kiedo-toolkit' ),
                'type' => Controls_Manager::MEDIA,
                'label_block' => true,
            ]
        );
        $repeater->add_control(
            'name',
            [
                'label' => esc_html__( 'Member Name', 'kiedo-toolkit' ),
                'type' => Controls_Manager::TEXT,
            ]
        );

        $repeater->add_control(
            'designation',
            [
                'label' => esc_html__( 'Designation', 'kiedo-toolkit' ),
                'type' => Controls_Manager::TEXT,
            ]
        );

        $this->add_control(
            'teams',
            [
                'label' => esc_html__( 'Add Member', 'kiedo-toolkit' ),
                'type' => Controls_Manager::REPEATER,
                'fields' => $repeater->get_controls(),
            ]
        );

    $this-> end_controls_section();

    // Start Style content controls
    $this-> start_controls_section(
        'style',
        [
            'label'=>esc_html__('Style', 'kiedo-toolkit'),
            'tab'=> Controls_Manager::TAB_STYLE,
        ]
    );

        $this->add_control(
            'name_color',
            [
                'label' => esc_html__( 'Member Name Color', 'kiedo-toolkit' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .single-team-box .content h3' => 'color: {{VALUE}}',
                ],
            ]
        );

		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' => 'name_size',
				'label' => __( 'Name Typography', 'kiedo-toolkit' ),
				'scheme' => Core\Schemes\Typography::TYPOGRAPHY_1,
				'selector' => '{{WRAPPER}} .single-team-box .content h3',
			]
		);

        $this->add_control(
            'designation_color',
            [
                'label' => esc_html__( 'Member Designation Color', 'kiedo-toolkit' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .single-team-box .content span' => 'color: {{VALUE}}',
                ],
            ]
        );

		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' => 'designation_size',
				'label' => __( 'Designation Typography', 'kiedo-toolkit' ),
				'scheme' => Core\Schemes\Typography::TYPOGRAPHY_1,
				'selector' => '{{WRAPPER}} .single-team-box .content span',
			]
		);
    $this-> end_controls_section();
}
    protected function render()
    {
        $settings = $this->get_settings_for_display();

        ?>
        <div class="container">
			<div class="row justify-content-center">
                <?php foreach( $settings['teams'] as $item ): ?>
					<div class="col-xl-2 col-lg-3 col-md-4 col-sm-4 col-6">
						<div class="single-team-box">
							<div class="image">
								<?php if( $item['member_img']['url'] != '' ): ?>
                                    <div class="bg-1" style="background-image:url(<?php echo esc_url( $item['member_img']['url'] ); ?>);"></div>
								<?php endif; ?>
							</div>

							<div class="content">
                            	<h3><?php echo esc_html( $item['name'] ); ?></h3>
								<span><?php echo esc_html( $item['designation'] ); ?></span>
							</div>
						</div>
					</div>
                <?php endforeach; ?>
			</div>
		</div>
    <?php
    }
}
Plugin::instance()->widgets_manager->register( new Kiedo_Team );