<?php
/**
 * Software Integrations Widget
 */

namespace Elementor;

// Exit if accessed directly
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

class Kiedo_Software_Integrations extends Widget_Base {

	public function get_name() {
        return 'Software_Integrations';
    }

	public function get_title() {
        return esc_html__( 'Software Integrations', 'kiedo-toolkit' );
    }

	public function get_icon() {
        return 'eicon-info-box';
    }

	public function get_categories() {
        return [ 'kiedo-elements' ];
    }

	protected function register_controls() {

        $this->start_controls_section(
			'Kiedo_Software_Integrations',
			[
				'label' => esc_html__( 'Kiedo Software Integrations', 'kiedo-toolkit' ),
				'tab' => Controls_Manager::TAB_CONTENT,
			]
        );

            $this->add_control(
                'style',
                [
                    'label' => esc_html__( 'Section Style', 'kiedo-toolkit' ),
                    'type' => Controls_Manager::SELECT,
                    'options' => [
                        '1'         => esc_html__( 'Style 1', 'kiedo-toolkit' ),
                        '2'         => esc_html__( 'Style 2', 'kiedo-toolkit' ),
                        '3'         => esc_html__( 'Style 3', 'kiedo-toolkit' ),
                        '4'         => esc_html__( 'Style 4', 'kiedo-toolkit' ),
                    ],
                    'default' => '1',
                ]
            );
            $this->add_control(
                'img_position',
                [
                    'label' => esc_html__( 'Image Position', 'kiedo-toolkit' ),
                    'type' => Controls_Manager::SELECT,
                    'options' => [
                        'left'         => esc_html__( 'Left', 'kiedo-toolkit' ),
                        'right'         => esc_html__( 'Right', 'kiedo-toolkit' ),
                    ],
                    'default' => 'left',
                    'condition' => [
                        'style' => '4',
                    ]
                ]
            );

            $this->add_control(
                'bg_title',
                [
                    'label' => esc_html__( 'Background Text', 'kiedo-toolkit' ),
                    'type' => Controls_Manager::TEXT,
                    'default' => esc_html__('Software', 'kiedo-toolkit'),
                    'condition' => [
                        'style' => '4',
                    ]
                ]
            );

            $this->add_control(
                'top_title',
                [
                    'label' => esc_html__( 'Top Title', 'kiedo-toolkit' ),
                    'type' => Controls_Manager::TEXT,
                    'default' => esc_html__('SOFTWARE INTEGRATIONS', 'kiedo-toolkit'),
                ]
            );

            $this->add_control(
                'title',
                [
                    'label' => esc_html__( 'Title', 'kiedo-toolkit' ),
                    'type' => Controls_Manager::TEXT,
                    'default' => esc_html__('Easy & Perfect Solution With Latest Software Integrations', 'kiedo-toolkit'),
                ]
            );

            $this->add_control(
                'title_tag',
                [
                    'label' => esc_html__( 'Title Tag', 'kiedo-toolkit' ),
                    'type' => Controls_Manager::SELECT,
                    'options' => [
                        'h1'         => esc_html__( 'h1', 'kiedo-toolkit' ),
                        'h2'         => esc_html__( 'h2', 'kiedo-toolkit' ),
                        'h3'         => esc_html__( 'h3', 'kiedo-toolkit' ),
                        'h4'         => esc_html__( 'h4', 'kiedo-toolkit' ),
                        'h5'         => esc_html__( 'h5', 'kiedo-toolkit' ),
                        'h6'         => esc_html__( 'h6', 'kiedo-toolkit' ),
                    ],
                    'default' => 'h2',
                ]
            );

            $this->add_control(
                'content',
                [
                    'label' => esc_html__( 'Content', 'kiedo-toolkit' ),
                    'type' => Controls_Manager::TEXTAREA,
                    'default' => esc_html__('Cloud based storage for your data backup just log in with your mail account from play store and using whatever you want for your business purpose orem ipsum dummy text. never missyour chance its just began. backup just log in with your mail account from.', 'kiedo-toolkit'),
                ]
            );

            $this->add_control(
				'button_text',
				[
					'label' 	=> esc_html__( 'Button Text', 'kiedo-toolkit' ),
					'type' 		=> Controls_Manager::TEXT,
					'default' 	=> esc_html__('Get Started', 'kiedo-toolkit'),
				]
            );

            $this->add_control(
                'ex_link',
                [
                    'label'		=> esc_html__('Button Link', 'kiedo-toolkit'),
                    'type'		=> Controls_Manager:: TEXT,
                ]
            );

        $this->end_controls_section();

        $this->start_controls_section(
			'section_images',
			[
				'label' => esc_html__( 'Images', 'kiedo-toolkit' ),
				'tab' => Controls_Manager::TAB_CONTENT,
			]
        );
            $this->add_control(
                'fimage',
                [
                    'label' => esc_html__( 'Software Integrations Image', 'kiedo-toolkit' ),
                    'type'	 => Controls_Manager::MEDIA,
                ]
            );

            $this->add_control(
                'img1',
                [
                    'label' => esc_html__( 'Software Integrations Image 1', 'kiedo-toolkit' ),
                    'type'	 => Controls_Manager::MEDIA,
                ]
            );

            $this->add_control(
                'img2',
                [
                    'label' => esc_html__( 'Software Integrations Image 2', 'kiedo-toolkit' ),
                    'type'	 => Controls_Manager::MEDIA,
                ]
            );

            $this->add_control(
                'img3',
                [
                    'label' => esc_html__( 'Software Integrations Image 3', 'kiedo-toolkit' ),
                    'type'	 => Controls_Manager::MEDIA,
                ]
            );

            $this->add_control(
                'img4',
                [
                    'label' => esc_html__( 'Software Integrations Image 4', 'kiedo-toolkit' ),
                    'type'	 => Controls_Manager::MEDIA,
                ]
            );

            $this->add_control(
                'img5',
                [
                    'label' => esc_html__( 'Software Integrations Image 5', 'kiedo-toolkit' ),
                    'type'	 => Controls_Manager::MEDIA,
                ]
            );

            $this->add_control(
                'shape_image',
                [
                    'label' => esc_html__( 'Software Integrations Shape Image', 'kiedo-toolkit' ),
                    'type'	 => Controls_Manager::MEDIA,
                    'condition' => [
                        'style!' => '4',
                    ]
                ]
            );
            $this->add_control(
                'bg_shape_image',
                [
                    'label' => esc_html__( 'Background Shape Image', 'kiedo-toolkit' ),
                    'type'	 => Controls_Manager::MEDIA,
                ]
            );

        $this->end_controls_section();

        $this->start_controls_section(
			'section_style',
			[
				'label' => esc_html__( 'Style', 'kiedo-toolkit' ),
				'tab'   => Controls_Manager::TAB_STYLE,
			]
        );

            $this->add_control(
                'title_color',
                [
                    'label' => esc_html__( 'Title Color', 'kiedo-toolkit' ),
                    'type' => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .software-integrations-content h2, .software-integrations-content h3, .software-integrations-content h4, .software-integrations-content h5, .software-integrations-content h5, .software-integrations-content h6, .software-integrations-content h1, .new-software-content h2, .new-software-content h1, .new-software-content h3, .new-software-content h4, .new-software-content h5, .new-software-content h6' => 'color: {{VALUE}}',
                    ],
                ]
            );

            $this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'name' => 'title_typography',
                    'label' => __( 'Title Typography', 'kiedo-toolkit' ),
                    'scheme' => Core\Schemes\Typography::TYPOGRAPHY_1,
                    'selector' => '{{WRAPPER}} .software-integrations-content h2, .software-integrations-content h3, .software-integrations-content h4, .software-integrations-content h5, .software-integrations-content h5, .software-integrations-content h6, .software-integrations-content h1,  .new-software-content h2, .new-software-content h1, .new-software-content h3, .new-software-content h4, .new-software-content h5, .new-software-content h6',
                ]
            );

            $this->add_control(
                'content_color',
                [
                    'label' => esc_html__( 'Content Color', 'kiedo-toolkit' ),
                    'type' => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .software-integrations-content p, .new-software-content p' => 'color: {{VALUE}}',
                    ],
                ]
            );

            $this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'name' => 'content_typography',
                    'label' => __( 'Content Typography', 'kiedo-toolkit' ),
                    'scheme' => Core\Schemes\Typography::TYPOGRAPHY_1,
                    'selector' => '{{WRAPPER}} .software-integrations-content p, .new-software-content p',
                ]
            );

        $this->end_controls_section();
    }

	protected function render() {

        $settings = $this->get_settings_for_display();

        // Inline Editing
        $this-> add_inline_editing_attributes('title','none');
        $this-> add_inline_editing_attributes('content','none');
        ?>

        <?php if($settings['style'] == '1'): ?>
            <div class="software-integrations-area ">
                <div class="container">
                    <div class="row align-items-center">
                        <div class="col-lg-6 col-md-12">
                            <div class="software-integrations-content">
                                <span class="sub-title"><?php echo esc_html( $settings['top_title'] ); ?></span>
                                <<?php echo esc_attr( $settings['title_tag'] ); ?> <?php echo $this-> get_render_attribute_string('title'); ?>><?php echo esc_html( $settings['title'] ); ?></<?php echo esc_attr( $settings['title_tag'] ); ?>>
                                <?php echo wp_kses_post( $settings['content'] ); ?>

                                <?php if($settings['button_text']): ?>
                                    <a href="<?php echo esc_url($settings['ex_link']); ?>" class="default-btn"><?php echo esc_html($settings['button_text']); ?></a>
                                <?php endif; ?>
                            </div>
                        </div>
                        <div class="col-lg-6 col-md-12">
                            <div class="software-integrations-list">
                                <?php if($settings['bg_shape_image']['url']): ?>
                                    <img src="<?php echo esc_url($settings['bg_shape_image']['url']); ?>" alt="<?php echo esc_attr($settings['title']); ?>">
                                <?php endif; ?>
                                <ul>
                                    <?php if($settings['img5']['url']): ?>
                                        <li data-aos="fade-down"><img src="<?php echo esc_url($settings['img5']['url']); ?>" class="atlassian" alt="<?php echo esc_attr($settings['title']); ?>"></li>
                                    <?php endif; ?>

                                    <?php if($settings['img4']['url']): ?>
                                        <li data-aos="fade-right"><img src="<?php echo esc_url($settings['img4']['url']); ?>" class="skype" alt="<?php echo esc_attr($settings['title']); ?>"></li>
                                    <?php endif; ?>

                                    <?php if($settings['img3']['url']): ?>
                                        <li data-aos="fade-up"><img src="<?php echo esc_url($settings['img3']['url']); ?>" class="gdrive" alt="<?php echo esc_attr($settings['title']); ?>"></li>
                                    <?php endif; ?>

                                    <?php if($settings['img2']['url']): ?>
                                        <li data-aos="fade-down"><img src="<?php echo esc_url($settings['img2']['url']); ?>" class="slack" alt="<?php echo esc_attr($settings['title']); ?>"></li>
                                    <?php endif; ?>

                                    <?php if($settings['img1']['url']): ?>
                                        <li data-aos="fade-up"><img src="<?php echo esc_url($settings['img1']['url']); ?>" class="jira" alt="<?php echo esc_attr($settings['title']); ?>"></li>
                                    <?php endif; ?>

                                    <?php if($settings['fimage']['url']): ?>
                                        <li><img src="<?php echo esc_url($settings['fimage']['url']); ?>" class="frame" alt="<?php echo esc_attr($settings['title']); ?>"></li>
                                    <?php endif; ?>
                                </ul>
                            </div>
                        </div>
                    </div>
                </div>
                <?php if($settings['shape_image']['url']): ?>
                    <div class="shape6"><img src="<?php echo esc_url($settings['shape_image']['url']); ?>" alt="<?php echo esc_attr($settings['title']); ?>"></div>
                <?php endif; ?>
            </div>
        <?php elseif($settings['style'] == '2'): ?>
            <div class="software-integrations-area bg-gradient-color ptb-100">
                <div class="container">
                    <div class="row align-items-center">
                        <div class="col-lg-6 col-md-12">
                            <div class="software-integrations-content white-color">
                                <span class="sub-title"><?php echo esc_html( $settings['top_title'] ); ?></span>
                                <<?php echo esc_attr( $settings['title_tag'] ); ?> <?php echo $this-> get_render_attribute_string('title'); ?>><?php echo esc_html( $settings['title'] ); ?></<?php echo esc_attr( $settings['title_tag'] ); ?>>
                                <?php echo wp_kses_post( $settings['content'] ); ?>

                                <?php if($settings['button_text']): ?>
                                    <a href="<?php echo esc_url($settings['ex_link']); ?>" class="default-btn"><?php echo esc_html($settings['button_text']); ?></a>
                                <?php endif; ?>
                            </div>
                        </div>
                        <div class="col-lg-6 col-md-12">
                            <div class="software-integrations-list">
                                <?php if($settings['bg_shape_image']['url']): ?>
                                    <img src="<?php echo esc_url($settings['bg_shape_image']['url']); ?>" alt="<?php echo esc_attr($settings['title']); ?>">
                                <?php endif; ?>
                                <ul>
                                    <?php if($settings['img5']['url']): ?>
                                        <li data-aos="fade-down"><img src="<?php echo esc_url($settings['img5']['url']); ?>" class="atlassian" alt="<?php echo esc_attr($settings['title']); ?>"></li>
                                    <?php endif; ?>

                                    <?php if($settings['img4']['url']): ?>
                                        <li data-aos="fade-right"><img src="<?php echo esc_url($settings['img4']['url']); ?>" class="skype" alt="<?php echo esc_attr($settings['title']); ?>"></li>
                                    <?php endif; ?>

                                    <?php if($settings['img3']['url']): ?>
                                        <li data-aos="fade-up"><img src="<?php echo esc_url($settings['img3']['url']); ?>" class="gdrive" alt="<?php echo esc_attr($settings['title']); ?>"></li>
                                    <?php endif; ?>

                                    <?php if($settings['img2']['url']): ?>
                                        <li data-aos="fade-down"><img src="<?php echo esc_url($settings['img2']['url']); ?>" class="slack" alt="<?php echo esc_attr($settings['title']); ?>"></li>
                                    <?php endif; ?>

                                    <?php if($settings['img1']['url']): ?>
                                        <li data-aos="fade-up"><img src="<?php echo esc_url($settings['img1']['url']); ?>" class="jira" alt="<?php echo esc_attr($settings['title']); ?>"></li>
                                    <?php endif; ?>

                                    <?php if($settings['fimage']['url']): ?>
                                        <li><img src="<?php echo esc_url($settings['fimage']['url']); ?>" class="frame" alt="<?php echo esc_attr($settings['title']); ?>"></li>
                                    <?php endif; ?>
                                </ul>
                            </div>
                        </div>
                    </div>
                </div>
                <?php if($settings['shape_image']['url']): ?>
                    <div class="shape8"><img src="<?php echo esc_url($settings['shape_image']['url']); ?>" alt="<?php echo esc_attr($settings['title']); ?>"></div>
                <?php endif; ?>
            </div>
        <?php elseif($settings['style'] == '3'): ?>
            <div class="software-integrations-area ptb-100">
                <div class="container">
                    <div class="software-integrations-inner bg-gradient-color">
                        <div class="row align-items-center">
                            <div class="col-lg-6 col-md-12">
                                <div class="software-integrations-content white-color">
                                    <span class="sub-title"><?php echo esc_html( $settings['top_title'] ); ?></span>

                                    <<?php echo esc_attr( $settings['title_tag'] ); ?> <?php echo $this-> get_render_attribute_string('title'); ?>><?php echo esc_html( $settings['title'] ); ?></<?php echo esc_attr( $settings['title_tag'] ); ?>>

                                    <?php echo wp_kses_post( $settings['content'] ); ?>

                                    <?php if($settings['button_text']): ?>
                                        <a href="<?php echo esc_url($settings['ex_link']); ?>" class="default-btn"><?php echo esc_html($settings['button_text']); ?></a>
                                    <?php endif; ?>
                                </div>
                            </div>
                            <div class="col-lg-6 col-md-12">
                                <div class="software-integrations-list">
                                    <?php if($settings['bg_shape_image']['url']): ?>
                                        <img src="<?php echo esc_url($settings['bg_shape_image']['url']); ?>" alt="<?php echo esc_attr($settings['title']); ?>">
                                    <?php endif; ?>
                                    <ul>
                                        <?php if($settings['img5']['url']): ?>
                                            <li data-aos="fade-down"><img src="<?php echo esc_url($settings['img5']['url']); ?>" class="atlassian" alt="<?php echo esc_attr($settings['title']); ?>"></li>
                                        <?php endif; ?>

                                        <?php if($settings['img4']['url']): ?>
                                            <li data-aos="fade-right"><img src="<?php echo esc_url($settings['img4']['url']); ?>" class="skype" alt="<?php echo esc_attr($settings['title']); ?>"></li>
                                        <?php endif; ?>

                                        <?php if($settings['img3']['url']): ?>
                                            <li data-aos="fade-up"><img src="<?php echo esc_url($settings['img3']['url']); ?>" class="gdrive" alt="<?php echo esc_attr($settings['title']); ?>"></li>
                                        <?php endif; ?>

                                        <?php if($settings['img2']['url']): ?>
                                            <li data-aos="fade-down"><img src="<?php echo esc_url($settings['img2']['url']); ?>" class="slack" alt="<?php echo esc_attr($settings['title']); ?>"></li>
                                        <?php endif; ?>

                                        <?php if($settings['img1']['url']): ?>
                                            <li data-aos="fade-up"><img src="<?php echo esc_url($settings['img1']['url']); ?>" class="jira" alt="<?php echo esc_attr($settings['title']); ?>"></li>
                                        <?php endif; ?>

                                        <?php if($settings['fimage']['url']): ?>
                                            <li><img src="<?php echo esc_url($settings['fimage']['url']); ?>" class="frame" alt="<?php echo esc_attr($settings['title']); ?>"></li>
                                        <?php endif; ?>
                                    </ul>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        <?php elseif($settings['style'] == '4'): ?>
            <div class="new-software-area ">
                <div class="container">
                    <div class="row align-items-center">
                        <?php if( $settings['img_position'] == 'left' ): ?>
                        <div class="col-lg-6 col-md-12">
                            <div class="new-software-list">
                                <?php if($settings['bg_shape_image']['url']): ?>
                                    <img src="<?php echo esc_url($settings['bg_shape_image']['url']); ?>" alt="<?php echo esc_attr($settings['title']); ?>">
                                <?php endif; ?>

                                <ul>
                                    <?php if($settings['img5']['url']): ?>
                                        <li data-aos="fade-down"><img src="<?php echo esc_url($settings['img5']['url']); ?>" class="atlassian" alt="<?php echo esc_attr($settings['title']); ?>"></li>
                                    <?php endif; ?>

                                    <?php if($settings['img4']['url']): ?>
                                        <li data-aos="fade-right"><img src="<?php echo esc_url($settings['img4']['url']); ?>" class="skype" alt="<?php echo esc_attr($settings['title']); ?>"></li>
                                    <?php endif; ?>

                                    <?php if($settings['img3']['url']): ?>
                                        <li data-aos="fade-up"><img src="<?php echo esc_url($settings['img3']['url']); ?>" class="gdrive" alt="<?php echo esc_attr($settings['title']); ?>"></li>
                                    <?php endif; ?>

                                    <?php if($settings['img2']['url']): ?>
                                        <li data-aos="fade-down"><img src="<?php echo esc_url($settings['img2']['url']); ?>" class="slack" alt="<?php echo esc_attr($settings['title']); ?>"></li>
                                    <?php endif; ?>

                                    <?php if($settings['img1']['url']): ?>
                                        <li data-aos="fade-up"><img src="<?php echo esc_url($settings['img1']['url']); ?>" class="jira" alt="<?php echo esc_attr($settings['title']); ?>"></li>
                                    <?php endif; ?>

                                    <?php if($settings['fimage']['url']): ?>
                                        <li><img src="<?php echo esc_url($settings['fimage']['url']); ?>" class="frame" alt="<?php echo esc_attr($settings['title']); ?>"></li>
                                    <?php endif; ?>
                                </ul>
                            </div>
                        </div>
                        <?php endif; ?>

                        <div class="col-lg-6 col-md-12">
                            <div class="new-software-content">
                                <?php if( $settings['bg_title']  != '' ) : ?>
                                <div class="big-text"><?php echo esc_html( $settings['bg_title'] ); ?></div>
                                <?php endif; ?>
                                <span class="sub-title"><?php echo esc_html( $settings['top_title'] ); ?></span>
                                <<?php echo esc_attr( $settings['title_tag'] ); ?> <?php echo $this-> get_render_attribute_string('title'); ?>><?php echo esc_html( $settings['title'] ); ?></<?php echo esc_attr( $settings['title_tag'] ); ?>>
                                <?php echo wp_kses_post( $settings['content'] ); ?>

                                <?php if($settings['button_text']): ?>
                                    <a href="<?php echo esc_url($settings['ex_link']); ?>" class="default-btn"><?php echo esc_html($settings['button_text']); ?></a>
                                <?php endif; ?>
                            </div>
                        </div>

                        <?php if( $settings['img_position'] == 'right' ): ?>
                        <div class="col-lg-6 col-md-12">
                            <div class="new-software-list">
                                <?php if($settings['bg_shape_image']['url']): ?>
                                    <img src="<?php echo esc_url($settings['bg_shape_image']['url']); ?>" alt="<?php echo esc_attr($settings['title']); ?>">
                                <?php endif; ?>

                                <ul>
                                    <?php if($settings['img5']['url']): ?>
                                        <li data-aos="fade-down"><img src="<?php echo esc_url($settings['img5']['url']); ?>" class="atlassian" alt="<?php echo esc_attr($settings['title']); ?>"></li>
                                    <?php endif; ?>

                                    <?php if($settings['img4']['url']): ?>
                                        <li data-aos="fade-right"><img src="<?php echo esc_url($settings['img4']['url']); ?>" class="skype" alt="<?php echo esc_attr($settings['title']); ?>"></li>
                                    <?php endif; ?>

                                    <?php if($settings['img3']['url']): ?>
                                        <li data-aos="fade-up"><img src="<?php echo esc_url($settings['img3']['url']); ?>" class="gdrive" alt="<?php echo esc_attr($settings['title']); ?>"></li>
                                    <?php endif; ?>

                                    <?php if($settings['img2']['url']): ?>
                                        <li data-aos="fade-down"><img src="<?php echo esc_url($settings['img2']['url']); ?>" class="slack" alt="<?php echo esc_attr($settings['title']); ?>"></li>
                                    <?php endif; ?>

                                    <?php if($settings['img1']['url']): ?>
                                        <li data-aos="fade-up"><img src="<?php echo esc_url($settings['img1']['url']); ?>" class="jira" alt="<?php echo esc_attr($settings['title']); ?>"></li>
                                    <?php endif; ?>

                                    <?php if($settings['fimage']['url']): ?>
                                        <li><img src="<?php echo esc_url($settings['fimage']['url']); ?>" class="frame" alt="<?php echo esc_attr($settings['title']); ?>"></li>
                                    <?php endif; ?>
                                </ul>
                            </div>
                        </div>
                        <?php endif; ?>

                    </div>
                </div>
            </div>
        <?php endif; ?>
        <?php
	}
}

Plugin::instance()->widgets_manager->register( new Kiedo_Software_Integrations );