<?php
/**
 * Gallery Logo Widget
 */

namespace Elementor;

// Exit if accessed directly
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

class Kiedo_Gallery extends Widget_Base {

	public function get_name() {
        return 'Gallery';
    }

	public function get_title() {
        return __( 'Gallery', 'kiedo-toolkit' );
    }

	public function get_icon() {
        return 'eicon-gallery-grid';
    }

	public function get_categories() {
        return [ 'kiedo-elements' ];
    }

	protected function register_controls() {

        $this->start_controls_section(
			'partner_section',
			[
				'label' => __( 'Gallery Logo Control', 'kiedo-toolkit' ),
				'tab' => Controls_Manager::TAB_CONTENT,
			]
        );
            $this->add_control(
                'gallery',
                [
                    'label' => __( 'Add Images', 'kiedo-toolkit' ),
                    'type' =>Controls_Manager::GALLERY,
                ]
            );

        $this->end_controls_section();

    }

	protected function render() {
        $settings = $this->get_settings_for_display();
        ?>
        <div class="gallery-area pt-100 pb-75">
            <div class="container">
                <div class="row justify-content-center">
                    <?php foreach ( $settings['gallery'] as $image ) { ?>
                        <div class="col-lg-4 col-sm-6 col-md-6">
                            <div class="single-gallery-item">
                                <a data-elementor-open-lightbox="yes" data-elementor-lightbox-slideshow="a0b6fgfgfg8f5" href="<?php echo esc_url($image['url']); ?>">
                                    <img src="<?php echo esc_url($image['url']); ?>" alt="<?php echo esc_attr__('Gallery Image', 'kiedo-toolkit'); ?>">
                                </a>
                            </div>
                        </div>
                    <?php } ?>
                </div>
            </div>
        </div>
        <?php
	}

}

Plugin::instance()->widgets_manager->register( new Kiedo_Gallery );