<?php
/**
 * Feedback Widget
 */

namespace Elementor;
class Kiedo_Feedback extends Widget_Base {

	public function get_name() {
        return 'Feedback';
    }

	public function get_title() {
        return __( 'Feedback', 'kiedo-toolkit' );
    }

	public function get_icon() {
        return 'eicon-testimonial';
    }

	public function get_categories() {
        return [ 'kiedo-elements' ];
    }

	protected function register_controls() {

        $this->start_controls_section(
			'content_section',
			[
				'label' => __( 'Content', 'kiedo-toolkit' ),
				'tab' => Controls_Manager::TAB_CONTENT,
			]
        );

        $this->add_control(
            'style',
            [
                'label' => esc_html__( 'Section Style', 'kiedo-toolkit' ),
                'type' => Controls_Manager::SELECT,
                'options' => [
                    '1'         => esc_html__( 'Style 1', 'kiedo-toolkit' ),
                    '2'         => esc_html__( 'Style 2', 'kiedo-toolkit' ),
                    '3'         => esc_html__( 'Style 3', 'kiedo-toolkit' ),
                    '4'         => esc_html__( 'Style 4', 'kiedo-toolkit' ),
                    '5'         => esc_html__( 'Style 5', 'kiedo-toolkit' ),
                ],
                'default' => '1',
            ]
        );

        $this->add_control(
            'top_title',
            [
                'label' => __( 'Top Title', 'kiedo-toolkit' ),
                'type' => Controls_Manager::TEXT,
                'default' => __('KEY FEATURES', 'kiedo-toolkit'),
                'condition' => [
                    'style' => '3',
                ]
            ]
        );
        $this->add_control(
            'title',
            [
                'label' => __( 'Title', 'kiedo-toolkit' ),
                'type' => Controls_Manager::TEXT,
                'default' => __('Our Featured Services', 'kiedo-toolkit'),
                'condition' => [
                    'style' => '3',
                ]
            ]
        );

        $this->add_control(
            'title_tag',
            [
                'label' => esc_html__( 'Title Tag', 'kiedo-toolkit' ),
                'type' => Controls_Manager::SELECT,
                'options' => [
                    'h1'         => esc_html__( 'h1', 'kiedo-toolkit' ),
                    'h2'         => esc_html__( 'h2', 'kiedo-toolkit' ),
                    'h3'         => esc_html__( 'h3', 'kiedo-toolkit' ),
                    'h4'         => esc_html__( 'h4', 'kiedo-toolkit' ),
                    'h5'         => esc_html__( 'h5', 'kiedo-toolkit' ),
                    'h6'         => esc_html__( 'h6', 'kiedo-toolkit' ),
                ],
                'default' => 'h2',
                'condition' => [
                    'style' => '3',
                ]
            ]
        );

        $list_items = new Repeater();

        $list_items->add_control(
            'image',
            [
                'label' => __( 'Image', 'kiedo-toolkit' ),
                'type' => Controls_Manager::MEDIA,
            ]
        );
        $list_items->add_control(
            'name',
            [
                'label' => esc_html__('Name', 'kiedo-toolkit'),
                'type' => Controls_Manager::TEXT,
                'default' => esc_html__('Olivar Lucy', 'kiedo-toolkit'),
                'label_block' => true,
            ]
        );
        $list_items->add_control(
            'designation',
            [
                'label' => esc_html__('Designation', 'kiedo-toolkit'),
                'type' => Controls_Manager::TEXT,
                'default' => esc_html__('CEO at ThemeForest', 'kiedo-toolkit'),
                'label_block' => true,
            ]
        );
        $list_items->add_control(
            'feedback',
            [
                'label' => esc_html__('Feedback Content', 'kiedo-toolkit'),
                'type' => Controls_Manager::TEXTAREA,
                'default' => esc_html__('“We believe brand interaction is key in communication. Real innovations and a positive customer experience are the heart of successful communication. No fake products and services.”', 'kiedo-toolkit'),
                'label_block' => true,
            ]
        );
        $list_items->add_control(
            'icon',
            [
                'label' => esc_html__('Feedback ICON', 'kiedo-toolkit'),
                'type' => Controls_Manager::ICON,
                'options' => kiedo_icons(),
            ]
        );
        $list_items->add_control(
            'icon_count',
            [
                'label' => esc_html__('Feedback Count', 'kiedo-toolkit'),
                'type' => Controls_Manager::NUMBER,
            ]
        );
        $list_items->add_control(
            'review_title',
            [
                'label' => esc_html__('Review Title', 'kiedo-toolkit'),
                'type' => Controls_Manager::TEXT,
            ]
        );
        $this->add_control(
            'kiedo_feedback_items',
            [
                'label' => esc_html__('Feedback Item', 'kiedo-toolkit'),
                'type' => Controls_Manager::REPEATER,
                'default' => [
                    [ 'name' => esc_html__(' Item #1', 'kiedo-toolkit') ],

                ],
                'fields' => $list_items->get_controls(),
            ]
        );
    $this->end_controls_section();
    }

	protected function render() {

        $settings = $this->get_settings_for_display();

        $items = $settings['kiedo_feedback_items'];

        $this-> add_inline_editing_attributes('title','none'); ?>

        <?php $count = 0;
        foreach ( $items as $key => $value ) {
            $count++;
        } ?>

        <?php if($settings['style'] == '1'): ?>
            <div class="container">
                <?php if( $count == 1 ): ?>
                <div class="col-lg-12 col-sm-12">
                <?php else: ?>
                <div class="feedback-slides owl-carousel owl-theme">
                <?php endif; ?>
                    <?php foreach ( $items as $key => $value ) { ?>
                        <div class="single-feedback-box">
                            <div class="client-info">
                                <div class="d-flex align-items-center">
                                    <?php if( $value['image']['url'] != '' ): ?>
                                        <img src="<?php echo esc_url( $value['image']['url'] ); ?>" alt="<?php echo esc_attr( $value['name'] ) ?>">
                                    <?php endif; ?>

                                    <div class="title">
                                        <h3><?php echo esc_html( $value['name'] ); ?></h3>
                                        <span><?php echo esc_html( $value['designation'] ); ?></span>
                                    </div>
                                </div>
                            </div>
                            <p><?php echo wp_kses_post( $value['feedback'] ); ?></p>
                            <div class="rating d-flex align-items-center justify-content-between">
                                <h5><?php echo esc_html($value['review_title']); ?></h5>
                                <div>
                                    <?php for ($x = 0; $x < $value['icon_count']; $x++) { ?>
                                        <i class="<?php echo esc_attr( $value['icon'] ) ?>"></i>
                                    <?php } ?>
                                </div>
                            </div>
                        </div>
                    <?php } ?>
                </div>
            </div>
        <?php elseif($settings['style'] == '2'): ?>
            <div class="container">
                <?php if( $count == 1 ): ?>
                <div class="col-lg-12 col-sm-12">
                <?php else: ?>
                <div class="feedback-swiper-slides swiper swiper-container">
                    <div class="swiper-wrapper">
                <?php endif; ?>
                        <?php foreach ( $items as $key => $value ) { ?>
                            <div class="swiper-slide">
                                <div class="single-feedback-item-bg">
                                    <div class="single-feedback-item">
                                        <div class="client-info">
                                            <?php if( $value['image']['url'] != '' ): ?>
                                                <img src="<?php echo esc_url( $value['image']['url'] ); ?>" alt="<?php echo esc_attr( $value['name'] ) ?>">
                                            <?php endif; ?>

                                            <div class="title">
                                                <h3><?php echo esc_html( $value['name'] ); ?></h3>
                                                <span><?php echo esc_html( $value['designation'] ); ?></span>
                                            </div>
                                        </div>
                                        <p><?php echo wp_kses_post( $value['feedback'] ); ?></p>
                                        <div class="rating">
                                            <h5><?php echo esc_html($value['review_title']); ?></h5>
                                            <div>
                                                <?php for ($x = 0; $x < $value['icon_count']; $x++) { ?>
                                                    <i class="<?php echo esc_attr( $value['icon'] ) ?>"></i>
                                                <?php } ?>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        <?php } ?>
                    </div>
                    <!-- Add Pagination -->
                    <div class="swiper-button-next" data-aos="fade-right"></div>
                    <div class="swiper-button-prev" data-aos="fade-left"></div>
                </div>
            </div>
        <?php elseif($settings['style'] == '3'): ?>
            <div class="feedback-area bg-gradient-color ptb-100">
                <div class="container">
                    <div class="row">
                        <div class="col-lg-4 col-md-12">
                            <div class="feedback-section-title">
                                <?php if( $settings['top_title'] != '' ): ?>
                                    <span class="sub-title"><?php echo wp_kses_post( $settings['top_title'] ); ?></span>
                                <?php endif; ?>
                                <h2 <?php echo $this-> get_render_attribute_string('title'); ?>><?php echo esc_html( $settings['title'] ); ?></h2>
                            </div>
                        </div>
                        <div class="col-lg-8 col-md-12">
                            <?php if( $count == 1 ): ?>
                            <div class="col-lg-12 col-sm-12">
                            <?php else: ?>
                            <div class="feedback-slides-two owl-carousel owl-theme">
                            <?php endif; ?>
                                <?php foreach ( $items as $key => $value ) { ?>
                                    <div class="single-feedback-box">
                                        <div class="client-info">
                                            <div class="d-flex align-items-center">
                                                <?php if( $value['image']['url'] != '' ): ?>
                                                    <img src="<?php echo esc_url( $value['image']['url'] ); ?>" alt="<?php echo esc_attr( $value['name'] ) ?>">
                                                <?php endif; ?>

                                                <div class="title">
                                                    <h3><?php echo esc_html( $value['name'] ); ?></h3>
                                                    <span><?php echo esc_html( $value['designation'] ); ?></span>
                                                </div>
                                            </div>
                                        </div>
                                        <p><?php echo wp_kses_post( $value['feedback'] ); ?></p>
                                        <div class="rating d-flex align-items-center justify-content-between">
                                            <h5><?php echo esc_html($value['review_title']); ?></h5>
                                            <div>
                                                <?php for ($x = 0; $x < $value['icon_count']; $x++) { ?>
                                                    <i class="<?php echo esc_attr( $value['icon'] ) ?>"></i>
                                                <?php } ?>
                                            </div>
                                        </div>
                                    </div>
                                <?php } ?>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        <?php elseif($settings['style'] == '4'): ?>
            <div class="feedback-area bg-F4F8FC ptb-100">
                <div class="container">
                    <div class="feedback-tabs">
                        <div class="tab-content" id="myTabContent">
                            <?php $count = 1; foreach ( $items as $key => $value ) { ?>
                                <div class="tab-pane fade <?php if($count == 1): echo "show active"; endif; ?>" id="feedback<?php echo $count; ?>" role="tabpanel">
                                    <p><?php echo wp_kses_post( $value['feedback'] ); ?></p>
                                    <h6><span><?php echo esc_html( $value['name'] ); ?></span> - <?php echo esc_html( $value['designation'] ); ?></h6>
                                </div>
                            <?php $count++; } ?>

                        </div>
                        <ul class="nav nav-tabs" id="myTab" role="tablist">
                            <?php $count = 1; foreach ( $items as $key => $value ) { ?>
                                <li class="nav-item" role="presentation">
                                    <button class="nav-link <?php if($count == 1): echo "active"; endif; ?>" id="feedback<?php echo $count; ?>-tab" data-bs-toggle="tab" data-bs-target="#feedback<?php echo $count; ?>" type="button" role="tab" aria-controls="feedback<?php echo $count; ?>" aria-selected="true">
                                    <?php if( $value['image']['url'] != '' ): ?>
                                        <img src="<?php echo esc_url( $value['image']['url'] ); ?>" alt="<?php echo esc_attr( $value['name'] ) ?>">
                                    <?php endif; ?>
                                    </button>
                                </li>
                            <?php $count++; } ?>
                        </ul>
                    </div>
                </div>
            </div>
        <?php elseif($settings['style'] == '5'): ?>
            <div class="container-fluid">
                <div class="new-feedback-wrap-slides owl-carousel owl-theme">
                    <?php $count = 1; foreach ( $items as $key => $value ) { ?>
                    <div class="single-feedback-wrap-card">
                        <div class="rating">
                            <?php for ($x = 0; $x < $value['icon_count']; $x++) { ?>
                                <i class="<?php echo esc_attr( $value['icon'] ) ?>"></i>
                            <?php } ?>
                        </div>
                        <p><?php echo wp_kses_post( $value['feedback'] ); ?></p>
                        <div class="client-info">
                            <?php if( $value['image']['url'] != '' ): ?>
                                <img src="<?php echo esc_url( $value['image']['url'] ); ?>" alt="<?php echo esc_attr( $value['name'] ) ?>">
                            <?php endif; ?>
                            <div class="title">
                                <h3><?php echo esc_html( $value['name'] ); ?></h3>
                                <span><?php echo esc_html( $value['designation'] ); ?></span>
                            </div>
                        </div>
                    </div>
                    <?php $count++; } ?>
                </div>
            </div>
        <?php endif; ?>
        <?php
	}
}

Plugin::instance()->widgets_manager->register( new Kiedo_Feedback );