<?php
/**
 * Features Card Widget
 */

namespace Elementor;
class Kiedo_Features_Card_Area extends Widget_Base {

	public function get_name() {
        return 'Kiedo_Features_Card_Area';
    }

	public function get_title() {
        return __( 'Features Area', 'kiedo-toolkit' );
    }

	public function get_icon() {
        return 'eicon-image-rollover';
    }

	public function get_categories() {
        return [ 'kiedo-elements' ];
    }

	protected function register_controls() {

        $this->start_controls_section(
			'features_section',
			[
				'label' => __( 'Features Control', 'kiedo-toolkit' ),
				'tab' => Controls_Manager::TAB_CONTENT,
			]
        );

            $this->add_control(
                'style',
                [
                    'label' => esc_html__( 'Section Style', 'kiedo-toolkit' ),
                    'type' => Controls_Manager::SELECT,
                    'options' => [
                        '1'         => esc_html__( 'Style 1', 'kiedo-toolkit' ),
                        '2'         => esc_html__( 'Style 2', 'kiedo-toolkit' ),
                        '3'         => esc_html__( 'Style 3', 'kiedo-toolkit' ),
                        '4'         => esc_html__( 'Style 4', 'kiedo-toolkit' ),
                        '5'         => esc_html__( 'Style 5', 'kiedo-toolkit' ),
                    ],
                    'default' => '1',
                ]
            );

            $this->add_control(
                'top_title',
                [
                    'label' => __( 'Top Title', 'kiedo-toolkit' ),
                    'type' => Controls_Manager::TEXT,
                    'default' => __('KEY FEATURES', 'kiedo-toolkit'),
                    'condition' => [
                        'style' => '3',
                    ]
                ]
            );
            $this->add_control(
                'title',
                [
                    'label' => __( 'Title', 'kiedo-toolkit' ),
                    'type' => Controls_Manager::TEXT,
                    'default' => __('Our Featured Services', 'kiedo-toolkit'),
                    'condition' => [
                        'style' => '3',
                    ]
                ]
            );

            $this->add_control(
                'title_tag',
                [
                    'label' => esc_html__( 'Title Tag', 'kiedo-toolkit' ),
                    'type' => Controls_Manager::SELECT,
                    'options' => [
                        'h1'         => esc_html__( 'h1', 'kiedo-toolkit' ),
                        'h2'         => esc_html__( 'h2', 'kiedo-toolkit' ),
                        'h3'         => esc_html__( 'h3', 'kiedo-toolkit' ),
                        'h4'         => esc_html__( 'h4', 'kiedo-toolkit' ),
                        'h5'         => esc_html__( 'h5', 'kiedo-toolkit' ),
                        'h6'         => esc_html__( 'h6', 'kiedo-toolkit' ),
                    ],
                    'default' => 'h2',
                    'condition' => [
                        'style' => '3',
                    ]
                ]
            );

            $this->add_control(
                'content',
                [
                    'label' => __( 'Content', 'kiedo-toolkit' ),
                    'type' => Controls_Manager::WYSIWYG,
                    'condition' => [
                        'style' => '3',
                    ]
                ]
            );

            $this->add_control(
				'left_button_text',
				[
					'label' 	=> esc_html__( 'Left Button Text', 'kiedo-toolkit' ),
					'type' 		=> Controls_Manager::TEXT,
					'default' 	=> esc_html__('Start Free Trial', 'kiedo-toolkit'),
                    'condition' => [
                        'style' => '3',
                    ]
				]
            );

            $this->add_control(
                'left_link',
                [
                    'label'		=> esc_html__('Left Button Link', 'kiedo-toolkit'),
                    'type'		=> Controls_Manager:: TEXT,
                    'condition' => [
                        'style' => '3',
                    ]
                ]
            );

            $this->add_control(
				'right_button_text',
				[
					'label' 	=> esc_html__( 'Right Button Text', 'kiedo-toolkit' ),
					'type' 		=> Controls_Manager::TEXT,
					'default' 	=> esc_html__('See All Features', 'kiedo-toolkit'),
                    'condition' => [
                        'style' => '3',
                    ]
				]
            );

            $this->add_control(
                'right_link',
                [
                    'label'		=> esc_html__('Right Button Link', 'kiedo-toolkit'),
                    'type'		=> Controls_Manager:: TEXT,
                    'condition' => [
                        'style' => '3',
                    ]
                ]
            );

            $list_items = new Repeater();

            $list_items->add_control(
                'icon',
                [
                    'type'    => Controls_Manager::ICON,
                    'label' => __( 'Icon', 'kiedo-toolkit' ),
                    'label_block' => true,
                    'options' => kiedo_icons(),
                ]
            );
            $list_items->add_control(
                'title',
                [
                    'type'    => Controls_Manager::TEXT,
                    'label'   => __( 'Title', 'kiedo-toolkit' ),
                    'default' => __('User Friendly', 'kiedo-toolkit'),
                ]
            );

            $list_items->add_control(
                'content',
                [
                    'type'    => Controls_Manager::TEXTAREA,
                    'label'   => __( 'Content', 'kiedo-toolkit' ),
                    'default' => __('Most provably best dashboard design for your business you can try.', 'kiedo-toolkit'),
                ]
            );
            $this->add_control(
                'items',
                [
                    'label'   => __( 'Add Counter Item', 'kiedo-toolkit' ),
                    'type' => Controls_Manager::REPEATER,
                    'fields' => $list_items->get_controls(),
                ]
            );

            $this->add_control(
				'button_text',
				[
					'label' 	=> esc_html__( 'Button Text', 'kiedo-toolkit' ),
					'type' 		=> Controls_Manager::TEXT,
					'default' 	=> esc_html__('Start Free Trial', 'kiedo-toolkit'),
                    'condition' => [
                        'style' => '2',
                    ]
				]
            );

            $this->add_control(
                'ex_link',
                [
                    'label'		=> esc_html__('Button Link', 'kiedo-toolkit'),
                    'type'		=> Controls_Manager:: TEXT,
                    'condition' => [
                        'style' => '2',
                    ]
                ]
            );
        $this->end_controls_section();
    }

	protected function render() {
        $settings = $this->get_settings_for_display();
        ?>
        <?php if($settings['style'] == '1' || $settings['style'] == '2' || $settings['style'] == '4'): ?>
            <div class="container">
                <div class="row justify-content-center">
                    <?php if($settings['style'] == '1' || $settings['style'] == '4'): ?>
                        <?php $i = 1; foreach( $settings['items'] as $item ): ?>
                            <div class="<?php if($settings['style'] == '1'): echo 'col-xl-3 col-lg-4 col-sm-6 col-md-6'; else: echo 'col-lg-4 col-sm-6 col-md-6'; endif; ?>">
                                <div class="<?php if($settings['style'] == '1'): echo 'single-features-box'; else: echo 'features-item'; endif; ?>">
                                    <?php if($item['icon']): ?>
                                        <div class="icon bg<?php echo $i; ?>">
                                            <i class="<?php echo esc_attr($item['icon']) ?>"></i>
                                        </div>
                                    <?php endif; ?>

                                    <h3><?php echo esc_html($item['title']) ?></h3>
                                    <p><?php echo esc_html($item['content']) ?></p>
                                </div>
                            </div>
                        <?php $i++; endforeach; ?>
                    <?php elseif($settings['style'] == '2'): ?>
                        <?php $i = 1; foreach( $settings['items'] as $item ): ?>
                            <div class="col-xl-4 col-lg-6 col-sm-6 col-md-6">
                                <div class="single-features-item">
                                    <?php if($item['icon']): ?>
                                        <div class="icon bg<?php echo $i; ?>">
                                            <i class="<?php echo esc_attr($item['icon']) ?>"></i>
                                        </div>
                                    <?php endif; ?>

                                    <h3><?php echo esc_html($item['title']) ?></h3>
                                    <p><?php echo esc_html($item['content']) ?></p>
                                </div>
                            </div>
                        <?php $i++; endforeach; ?>

                        <?php if($settings['button_text']): ?>
                            <div class="col-xl-12 col-lg-12 col-sm-12 col-md-12">
                                <div class="view-more-box">
                                    <a href="<?php echo esc_url($settings['ex_link']); ?>" class="default-btn"><?php echo esc_html($settings['button_text']); ?></a>
                                </div>
                            </div>
                        <?php endif; ?>
                    <?php endif; ?>
                </div>
            </div>
        <?php elseif($settings['style'] == '3'): ?>
            <div class="features-area pt-100 pb-75">
                <div class="container">
                    <div class="row align-items-center">
                        <div class="col-lg-6 col-md-12">
                            <div class="features-content">
                                <?php if( $settings['top_title'] != '' ): ?>
                                    <span class="sub-title"><?php echo wp_kses_post( $settings['top_title'] ); ?></span>
                                <?php endif; ?>
                                <h2 <?php echo $this-> get_render_attribute_string('title'); ?>><?php echo esc_html( $settings['title'] ); ?></h2>
                                <?php if( $settings['content'] != '' ): ?>
                                    <p <?php echo $this-> get_render_attribute_string('content'); ?>><?php echo wp_kses_post( $settings['content'] ); ?></p>
                                <?php endif; ?>
                                <div class="btn-box">

                                <?php if($settings['left_button_text']): ?>
                                    <a href="<?php echo esc_url($settings['left_link']); ?>" class="default-btn"><?php echo esc_html($settings['left_button_text']); ?></a>
                                <?php endif; ?>

                                <?php if($settings['right_button_text']): ?>
                                    <a href="<?php echo esc_url($settings['right_link']); ?>" class="link-btn"><?php echo esc_html($settings['right_button_text']); ?></a>
                                <?php endif; ?>

                                </div>
                            </div>
                        </div>
                        <div class="col-lg-6 col-md-12">
                            <div class="list-of-features">
                                <div class="row justify-content-center">
                                    <?php $i = 1; foreach( $settings['items'] as $item ): ?>
                                        <div class="col-lg-6 col-sm-6 col-md-6">
                                            <div class="features-item with-border">
                                                <?php if($item['icon']): ?>
                                                    <div class="icon bg<?php echo $i; ?>">
                                                        <i class="<?php echo esc_attr($item['icon']) ?>"></i>
                                                    </div>
                                                <?php endif; ?>

                                                <h3><?php echo esc_html($item['title']) ?></h3>
                                                <p><?php echo esc_html($item['content']) ?></p>
                                            </div>
                                        </div>
                                    <?php $i++; endforeach; ?>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        <?php elseif($settings['style'] == '5'): ?>
            <div class="container">
                <div class="row justify-content-center">
                    <?php $i = 1; foreach( $settings['items'] as $item ): ?>
                        <div class="col-lg-4 col-sm-6 col-md-6">
                            <div class="features-item with-border">
                                <?php if($item['icon']): ?>
                                    <div class="icon bg<?php echo $i; ?>">
                                        <i class="<?php echo esc_attr($item['icon']) ?>"></i>
                                    </div>
                                <?php endif; ?>

                                <h3><?php echo esc_html($item['title']) ?></h3>
                                <p><?php echo esc_html($item['content']) ?></p>
                            </div>
                        </div>
                    <?php $i++; endforeach; ?>
                </div>
            </div>
        <?php endif; ?>
        <?php
	}

}

Plugin::instance()->widgets_manager->register( new Kiedo_Features_Card_Area );