<?php
$theme = wp_get_theme(); // gets the current theme
if ( 'Kiedo' == $theme->name || 'Kiedo' == $theme->parent_theme ) {
	/**	
	 * Classes
	 */
	require_once(KIEDO_ACC_PATH . 'inc/classes/Kiedo_base.php');
	require_once(KIEDO_ACC_PATH . 'inc/classes/Kiedo_rt.php');
	require_once(KIEDO_ACC_PATH . 'inc/classes/Kiedo_admin_page.php');
	require_once(KIEDO_ACC_PATH . 'inc/admin/dashboard/Kiedo_admin_dashboard.php');
	require_once(KIEDO_ACC_PATH . 'inc/functions.php');

    /**
     * Redirect after theme activation
     */
    add_action( 'after_switch_theme', function() {
        if ( isset( $_GET['activated'] ) ) {
            wp_safe_redirect( admin_url('admin.php?page=kiedo') );
            update_option( 'kiedo_purchase_code_status', '', 'yes' );
            update_option( 'kiedo_purchase_code', '', 'yes' );
            exit;
        }
        update_option('notice_dismissed', '0');
    });

    if (version_compare($theme->get('Version'), KIEDO_TOOLKIT_VERSION, '>')) {
        $update_message = "A new version of Kiedo Toolkit is available. Please go to Dashboard->Plugins and delete the old Kiedo Toolkit plugin and then install the updated Kiedo Toolkit plugin from Appearance > Install Plugins.";
        add_action('admin_notices', function() use ($update_message) {
            echo '<div class="notice notice-warning" style="background-color: #fff2ce;"><p>' . esc_html($update_message) . '</p></div>';
        });
    }
}