<?php
/**
 * Load eCademy Elementor support  
 */

// Main Elementor kiedo Extension Class
final class Elementor_Kiedo_Extension {

	const VERSION = '1.0.0';
	const MINIMUM_ELEMENTOR_VERSION = '2.0.0';
	const MINIMUM_PHP_VERSION = '7.0';

	// Instance
    private static $_instance = null;

	public static function instance() {

		if ( is_null( self::$_instance ) ) {
			self::$_instance = new self();
		}
		return self::$_instance;

	}

	// Constructor
	public function __construct() {
		add_action( 'plugins_loaded', [ $this, 'init' ] );

	}

	// init
	public function init() {
        load_plugin_textdomain( 'kiedo-toolkit' );

		// Check if Elementor installed and activated
		if ( ! did_action( 'elementor/loaded' ) ) {
			add_action( 'admin_notices', [ $this, 'admin_notice_missing_main_plugin' ] );
			return;
		}

		// Check for required Elementor version
		if ( ! version_compare( ELEMENTOR_VERSION, self::MINIMUM_ELEMENTOR_VERSION, '>=' ) ) {
			add_action( 'admin_notices', [ $this, 'admin_notice_minimum_elementor_version' ] );
			return;
		}

		// Check for required PHP version
		if ( version_compare( PHP_VERSION, self::MINIMUM_PHP_VERSION, '<' ) ) {
			add_action( 'admin_notices', [ $this, 'admin_notice_minimum_php_version' ] );
			return;
		}

		// Add Plugin actions
		add_action( 'elementor/widgets/register', [ $this, 'init_widgets' ] );

        add_action('elementor/elements/categories_registered',[ $this, 'register_new_category'] );

    }

    public function register_new_category($manager){
        $manager->add_category('kiedo-elements',[
            'title'=>esc_html__('Kiedo','kiedo-toolkit'),
            'icon'=> 'fa fa-image'
        ]);
    }

	//Admin notice
	public function admin_notice_missing_main_plugin() {

		if ( isset( $_GET['activate'] ) ) unset( $_GET['activate'] );

		$message = sprintf(
			/* translators: 1: Plugin name 2: Elementor */
			esc_html__( '"%1$s" requires "%2$s" to be installed and activated.', 'kiedo-toolkit' ),
			'<strong>' . esc_html__( 'Kiedo Toolkit', 'kiedo-toolkit' ) . '</strong>',
			'<strong>' . esc_html__( 'Elementor', 'kiedo-toolkit' ) . '</strong>'
		);

		printf( '<div class="notice notice-warning is-dismissible"><p>%1$s</p></div>', $message );

	}
	public function admin_notice_minimum_elementor_version() {

		if ( isset( $_GET['activate'] ) ) unset( $_GET['activate'] );

		$message = sprintf(
			/* translators: 1: Plugin name 2: Elementor 3: Required Elementor version */
			esc_html__( '"%1$s" requires "%2$s" version %3$s or greater.', 'kiedo-toolkit' ),
			'<strong>' . esc_html__( 'Kiedo Toolkit', 'kiedo-toolkit' ) . '</strong>',
			'<strong>' . esc_html__( 'Elementor', 'kiedo-toolkit' ) . '</strong>',
			 self::MINIMUM_ELEMENTOR_VERSION
		);

		printf( '<div class="notice notice-warning is-dismissible"><p>%1$s</p></div>', $message );

	}
	public function admin_notice_minimum_php_version() {

		if ( isset( $_GET['activate'] ) ) unset( $_GET['activate'] );

		$message = sprintf(
			/* translators: 1: Plugin name 2: PHP 3: Required PHP version */
			esc_html__( '"%1$s" requires "%2$s" version %3$s or greater.', 'kiedo-toolkit' ),
			'<strong>' . esc_html__( 'Kiedo Toolkit', 'kiedo-toolkit' ) . '</strong>',
			'<strong>' . esc_html__( 'PHP', 'kiedo-toolkit' ) . '</strong>',
			 self::MINIMUM_PHP_VERSION
		);

		printf( '<div class="notice notice-warning is-dismissible"><p>%1$s</p></div>', $message );

	}

	// Toolkit Widgets
	public function init_widgets() {

		// Include Widget files
		$pcs = trim( get_option( 'kiedo_purchase_code_status' ) );
		if ( $pcs == 'valid' ) {
			require_once( __DIR__ . '/widgets/banner-one.php' );
			require_once( __DIR__ . '/widgets/features-area.php' );
			require_once( __DIR__ . '/widgets/video.php' );
			require_once( __DIR__ . '/widgets/features-info.php' );
			require_once( __DIR__ . '/widgets/section.php' );
			require_once( __DIR__ . '/widgets/app-progress.php' );
			require_once( __DIR__ . '/widgets/app-download.php' );
			require_once( __DIR__ . '/widgets/screenshots-slides.php' );
			require_once( __DIR__ . '/widgets/software-integrations.php' );
			require_once( __DIR__ . '/widgets/pricing.php' );
			require_once( __DIR__ . '/widgets/feedback.php' );
			require_once( __DIR__ . '/widgets/subscribe-area.php' );
			require_once( __DIR__ . '/widgets/about-area.php' );
			require_once( __DIR__ . '/widgets/funfacts.php' );
			require_once( __DIR__ . '/widgets/team2.php' );
			require_once( __DIR__ . '/widgets/partner.php' );
			require_once( __DIR__ . '/widgets/how-it-works.php' );
			require_once( __DIR__ . '/widgets/gallery.php' );
			require_once( __DIR__ . '/widgets/feedback2.php' );
			require_once( __DIR__ . '/widgets/screenshots.php' );
			require_once( __DIR__ . '/widgets/image-tab.php' );
			require_once( __DIR__ . '/widgets/faq.php' );
			require_once( __DIR__ . '/widgets/coming-soon.php' );
			require_once( __DIR__ . '/widgets/contact-info.php' );
			require_once( __DIR__ . '/widgets/features-post-area.php' );
			require_once( __DIR__ . '/widgets/features-details.php' );
			require_once( __DIR__ . '/widgets/team.php' );

			// V1.2
			require_once( __DIR__ . '/widgets/banner-two.php' );
			require_once( __DIR__ . '/widgets/banner-three.php' );
			require_once( __DIR__ . '/widgets/blog-posts.php' );
			require_once( __DIR__ . '/widgets/banner-four.php' );
			require_once( __DIR__ . '/widgets/banner-five.php' );
			require_once( __DIR__ . '/widgets/banner-six.php' );

			// V1.3
			require_once( __DIR__ . '/widgets/banner-seven.php' );
			require_once( __DIR__ . '/widgets/banner-eight.php' );
			require_once( __DIR__ . '/widgets/banner-nine.php' );
			require_once( __DIR__ . '/widgets/career-post.php' );

			require_once( __DIR__ . '/widgets/kiedo-button.php' );
		}
	}
}
Elementor_kiedo_Extension::instance();